// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/oslogin/v1/oslogin.proto

#include "google/cloud/oslogin/v1/internal/os_login_stub.h"
#include "google/cloud/grpc_error_delegate.h"
#include "google/cloud/status_or.h"
#include <google/cloud/oslogin/v1/oslogin.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace oslogin_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

OsLoginServiceStub::~OsLoginServiceStub() = default;

StatusOr<google::cloud::oslogin::common::SshPublicKey>
DefaultOsLoginServiceStub::CreateSshPublicKey(
    grpc::ClientContext& context,
    google::cloud::oslogin::v1::CreateSshPublicKeyRequest const& request) {
  google::cloud::oslogin::common::SshPublicKey response;
  auto status = grpc_stub_->CreateSshPublicKey(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

Status DefaultOsLoginServiceStub::DeletePosixAccount(
    grpc::ClientContext& context,
    google::cloud::oslogin::v1::DeletePosixAccountRequest const& request) {
  google::protobuf::Empty response;
  auto status = grpc_stub_->DeletePosixAccount(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return google::cloud::Status();
}

Status DefaultOsLoginServiceStub::DeleteSshPublicKey(
    grpc::ClientContext& context,
    google::cloud::oslogin::v1::DeleteSshPublicKeyRequest const& request) {
  google::protobuf::Empty response;
  auto status = grpc_stub_->DeleteSshPublicKey(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return google::cloud::Status();
}

StatusOr<google::cloud::oslogin::v1::LoginProfile>
DefaultOsLoginServiceStub::GetLoginProfile(
    grpc::ClientContext& context,
    google::cloud::oslogin::v1::GetLoginProfileRequest const& request) {
  google::cloud::oslogin::v1::LoginProfile response;
  auto status = grpc_stub_->GetLoginProfile(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::oslogin::common::SshPublicKey>
DefaultOsLoginServiceStub::GetSshPublicKey(
    grpc::ClientContext& context,
    google::cloud::oslogin::v1::GetSshPublicKeyRequest const& request) {
  google::cloud::oslogin::common::SshPublicKey response;
  auto status = grpc_stub_->GetSshPublicKey(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::oslogin::v1::ImportSshPublicKeyResponse>
DefaultOsLoginServiceStub::ImportSshPublicKey(
    grpc::ClientContext& context,
    google::cloud::oslogin::v1::ImportSshPublicKeyRequest const& request) {
  google::cloud::oslogin::v1::ImportSshPublicKeyResponse response;
  auto status = grpc_stub_->ImportSshPublicKey(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::oslogin::common::SshPublicKey>
DefaultOsLoginServiceStub::UpdateSshPublicKey(
    grpc::ClientContext& context,
    google::cloud::oslogin::v1::UpdateSshPublicKeyRequest const& request) {
  google::cloud::oslogin::common::SshPublicKey response;
  auto status = grpc_stub_->UpdateSshPublicKey(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace oslogin_v1_internal
}  // namespace cloud
}  // namespace google
