// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/securesourcemanager/v1/secure_source_manager.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SECURESOURCEMANAGER_V1_INTERNAL_SECURE_SOURCE_MANAGER_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SECURESOURCEMANAGER_V1_INTERNAL_SECURE_SOURCE_MANAGER_TRACING_CONNECTION_H

#include "google/cloud/securesourcemanager/v1/secure_source_manager_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace securesourcemanager_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class SecureSourceManagerTracingConnection
    : public securesourcemanager_v1::SecureSourceManagerConnection {
 public:
  ~SecureSourceManagerTracingConnection() override = default;

  explicit SecureSourceManagerTracingConnection(
      std::shared_ptr<securesourcemanager_v1::SecureSourceManagerConnection>
          child);

  Options options() override { return child_->options(); }

  StreamRange<google::cloud::securesourcemanager::v1::Instance> ListInstances(
      google::cloud::securesourcemanager::v1::ListInstancesRequest request)
      override;

  StatusOr<google::cloud::securesourcemanager::v1::Instance> GetInstance(
      google::cloud::securesourcemanager::v1::GetInstanceRequest const& request)
      override;

  future<StatusOr<google::cloud::securesourcemanager::v1::Instance>>
  CreateInstance(
      google::cloud::securesourcemanager::v1::CreateInstanceRequest const&
          request) override;

  future<StatusOr<google::cloud::securesourcemanager::v1::OperationMetadata>>
  DeleteInstance(
      google::cloud::securesourcemanager::v1::DeleteInstanceRequest const&
          request) override;

  StreamRange<google::cloud::securesourcemanager::v1::Repository>
  ListRepositories(
      google::cloud::securesourcemanager::v1::ListRepositoriesRequest request)
      override;

  StatusOr<google::cloud::securesourcemanager::v1::Repository> GetRepository(
      google::cloud::securesourcemanager::v1::GetRepositoryRequest const&
          request) override;

  future<StatusOr<google::cloud::securesourcemanager::v1::Repository>>
  CreateRepository(
      google::cloud::securesourcemanager::v1::CreateRepositoryRequest const&
          request) override;

  future<StatusOr<google::cloud::securesourcemanager::v1::OperationMetadata>>
  DeleteRepository(
      google::cloud::securesourcemanager::v1::DeleteRepositoryRequest const&
          request) override;

  StatusOr<google::iam::v1::Policy> GetIamPolicyRepo(
      google::iam::v1::GetIamPolicyRequest const& request) override;

  StatusOr<google::iam::v1::Policy> SetIamPolicyRepo(
      google::iam::v1::SetIamPolicyRequest const& request) override;

  StatusOr<google::iam::v1::TestIamPermissionsResponse> TestIamPermissionsRepo(
      google::iam::v1::TestIamPermissionsRequest const& request) override;

 private:
  std::shared_ptr<securesourcemanager_v1::SecureSourceManagerConnection> child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<securesourcemanager_v1::SecureSourceManagerConnection>
MakeSecureSourceManagerTracingConnection(
    std::shared_ptr<securesourcemanager_v1::SecureSourceManagerConnection>
        conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace securesourcemanager_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SECURESOURCEMANAGER_V1_INTERNAL_SECURE_SOURCE_MANAGER_TRACING_CONNECTION_H
