// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/vmmigration/v1/vmmigration.proto

#include "google/cloud/vmmigration/v1/internal/vm_migration_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"

namespace google {
namespace cloud {
namespace vmmigration_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

VmMigrationTracingStub::VmMigrationTracingStub(
    std::shared_ptr<VmMigrationStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

StatusOr<google::cloud::vmmigration::v1::ListSourcesResponse>
VmMigrationTracingStub::ListSources(
    grpc::ClientContext& context,
    google::cloud::vmmigration::v1::ListSourcesRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.vmmigration.v1.VmMigration",
                                     "ListSources");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListSources(context, request));
}

StatusOr<google::cloud::vmmigration::v1::Source>
VmMigrationTracingStub::GetSource(
    grpc::ClientContext& context,
    google::cloud::vmmigration::v1::GetSourceRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.vmmigration.v1.VmMigration",
                                     "GetSource");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span, child_->GetSource(context, request));
}

future<StatusOr<google::longrunning::Operation>>
VmMigrationTracingStub::AsyncCreateSource(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::vmmigration::v1::CreateSourceRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.vmmigration.v1.VmMigration",
                                     "CreateSource");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncCreateSource(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<StatusOr<google::longrunning::Operation>>
VmMigrationTracingStub::AsyncUpdateSource(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::vmmigration::v1::UpdateSourceRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.vmmigration.v1.VmMigration",
                                     "UpdateSource");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncUpdateSource(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<StatusOr<google::longrunning::Operation>>
VmMigrationTracingStub::AsyncDeleteSource(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::vmmigration::v1::DeleteSourceRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.vmmigration.v1.VmMigration",
                                     "DeleteSource");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncDeleteSource(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::cloud::vmmigration::v1::FetchInventoryResponse>
VmMigrationTracingStub::FetchInventory(
    grpc::ClientContext& context,
    google::cloud::vmmigration::v1::FetchInventoryRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.vmmigration.v1.VmMigration",
                                     "FetchInventory");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->FetchInventory(context, request));
}

StatusOr<google::cloud::vmmigration::v1::ListUtilizationReportsResponse>
VmMigrationTracingStub::ListUtilizationReports(
    grpc::ClientContext& context,
    google::cloud::vmmigration::v1::ListUtilizationReportsRequest const&
        request) {
  auto span = internal::MakeSpanGrpc("google.cloud.vmmigration.v1.VmMigration",
                                     "ListUtilizationReports");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListUtilizationReports(context, request));
}

StatusOr<google::cloud::vmmigration::v1::UtilizationReport>
VmMigrationTracingStub::GetUtilizationReport(
    grpc::ClientContext& context,
    google::cloud::vmmigration::v1::GetUtilizationReportRequest const&
        request) {
  auto span = internal::MakeSpanGrpc("google.cloud.vmmigration.v1.VmMigration",
                                     "GetUtilizationReport");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetUtilizationReport(context, request));
}

future<StatusOr<google::longrunning::Operation>>
VmMigrationTracingStub::AsyncCreateUtilizationReport(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::vmmigration::v1::CreateUtilizationReportRequest const&
        request) {
  auto span = internal::MakeSpanGrpc("google.cloud.vmmigration.v1.VmMigration",
                                     "CreateUtilizationReport");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncCreateUtilizationReport(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<StatusOr<google::longrunning::Operation>>
VmMigrationTracingStub::AsyncDeleteUtilizationReport(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::vmmigration::v1::DeleteUtilizationReportRequest const&
        request) {
  auto span = internal::MakeSpanGrpc("google.cloud.vmmigration.v1.VmMigration",
                                     "DeleteUtilizationReport");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncDeleteUtilizationReport(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::cloud::vmmigration::v1::ListDatacenterConnectorsResponse>
VmMigrationTracingStub::ListDatacenterConnectors(
    grpc::ClientContext& context,
    google::cloud::vmmigration::v1::ListDatacenterConnectorsRequest const&
        request) {
  auto span = internal::MakeSpanGrpc("google.cloud.vmmigration.v1.VmMigration",
                                     "ListDatacenterConnectors");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListDatacenterConnectors(context, request));
}

StatusOr<google::cloud::vmmigration::v1::DatacenterConnector>
VmMigrationTracingStub::GetDatacenterConnector(
    grpc::ClientContext& context,
    google::cloud::vmmigration::v1::GetDatacenterConnectorRequest const&
        request) {
  auto span = internal::MakeSpanGrpc("google.cloud.vmmigration.v1.VmMigration",
                                     "GetDatacenterConnector");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetDatacenterConnector(context, request));
}

future<StatusOr<google::longrunning::Operation>>
VmMigrationTracingStub::AsyncCreateDatacenterConnector(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::vmmigration::v1::CreateDatacenterConnectorRequest const&
        request) {
  auto span = internal::MakeSpanGrpc("google.cloud.vmmigration.v1.VmMigration",
                                     "CreateDatacenterConnector");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncCreateDatacenterConnector(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<StatusOr<google::longrunning::Operation>>
VmMigrationTracingStub::AsyncDeleteDatacenterConnector(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::vmmigration::v1::DeleteDatacenterConnectorRequest const&
        request) {
  auto span = internal::MakeSpanGrpc("google.cloud.vmmigration.v1.VmMigration",
                                     "DeleteDatacenterConnector");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncDeleteDatacenterConnector(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<StatusOr<google::longrunning::Operation>>
VmMigrationTracingStub::AsyncUpgradeAppliance(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::vmmigration::v1::UpgradeApplianceRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.vmmigration.v1.VmMigration",
                                     "UpgradeAppliance");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncUpgradeAppliance(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<StatusOr<google::longrunning::Operation>>
VmMigrationTracingStub::AsyncCreateMigratingVm(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::vmmigration::v1::CreateMigratingVmRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.vmmigration.v1.VmMigration",
                                     "CreateMigratingVm");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncCreateMigratingVm(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::cloud::vmmigration::v1::ListMigratingVmsResponse>
VmMigrationTracingStub::ListMigratingVms(
    grpc::ClientContext& context,
    google::cloud::vmmigration::v1::ListMigratingVmsRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.vmmigration.v1.VmMigration",
                                     "ListMigratingVms");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListMigratingVms(context, request));
}

StatusOr<google::cloud::vmmigration::v1::MigratingVm>
VmMigrationTracingStub::GetMigratingVm(
    grpc::ClientContext& context,
    google::cloud::vmmigration::v1::GetMigratingVmRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.vmmigration.v1.VmMigration",
                                     "GetMigratingVm");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetMigratingVm(context, request));
}

future<StatusOr<google::longrunning::Operation>>
VmMigrationTracingStub::AsyncUpdateMigratingVm(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::vmmigration::v1::UpdateMigratingVmRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.vmmigration.v1.VmMigration",
                                     "UpdateMigratingVm");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncUpdateMigratingVm(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<StatusOr<google::longrunning::Operation>>
VmMigrationTracingStub::AsyncDeleteMigratingVm(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::vmmigration::v1::DeleteMigratingVmRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.vmmigration.v1.VmMigration",
                                     "DeleteMigratingVm");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncDeleteMigratingVm(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<StatusOr<google::longrunning::Operation>>
VmMigrationTracingStub::AsyncStartMigration(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::vmmigration::v1::StartMigrationRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.vmmigration.v1.VmMigration",
                                     "StartMigration");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncStartMigration(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<StatusOr<google::longrunning::Operation>>
VmMigrationTracingStub::AsyncResumeMigration(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::vmmigration::v1::ResumeMigrationRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.vmmigration.v1.VmMigration",
                                     "ResumeMigration");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncResumeMigration(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<StatusOr<google::longrunning::Operation>>
VmMigrationTracingStub::AsyncPauseMigration(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::vmmigration::v1::PauseMigrationRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.vmmigration.v1.VmMigration",
                                     "PauseMigration");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncPauseMigration(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<StatusOr<google::longrunning::Operation>>
VmMigrationTracingStub::AsyncFinalizeMigration(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::vmmigration::v1::FinalizeMigrationRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.vmmigration.v1.VmMigration",
                                     "FinalizeMigration");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncFinalizeMigration(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<StatusOr<google::longrunning::Operation>>
VmMigrationTracingStub::AsyncCreateCloneJob(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::vmmigration::v1::CreateCloneJobRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.vmmigration.v1.VmMigration",
                                     "CreateCloneJob");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncCreateCloneJob(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<StatusOr<google::longrunning::Operation>>
VmMigrationTracingStub::AsyncCancelCloneJob(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::vmmigration::v1::CancelCloneJobRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.vmmigration.v1.VmMigration",
                                     "CancelCloneJob");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncCancelCloneJob(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::cloud::vmmigration::v1::ListCloneJobsResponse>
VmMigrationTracingStub::ListCloneJobs(
    grpc::ClientContext& context,
    google::cloud::vmmigration::v1::ListCloneJobsRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.vmmigration.v1.VmMigration",
                                     "ListCloneJobs");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListCloneJobs(context, request));
}

StatusOr<google::cloud::vmmigration::v1::CloneJob>
VmMigrationTracingStub::GetCloneJob(
    grpc::ClientContext& context,
    google::cloud::vmmigration::v1::GetCloneJobRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.vmmigration.v1.VmMigration",
                                     "GetCloneJob");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetCloneJob(context, request));
}

future<StatusOr<google::longrunning::Operation>>
VmMigrationTracingStub::AsyncCreateCutoverJob(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::vmmigration::v1::CreateCutoverJobRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.vmmigration.v1.VmMigration",
                                     "CreateCutoverJob");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncCreateCutoverJob(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<StatusOr<google::longrunning::Operation>>
VmMigrationTracingStub::AsyncCancelCutoverJob(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::vmmigration::v1::CancelCutoverJobRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.vmmigration.v1.VmMigration",
                                     "CancelCutoverJob");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncCancelCutoverJob(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::cloud::vmmigration::v1::ListCutoverJobsResponse>
VmMigrationTracingStub::ListCutoverJobs(
    grpc::ClientContext& context,
    google::cloud::vmmigration::v1::ListCutoverJobsRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.vmmigration.v1.VmMigration",
                                     "ListCutoverJobs");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListCutoverJobs(context, request));
}

StatusOr<google::cloud::vmmigration::v1::CutoverJob>
VmMigrationTracingStub::GetCutoverJob(
    grpc::ClientContext& context,
    google::cloud::vmmigration::v1::GetCutoverJobRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.vmmigration.v1.VmMigration",
                                     "GetCutoverJob");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetCutoverJob(context, request));
}

StatusOr<google::cloud::vmmigration::v1::ListGroupsResponse>
VmMigrationTracingStub::ListGroups(
    grpc::ClientContext& context,
    google::cloud::vmmigration::v1::ListGroupsRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.vmmigration.v1.VmMigration",
                                     "ListGroups");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListGroups(context, request));
}

StatusOr<google::cloud::vmmigration::v1::Group>
VmMigrationTracingStub::GetGroup(
    grpc::ClientContext& context,
    google::cloud::vmmigration::v1::GetGroupRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.vmmigration.v1.VmMigration",
                                     "GetGroup");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span, child_->GetGroup(context, request));
}

future<StatusOr<google::longrunning::Operation>>
VmMigrationTracingStub::AsyncCreateGroup(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::vmmigration::v1::CreateGroupRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.vmmigration.v1.VmMigration",
                                     "CreateGroup");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncCreateGroup(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<StatusOr<google::longrunning::Operation>>
VmMigrationTracingStub::AsyncUpdateGroup(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::vmmigration::v1::UpdateGroupRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.vmmigration.v1.VmMigration",
                                     "UpdateGroup");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncUpdateGroup(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<StatusOr<google::longrunning::Operation>>
VmMigrationTracingStub::AsyncDeleteGroup(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::vmmigration::v1::DeleteGroupRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.vmmigration.v1.VmMigration",
                                     "DeleteGroup");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncDeleteGroup(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<StatusOr<google::longrunning::Operation>>
VmMigrationTracingStub::AsyncAddGroupMigration(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::vmmigration::v1::AddGroupMigrationRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.vmmigration.v1.VmMigration",
                                     "AddGroupMigration");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncAddGroupMigration(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<StatusOr<google::longrunning::Operation>>
VmMigrationTracingStub::AsyncRemoveGroupMigration(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::vmmigration::v1::RemoveGroupMigrationRequest const&
        request) {
  auto span = internal::MakeSpanGrpc("google.cloud.vmmigration.v1.VmMigration",
                                     "RemoveGroupMigration");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncRemoveGroupMigration(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::cloud::vmmigration::v1::ListTargetProjectsResponse>
VmMigrationTracingStub::ListTargetProjects(
    grpc::ClientContext& context,
    google::cloud::vmmigration::v1::ListTargetProjectsRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.vmmigration.v1.VmMigration",
                                     "ListTargetProjects");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListTargetProjects(context, request));
}

StatusOr<google::cloud::vmmigration::v1::TargetProject>
VmMigrationTracingStub::GetTargetProject(
    grpc::ClientContext& context,
    google::cloud::vmmigration::v1::GetTargetProjectRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.vmmigration.v1.VmMigration",
                                     "GetTargetProject");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetTargetProject(context, request));
}

future<StatusOr<google::longrunning::Operation>>
VmMigrationTracingStub::AsyncCreateTargetProject(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::vmmigration::v1::CreateTargetProjectRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.vmmigration.v1.VmMigration",
                                     "CreateTargetProject");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncCreateTargetProject(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<StatusOr<google::longrunning::Operation>>
VmMigrationTracingStub::AsyncUpdateTargetProject(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::vmmigration::v1::UpdateTargetProjectRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.vmmigration.v1.VmMigration",
                                     "UpdateTargetProject");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncUpdateTargetProject(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<StatusOr<google::longrunning::Operation>>
VmMigrationTracingStub::AsyncDeleteTargetProject(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::vmmigration::v1::DeleteTargetProjectRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.vmmigration.v1.VmMigration",
                                     "DeleteTargetProject");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncDeleteTargetProject(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::cloud::vmmigration::v1::ListReplicationCyclesResponse>
VmMigrationTracingStub::ListReplicationCycles(
    grpc::ClientContext& context,
    google::cloud::vmmigration::v1::ListReplicationCyclesRequest const&
        request) {
  auto span = internal::MakeSpanGrpc("google.cloud.vmmigration.v1.VmMigration",
                                     "ListReplicationCycles");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListReplicationCycles(context, request));
}

StatusOr<google::cloud::vmmigration::v1::ReplicationCycle>
VmMigrationTracingStub::GetReplicationCycle(
    grpc::ClientContext& context,
    google::cloud::vmmigration::v1::GetReplicationCycleRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.vmmigration.v1.VmMigration",
                                     "GetReplicationCycle");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetReplicationCycle(context, request));
}

future<StatusOr<google::longrunning::Operation>>
VmMigrationTracingStub::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::longrunning::GetOperationRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.longrunning.Operations", "GetOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncGetOperation(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<Status> VmMigrationTracingStub::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::longrunning::CancelOperationRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.longrunning.Operations",
                                     "CancelOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncCancelOperation(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<VmMigrationStub> MakeVmMigrationTracingStub(
    std::shared_ptr<VmMigrationStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<VmMigrationTracingStub>(std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace vmmigration_v1_internal
}  // namespace cloud
}  // namespace google
