/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.spreadsheet;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.part.IPart;
import org.xmind.ui.internal.spreadsheet.RowHeadEditorHelper;
import org.xmind.ui.internal.spreadsheet.structures.Cell2;
import org.xmind.ui.internal.spreadsheet.structures.Chart2;
import org.xmind.ui.internal.spreadsheet.structures.Column2;
import org.xmind.ui.internal.spreadsheet.structures.Item2;
import org.xmind.ui.internal.spreadsheet.structures.Row2;
import org.xmind.ui.internal.spreadsheet.structures.RowHead;
import org.xmind.ui.internal.tools.LabelProposalProvider;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.texteditor.ContentProposalAdapter;
import org.xmind.ui.texteditor.FloatingTextEditor;
import org.xmind.ui.texteditor.FloatingTextEditorContentAssistAdapter;
import org.xmind.ui.tools.MindMapEditToolBase;

public class RowHeadEditTool
extends MindMapEditToolBase {
    private Chart2 chart;
    private RowHead rowHead;
    private Row2 row;
    private RowHeadEditorHelper helper;
    protected ContentProposalAdapter contentProposalAdapter = null;

    protected boolean acceptEditRequest(Request request) {
        this.setChart((Chart2)((Object)request.getParameter("chart")));
        this.setRow((Row2)request.getParameter("row"));
        this.setRowHead((RowHead)request.getParameter("rowHead"));
        return super.acceptEditRequest(request);
    }

    public void setChart(Chart2 chart) {
        Assert.isNotNull((Object)((Object)chart));
        this.chart = chart;
    }

    public void setRowHead(RowHead rowHead) {
        Assert.isNotNull((Object)rowHead);
        this.rowHead = rowHead;
    }

    public void setRow(Row2 row) {
        Assert.isNotNull((Object)row);
        this.row = row;
    }

    protected String getInitialText(IPart source) {
        Assert.isNotNull((Object)this.rowHead);
        Assert.isNotNull((Object)this.row);
        return this.rowHead.toString();
    }

    protected void handleTextModified(IPart source, IDocument document) {
        Request request;
        if (this.finishedOnMouseDown) {
            this.finishedOnMouseDown = false;
            if (this.shouldIgnoreTextChange(source, document, this.oldText)) {
                return;
            }
        }
        if ((request = this.createTextRequest(source, document)) != null) {
            source.handleRequest(request, "sheet head modifiable role");
        }
    }

    protected Request createTextRequest(IPart source, IDocument document) {
        if (this.row == null) {
            return null;
        }
        if (this.isRowEmpty()) {
            Request request = new Request("create_child").setViewer((IViewer)this.getTargetViewer());
            request.setParameter("property.labels", (Object)document.get());
            for (Cell2 cell : this.row.getCells()) {
                Column2 col = cell.getOwnedColumn();
                if (col == null) continue;
                request.setPrimaryTarget((IPart)col.getHead());
                return request;
            }
            return null;
        }
        Request request = new Request("modify_sheet_head");
        request.setParameter("text", (Object)document.get());
        ArrayList<ITopicPart> targets = new ArrayList<ITopicPart>();
        for (Cell2 cell : this.row.getCells()) {
            for (Item2 item : cell.getItems()) {
                targets.add(item.getBranch().getTopicPart());
            }
        }
        request.setTargets(targets);
        return request;
    }

    private boolean isRowEmpty() {
        if (!this.row.getHead().isEmpty()) {
            return false;
        }
        for (Cell2 cell : this.row.getCells()) {
            if (cell.getItems().isEmpty()) continue;
            return false;
        }
        return true;
    }

    protected void hookEditor(FloatingTextEditor editor) {
        super.hookEditor(editor);
        if (this.helper == null) {
            this.helper = new RowHeadEditorHelper(true);
        }
        this.helper.setEditor(editor);
        this.helper.setViewer(this.getTargetViewer());
        this.helper.setChart(this.chart);
        this.helper.setRow(this.row);
        this.helper.setRowHead(this.rowHead);
        this.helper.activate();
    }

    protected void unhookEditor(FloatingTextEditor editor) {
        if (this.helper != null) {
            this.helper.deactivate();
        }
        super.unhookEditor(editor);
    }

    protected void hookEditorControl(FloatingTextEditor editor, ITextViewer textViewer) {
        super.hookEditorControl(editor, textViewer);
        LabelProposalProvider proposalProvider = new LabelProposalProvider((IPart)this.getSource());
        if (this.contentProposalAdapter == null) {
            this.contentProposalAdapter = new FloatingTextEditorContentAssistAdapter(editor, (IContentProposalProvider)proposalProvider);
            this.contentProposalAdapter.setProposalAcceptanceStyle(2);
            this.contentProposalAdapter.setPopupSize(new Point(180, 80));
            final Image labelImage = this.createLabelProposalImage();
            if (labelImage != null) {
                this.contentProposalAdapter.setLabelProvider((ILabelProvider)new LabelProvider(){

                    public Image getImage(Object element) {
                        return labelImage;
                    }
                });
            }
            editor.getControl().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    RowHeadEditTool.this.contentProposalAdapter.setLabelProvider(null);
                    RowHeadEditTool.this.contentProposalAdapter = null;
                    if (labelImage != null) {
                        labelImage.dispose();
                    }
                }
            });
        } else {
            this.contentProposalAdapter.setContentProposalProvider((IContentProposalProvider)proposalProvider);
        }
    }

    private Image createLabelProposalImage() {
        return MindMapUI.getImages().get("label.png", true).createImage(false, (Device)Display.getCurrent());
    }
}

