/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.net.http;

import java.io.IOException;
import java.io.OutputStream;
import org.json.JSONObject;
import org.xmind.core.net.http.HttpEntity;
import org.xmind.core.net.internal.EncodingUtils;

public class JSONEntity
extends HttpEntity {
    public static final String CONTENT_TYPE_JSON = "application/json; charset=utf-8";
    private JSONObject object;
    private boolean pretty;
    private String json;

    public JSONEntity(JSONObject object) {
        this(object, false);
    }

    public JSONEntity(JSONObject object, boolean pretty) {
        this.object = object;
        this.pretty = pretty;
        this.json = null;
    }

    public String getJSON() {
        if (this.json == null) {
            this.json = this.pretty ? this.object.toString(4) : this.object.toString();
        }
        return this.json;
    }

    @Override
    public String getContentType() {
        return CONTENT_TYPE_JSON;
    }

    @Override
    public long getContentLength() {
        return EncodingUtils.toDefaultBytes(this.getJSON()).length;
    }

    @Override
    public void writeTo(OutputStream output) throws IOException {
        output.write(EncodingUtils.toDefaultBytes(this.getJSON()));
    }
}

