/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.aspose.exports.slide;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import net.xmind.verify.ui.VerifyUI20141031;
import net.xmind.verify.ui.VerifyWizardPage20141031;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.ui.internal.aspose.AsposePlugin;
import org.xmind.ui.internal.aspose.exports.ExportMessages;
import org.xmind.ui.internal.aspose.exports.IExportAvailabilityChecker;
import org.xmind.ui.internal.aspose.exports.slide.PPTExportPageBase;
import org.xmind.ui.internal.aspose.exports.slide.PPTExporter;
import org.xmind.ui.mindmap.IMindMap;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.wizards.DocumentExportWizard;
import org.xmind.ui.wizards.IExporter;

public class PPTExportWizard
extends DocumentExportWizard
implements IExportAvailabilityChecker {
    private static final String PAGE_NAME = "org.xmind.ui.export.pptExportPage";
    private static final String SECTION_NAME = "org.xmind.ui.export.ppt";
    private static final String PPT_EXT = ".ppt";
    private static final String PPTX_EXT = ".pptx";
    private FileDialog fileDialog;
    private PPTExportPage page;

    public PPTExportWizard() {
        this.setWindowTitle(ExportMessages.PPTWizard_WindowTitle);
        this.setDialogSettings(AsposePlugin.getDialogSettings(SECTION_NAME));
        this.setDefaultPageImageDescriptor(MindMapUI.getImages().getWizBan("export_wiz.png"));
    }

    protected IExporter createExporter() {
        IMindMap mindmap = this.getSourceMindMap();
        ITopic centralTopic = mindmap.getCentralTopic();
        ISheet sheet = mindmap.getSheet();
        int version = this.getExtension();
        PPTExporter exporter = new PPTExporter(sheet, centralTopic, this.getTargetPath(), version);
        exporter.setDialogSettings(this.getDialogSettings());
        exporter.init();
        return exporter;
    }

    protected void addValidPages() {
        this.addPage((IWizardPage)new VerifyWizardPage20141031("ExportToPPT", ExportMessages.PPTExportJob_Name));
        this.page = new PPTExportPage();
        this.addPage((IWizardPage)this.page);
    }

    protected String getFormatName() {
        if (this.getExtension() == 2) {
            return ExportMessages.PPT2007Wizard_FormatName;
        }
        return ExportMessages.PPTWizard_FormatName;
    }

    public boolean checkAvailability() {
        return true;
    }

    protected boolean isExtensionCompatible(String path, String extension) {
        return super.isExtensionCompatible(path, extension) && (PPT_EXT.equalsIgnoreCase(extension) || PPTX_EXT.equalsIgnoreCase(extension));
    }

    protected void handleExportException(Throwable e) {
        super.handleExportException(e);
        this.page.setErrorMessage(e.getLocalizedMessage());
    }

    private int getExtension() {
        if (this.fileDialog == null) {
            return 1;
        }
        int filterIndex = this.fileDialog.getFilterIndex();
        String filterExtension = this.fileDialog.getFilterExtensions()[filterIndex];
        if (filterExtension.equals("*.pptx")) {
            String target = this.getTargetPath();
            if (!target.contains(PPTX_EXT)) {
                this.setTargetPath(String.valueOf(target) + "x");
            }
            return 2;
        }
        return 1;
    }

    protected String getSuggestedFileName() {
        return String.valueOf(super.getSuggestedFileName()) + PPT_EXT;
    }

    protected void doExport(IProgressMonitor monitor, Display display, Shell parentShell) throws InvocationTargetException, InterruptedException {
        VerifyUI20141031.getUsageDataCollector().increase("ExportToPPTCount");
        super.doExport(monitor, display, parentShell);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PPTExportPage
    extends PPTExportPageBase {
        public PPTExportPage() {
            super(PPTExportWizard.PAGE_NAME, ExportMessages.PPTPage_Title);
            this.setDescription(ExportMessages.PPTPage_Description);
        }

        protected void setDialogFilters(FileDialog dialog, List<String> filterNames, List<String> filterExtensions) {
            filterNames.add(0, ExportMessages.PPT2007Page_FilterName);
            filterNames.add(0, ExportMessages.PPTPage_FilterName);
            filterExtensions.add(0, "*.pptx");
            filterExtensions.add(0, "*.ppt");
            PPTExportWizard.this.fileDialog = dialog;
            super.setDialogFilters(dialog, filterNames, filterExtensions);
        }
    }
}

