# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.network import NetworkManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestNetworkManagementConfigurationPolicyGroupsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(NetworkManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_configuration_policy_groups_begin_create_or_update(self, resource_group):
        response = self.client.configuration_policy_groups.begin_create_or_update(
            resource_group_name=resource_group.name,
            vpn_server_configuration_name="str",
            configuration_policy_group_name="str",
            vpn_server_configuration_policy_group_parameters={
                "etag": "str",
                "id": "str",
                "isDefault": bool,
                "name": "str",
                "p2SConnectionConfigurations": [{"id": "str"}],
                "policyMembers": [{"attributeType": "str", "attributeValue": "str", "name": "str"}],
                "priority": 0,
                "provisioningState": "str",
                "type": "str",
            },
            api_version="2024-10-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_configuration_policy_groups_begin_delete(self, resource_group):
        response = self.client.configuration_policy_groups.begin_delete(
            resource_group_name=resource_group.name,
            vpn_server_configuration_name="str",
            configuration_policy_group_name="str",
            api_version="2024-10-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_configuration_policy_groups_get(self, resource_group):
        response = self.client.configuration_policy_groups.get(
            resource_group_name=resource_group.name,
            vpn_server_configuration_name="str",
            configuration_policy_group_name="str",
            api_version="2024-10-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_configuration_policy_groups_list_by_vpn_server_configuration(self, resource_group):
        response = self.client.configuration_policy_groups.list_by_vpn_server_configuration(
            resource_group_name=resource_group.name,
            vpn_server_configuration_name="str",
            api_version="2024-10-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
