// $Id: depthdialog.cpp,v 1.12 2003/01/12 01:29:27 nhasan Exp $

#include <qlayout.h>
#include <qlabel.h>
#include <qcombobox.h>

#include <klocale.h>

#include "canvas.h"
#include "depthdialog.h"

depthDialog::depthDialog(Canvas *c, QWidget* parent, const char* name)
    : KDialogBase( parent, name, true, i18n( "Color Depth" ), 
      Ok|Cancel, Ok, true )
{
  QFrame *frame = makeMainWidget();

  QHBoxLayout *layout = new QHBoxLayout( frame );

  QLabel *tmpLabel = new QLabel( frame );
  tmpLabel->setText( i18n("Color depth:") );
  layout->addWidget( tmpLabel );

  depthBox = new QComboBox( false, frame );
  depthBox->insertItem(i18n("1 (2 Colors)"), ID_COLOR_1);
  depthBox->insertItem(i18n("8 (256 Colors)"), ID_COLOR_8);
  depthBox->insertItem(i18n("32 (True Color)"), ID_COLOR_32);

  depthBox->setFixedSize( depthBox->sizeHint() );
  layout->addWidget( depthBox );

  switch (c->pixmap()->depth()) {
  default: // fall to 1bit colordepth
  case 1:
    depthBox->setCurrentItem(ID_COLOR_1);
    break;
  case 8:
    depthBox->setCurrentItem(ID_COLOR_8);
    break;
  case 32:
    depthBox->setCurrentItem(ID_COLOR_32);
    break;
  }
}

#include "depthdialog.moc"
