/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import sun.io.ByteToCharCp1254;
import sun.io.CharToByteCp1254;
import sun.nio.cs.HistoricallyNamedCharset;
import sun.nio.cs.SingleByteDecoder;
import sun.nio.cs.SingleByteEncoder;
import sun.nio.cs.StandardCharsets;

public class MS1254
extends Charset
implements HistoricallyNamedCharset {
    public String historicalName() {
        return "Cp1254";
    }

    public MS1254() {
        super("windows-1254", StandardCharsets.aliasesFor((String)"windows-1254"));
    }

    public boolean contains(Charset charset) {
        return charset.name().equals("US-ASCII") || charset instanceof MS1254;
    }

    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    private static class Encoder
    extends SingleByteEncoder {
        private static CharToByteCp1254 c2b = new CharToByteCp1254();

        public Encoder(Charset charset) {
            super(charset, c2b.getIndex1(), c2b.getIndex2(), 65280, 255, 8);
        }
    }

    private static class Decoder
    extends SingleByteDecoder {
        private static ByteToCharCp1254 b2c = new ByteToCharCp1254();

        public Decoder(Charset charset) {
            super(charset, b2c.getByteToCharTable());
        }
    }
}

