/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.internal.io;

import com.sun.corba.se.internal.io.ObjectStreamField;
import com.sun.corba.se.internal.io.ValueUtility;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import org.omg.CORBA.ValueMember;

public class ObjectStreamClass
implements Serializable {
    public static final long kDefaultUID = -1L;
    private static Object[] noArgsList = new Object[0];
    private static Class[] noTypesList = new Class[0];
    private static Hashtable translatedFields;
    private static ObjectStreamClassEntry[] descriptorFor;
    private String name;
    private ObjectStreamClass superclass;
    private boolean serializable;
    private boolean externalizable;
    private ObjectStreamField[] fields;
    private Class ofClass;
    boolean forProxyClass;
    private long suid = -1L;
    private String suidStr = null;
    private long actualSuid = -1L;
    private String actualSuidStr = null;
    int primBytes;
    int objFields;
    private boolean initialized = false;
    private Object lock = new Object();
    private boolean hasWriteObjectMethod;
    private boolean hasExternalizableBlockData;
    Method writeObjectMethod;
    Method readObjectMethod;
    private Method writeReplaceObjectMethod;
    private Method readResolveObjectMethod;
    private ObjectStreamClass localClassDesc;
    private static Class classSerializable;
    private static Class classExternalizable;
    private static final long serialVersionUID = -6120832682080437368L;
    public static final ObjectStreamField[] NO_FIELDS;
    private static Comparator compareClassByName;
    private static final Comparator compareObjStrFieldsByName;
    private static Comparator compareMemberByName;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$io$ObjectOutputStream;
    static /* synthetic */ Class class$java$io$ObjectInputStream;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$java$io$Externalizable;

    static final ObjectStreamClass lookup(Class clazz) {
        ObjectStreamClass objectStreamClass = ObjectStreamClass.lookupInternal(clazz);
        if (objectStreamClass.isSerializable() || objectStreamClass.isExternalizable()) {
            return objectStreamClass;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ObjectStreamClass lookupInternal(Class clazz) {
        ObjectStreamClass objectStreamClass = null;
        ObjectStreamClassEntry[] objectStreamClassEntryArray = descriptorFor;
        synchronized (descriptorFor) {
            objectStreamClass = ObjectStreamClass.findDescriptorFor(clazz);
            if (objectStreamClass == null) {
                Class clazz2;
                boolean bl2 = classSerializable.isAssignableFrom(clazz);
                ObjectStreamClass objectStreamClass2 = null;
                if (bl2 && (clazz2 = clazz.getSuperclass()) != null) {
                    objectStreamClass2 = ObjectStreamClass.lookup(clazz2);
                }
                boolean bl3 = false;
                if (bl2) {
                    boolean bl4 = bl3 = objectStreamClass2 != null && objectStreamClass2.isExternalizable() || classExternalizable.isAssignableFrom(clazz);
                    if (bl3) {
                        bl2 = false;
                    }
                }
                objectStreamClass = new ObjectStreamClass(clazz, objectStreamClass2, bl2, bl3);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            objectStreamClass.init();
            return objectStreamClass;
        }
    }

    public final String getName() {
        return this.name;
    }

    public static final long getSerialVersionUID(Class clazz) {
        ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(clazz);
        if (objectStreamClass != null) {
            return objectStreamClass.getSerialVersionUID();
        }
        return 0L;
    }

    public final long getSerialVersionUID() {
        return this.suid;
    }

    public final String getSerialVersionUIDStr() {
        if (this.suidStr == null) {
            this.suidStr = Long.toHexString(this.suid).toUpperCase();
        }
        return this.suidStr;
    }

    public static final long getActualSerialVersionUID(Class clazz) {
        ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(clazz);
        if (objectStreamClass != null) {
            return objectStreamClass.getActualSerialVersionUID();
        }
        return 0L;
    }

    public final long getActualSerialVersionUID() {
        return this.actualSuid;
    }

    public final String getActualSerialVersionUIDStr() {
        if (this.actualSuidStr == null) {
            this.actualSuidStr = Long.toHexString(this.actualSuid).toUpperCase();
        }
        return this.actualSuidStr;
    }

    public final Class forClass() {
        return this.ofClass;
    }

    public ObjectStreamField[] getFields() {
        if (this.fields.length > 0) {
            ObjectStreamField[] objectStreamFieldArray = new ObjectStreamField[this.fields.length];
            System.arraycopy(this.fields, 0, objectStreamFieldArray, 0, this.fields.length);
            return objectStreamFieldArray;
        }
        return this.fields;
    }

    public boolean hasField(ValueMember valueMember) {
        int n2 = 0;
        while (n2 < this.fields.length) {
            try {
                if (this.fields[n2].getName().equals(valueMember.name) && this.fields[n2].getSignature().equals(ValueUtility.getSignature(valueMember))) {
                    return true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ++n2;
        }
        return false;
    }

    final ObjectStreamField[] getFieldsNoCopy() {
        return this.fields;
    }

    public final ObjectStreamField getField(String string) {
        int n2 = this.fields.length - 1;
        while (n2 >= 0) {
            if (string.equals(this.fields[n2].getName())) {
                return this.fields[n2];
            }
            --n2;
        }
        return null;
    }

    public Serializable writeReplace(Serializable serializable) {
        if (this.writeReplaceObjectMethod != null) {
            try {
                return (Serializable)this.writeReplaceObjectMethod.invoke(serializable, noArgsList);
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable.getMessage());
            }
        }
        return serializable;
    }

    public Object readResolve(Object object) {
        if (this.readResolveObjectMethod != null) {
            try {
                return this.readResolveObjectMethod.invoke(object, noArgsList);
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable.getMessage());
            }
        }
        return object;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.name);
        stringBuffer.append(": static final long serialVersionUID = ");
        stringBuffer.append(Long.toString(this.suid));
        stringBuffer.append("L;");
        return stringBuffer.toString();
    }

    private ObjectStreamClass(Class clazz, ObjectStreamClass objectStreamClass, boolean bl2, boolean bl3) {
        this.ofClass = clazz;
        if (Proxy.isProxyClass(clazz)) {
            this.forProxyClass = true;
        }
        this.name = clazz.getName();
        this.superclass = objectStreamClass;
        this.serializable = bl2;
        if (!this.forProxyClass) {
            this.externalizable = bl3;
        }
        ObjectStreamClass.insertDescriptorFor(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        Object object = this.lock;
        synchronized (object) {
            if (this.initialized) {
                return;
            }
            final Class clazz = this.ofClass;
            if (!this.serializable || this.externalizable || this.forProxyClass || this.name.equals("java.lang.String")) {
                this.fields = NO_FIELDS;
            } else if (this.serializable) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Object object;
                        Field[] fieldArray;
                        try {
                            fieldArray = clazz.getDeclaredField("serialPersistentFields");
                            fieldArray.setAccessible(true);
                            object = (java.io.ObjectStreamField[])fieldArray.get(clazz);
                            int n2 = fieldArray.getModifiers();
                            if (Modifier.isPrivate(n2) && Modifier.isStatic(n2) && Modifier.isFinal(n2)) {
                                ObjectStreamClass.access$002(ObjectStreamClass.this, (ObjectStreamField[])ObjectStreamClass.translateFields((Object[])fieldArray.get(clazz)));
                            }
                        }
                        catch (NoSuchFieldException noSuchFieldException) {
                            ObjectStreamClass.access$002(ObjectStreamClass.this, null);
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            ObjectStreamClass.access$002(ObjectStreamClass.this, null);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            ObjectStreamClass.access$002(ObjectStreamClass.this, null);
                        }
                        catch (ClassCastException classCastException) {
                            ObjectStreamClass.access$002(ObjectStreamClass.this, null);
                        }
                        if (ObjectStreamClass.this.fields == null) {
                            fieldArray = clazz.getDeclaredFields();
                            int n3 = 0;
                            ObjectStreamField[] objectStreamFieldArray = new ObjectStreamField[fieldArray.length];
                            int n4 = 0;
                            while (n4 < fieldArray.length) {
                                int n5 = fieldArray[n4].getModifiers();
                                if (!Modifier.isStatic(n5) && !Modifier.isTransient(n5)) {
                                    objectStreamFieldArray[n3++] = new ObjectStreamField(fieldArray[n4]);
                                }
                                ++n4;
                            }
                            ObjectStreamClass.access$002(ObjectStreamClass.this, new ObjectStreamField[n3]);
                            System.arraycopy(objectStreamFieldArray, 0, ObjectStreamClass.this.fields, 0, n3);
                        } else {
                            int n6 = ObjectStreamClass.this.fields.length - 1;
                            while (n6 >= 0) {
                                try {
                                    object = clazz.getDeclaredField(ObjectStreamClass.this.fields[n6].getName());
                                    if (ObjectStreamClass.this.fields[n6].getType() == ((Field)object).getType()) {
                                        ObjectStreamClass.this.fields[n6].setField((Field)object);
                                    }
                                }
                                catch (NoSuchFieldException noSuchFieldException) {
                                    // empty catch block
                                }
                                --n6;
                            }
                        }
                        return null;
                    }
                });
                if (this.fields.length > 1) {
                    Arrays.sort(this.fields);
                }
                this.computeFieldInfo();
            }
            if (this.isNonSerializable()) {
                this.suid = 0L;
            } else {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        block13: {
                            int n2;
                            Class[] classArray;
                            if (ObjectStreamClass.this.forProxyClass) {
                                ObjectStreamClass.this.suid = 0L;
                            } else {
                                try {
                                    classArray = clazz.getDeclaredField("serialVersionUID");
                                    n2 = classArray.getModifiers();
                                    if (Modifier.isStatic(n2) && Modifier.isFinal(n2)) {
                                        classArray.setAccessible(true);
                                        ObjectStreamClass.this.suid = classArray.getLong(clazz);
                                    } else {
                                        ObjectStreamClass.this.suid = ObjectStreamClass._computeSerialVersionUID(clazz);
                                    }
                                }
                                catch (NoSuchFieldException noSuchFieldException) {
                                    ObjectStreamClass.this.suid = ObjectStreamClass._computeSerialVersionUID(clazz);
                                }
                                catch (IllegalAccessException illegalAccessException) {
                                    ObjectStreamClass.this.suid = ObjectStreamClass._computeSerialVersionUID(clazz);
                                }
                            }
                            ObjectStreamClass.this.writeReplaceObjectMethod = ObjectStreamClass.getInheritableMethod(clazz, "writeReplace", noTypesList, class$java$lang$Object == null ? (class$java$lang$Object = ObjectStreamClass.class$("java.lang.Object")) : class$java$lang$Object);
                            ObjectStreamClass.this.readResolveObjectMethod = ObjectStreamClass.getInheritableMethod(clazz, "readResolve", noTypesList, class$java$lang$Object == null ? (class$java$lang$Object = ObjectStreamClass.class$("java.lang.Object")) : class$java$lang$Object);
                            if (!ObjectStreamClass.this.serializable || ObjectStreamClass.this.forProxyClass) break block13;
                            try {
                                classArray = new Class[]{class$java$io$ObjectOutputStream == null ? (class$java$io$ObjectOutputStream = ObjectStreamClass.class$("java.io.ObjectOutputStream")) : class$java$io$ObjectOutputStream};
                                ObjectStreamClass.this.writeObjectMethod = clazz.getDeclaredMethod("writeObject", classArray);
                                ObjectStreamClass.this.hasWriteObjectMethod = true;
                                n2 = ObjectStreamClass.this.writeObjectMethod.getModifiers();
                                if (!Modifier.isPrivate(n2) || Modifier.isStatic(n2)) {
                                    ObjectStreamClass.this.writeObjectMethod = null;
                                    ObjectStreamClass.this.hasWriteObjectMethod = false;
                                }
                            }
                            catch (NoSuchMethodException noSuchMethodException) {
                                // empty catch block
                            }
                            try {
                                classArray = new Class[]{class$java$io$ObjectInputStream == null ? (class$java$io$ObjectInputStream = ObjectStreamClass.class$("java.io.ObjectInputStream")) : class$java$io$ObjectInputStream};
                                ObjectStreamClass.this.readObjectMethod = clazz.getDeclaredMethod("readObject", classArray);
                                n2 = ObjectStreamClass.this.readObjectMethod.getModifiers();
                                if (!Modifier.isPrivate(n2) || Modifier.isStatic(n2)) {
                                    ObjectStreamClass.this.readObjectMethod = null;
                                }
                            }
                            catch (NoSuchMethodException noSuchMethodException) {}
                        }
                        return null;
                    }
                });
            }
            this.actualSuid = ObjectStreamClass.computeStructuralUID(this, clazz);
            this.initialized = true;
        }
    }

    ObjectStreamClass(String string, long l2) {
        this.name = string;
        this.suid = l2;
        this.superclass = null;
    }

    private static Object[] translateFields(Object[] objectArray) throws NoSuchFieldException {
        try {
            java.io.ObjectStreamField[] objectStreamFieldArray = (java.io.ObjectStreamField[])objectArray;
            Object[] objectArray2 = null;
            if (translatedFields == null) {
                translatedFields = new Hashtable();
            }
            if ((objectArray2 = (Object[])translatedFields.get(objectStreamFieldArray)) != null) {
                return objectArray2;
            }
            Class clazz = Class.forName("com.sun.corba.se.internal.io.ObjectStreamField");
            objectArray2 = (Object[])Array.newInstance(clazz, objectArray.length);
            Object[] objectArray3 = new Object[2];
            Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = ObjectStreamClass.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Class == null ? (class$java$lang$Class = ObjectStreamClass.class$("java.lang.Class")) : class$java$lang$Class};
            Constructor constructor = clazz.getDeclaredConstructor(classArray);
            int n2 = objectStreamFieldArray.length - 1;
            while (n2 >= 0) {
                objectArray3[0] = objectStreamFieldArray[n2].getName();
                objectArray3[1] = objectStreamFieldArray[n2].getType();
                objectArray2[n2] = constructor.newInstance(objectArray3);
                --n2;
            }
            translatedFields.put(objectStreamFieldArray, objectArray2);
            return objectArray2;
        }
        catch (Throwable throwable) {
            throw new NoSuchFieldException();
        }
    }

    final void setClass(Class clazz) throws InvalidClassException {
        if (clazz == null) {
            this.localClassDesc = null;
            this.ofClass = null;
            this.computeFieldInfo();
            return;
        }
        this.localClassDesc = ObjectStreamClass.lookupInternal(clazz);
        if (this.localClassDesc == null) {
            throw new InvalidClassException(clazz.getName(), "Local class not compatible");
        }
        if (this.suid != this.localClassDesc.suid) {
            boolean bl2;
            boolean bl3 = this.isNonSerializable() || this.localClassDesc.isNonSerializable();
            boolean bl4 = bl2 = clazz.isArray() && !clazz.getName().equals(this.name);
            if (!bl2 && !bl3) {
                throw new InvalidClassException(clazz.getName(), "Local class not compatible: stream classdesc serialVersionUID=" + this.suid + " local class serialVersionUID=" + this.localClassDesc.suid);
            }
        }
        if (!ObjectStreamClass.compareClassNames(this.name, clazz.getName(), '.')) {
            throw new InvalidClassException(clazz.getName(), "Incompatible local class name. Expected class name compatible with " + this.name);
        }
        if (this.serializable != this.localClassDesc.serializable || this.externalizable != this.localClassDesc.externalizable || !this.serializable && !this.externalizable) {
            throw new InvalidClassException(clazz.getName(), "Serialization incompatible with Externalization");
        }
        ObjectStreamField[] objectStreamFieldArray = this.localClassDesc.fields;
        ObjectStreamField[] objectStreamFieldArray2 = this.fields;
        int n2 = 0;
        int n3 = 0;
        while (n3 < objectStreamFieldArray2.length) {
            int n4 = n2;
            while (n4 < objectStreamFieldArray.length) {
                if (objectStreamFieldArray2[n3].getName().equals(objectStreamFieldArray[n4].getName())) {
                    if (objectStreamFieldArray2[n3].isPrimitive() && !objectStreamFieldArray2[n3].typeEquals(objectStreamFieldArray[n4])) {
                        throw new InvalidClassException(clazz.getName(), "The type of field " + objectStreamFieldArray2[n3].getName() + " of class " + this.name + " is incompatible.");
                    }
                    n2 = n4;
                    objectStreamFieldArray2[n3].setField(objectStreamFieldArray[n2].getField());
                    break;
                }
                ++n4;
            }
            ++n3;
        }
        this.computeFieldInfo();
        this.ofClass = clazz;
        this.readObjectMethod = this.localClassDesc.readObjectMethod;
        this.readResolveObjectMethod = this.localClassDesc.readResolveObjectMethod;
    }

    static boolean compareClassNames(String string, String string2, char c2) {
        int n2;
        int n3 = string.lastIndexOf(c2);
        if (n3 < 0) {
            n3 = 0;
        }
        if ((n2 = string2.lastIndexOf(c2)) < 0) {
            n2 = 0;
        }
        return string.regionMatches(false, n3, string2, n2, string.length() - n3);
    }

    final boolean typeEquals(ObjectStreamClass objectStreamClass) {
        return this.suid == objectStreamClass.suid && ObjectStreamClass.compareClassNames(this.name, objectStreamClass.name, '.');
    }

    final void setSuperclass(ObjectStreamClass objectStreamClass) {
        this.superclass = objectStreamClass;
    }

    final ObjectStreamClass getSuperclass() {
        return this.superclass;
    }

    final boolean hasWriteObject() {
        return this.hasWriteObjectMethod;
    }

    final boolean isCustomMarshaled() {
        return this.hasWriteObject() || this.isExternalizable();
    }

    boolean hasExternalizableBlockDataMode() {
        return this.hasExternalizableBlockData;
    }

    final ObjectStreamClass localClassDescriptor() {
        return this.localClassDesc;
    }

    boolean isSerializable() {
        return this.serializable;
    }

    boolean isExternalizable() {
        return this.externalizable;
    }

    boolean isNonSerializable() {
        return !this.externalizable && !this.serializable;
    }

    private void computeFieldInfo() {
        this.primBytes = 0;
        this.objFields = 0;
        int n2 = 0;
        while (n2 < this.fields.length) {
            switch (this.fields[n2].getTypeCode()) {
                case 'B': 
                case 'Z': {
                    ++this.primBytes;
                    break;
                }
                case 'C': 
                case 'S': {
                    this.primBytes += 2;
                    break;
                }
                case 'F': 
                case 'I': {
                    this.primBytes += 4;
                    break;
                }
                case 'D': 
                case 'J': {
                    this.primBytes += 8;
                    break;
                }
                case 'L': 
                case '[': {
                    ++this.objFields;
                }
            }
            ++n2;
        }
    }

    private static long _computeSerialVersionUID(Class clazz) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
        long l2 = 0L;
        try {
            Object object;
            Object object2;
            int n2;
            MethodSignature[] methodSignatureArray;
            int n3;
            Object[] objectArray;
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            DigestOutputStream digestOutputStream = new DigestOutputStream(byteArrayOutputStream, messageDigest);
            DataOutputStream dataOutputStream = new DataOutputStream(digestOutputStream);
            dataOutputStream.writeUTF(clazz.getName());
            int n4 = clazz.getModifiers();
            Member[] memberArray = clazz.getDeclaredMethods();
            if (((n4 &= 0x611) & 0x200) != 0) {
                n4 &= 0xFFFFFBFF;
                if (memberArray.length > 0) {
                    n4 |= 0x400;
                }
            }
            dataOutputStream.writeInt(n4);
            if (!clazz.isArray()) {
                objectArray = clazz.getInterfaces();
                Arrays.sort(objectArray, compareClassByName);
                n3 = 0;
                while (n3 < objectArray.length) {
                    dataOutputStream.writeUTF(((Class)objectArray[n3]).getName());
                    ++n3;
                }
            }
            objectArray = clazz.getDeclaredFields();
            Arrays.sort(objectArray, compareMemberByName);
            n3 = 0;
            while (n3 < objectArray.length) {
                methodSignatureArray = objectArray[n3];
                n2 = methodSignatureArray.getModifiers();
                if (!Modifier.isPrivate(n2) || !Modifier.isTransient(n2) && !Modifier.isStatic(n2)) {
                    dataOutputStream.writeUTF(methodSignatureArray.getName());
                    dataOutputStream.writeInt(n2);
                    dataOutputStream.writeUTF(ObjectStreamClass.getSignature(methodSignatureArray.getType()));
                }
                ++n3;
            }
            if (ObjectStreamClass.hasStaticInitializer(clazz)) {
                dataOutputStream.writeUTF("<clinit>");
                dataOutputStream.writeInt(8);
                dataOutputStream.writeUTF("()V");
            }
            methodSignatureArray = MethodSignature.removePrivateAndSort(clazz.getDeclaredConstructors());
            n2 = 0;
            while (n2 < methodSignatureArray.length) {
                object2 = methodSignatureArray[n2];
                String string = "<init>";
                object = object2.signature;
                object = ((String)object).replace('/', '.');
                dataOutputStream.writeUTF(string);
                dataOutputStream.writeInt(object2.member.getModifiers());
                dataOutputStream.writeUTF((String)object);
                ++n2;
            }
            object2 = MethodSignature.removePrivateAndSort(memberArray);
            int n5 = 0;
            while (n5 < ((MethodSignature[])object2).length) {
                object = object2[n5];
                String string = ((MethodSignature)object).signature;
                string = string.replace('/', '.');
                dataOutputStream.writeUTF(((MethodSignature)object).member.getName());
                dataOutputStream.writeInt(((MethodSignature)object).member.getModifiers());
                dataOutputStream.writeUTF(string);
                ++n5;
            }
            dataOutputStream.flush();
            object = messageDigest.digest();
            int n6 = 0;
            while (n6 < Math.min(8, ((Object)object).length)) {
                l2 += (long)(object[n6] & 0xFF) << n6 * 8;
                ++n6;
            }
        }
        catch (IOException iOException) {
            l2 = -1L;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SecurityException(noSuchAlgorithmException.getMessage());
        }
        return l2;
    }

    private static long computeStructuralUID(ObjectStreamClass objectStreamClass, Class clazz) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
        long l2 = 0L;
        try {
            if (!(class$java$io$Serializable == null ? (class$java$io$Serializable = ObjectStreamClass.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(clazz) || clazz.isInterface()) {
                return 0L;
            }
            if ((class$java$io$Externalizable == null ? (class$java$io$Externalizable = ObjectStreamClass.class$("java.io.Externalizable")) : class$java$io$Externalizable).isAssignableFrom(clazz)) {
                return 1L;
            }
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            DigestOutputStream digestOutputStream = new DigestOutputStream(byteArrayOutputStream, messageDigest);
            DataOutputStream dataOutputStream = new DataOutputStream(digestOutputStream);
            Class clazz2 = clazz.getSuperclass();
            if (clazz2 != null) {
                dataOutputStream.writeLong(ObjectStreamClass.computeStructuralUID(ObjectStreamClass.lookup(clazz2), clazz2));
            }
            if (objectStreamClass.hasWriteObject()) {
                dataOutputStream.writeInt(2);
            } else {
                dataOutputStream.writeInt(1);
            }
            Object[] objectArray = objectStreamClass.getFields();
            if (objectArray.length > 1) {
                Arrays.sort(objectArray, compareObjStrFieldsByName);
            }
            int n2 = 0;
            while (n2 < objectArray.length) {
                dataOutputStream.writeUTF(((ObjectStreamField)objectArray[n2]).getName());
                dataOutputStream.writeUTF(((ObjectStreamField)objectArray[n2]).getSignature());
                ++n2;
            }
            dataOutputStream.flush();
            byte[] byArray = messageDigest.digest();
            int n3 = 0;
            while (n3 < Math.min(8, byArray.length)) {
                l2 += (long)(byArray[n3] & 0xFF) << n3 * 8;
                ++n3;
            }
        }
        catch (IOException iOException) {
            l2 = -1L;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SecurityException(noSuchAlgorithmException.getMessage());
        }
        return l2;
    }

    static String getSignature(Class clazz) {
        String string = null;
        if (clazz.isArray()) {
            Class clazz2 = clazz;
            int n2 = 0;
            while (clazz2.isArray()) {
                ++n2;
                clazz2 = clazz2.getComponentType();
            }
            StringBuffer stringBuffer = new StringBuffer();
            int n3 = 0;
            while (n3 < n2) {
                stringBuffer.append("[");
                ++n3;
            }
            stringBuffer.append(ObjectStreamClass.getSignature(clazz2));
            string = stringBuffer.toString();
        } else if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                string = "I";
            } else if (clazz == Byte.TYPE) {
                string = "B";
            } else if (clazz == Long.TYPE) {
                string = "J";
            } else if (clazz == Float.TYPE) {
                string = "F";
            } else if (clazz == Double.TYPE) {
                string = "D";
            } else if (clazz == Short.TYPE) {
                string = "S";
            } else if (clazz == Character.TYPE) {
                string = "C";
            } else if (clazz == Boolean.TYPE) {
                string = "Z";
            } else if (clazz == Void.TYPE) {
                string = "V";
            }
        } else {
            string = "L" + clazz.getName().replace('.', '/') + ";";
        }
        return string;
    }

    static String getSignature(Method method) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        Class[] classArray = method.getParameterTypes();
        int n2 = 0;
        while (n2 < classArray.length) {
            stringBuffer.append(ObjectStreamClass.getSignature(classArray[n2]));
            ++n2;
        }
        stringBuffer.append(")");
        stringBuffer.append(ObjectStreamClass.getSignature(method.getReturnType()));
        return stringBuffer.toString();
    }

    static String getSignature(Constructor constructor) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        Class[] classArray = constructor.getParameterTypes();
        int n2 = 0;
        while (n2 < classArray.length) {
            stringBuffer.append(ObjectStreamClass.getSignature(classArray[n2]));
            ++n2;
        }
        stringBuffer.append(")V");
        return stringBuffer.toString();
    }

    private static ObjectStreamClass findDescriptorFor(Class clazz) {
        ObjectStreamClassEntry objectStreamClassEntry;
        int n2 = clazz.hashCode();
        int n3 = (n2 & Integer.MAX_VALUE) % descriptorFor.length;
        while ((objectStreamClassEntry = descriptorFor[n3]) != null && objectStreamClassEntry.get() == null) {
            ObjectStreamClass.descriptorFor[n3] = objectStreamClassEntry.next;
        }
        ObjectStreamClassEntry objectStreamClassEntry2 = objectStreamClassEntry;
        while (objectStreamClassEntry != null) {
            ObjectStreamClass objectStreamClass = (ObjectStreamClass)objectStreamClassEntry.get();
            if (objectStreamClass == null) {
                objectStreamClassEntry2.next = objectStreamClassEntry.next;
            } else {
                if (objectStreamClass.ofClass == clazz) {
                    return objectStreamClass;
                }
                objectStreamClassEntry2 = objectStreamClassEntry;
            }
            objectStreamClassEntry = objectStreamClassEntry.next;
        }
        return null;
    }

    private static void insertDescriptorFor(ObjectStreamClass objectStreamClass) {
        if (ObjectStreamClass.findDescriptorFor(objectStreamClass.ofClass) != null) {
            return;
        }
        int n2 = objectStreamClass.ofClass.hashCode();
        int n3 = (n2 & Integer.MAX_VALUE) % descriptorFor.length;
        ObjectStreamClassEntry objectStreamClassEntry = new ObjectStreamClassEntry(objectStreamClass);
        objectStreamClassEntry.next = descriptorFor[n3];
        ObjectStreamClass.descriptorFor[n3] = objectStreamClassEntry;
    }

    private static Field[] getDeclaredFields(final Class clazz) {
        return (Field[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return clazz.getDeclaredFields();
            }
        });
    }

    private static native boolean hasStaticInitializer(Class var0);

    private static Method getInheritableMethod(Class clazz, String string, Class[] classArray, Class clazz2) {
        Method method = null;
        Class clazz3 = clazz;
        while (clazz3 != null) {
            try {
                method = clazz3.getDeclaredMethod(string, classArray);
                break;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                clazz3 = clazz3.getSuperclass();
            }
        }
        if (method == null || method.getReturnType() != clazz2) {
            return null;
        }
        method.setAccessible(true);
        int n2 = method.getModifiers();
        if ((n2 & 0x408) != 0) {
            return null;
        }
        if ((n2 & 5) != 0) {
            return method;
        }
        if ((n2 & 2) != 0) {
            return clazz == clazz3 ? method : null;
        }
        return ObjectStreamClass.packageEquals(clazz, clazz3) ? method : null;
    }

    private static boolean packageEquals(Class clazz, Class clazz2) {
        Package package_;
        Package package_2 = clazz.getPackage();
        return package_2 == (package_ = clazz2.getPackage()) || package_2 != null && package_2.equals(package_);
    }

    static /* synthetic */ ObjectStreamField[] access$002(ObjectStreamClass objectStreamClass, ObjectStreamField[] objectStreamFieldArray) {
        objectStreamClass.fields = objectStreamFieldArray;
        return objectStreamFieldArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            Class.forName("com.sun.corba.se.internal.io.LibraryManager").getDeclaredMethod("load", null).invoke(null, null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        descriptorFor = new ObjectStreamClassEntry[61];
        classSerializable = null;
        classExternalizable = null;
        try {
            classSerializable = Class.forName("java.io.Serializable");
            classExternalizable = Class.forName("java.io.Externalizable");
        }
        catch (Throwable throwable) {
            System.err.println("Could not load java.io.Serializable or java.io.Externalizable.");
        }
        NO_FIELDS = new ObjectStreamField[0];
        compareClassByName = new CompareClassByName();
        compareObjStrFieldsByName = new CompareObjStrFieldsByName();
        compareMemberByName = new CompareMemberByName();
    }

    private static class MethodSignature
    implements Comparator {
        Member member;
        String signature;

        static MethodSignature[] removePrivateAndSort(Member[] memberArray) {
            int n2 = 0;
            int n3 = 0;
            while (n3 < memberArray.length) {
                if (!Modifier.isPrivate(memberArray[n3].getModifiers())) {
                    ++n2;
                }
                ++n3;
            }
            Object[] objectArray = new MethodSignature[n2];
            int n4 = 0;
            int n5 = 0;
            while (n5 < memberArray.length) {
                if (!Modifier.isPrivate(memberArray[n5].getModifiers())) {
                    objectArray[n4] = new MethodSignature(memberArray[n5]);
                    ++n4;
                }
                ++n5;
            }
            if (n4 > 0) {
                Arrays.sort(objectArray, objectArray[0]);
            }
            return objectArray;
        }

        public int compare(Object object, Object object2) {
            int n2;
            if (object == object2) {
                return 0;
            }
            MethodSignature methodSignature = (MethodSignature)object;
            MethodSignature methodSignature2 = (MethodSignature)object2;
            if (this.isConstructor()) {
                n2 = methodSignature.signature.compareTo(methodSignature2.signature);
            } else {
                n2 = methodSignature.member.getName().compareTo(methodSignature2.member.getName());
                if (n2 == 0) {
                    n2 = methodSignature.signature.compareTo(methodSignature2.signature);
                }
            }
            return n2;
        }

        private final boolean isConstructor() {
            return this.member instanceof Constructor;
        }

        private MethodSignature(Member member) {
            this.member = member;
            this.signature = this.isConstructor() ? ObjectStreamClass.getSignature((Constructor)member) : ObjectStreamClass.getSignature((Method)member);
        }
    }

    private static class CompareMemberByName
    implements Comparator {
        private CompareMemberByName() {
        }

        public int compare(Object object, Object object2) {
            String string = ((Member)object).getName();
            String string2 = ((Member)object2).getName();
            if (object instanceof Method) {
                string = string + ObjectStreamClass.getSignature((Method)object);
                string2 = string2 + ObjectStreamClass.getSignature((Method)object2);
            } else if (object instanceof Constructor) {
                string = string + ObjectStreamClass.getSignature((Constructor)object);
                string2 = string2 + ObjectStreamClass.getSignature((Constructor)object2);
            }
            return string.compareTo(string2);
        }
    }

    private static class CompareObjStrFieldsByName
    implements Comparator {
        private CompareObjStrFieldsByName() {
        }

        public int compare(Object object, Object object2) {
            ObjectStreamField objectStreamField = (ObjectStreamField)object;
            ObjectStreamField objectStreamField2 = (ObjectStreamField)object2;
            return objectStreamField.getName().compareTo(objectStreamField2.getName());
        }
    }

    private static class CompareClassByName
    implements Comparator {
        private CompareClassByName() {
        }

        public int compare(Object object, Object object2) {
            Class clazz = (Class)object;
            Class clazz2 = (Class)object2;
            return clazz.getName().compareTo(clazz2.getName());
        }
    }

    private static class ObjectStreamClassEntry {
        ObjectStreamClassEntry next;
        private ObjectStreamClass c;

        ObjectStreamClassEntry(ObjectStreamClass objectStreamClass) {
            this.c = objectStreamClass;
        }

        public Object get() {
            return this.c;
        }
    }
}

