/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.jpeg;

import com.sun.imageio.plugins.jpeg.JPEGBuffer;
import com.sun.imageio.plugins.jpeg.MarkerSegment;
import java.io.IOException;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;
import org.w3c.dom.Node;

class DRIMarkerSegment
extends MarkerSegment {
    int restartInterval = 0;

    DRIMarkerSegment(JPEGBuffer jPEGBuffer) throws IOException {
        super(jPEGBuffer);
        this.restartInterval = (jPEGBuffer.buf[jPEGBuffer.bufPtr++] & 0xFF) << 8;
        this.restartInterval |= jPEGBuffer.buf[jPEGBuffer.bufPtr++] & 0xFF;
        jPEGBuffer.bufAvail -= this.length;
    }

    DRIMarkerSegment(Node node) throws IIOInvalidTreeException {
        super(221);
        this.updateFromNativeNode(node, true);
    }

    IIOMetadataNode getNativeNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("dri");
        iIOMetadataNode.setAttribute("interval", Integer.toString(this.restartInterval));
        return iIOMetadataNode;
    }

    void updateFromNativeNode(Node node, boolean bl2) throws IIOInvalidTreeException {
        this.restartInterval = MarkerSegment.getAttributeValue(node, null, "interval", 0, 65535, true);
    }

    void write(ImageOutputStream imageOutputStream) throws IOException {
    }

    void print() {
        this.printTag("DRI");
        System.out.println("Interval: " + Integer.toString(this.restartInterval));
    }
}

