/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.plaf.metal.MetalUtils;

public class MetalTabbedPaneUI
extends BasicTabbedPaneUI {
    protected int minTabWidth = 40;
    protected Color tabAreaBackground;
    protected Color selectColor;
    protected Color selectHighlight;

    public static ComponentUI createUI(JComponent jComponent) {
        return new MetalTabbedPaneUI();
    }

    protected LayoutManager createLayoutManager() {
        if (this.tabPane.getTabLayoutPolicy() == 1) {
            return super.createLayoutManager();
        }
        return new TabbedPaneLayout();
    }

    protected void installDefaults() {
        super.installDefaults();
        this.tabAreaBackground = UIManager.getColor("TabbedPane.tabAreaBackground");
        this.selectColor = UIManager.getColor("TabbedPane.selected");
        this.selectHighlight = UIManager.getColor("TabbedPane.selectHighlight");
    }

    protected void paintTabBorder(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl2) {
        int n8 = n5 + (n7 - 1);
        int n9 = n4 + (n6 - 1);
        switch (n2) {
            case 2: {
                this.paintLeftTabBorder(n3, graphics, n4, n5, n6, n7, n8, n9, bl2);
                break;
            }
            case 3: {
                this.paintBottomTabBorder(n3, graphics, n4, n5, n6, n7, n8, n9, bl2);
                break;
            }
            case 4: {
                this.paintRightTabBorder(n3, graphics, n4, n5, n6, n7, n8, n9, bl2);
                break;
            }
            default: {
                this.paintTopTabBorder(n3, graphics, n4, n5, n6, n7, n8, n9, bl2);
            }
        }
    }

    protected void paintTopTabBorder(int n2, Graphics graphics, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl2) {
        int n9 = this.getRunForTab(this.tabPane.getTabCount(), n2);
        int n10 = this.lastTabInRun(this.tabPane.getTabCount(), n9);
        int n11 = this.tabRuns[n9];
        boolean bl3 = MetalUtils.isLeftToRight(this.tabPane);
        int n12 = n6 - 1;
        int n13 = n5 - 1;
        if (this.shouldFillGap(n9, n2, n3, n4)) {
            graphics.translate(n3, n4);
            if (bl3) {
                graphics.setColor(this.getColorForGap(n9, n3, n4 + 1));
                graphics.fillRect(1, 0, 5, 3);
                graphics.fillRect(1, 3, 2, 2);
            } else {
                graphics.setColor(this.getColorForGap(n9, n3 + n5 - 1, n4 + 1));
                graphics.fillRect(n13 - 5, 0, 5, 3);
                graphics.fillRect(n13 - 2, 3, 2, 2);
            }
            graphics.translate(-n3, -n4);
        }
        graphics.translate(n3, n4);
        graphics.setColor(this.darkShadow);
        if (bl3) {
            graphics.drawLine(1, 5, 6, 0);
            graphics.drawLine(6, 0, n13, 0);
            if (n2 == n10) {
                graphics.drawLine(n13, 1, n13, n12);
            }
            if (n2 != this.tabRuns[this.runCount - 1]) {
                graphics.drawLine(0, 0, 0, n12);
            } else {
                graphics.drawLine(0, 6, 0, n12);
            }
        } else {
            graphics.drawLine(n13 - 1, 5, n13 - 6, 0);
            graphics.drawLine(n13 - 6, 0, 0, 0);
            if (n2 != this.tabRuns[this.runCount - 1]) {
                graphics.drawLine(n13, 0, n13, n12);
            } else {
                graphics.drawLine(n13, 6, n13, n12);
            }
            if (n2 == n10) {
                graphics.drawLine(0, 1, 0, n12);
            }
        }
        graphics.setColor(bl2 ? this.selectHighlight : this.highlight);
        if (bl3) {
            graphics.drawLine(1, 6, 6, 1);
            graphics.drawLine(6, 1, n13, 1);
            graphics.drawLine(1, 6, 1, n12);
            if (n2 == n11 && n2 != this.tabRuns[this.runCount - 1]) {
                if (this.tabPane.getSelectedIndex() == this.tabRuns[n9 + 1]) {
                    graphics.setColor(this.selectHighlight);
                } else {
                    graphics.setColor(this.highlight);
                }
                graphics.drawLine(1, 0, 1, 4);
            }
        } else {
            graphics.drawLine(n13 - 1, 6, n13 - 6, 1);
            graphics.drawLine(n13 - 6, 1, 1, 1);
            if (n2 == n10) {
                graphics.drawLine(1, 1, 1, n12);
            } else {
                graphics.drawLine(0, 1, 0, n12);
            }
        }
        graphics.translate(-n3, -n4);
    }

    protected boolean shouldFillGap(int n2, int n3, int n4, int n5) {
        boolean bl2 = false;
        if (n2 == this.runCount - 2) {
            int n6;
            int n7;
            int n8;
            Rectangle rectangle = this.getTabBounds(this.tabPane, this.tabPane.getTabCount() - 1);
            Rectangle rectangle2 = this.getTabBounds(this.tabPane, n3);
            if (MetalUtils.isLeftToRight(this.tabPane) ? (n8 = rectangle.x + rectangle.width - 1) > rectangle2.x + 2 : (n7 = rectangle.x) < (n6 = rectangle2.x + rectangle2.width - 1) - 2) {
                return true;
            }
        } else {
            bl2 = n2 != this.runCount - 1;
        }
        return bl2;
    }

    protected Color getColorForGap(int n2, int n3, int n4) {
        int n5 = this.tabPane.getSelectedIndex();
        int n6 = this.tabRuns[n2 + 1];
        int n7 = this.lastTabInRun(this.tabPane.getTabCount(), n2 + 1);
        int n8 = -1;
        int n9 = n6;
        while (n9 <= n7) {
            Rectangle rectangle = this.getTabBounds(this.tabPane, n9);
            int n10 = rectangle.x;
            int n11 = rectangle.x + rectangle.width - 1;
            if (MetalUtils.isLeftToRight(this.tabPane) ? n10 <= n3 && n11 - 4 > n3 : n10 + 4 < n3 && n11 >= n3) {
                return n5 == n9 ? this.selectColor : this.tabPane.getBackgroundAt(n9);
            }
            ++n9;
        }
        return this.tabPane.getBackground();
    }

    protected void paintLeftTabBorder(int n2, Graphics graphics, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl2) {
        int n9 = this.tabPane.getTabCount();
        int n10 = this.getRunForTab(n9, n2);
        int n11 = this.lastTabInRun(n9, n10);
        int n12 = this.tabRuns[n10];
        graphics.translate(n3, n4);
        int n13 = n6 - 1;
        int n14 = n5 - 1;
        if (n2 != n12) {
            graphics.setColor(this.tabPane.getSelectedIndex() == n2 - 1 ? this.selectColor : this.tabPane.getBackgroundAt(n2 - 1));
            graphics.fillRect(2, 0, 4, 3);
            graphics.drawLine(2, 3, 2, 3);
        }
        graphics.setColor(bl2 ? this.selectHighlight : this.highlight);
        graphics.drawLine(1, 6, 6, 1);
        graphics.drawLine(6, 1, n14, 1);
        graphics.drawLine(1, 6, 1, n13);
        if (n2 != n12) {
            graphics.setColor(this.tabPane.getSelectedIndex() == n2 - 1 ? this.selectHighlight : this.highlight);
            graphics.drawLine(1, 0, 1, 4);
        }
        graphics.setColor(this.darkShadow);
        graphics.drawLine(1, 5, 6, 0);
        graphics.drawLine(6, 0, n14, 0);
        if (n2 != n12) {
            graphics.drawLine(0, 0, 0, n13);
        } else {
            graphics.drawLine(0, 6, 0, n13);
        }
        if (n2 == n11) {
            graphics.drawLine(0, n13, n14, n13);
        }
        graphics.translate(-n3, -n4);
    }

    protected void paintBottomTabBorder(int n2, Graphics graphics, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl2) {
        int n9 = this.tabPane.getTabCount();
        int n10 = this.getRunForTab(n9, n2);
        int n11 = this.lastTabInRun(n9, n10);
        int n12 = this.tabRuns[n10];
        boolean bl3 = MetalUtils.isLeftToRight(this.tabPane);
        int n13 = n6 - 1;
        int n14 = n5 - 1;
        if (this.shouldFillGap(n10, n2, n3, n4)) {
            graphics.translate(n3, n4);
            if (bl3) {
                graphics.setColor(this.getColorForGap(n10, n3, n4));
                graphics.fillRect(1, n13 - 4, 3, 5);
                graphics.fillRect(4, n13 - 1, 2, 2);
            } else {
                graphics.setColor(this.getColorForGap(n10, n3 + n5 - 1, n4));
                graphics.fillRect(n14 - 3, n13 - 3, 3, 4);
                graphics.fillRect(n14 - 5, n13 - 1, 2, 2);
                graphics.drawLine(n14 - 1, n13 - 4, n14 - 1, n13 - 4);
            }
            graphics.translate(-n3, -n4);
        }
        graphics.translate(n3, n4);
        graphics.setColor(this.darkShadow);
        if (bl3) {
            graphics.drawLine(1, n13 - 5, 6, n13);
            graphics.drawLine(6, n13, n14, n13);
            if (n2 == n11) {
                graphics.drawLine(n14, 0, n14, n13);
            }
            if (n2 != this.tabRuns[this.runCount - 1]) {
                graphics.drawLine(0, 0, 0, n13);
            } else {
                graphics.drawLine(0, 0, 0, n13 - 6);
            }
        } else {
            graphics.drawLine(n14 - 1, n13 - 5, n14 - 6, n13);
            graphics.drawLine(n14 - 6, n13, 0, n13);
            if (n2 != this.tabRuns[this.runCount - 1]) {
                graphics.drawLine(n14, 0, n14, n13);
            } else {
                graphics.drawLine(n14, 0, n14, n13 - 6);
            }
            if (n2 == n11) {
                graphics.drawLine(0, 0, 0, n13);
            }
        }
        graphics.setColor(bl2 ? this.selectHighlight : this.highlight);
        if (bl3) {
            graphics.drawLine(1, n13 - 6, 6, n13 - 1);
            graphics.drawLine(1, 0, 1, n13 - 6);
            if (n2 == n12 && n2 != this.tabRuns[this.runCount - 1]) {
                if (this.tabPane.getSelectedIndex() == this.tabRuns[n10 + 1]) {
                    graphics.setColor(this.selectHighlight);
                } else {
                    graphics.setColor(this.highlight);
                }
                graphics.drawLine(1, n13 - 4, 1, n13);
            }
        } else if (n2 == n11) {
            graphics.drawLine(1, 0, 1, n13 - 1);
        } else {
            graphics.drawLine(0, 0, 0, n13 - 1);
        }
        graphics.translate(-n3, -n4);
    }

    protected void paintRightTabBorder(int n2, Graphics graphics, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl2) {
        int n9 = this.tabPane.getTabCount();
        int n10 = this.getRunForTab(n9, n2);
        int n11 = this.lastTabInRun(n9, n10);
        int n12 = this.tabRuns[n10];
        graphics.translate(n3, n4);
        int n13 = n6 - 1;
        int n14 = n5 - 1;
        if (n2 != n12) {
            graphics.setColor(this.tabPane.getSelectedIndex() == n2 - 1 ? this.tabAreaBackground : this.tabPane.getBackgroundAt(n2 - 1));
            graphics.fillRect(n14 - 5, 0, 5, 3);
            graphics.fillRect(n14 - 2, 3, 2, 2);
        }
        graphics.setColor(bl2 ? this.selectHighlight : this.highlight);
        graphics.drawLine(n14 - 6, 1, n14 - 1, 6);
        graphics.drawLine(0, 1, n14 - 6, 1);
        if (!bl2) {
            graphics.drawLine(0, 1, 0, n13);
        }
        graphics.setColor(this.darkShadow);
        graphics.drawLine(n14 - 6, 0, n14, 6);
        graphics.drawLine(0, 0, n14 - 6, 0);
        if (n2 != n12) {
            graphics.drawLine(n14, 0, n14, n13);
        } else {
            graphics.drawLine(n14, 6, n14, n13);
        }
        if (n2 == n11) {
            graphics.drawLine(0, n13, n14, n13);
        }
        graphics.translate(-n3, -n4);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        if (jComponent.isOpaque()) {
            graphics.setColor(this.tabAreaBackground);
            graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
        }
        this.paint(graphics, jComponent);
    }

    protected void paintTabBackground(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl2) {
        int n8 = n7 / 2;
        if (bl2) {
            graphics.setColor(this.selectColor);
        } else {
            graphics.setColor(this.tabPane.getBackgroundAt(n3));
        }
        if (MetalUtils.isLeftToRight(this.tabPane)) {
            switch (n2) {
                case 2: {
                    graphics.fillRect(n4 + 5, n5 + 1, n6 - 5, n7 - 1);
                    graphics.fillRect(n4 + 2, n5 + 4, 3, n7 - 4);
                    break;
                }
                case 3: {
                    graphics.fillRect(n4 + 2, n5, n6 - 2, n7 - 4);
                    graphics.fillRect(n4 + 5, n5 + (n7 - 1) - 3, n6 - 5, 3);
                    break;
                }
                case 4: {
                    graphics.fillRect(n4 + 1, n5 + 1, n6 - 5, n7 - 1);
                    graphics.fillRect(n4 + (n6 - 1) - 3, n5 + 5, 3, n7 - 5);
                    break;
                }
                default: {
                    graphics.fillRect(n4 + 4, n5 + 2, n6 - 1 - 3, n7 - 1 - 1);
                    graphics.fillRect(n4 + 2, n5 + 5, 2, n7 - 5);
                    break;
                }
            }
        } else {
            switch (n2) {
                case 2: {
                    graphics.fillRect(n4 + 5, n5 + 1, n6 - 5, n7 - 1);
                    graphics.fillRect(n4 + 2, n5 + 4, 3, n7 - 4);
                    break;
                }
                case 3: {
                    graphics.fillRect(n4, n5, n6 - 5, n7 - 1);
                    graphics.fillRect(n4 + (n6 - 1) - 4, n5, 4, n7 - 5);
                    graphics.fillRect(n4 + (n6 - 1) - 4, n5 + (n7 - 1) - 4, 2, 2);
                    break;
                }
                case 4: {
                    graphics.fillRect(n4 + 1, n5 + 1, n6 - 5, n7 - 1);
                    graphics.fillRect(n4 + (n6 - 1) - 3, n5 + 5, 3, n7 - 5);
                    break;
                }
                default: {
                    graphics.fillRect(n4, n5 + 2, n6 - 1 - 3, n7 - 1 - 1);
                    graphics.fillRect(n4 + (n6 - 1) - 3, n5 + 4, 3, n7 - 4);
                }
            }
        }
    }

    protected int getTabLabelShiftX(int n2, int n3, boolean bl2) {
        return 0;
    }

    protected int getTabLabelShiftY(int n2, int n3, boolean bl2) {
        return 0;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        int n2 = this.tabPane.getTabPlacement();
        Insets insets = jComponent.getInsets();
        Dimension dimension = jComponent.getSize();
        if (this.tabPane.isOpaque()) {
            graphics.setColor(jComponent.getBackground());
            switch (n2) {
                case 2: {
                    graphics.fillRect(insets.left, insets.top, this.calculateTabAreaWidth(n2, this.runCount, this.maxTabWidth), dimension.height - insets.bottom - insets.top);
                    break;
                }
                case 3: {
                    int n3 = this.calculateTabAreaHeight(n2, this.runCount, this.maxTabHeight);
                    graphics.fillRect(insets.left, dimension.height - insets.bottom - n3, dimension.width - insets.left - insets.right, n3);
                    break;
                }
                case 4: {
                    int n4 = this.calculateTabAreaWidth(n2, this.runCount, this.maxTabWidth);
                    graphics.fillRect(dimension.width - insets.right - n4, insets.top, n4, dimension.height - insets.top - insets.bottom);
                    break;
                }
                default: {
                    graphics.fillRect(insets.left, insets.top, dimension.width - insets.right - insets.left, this.calculateTabAreaHeight(n2, this.runCount, this.maxTabHeight));
                    this.paintHighlightBelowTab();
                }
            }
        }
        super.paint(graphics, jComponent);
    }

    protected void paintHighlightBelowTab() {
    }

    protected void paintFocusIndicator(Graphics graphics, int n2, Rectangle[] rectangleArray, int n3, Rectangle rectangle, Rectangle rectangle2, boolean bl2) {
        if (this.tabPane.hasFocus() && bl2) {
            Rectangle rectangle3 = rectangleArray[n3];
            boolean bl3 = this.isLastInRun(n3);
            graphics.setColor(this.focus);
            graphics.translate(rectangle3.x, rectangle3.y);
            int n4 = rectangle3.width - 1;
            int n5 = rectangle3.height - 1;
            boolean bl4 = MetalUtils.isLeftToRight(this.tabPane);
            switch (n2) {
                case 4: {
                    graphics.drawLine(n4 - 6, 2, n4 - 2, 6);
                    graphics.drawLine(1, 2, n4 - 6, 2);
                    graphics.drawLine(n4 - 2, 6, n4 - 2, n5);
                    graphics.drawLine(1, 2, 1, n5);
                    graphics.drawLine(1, n5, n4 - 2, n5);
                    break;
                }
                case 3: {
                    if (bl4) {
                        graphics.drawLine(2, n5 - 6, 6, n5 - 2);
                        graphics.drawLine(6, n5 - 2, n4, n5 - 2);
                        graphics.drawLine(2, 0, 2, n5 - 6);
                        graphics.drawLine(2, 0, n4, 0);
                        graphics.drawLine(n4, 0, n4, n5 - 2);
                        break;
                    }
                    graphics.drawLine(n4 - 2, n5 - 6, n4 - 6, n5 - 2);
                    graphics.drawLine(n4 - 2, 0, n4 - 2, n5 - 6);
                    if (bl3) {
                        graphics.drawLine(2, n5 - 2, n4 - 6, n5 - 2);
                        graphics.drawLine(2, 0, n4 - 2, 0);
                        graphics.drawLine(2, 0, 2, n5 - 2);
                        break;
                    }
                    graphics.drawLine(1, n5 - 2, n4 - 6, n5 - 2);
                    graphics.drawLine(1, 0, n4 - 2, 0);
                    graphics.drawLine(1, 0, 1, n5 - 2);
                    break;
                }
                case 2: {
                    graphics.drawLine(2, 6, 6, 2);
                    graphics.drawLine(2, 6, 2, n5 - 1);
                    graphics.drawLine(6, 2, n4, 2);
                    graphics.drawLine(n4, 2, n4, n5 - 1);
                    graphics.drawLine(2, n5 - 1, n4, n5 - 1);
                    break;
                }
                default: {
                    if (bl4) {
                        graphics.drawLine(2, 6, 6, 2);
                        graphics.drawLine(2, 6, 2, n5 - 1);
                        graphics.drawLine(6, 2, n4, 2);
                        graphics.drawLine(n4, 2, n4, n5 - 1);
                        graphics.drawLine(2, n5 - 1, n4, n5 - 1);
                        break;
                    }
                    graphics.drawLine(n4 - 2, 6, n4 - 6, 2);
                    graphics.drawLine(n4 - 2, 6, n4 - 2, n5 - 1);
                    if (bl3) {
                        graphics.drawLine(n4 - 6, 2, 2, 2);
                        graphics.drawLine(2, 2, 2, n5 - 1);
                        graphics.drawLine(n4 - 2, n5 - 1, 2, n5 - 1);
                        break;
                    }
                    graphics.drawLine(n4 - 6, 2, 1, 2);
                    graphics.drawLine(1, 2, 1, n5 - 1);
                    graphics.drawLine(n4 - 2, n5 - 1, 1, n5 - 1);
                }
            }
            graphics.translate(-rectangle3.x, -rectangle3.y);
        }
    }

    protected void paintContentBorderTopEdge(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7) {
        boolean bl2 = MetalUtils.isLeftToRight(this.tabPane);
        int n8 = n4 + n6 - 1;
        Rectangle rectangle = n3 < 0 ? null : this.getTabBounds(n3, this.calcRect);
        graphics.setColor(this.selectHighlight);
        if (n2 != 1 || n3 < 0 || rectangle.y + rectangle.height + 1 < n5 || rectangle.x < n4 || rectangle.x > n4 + n6) {
            graphics.drawLine(n4, n5, n4 + n6 - 2, n5);
        } else {
            boolean bl3 = this.isLastInRun(n3);
            if (bl2 || bl3) {
                graphics.drawLine(n4, n5, rectangle.x + 1, n5);
            } else {
                graphics.drawLine(n4, n5, rectangle.x, n5);
            }
            if (rectangle.x + rectangle.width < n8 - 1) {
                if (bl2 && !bl3) {
                    graphics.drawLine(rectangle.x + rectangle.width, n5, n8 - 1, n5);
                } else {
                    graphics.drawLine(rectangle.x + rectangle.width - 1, n5, n8 - 1, n5);
                }
            } else {
                graphics.setColor(this.shadow);
                graphics.drawLine(n4 + n6 - 2, n5, n4 + n6 - 2, n5);
            }
        }
    }

    protected void paintContentBorderBottomEdge(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7) {
        boolean bl2 = MetalUtils.isLeftToRight(this.tabPane);
        int n8 = n5 + n7 - 1;
        int n9 = n4 + n6 - 1;
        Rectangle rectangle = n3 < 0 ? null : this.getTabBounds(n3, this.calcRect);
        graphics.setColor(this.shadow);
        if (n2 != 3 || n3 < 0 || rectangle.y - 1 > n7 || rectangle.x < n4 || rectangle.x > n4 + n6) {
            graphics.setColor(this.darkShadow);
            graphics.drawLine(n4, n5 + n7 - 1, n4 + n6 - 1, n5 + n7 - 1);
        } else {
            boolean bl3 = this.isLastInRun(n3);
            graphics.setColor(this.darkShadow);
            if (bl2 || bl3) {
                graphics.drawLine(n4, n8, rectangle.x, n8);
            } else {
                graphics.drawLine(n4, n8, rectangle.x - 1, n8);
            }
            if (rectangle.x + rectangle.width < n4 + n6 - 2) {
                if (bl2 && !bl3) {
                    graphics.drawLine(rectangle.x + rectangle.width, n8, n9, n8);
                } else {
                    graphics.drawLine(rectangle.x + rectangle.width - 1, n8, n9, n8);
                }
            }
        }
    }

    protected void paintContentBorderLeftEdge(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7) {
        Rectangle rectangle = n3 < 0 ? null : this.getTabBounds(n3, this.calcRect);
        graphics.setColor(this.selectHighlight);
        if (n2 != 2 || n3 < 0 || rectangle.x + rectangle.width + 1 < n4 || rectangle.y < n5 || rectangle.y > n5 + n7) {
            graphics.drawLine(n4, n5, n4, n5 + n7 - 2);
        } else {
            graphics.drawLine(n4, n5, n4, rectangle.y + 1);
            if (rectangle.y + rectangle.height < n5 + n7 - 2) {
                graphics.drawLine(n4, rectangle.y + rectangle.height + 1, n4, n5 + n7 + 2);
            }
        }
    }

    protected void paintContentBorderRightEdge(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7) {
        Rectangle rectangle = n3 < 0 ? null : this.getTabBounds(n3, this.calcRect);
        graphics.setColor(this.shadow);
        if (n2 != 4 || n3 < 0 || rectangle.x - 1 > n6 || rectangle.y < n5 || rectangle.y > n5 + n7) {
            graphics.setColor(this.darkShadow);
            graphics.drawLine(n4 + n6 - 1, n5, n4 + n6 - 1, n5 + n7 - 1);
        } else {
            graphics.setColor(this.darkShadow);
            graphics.drawLine(n4 + n6 - 1, n5, n4 + n6 - 1, rectangle.y);
            if (rectangle.y + rectangle.height < n5 + n7 - 2) {
                graphics.setColor(this.darkShadow);
                graphics.drawLine(n4 + n6 - 1, rectangle.y + rectangle.height, n4 + n6 - 1, n5 + n7 - 2);
            }
        }
    }

    protected int calculateMaxTabHeight(int n2) {
        FontMetrics fontMetrics = this.getFontMetrics();
        int n3 = fontMetrics.getHeight();
        boolean bl2 = false;
        int n4 = 0;
        while (n4 < this.tabPane.getTabCount()) {
            Icon icon = this.tabPane.getIconAt(n4);
            if (icon != null && icon.getIconHeight() > n3) {
                bl2 = true;
                break;
            }
            ++n4;
        }
        return super.calculateMaxTabHeight(n2) - (bl2 ? this.tabInsets.top + this.tabInsets.bottom : 0);
    }

    protected int getTabRunOverlay(int n2) {
        if (n2 == 2 || n2 == 4) {
            int n3 = this.calculateMaxTabHeight(n2);
            return n3 / 2;
        }
        return 0;
    }

    protected boolean shouldRotateTabRuns(int n2, int n3) {
        return false;
    }

    protected boolean shouldPadTabRun(int n2, int n3) {
        return this.runCount > 1 && n3 < this.runCount - 1;
    }

    private boolean isLastInRun(int n2) {
        int n3 = this.getRunForTab(this.tabPane.getTabCount(), n2);
        int n4 = this.lastTabInRun(this.tabPane.getTabCount(), n3);
        return n2 == n4;
    }

    public class TabbedPaneLayout
    extends BasicTabbedPaneUI.TabbedPaneLayout {
        protected void normalizeTabRuns(int n2, int n3, int n4, int n5) {
            if (n2 == 1 || n2 == 3) {
                super.normalizeTabRuns(n2, n3, n4, n5);
            }
        }

        protected void rotateTabRuns(int n2, int n3) {
        }

        protected void padSelectedTab(int n2, int n3) {
        }
    }
}

