/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crimson.tree;

import java.io.IOException;
import java.io.Writer;
import org.apache.crimson.tree.XmlDocument;

public class XmlWriteContext {
    private Writer writer;
    private int indentLevel;
    private boolean prettyOutput;

    public XmlWriteContext(Writer writer) {
        this.writer = writer;
    }

    public XmlWriteContext(Writer writer, int n2) {
        this.writer = writer;
        this.prettyOutput = true;
        this.indentLevel = n2;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public boolean isEntityDeclared(String string) {
        return "amp".equals(string) || "lt".equals(string) || "gt".equals(string) || "quot".equals(string) || "apos".equals(string);
    }

    public int getIndentLevel() {
        return this.indentLevel;
    }

    public void setIndentLevel(int n2) {
        this.indentLevel = n2;
    }

    public void printIndent() throws IOException {
        int n2 = this.indentLevel;
        if (!this.prettyOutput) {
            return;
        }
        this.writer.write(XmlDocument.eol);
        while (n2-- > 0) {
            this.writer.write(32);
        }
    }

    public boolean isPrettyOutput() {
        return this.prettyOutput;
    }
}

