/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.font;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.LineMetrics;
import java.awt.font.TextAttribute;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import sun.awt.font.Underline;

public class Decoration {
    private static final Decoration PLAIN = new Decoration();

    private Decoration() {
    }

    public static Decoration getPlainDecoration() {
        return PLAIN;
    }

    public static Decoration getDecoration(Map map) {
        if (map == null) {
            return PLAIN;
        }
        Object object = map.get(TextAttribute.FOREGROUND);
        Object object2 = map.get(TextAttribute.BACKGROUND);
        Object object3 = map.get(TextAttribute.SWAP_COLORS);
        boolean bl2 = TextAttribute.SWAP_COLORS_ON.equals(object3);
        object3 = map.get(TextAttribute.STRIKETHROUGH);
        boolean bl3 = TextAttribute.STRIKETHROUGH_ON.equals(object3);
        object3 = map.get(TextAttribute.UNDERLINE);
        Underline underline = Underline.getUnderline(object3);
        object3 = map.get(TextAttribute.INPUT_METHOD_UNDERLINE);
        Underline underline2 = Underline.getUnderline(object3);
        if (underline == null && object == null && object2 == null && !bl2 && !bl3 && underline2 == null) {
            return PLAIN;
        }
        return new DecorationImpl((Paint)object, (Paint)object2, bl2, bl3, underline, underline2);
    }

    public void drawTextAndDecorations(Label label, Graphics2D graphics2D, float f2, float f3) {
        label.handleDraw(graphics2D, f2, f3);
    }

    public Rectangle2D getVisualBounds(Label label) {
        return label.handleGetVisualBounds();
    }

    public Rectangle2D getCharVisualBounds(Label label, int n2) {
        return label.handleGetCharVisualBounds(n2);
    }

    Shape getOutline(Label label, float f2, float f3) {
        return label.handleGetOutline(f2, f3);
    }

    private static final class DecorationImpl
    extends Decoration {
        private Paint fgPaint = null;
        private Paint bgPaint = null;
        private boolean swapColors = false;
        private boolean strikethrough = false;
        private Underline stdUnderline = null;
        private Underline imUnderline = null;

        DecorationImpl(Paint paint, Paint paint2, boolean bl2, boolean bl3, Underline underline, Underline underline2) {
            this.fgPaint = paint;
            this.bgPaint = paint2;
            this.swapColors = bl2;
            this.strikethrough = bl3;
            this.stdUnderline = underline;
            this.imUnderline = underline2;
        }

        private static boolean areEqual(Object object, Object object2) {
            if (object == null) {
                return object2 == null;
            }
            return object.equals(object2);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            DecorationImpl decorationImpl = null;
            try {
                decorationImpl = (DecorationImpl)object;
            }
            catch (ClassCastException classCastException) {
                return false;
            }
            if (this.swapColors != decorationImpl.swapColors || this.strikethrough != decorationImpl.strikethrough) {
                return false;
            }
            if (!DecorationImpl.areEqual(this.stdUnderline, decorationImpl.stdUnderline)) {
                return false;
            }
            if (!DecorationImpl.areEqual(this.fgPaint, decorationImpl.fgPaint)) {
                return false;
            }
            if (!DecorationImpl.areEqual(this.bgPaint, decorationImpl.bgPaint)) {
                return false;
            }
            return DecorationImpl.areEqual(this.imUnderline, decorationImpl.imUnderline);
        }

        public int hashCode() {
            int n2 = 1;
            if (this.strikethrough) {
                n2 |= 2;
            }
            if (this.swapColors) {
                n2 |= 4;
            }
            if (this.stdUnderline != null) {
                n2 += this.stdUnderline.hashCode();
            }
            return n2;
        }

        private float getUnderlineMaxY(LineMetrics lineMetrics) {
            float f2;
            float f3 = 0.0f;
            if (this.stdUnderline != null) {
                f2 = lineMetrics.getUnderlineOffset();
                f3 = Math.max(f3, f2 += this.stdUnderline.getLowerDrawLimit(lineMetrics.getUnderlineThickness()));
            }
            if (this.imUnderline != null) {
                f2 = lineMetrics.getUnderlineOffset();
                f3 = Math.max(f3, f2 += this.imUnderline.getLowerDrawLimit(lineMetrics.getUnderlineThickness()));
            }
            return f3;
        }

        private void drawTextAndEmbellishments(Label label, Graphics2D graphics2D, float f2, float f3) {
            float f4;
            label.handleDraw(graphics2D, f2, f3);
            if (!this.strikethrough && this.stdUnderline == null && this.imUnderline == null) {
                return;
            }
            float f5 = f2;
            float f6 = f5 + (float)label.getLogicalBounds().getWidth();
            LineMetrics lineMetrics = label.getLineMetrics();
            if (this.strikethrough) {
                Stroke stroke = graphics2D.getStroke();
                f4 = f3 + lineMetrics.getStrikethroughOffset();
                graphics2D.setStroke(new BasicStroke(lineMetrics.getStrikethroughThickness()));
                graphics2D.draw(new Line2D.Float(f5, f4, f6, f4));
                graphics2D.setStroke(stroke);
            }
            float f7 = lineMetrics.getUnderlineOffset();
            f4 = lineMetrics.getUnderlineThickness();
            if (this.stdUnderline != null) {
                this.stdUnderline.drawUnderline(graphics2D, f4, f5, f6, f3 + f7);
            }
            if (this.imUnderline != null) {
                this.imUnderline.drawUnderline(graphics2D, f4, f5, f6, f3 + f7);
            }
        }

        public void drawTextAndDecorations(Label label, Graphics2D graphics2D, float f2, float f3) {
            if (this.fgPaint == null && this.bgPaint == null && !this.swapColors) {
                this.drawTextAndEmbellishments(label, graphics2D, f2, f3);
            } else {
                Paint paint;
                Paint paint2;
                Paint paint3 = graphics2D.getPaint();
                if (this.swapColors) {
                    paint2 = this.bgPaint == null ? Color.white : this.bgPaint;
                    paint = this.fgPaint == null ? paint3 : this.fgPaint;
                } else {
                    paint2 = this.fgPaint == null ? paint3 : this.fgPaint;
                    paint = this.bgPaint;
                }
                if (paint != null) {
                    Rectangle2D rectangle2D = label.getLogicalBounds();
                    rectangle2D = new Rectangle2D.Float(f2 + (float)rectangle2D.getX(), f3 + (float)rectangle2D.getY(), (float)rectangle2D.getWidth(), (float)rectangle2D.getHeight());
                    graphics2D.setPaint(paint);
                    graphics2D.fill(rectangle2D);
                }
                graphics2D.setPaint(paint2);
                this.drawTextAndEmbellishments(label, graphics2D, f2, f3);
                graphics2D.setPaint(paint3);
            }
        }

        public Rectangle2D getVisualBounds(Label label) {
            Rectangle2D rectangle2D = label.handleGetVisualBounds();
            if (this.swapColors || this.bgPaint != null || this.stdUnderline != null || this.imUnderline != null) {
                float f2 = 0.0f;
                Rectangle2D rectangle2D2 = label.getLogicalBounds();
                float f3 = 0.0f;
                float f4 = 0.0f;
                if (this.swapColors || this.bgPaint != null) {
                    f3 = (float)rectangle2D2.getY();
                    f4 = f3 + (float)rectangle2D2.getHeight();
                }
                f4 = Math.max(f4, this.getUnderlineMaxY(label.getLineMetrics()));
                Rectangle2D.Float float_ = new Rectangle2D.Float(f2, f3, (float)rectangle2D2.getWidth(), f4 - f3);
                rectangle2D.add(float_);
            }
            return rectangle2D;
        }

        Shape getOutline(Label label, float f2, float f3) {
            Shape shape;
            if (this.stdUnderline == null && this.imUnderline == null) {
                return label.handleGetOutline(f2, f3);
            }
            LineMetrics lineMetrics = label.getLineMetrics();
            float f4 = lineMetrics.getUnderlineThickness();
            Rectangle2D rectangle2D = label.getLogicalBounds();
            float f5 = f2;
            float f6 = f5 + (float)rectangle2D.getWidth();
            Area area = null;
            if (this.stdUnderline != null) {
                shape = this.stdUnderline.getUnderlineShape(f4, f5, f6, f3);
                area = new Area(shape);
            }
            if (this.imUnderline != null) {
                shape = this.imUnderline.getUnderlineShape(f4, f5, f6, f3);
                Area area2 = new Area(shape);
                if (area == null) {
                    area = area2;
                } else {
                    area.add(area2);
                }
            }
            area.add(new Area(label.handleGetOutline(f2, f3)));
            return new GeneralPath(area);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.toString());
            stringBuffer.append("[");
            if (this.fgPaint != null) {
                stringBuffer.append("fgPaint: " + this.fgPaint);
            }
            if (this.bgPaint != null) {
                stringBuffer.append(" bgPaint: " + this.bgPaint);
            }
            if (this.swapColors) {
                stringBuffer.append(" swapColors: true");
            }
            if (this.strikethrough) {
                stringBuffer.append(" strikethrough: true");
            }
            if (this.stdUnderline != null) {
                stringBuffer.append(" stdUnderline: " + this.stdUnderline);
            }
            if (this.imUnderline != null) {
                stringBuffer.append(" imUnderline: " + this.imUnderline);
            }
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
    }

    public static interface Label {
        public LineMetrics getLineMetrics();

        public Rectangle2D getLogicalBounds();

        public void handleDraw(Graphics2D var1, float var2, float var3);

        public Rectangle2D handleGetCharVisualBounds(int var1);

        public Rectangle2D handleGetVisualBounds();

        public Shape handleGetOutline(float var1, float var2);
    }
}

