/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.List;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.peer.ListPeer;
import sun.awt.motif.MComponentPeer;
import sun.awt.motif.MToolkit;

class MListPeer
extends MComponentPeer
implements ListPeer {
    static final int MARGIN = 2;
    static final int SPACE = 1;
    static final int SCROLLBAR = 16;
    int fontHeight;
    int fontAscent;
    int fontLeading;
    int vval;
    int hval;
    int vmax;
    int hmax;

    native void create(MComponentPeer var1);

    void initialize() {
        List list = (List)this.target;
        int n2 = list.countItems();
        int n3 = 0;
        while (n3 < n2) {
            this.addItem(list.getItem(n3), -1);
            ++n3;
        }
        this.setMultipleSelections(list.allowsMultipleSelections());
        int n4 = list.getVisibleIndex();
        if (n4 >= 0) {
            this.makeVisible(n4);
        }
        int[] nArray = list.getSelectedIndexes();
        int n5 = 0;
        while (n5 < nArray.length) {
            this.select(nArray[n5]);
            ++n5;
        }
        if (n2 == 0) {
            this.addItem(" ", 0);
            this.delItems(0, 0);
        }
        super.pSetScrollbarBackground(MComponentPeer.getParent_NoClientCode(list).getBackground());
        if (!this.target.isBackgroundSet()) {
            this.target.setBackground(SystemColor.text);
        }
        if (!this.target.isForegroundSet()) {
            this.target.setForeground(SystemColor.textText);
        }
        super.initialize();
    }

    MListPeer(List list) {
        super(list);
    }

    public void add(String string, int n2) {
        this.addItem(string, n2);
    }

    public void removeAll() {
        this.clear();
    }

    public void setMultipleMode(boolean bl2) {
        this.setMultipleSelections(bl2);
    }

    public Dimension getPreferredSize(int n2) {
        return this.preferredSize(n2);
    }

    public Dimension getMinimumSize(int n2) {
        return this.minimumSize(n2);
    }

    public void setForeground(Color color) {
        this.pSetInnerForeground(color);
    }

    public native void setBackground(Color var1);

    public native void setMultipleSelections(boolean var1);

    public native boolean isSelected(int var1);

    public native void addItem(String var1, int var2);

    public native void delItems(int var1, int var2);

    public native void select(int var1);

    public native void deselect(int var1);

    public native void makeVisible(int var1);

    public void clear() {
        List list = (List)this.target;
        int n2 = list.countItems();
        if (n2 > 0) {
            this.delItems(0, n2 - 1);
        }
    }

    public int[] getSelectedIndexes() {
        List list = (List)this.target;
        int n2 = list.countItems();
        int[] nArray = new int[n2];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            if (this.isSelected(n4)) {
                nArray[n3++] = n4;
            }
            ++n4;
        }
        int[] nArray2 = new int[n3];
        System.arraycopy(nArray, 0, nArray2, 0, n3);
        return nArray2;
    }

    public void action(int n2, final long l2, final int n3) {
        final List list = (List)this.target;
        final int n4 = n2;
        MToolkit.executeOnEventHandlerThread(list, new Runnable(){

            public void run() {
                list.select(n4);
                MListPeer.this.postEvent(new ActionEvent(MListPeer.this.target, 1001, list.getItem(n4), l2, n3));
            }
        });
    }

    public void handleListChanged(int n2) {
        final MListPeer mListPeer = this;
        final List list = (List)this.target;
        final int n3 = n2;
        MToolkit.executeOnEventHandlerThread(list, new Runnable(){

            public void run() {
                int[] nArray = mListPeer.getSelectedIndexes();
                boolean bl2 = false;
                int n2 = 0;
                while (n2 < nArray.length) {
                    if (n3 == nArray[n2]) {
                        bl2 = true;
                        break;
                    }
                    ++n2;
                }
                MListPeer.this.postEvent(new ItemEvent(list, 701, new Integer(n3), bl2 ? 1 : 2));
            }
        });
    }

    public Dimension minimumSize() {
        return this.minimumSize(4);
    }

    public Dimension preferredSize(int n2) {
        return this.minimumSize(n2);
    }

    public Dimension minimumSize(int n2) {
        FontMetrics fontMetrics = this.getFontMetrics(((List)this.target).getFont());
        return new Dimension(20 + fontMetrics.stringWidth("0123456789abcde"), (fontMetrics.getHeight() + 2) * n2 + 4);
    }

    public boolean isFocusable() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(Graphics graphics) {
        Graphics graphics2;
        int n2;
        int n3;
        int n4;
        List list = (List)this.target;
        Dimension dimension = list.size();
        Color color = list.getBackground();
        Color color2 = list.getForeground();
        int n5 = list.getItemCount();
        FontMetrics fontMetrics = this.getFontMetrics(list.getFont());
        int n6 = 0;
        int n7 = 0;
        while (n7 < n5) {
            n4 = fontMetrics.stringWidth(list.getItem(n7));
            n6 = Math.max(n6, n4);
            ++n7;
        }
        this.fontHeight = fontMetrics.getHeight();
        this.fontAscent = fontMetrics.getAscent();
        this.fontLeading = fontMetrics.getLeading();
        int n8 = 0;
        int n9 = 0;
        int n10 = this.itemsInWindow(true);
        this.vmax = Math.max(n5 - n10, 0);
        int n11 = dimension.height - 16;
        if (this.vmax != 0) {
            n3 = dimension.width - 16;
            n2 = n3 - 6;
            this.hmax = Math.max(n6 - n2, 0);
        } else {
            n3 = dimension.width;
            n2 = n3 - 6;
            this.hmax = Math.max(n6 - n2, 0);
        }
        if (this.hmax == 0) {
            n11 = dimension.height;
            n10 = this.itemsInWindow(false);
            this.vmax = Math.max(n5 - n10, 0);
        }
        if (this.vmax == 0) {
            n3 = dimension.width;
            n2 = n3 - 6;
            this.hmax = Math.max(n6 - n2, 0);
        }
        this.hval = 0;
        this.vval = 0;
        graphics.setColor(color);
        graphics.fillRect(0, 0, n3, n11);
        if (this.hmax != 0) {
            n4 = dimension.width - (this.vmax == 0 ? 0 : 16);
            graphics.fillRect(1, dimension.height - 16 - 3, n4 - 1, 13);
            graphics2 = graphics.create();
            try {
                graphics2.translate(0, dimension.height - 14);
                this.drawScrollbar(graphics2, color, 14, n4, n9, this.hmax, this.hval, n2, true);
                Object var19_19 = null;
                graphics2.dispose();
            }
            catch (Throwable throwable) {
                Object var19_20 = null;
                graphics2.dispose();
                throw throwable;
            }
        }
        if (this.vmax != 0) {
            n4 = dimension.height - (this.hmax == 0 ? 0 : 16);
            graphics.fillRect(dimension.width - 16 - 3, 1, 13, n4 - 1);
            graphics2 = graphics.create();
            try {
                graphics2.translate(dimension.width - 14, 0);
                this.drawScrollbar(graphics2, color, 14, n4, n8, this.vmax, this.vval, n10, false);
                Object var21_22 = null;
                graphics2.dispose();
            }
            catch (Throwable throwable) {
                Object var21_23 = null;
                graphics2.dispose();
                throw throwable;
            }
        }
        this.draw3DRect(graphics, color, 0, 0, n3 - 1, n11 - 1, false);
        if (n5 > 0) {
            n4 = this.itemsInWindow(this.hmax != 0);
            int n12 = Math.min(n5 - 1, this.vval + n4 - 1);
            this.paintItems(graphics, color, color2, this.vval, n12);
        }
        this.target.print(graphics);
    }

    int itemsInWindow(boolean bl2) {
        Dimension dimension = this.target.size();
        int n2 = bl2 ? dimension.height - 20 : dimension.height - 4;
        int n3 = this.fontHeight - this.fontLeading;
        return n2 / (n3 + 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void paintItem(Graphics graphics, Color color, Color color2, int n2, boolean bl2) {
        List list = (List)this.target;
        Dimension dimension = list.size();
        int n3 = list.getItemCount();
        Color color3 = color.darker();
        if (n2 < this.vval || n2 >= this.vval + this.itemsInWindow(this.hmax != 0)) {
            return;
        }
        int n4 = dimension.width - (4 + (this.vmax != 0 ? 16 : 0));
        int n5 = this.fontHeight - this.fontLeading;
        int n6 = n5 + 2;
        int n7 = 2 + n2 * n6 + 1;
        int n8 = n7 - this.vval * n6;
        int n9 = 3;
        Graphics graphics2 = graphics.create();
        try {
            if (n2 > n3 - 1) {
                graphics2.setColor(color);
                graphics2.fillRect(n9 - 2, n8 - 2, n4, n5 + 4);
                Object var19_17 = null;
                graphics2.dispose();
                return;
            }
            if (bl2) {
                graphics2.setColor(color3);
                graphics2.fillRect(n9 - 1, n8 - 1, n4 - 2, n5 + 2);
            } else {
                graphics2.setColor(color);
                graphics2.fillRect(n9 - 1, n8 - 1, n4 - 2, n5 + 2);
            }
            graphics2.setColor(color);
            graphics2.drawRect(n9 - 2, n8 - 2, n4 - 1, n5 + 3);
            graphics2.setColor(color2);
            String string = list.getItem(n2);
            graphics2.clipRect(n9, n8, n4 - 2, n5);
            graphics2.drawString(string, n9 - this.hval, n8 + this.fontAscent);
        }
        catch (Throwable throwable) {
            Object var19_19 = null;
            graphics2.dispose();
            throw throwable;
        }
        Object var19_18 = null;
        graphics2.dispose();
    }

    void paintItems(Graphics graphics, Color color, Color color2, int n2, int n3) {
        int n4 = n2;
        while (n4 <= n3) {
            this.paintItem(graphics, color, color2, n4, false);
            ++n4;
        }
    }

    public boolean handlesWheelScrolling() {
        return true;
    }

    public void handleEvent(AWTEvent aWTEvent) {
        if (aWTEvent.getID() == 507) {
            MouseWheelEvent mouseWheelEvent = (MouseWheelEvent)aWTEvent;
            this.nativeHandleMouseWheel(mouseWheelEvent.getScrollType(), mouseWheelEvent.getScrollAmount(), mouseWheelEvent.getWheelRotation());
        } else {
            super.handleEvent(aWTEvent);
        }
    }

    native void nativeHandleMouseWheel(int var1, int var2, int var3);
}

