/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.DNSName;
import sun.security.x509.EDIPartyName;
import sun.security.x509.GeneralNameInterface;
import sun.security.x509.IPAddressName;
import sun.security.x509.OIDName;
import sun.security.x509.OtherName;
import sun.security.x509.RFC822Name;
import sun.security.x509.URIName;
import sun.security.x509.X500Name;

public class GeneralName {
    private GeneralNameInterface name = null;

    public GeneralName(GeneralNameInterface generalNameInterface) throws IOException {
        if (generalNameInterface == null) {
            throw new IOException("GeneralName must not be null");
        }
        this.name = generalNameInterface;
    }

    public GeneralName(DerValue derValue) throws IOException {
        short s2 = (byte)(derValue.tag & 0x1F);
        switch (s2) {
            case 0: {
                if (derValue.isContextSpecific() && derValue.isConstructed()) {
                    derValue.resetTag((byte)48);
                    this.name = new OtherName(derValue);
                    break;
                }
                throw new IOException("Invalid encoding of Other-Name");
            }
            case 1: {
                if (derValue.isContextSpecific() && !derValue.isConstructed()) {
                    derValue.resetTag((byte)22);
                    this.name = new RFC822Name(derValue);
                    break;
                }
                throw new IOException("Invalid encoding of RFC822 name");
            }
            case 2: {
                if (derValue.isContextSpecific() && !derValue.isConstructed()) {
                    derValue.resetTag((byte)22);
                    this.name = new DNSName(derValue);
                    break;
                }
                throw new IOException("Invalid encoding of DNS name");
            }
            case 6: {
                if (derValue.isContextSpecific() && !derValue.isConstructed()) {
                    derValue.resetTag((byte)22);
                    this.name = new URIName(derValue);
                    break;
                }
                throw new IOException("Invalid encoding of URI");
            }
            case 7: {
                if (derValue.isContextSpecific() && !derValue.isConstructed()) {
                    derValue.resetTag((byte)4);
                    this.name = new IPAddressName(derValue);
                    break;
                }
                throw new IOException("Invalid encoding of IP address");
            }
            case 8: {
                if (derValue.isContextSpecific() && !derValue.isConstructed()) {
                    derValue.resetTag((byte)6);
                    this.name = new OIDName(derValue);
                    break;
                }
                throw new IOException("Invalid encoding of OID name");
            }
            case 4: {
                if (derValue.isContextSpecific() && derValue.isConstructed()) {
                    derValue.resetTag((byte)48);
                    this.name = new X500Name(derValue);
                    break;
                }
                throw new IOException("Invalid encoding of Directory name");
            }
            case 5: {
                if (derValue.isContextSpecific() && derValue.isConstructed()) {
                    derValue.resetTag((byte)48);
                    this.name = new EDIPartyName(derValue);
                    break;
                }
                throw new IOException("Invalid encoding of EDI name");
            }
            default: {
                throw new IOException("Unrecognized GeneralName tag, (" + s2 + ")");
            }
        }
    }

    public int getType() {
        return this.name.getType();
    }

    public GeneralNameInterface getName() {
        return this.name;
    }

    public String toString() {
        return this.name.toString();
    }

    public boolean equals(Object object) {
        boolean bl2;
        if (!(object instanceof GeneralName)) {
            return false;
        }
        GeneralNameInterface generalNameInterface = ((GeneralName)object).name;
        try {
            bl2 = this.name.constrains(generalNameInterface) == 0;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            bl2 = false;
        }
        return bl2;
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        DerOutputStream derOutputStream2 = new DerOutputStream();
        this.name.encode(derOutputStream2);
        int n2 = this.name.getType();
        if (n2 == 0 || n2 == 3 || n2 == 4 || n2 == 5) {
            derOutputStream.writeImplicit(DerValue.createTag((byte)-128, true, (byte)n2), derOutputStream2);
        } else {
            derOutputStream.writeImplicit(DerValue.createTag((byte)-128, false, (byte)n2), derOutputStream2);
        }
    }
}

