.\" Copyright (c) 1993, 1994  X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealing in this Software without prior written authorization
.\" from the X Consortium.
.\"
.ds tk X Toolkit
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xI Intrinsics
.ds xW X Toolkit Athena Widgets \- C Language Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.ds Rn 3
.ds Vn 2.2
.hw XtAdd-Callback XtAdd-Callbacks XtRemove-Callback
.hw XtRemove-Callbacks XtRemove-All-Callbacks wid-get
.na
.TH XtAddCallback __libmansuffix__ __xorgversion__ "XT FUNCTIONS"
.SH NAME
XtAddCallback, XtAddCallbacks, XtRemoveCallback, XtRemoveCallbacks, XtRemoveAllCallbacks \- add and remove callback procedures
.SH SYNTAX
#include <X11/Intrinsic.h>
.HP
void XtAddCallback(Widget \fIw\fP, const char *\fIcallback_name\fP, XtCallbackProc
\fIcallback\fP, XtPointer \fIclient_data\fP);
.HP
void XtAddCallbacks(Widget \fIw\fP, const char *\fIcallback_name\fP, XtCallbackList
\fIcallbacks\fP);
.HP
void XtRemoveCallback(Widget \fIw\fP, const char *\fIcallback_name\fP,
XtCallbackProc \fIcallback\fP, XtPointer \fIclient_data\fP);
.HP
void XtRemoveCallbacks(Widget \fIw\fP, const char *\fIcallback_name\fP,
XtCallbackList \fIcallbacks\fP);
.HP
void XtRemoveAllCallbacks(Widget \fIw\fP, const char *\fIcallback_name\fP);
.SH ARGUMENTS
.IP \fIcallback\fP 1i
Specifies the callback procedure.
.IP \fIcallbacks\fP 1i
Specifies the null-terminated list of callback procedures and corresponding
client data.
.IP \fIcallback_name\fP 1i
Specifies the callback list to which the procedure is to be appended or
deleted.
.IP \fIclient_data\fP 1i
Specifies the argument that is to be passed to the specified procedure
when it is invoked by XtCallbacks or NULL,
or the client data to match on the registered callback procedures.
.IP \fIw\fP 1i
Specifies the widget.
.SH DESCRIPTION
The
.B XtAddCallback
function adds the specified callback procedure to the specified widget's
callback list.
.LP
The
.B XtAddCallbacks
add the specified list of callbacks to the specified widget's callback list.
.LP
The
.B XtRemoveCallback
function removes a callback only if both the procedure and the client
data match.
.LP
The
.B XtRemoveCallbacks
function removes the specified callback procedures from the specified
widget's callback list.
.LP
The
.B XtRemoveAllCallbacks
function removes all the callback procedures from the specified
widget's callback list.
.SH "SEE ALSO"
XtCallCallbacks(__libmansuffix__)
.br
\fI\*(xT\fP
.br
\fI\*(xL\fP
