/*****************************************************************
kwin - the KDE window manager
								
Copyright (C) 1999, 2000 Matthias Ettrich <ettrich@kde.org>
******************************************************************/
#ifndef STDCLIENT_H
#define STDCLIENT_H
#include <qvariant.h>
#include <kdecoration.h>
#include <kdecorationfactory.h>
#include <qtoolbutton.h>
class QLabel;
class QSpacerItem;

namespace KDE1 {

class StdClient : public KDecoration
{
    Q_OBJECT
public:
    StdClient( KDecorationBridge* b, KDecorationFactory* f );
    ~StdClient();
    void init();
    QSize minimumSize() const;
    void borders( int& left, int& right, int& top, int& bottom ) const;
    void reset( unsigned long mask );
    void resize( const QSize& s );
    void shadeChange() {};
    Position mousePosition( const QPoint& p ) const { return KDecoration::mousePosition( p ); }
protected:
    bool eventFilter( QObject* o, QEvent* e );
    void resizeEvent( QResizeEvent* );
    void paintEvent( QPaintEvent* );

    void mouseDoubleClickEvent( QMouseEvent * );
    void captionChange();
    void iconChange();
    void maximizeChange();
    void desktopChange();
    void activeChange();

private slots:
    void menuButtonPressed();
    void maxButtonClicked( int );

private:
    QToolButton* button[7];
    QSpacerItem* titlebar;
};

class StdToolClient : public KDecoration
{
    Q_OBJECT
public:
    StdToolClient( KDecorationBridge* b, KDecorationFactory* f );
    ~StdToolClient();
    void init();
    QSize minimumSize() const;
    void borders( int& left, int& right, int& top, int& bottom ) const;
    void reset( unsigned long mask );
    void resize( const QSize& s );
    void shadeChange() {};
    void activeChange() {};
    void iconChange() {};
    void maximizeChange() {};
    void desktopChange() {};
    Position mousePosition( const QPoint& p ) const { return KDecoration::mousePosition( p ); }
protected:
    bool eventFilter( QObject* o, QEvent* e );
    void resizeEvent( QResizeEvent* );
    void paintEvent( QPaintEvent* );

    void mouseDoubleClickEvent( QMouseEvent * );
    void captionChange();

private:
    QToolButton* closeBtn;
    QSpacerItem* titlebar;
};



/*
  Like QToolButton, but provides a clicked(int) signals that
  has the last pressed mouse button as argument
 */
class ThreeButtonButton: public QToolButton
{
    Q_OBJECT
public:
  ThreeButtonButton ( QWidget *parent = 0, const char* name = 0 )
      : QToolButton( parent, name )
    {
	connect( this, SIGNAL( clicked() ), this, SLOT( handleClicked() ) );
        setCursor( arrowCursor );
    }
    ~ThreeButtonButton () {}

signals:
    void clicked( int );

protected:
    void mousePressEvent( QMouseEvent* e )
    {
	last_button = e->button();
	QMouseEvent me ( e->type(), e->pos(), e->globalPos(), LeftButton, e->state() );
	QToolButton::mousePressEvent( &me );
    }

    void mouseReleaseEvent( QMouseEvent* e )
    {
	QMouseEvent me ( e->type(), e->pos(), e->globalPos(), LeftButton, e->state() );
	QToolButton::mouseReleaseEvent( &me );
    }

private slots:
    void handleClicked()
    {
	emit clicked( last_button );
    }

private:
    int last_button;

};

class StdFactory : public KDecorationFactory
{
public:
    StdFactory();
    ~StdFactory();
    KDecoration* createDecoration( KDecorationBridge* b );
    bool reset( unsigned long mask );
};

}

#endif
