/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.java.awt.peer.gtk.GtkImagePainter;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.util.Hashtable;
import java.util.Vector;

public class GtkImage
extends Image
implements ImageConsumer {
    int width;
    int height;
    Hashtable props;
    boolean isLoaded;
    boolean isCacheable;
    boolean loading;
    Vector widthObservers;
    Vector heightObservers;
    Vector propertyObservers;
    ImageProducer source;
    ImageObserver observer;
    Graphics g;
    int[] pixelCache;
    ColorModel model;

    private /* synthetic */ void finit$() {
        this.width = -1;
        this.height = -1;
        this.props = null;
        this.isLoaded = false;
        this.isCacheable = true;
        this.loading = false;
        this.widthObservers = new Vector();
        this.heightObservers = new Vector();
        this.propertyObservers = new Vector();
    }

    public GtkImage(ImageProducer producer, Graphics g) {
        this.finit$();
        this.source = producer;
        this.g = g;
        if (this.source != null) {
            this.source.addConsumer(this);
        }
    }

    public void setObserver(ImageObserver observer) {
        this.observer = observer;
    }

    public synchronized int getWidth(ImageObserver observer) {
        if (this.width == -1) {
            this.widthObservers.addElement(observer);
        }
        return this.width;
    }

    public synchronized int getHeight(ImageObserver observer) {
        if (this.height == -1) {
            this.heightObservers.addElement(observer);
        }
        return this.height;
    }

    public ImageProducer getSource() {
        return this.source;
    }

    public Graphics getGraphics() {
        return this.g;
    }

    public synchronized Object getProperty(String name, ImageObserver observer) {
        if (this.props == null) {
            this.propertyObservers.addElement(observer);
            return null;
        }
        Object value = this.props.get(name);
        if (value == null) {
            return Image.UndefinedProperty;
        }
        return value;
    }

    public synchronized void flush() {
        this.isLoaded = false;
        this.isCacheable = true;
        this.height = -1;
        this.width = -1;
        this.props = null;
        this.pixelCache = null;
        this.model = null;
        if (this.source != null) {
            this.source.removeConsumer(this);
            this.source.addConsumer(this);
        }
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    public synchronized void setDimensions(int width, int height) {
        ImageObserver io;
        int i;
        this.pixelCache = new int[width * height];
        this.width = width;
        this.height = height;
        for (i = 0; i < this.widthObservers.size(); ++i) {
            io = (ImageObserver)this.widthObservers.elementAt(i);
            if (io == null) continue;
            io.imageUpdate(this, 1, -1, -1, width, height);
        }
        for (i = 0; i < this.heightObservers.size(); ++i) {
            io = (ImageObserver)this.heightObservers.elementAt(i);
            if (io == null) continue;
            io.imageUpdate(this, 2, -1, -1, width, height);
        }
        if (this.observer != null) {
            this.observer.imageUpdate(this, 3, -1, -1, width, height);
        }
    }

    public synchronized void setProperties(Hashtable props) {
        this.props = props;
        for (int i = 0; i < this.propertyObservers.size(); ++i) {
            ImageObserver io = (ImageObserver)this.propertyObservers.elementAt(i);
            if (io == null) continue;
            io.imageUpdate(this, 4, -1, -1, this.width, this.height);
        }
    }

    public synchronized void setColorModel(ColorModel model) {
        if (this.model == null || this.model == model) {
            this.model = model;
        } else {
            this.isCacheable = false;
        }
    }

    public synchronized void setHints(int flags) {
    }

    public synchronized void setPixels(int x, int y, int width, int height, ColorModel cm, byte[] pixels, int offset, int scansize) {
        this.setPixels(x, y, width, height, cm, this.convertPixels(pixels), offset, scansize);
        if (this.observer != null) {
            this.observer.imageUpdate(this, 8, x, y, width, height);
        }
    }

    public synchronized void setPixels(int x, int y, int width, int height, ColorModel cm, int[] pixels, int offset, int scansize) {
        this.loading = true;
        if (!this.isCacheable) {
            return;
        }
        if (cm != this.model || this.pixelCache == null) {
            this.isCacheable = false;
            return;
        }
        if (scansize == width) {
            System.arraycopy(pixels, offset, this.pixelCache, y * this.width + x, pixels.length - offset);
        } else {
            for (int i = 0; i < height; ++i) {
                System.arraycopy(pixels, offset + i * scansize, this.pixelCache, (y + i) * this.width + x, width);
            }
        }
    }

    public synchronized void imageComplete(int status) {
        if (status == 3 && this.isCacheable) {
            this.isLoaded = true;
        }
        if (status == 2) {
            this.isCacheable = false;
        }
        if (this.observer != null) {
            if (status == 1) {
                this.observer.imageUpdate(null, 64, -1, -1, -1, -1);
            } else {
                this.observer.imageUpdate(null, 32, -1, -1, -1, -1);
            }
        }
        if (this.source != null) {
            this.source.removeConsumer(this);
        }
    }

    public synchronized void startProduction(GtkImagePainter painter) {
        if (this.isLoaded) {
            painter.setDimensions(this.width, this.height);
            painter.setPixels(0, 0, this.width, this.height, this.model, this.pixelCache, 0, this.width);
        } else if (this.source != null) {
            this.source.startProduction(painter);
            this.source.removeConsumer(painter);
        }
    }

    private int[] convertPixels(byte[] pixels) {
        int[] ret = new int[pixels.length];
        for (int i = 0; i < pixels.length; ++i) {
            ret[i] = pixels[i];
        }
        return ret;
    }

    synchronized int checkImage() {
        int bits = 0;
        if (this.width != -1) {
            bits |= 1;
        }
        if (this.height != -1) {
            bits |= 2;
        }
        if (this.props != null) {
            bits |= 4;
        }
        if (this.loading) {
            bits |= 8;
        }
        if (this.isLoaded) {
            bits |= 0x20;
        }
        return bits;
    }
}

