/* Copyright (C) 2002 Philippe Fremy <pfremy@kde.org>
   Strongly inspired by other KPart applications and tutorials.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#include "vimpart_factory.h"

#include <klocale.h>
#include <kstandarddirs.h>
#include <kinstance.h>
#include <kdebug.h>
#include <kaboutdata.h>
#include <assert.h>
#include <unistd.h>

#include "vimdocument.h"

extern "C"
{
    void* init_libvimpart()
    {
		KGlobal::locale()->insertCatalogue("vimpart");
		return new VimPartFactory();
    }
}

KInstance* VimPartFactory::s_instance = 0L;

VimPartFactory::VimPartFactory()
{
		s_instance=0;
}

VimPartFactory::~VimPartFactory()
{
	if ( s_instance ) {
		delete s_instance->aboutData();
		delete s_instance;
	}
	s_instance=0;
}

KParts::Part *VimPartFactory::createPartObject( QWidget *parentWidget, const char *widgetname, QObject *parent, const char *name, const char *classname, const QStringList & )
{
	bool bSingleView = (classname!=QString::fromLatin1("KTextEditor::Document"));
	bool bWantBrowserView =  (classname == QString("Browser/View") );
	bool bWantReadOnly = (bWantBrowserView || ( classname == QString("KParts::ReadOnlyPart") ));

	KParts::ReadWritePart *part = new Vim::Document (bWantReadOnly, bSingleView, bWantBrowserView, parentWidget, widgetname, parent, name );

	return part;
}

KInstance* VimPartFactory::instance()
{
  if( !s_instance )
    s_instance = new KInstance( aboutData() );
  return s_instance;
}

const KAboutData *VimPartFactory::aboutData()
{
	KAboutData *data = new KAboutData ("vimpart", I18N_NOOP("VimPart"), "1.0",
					I18N_NOOP( "VimPart - Vim embedded in KDE" ),
					KAboutData::License_LGPL_V2,
					I18N_NOOP( "(c) 2002" ), 0, "http://freehackers.org/kvim");
	data->addAuthor ("Philippe Fremy", I18N_NOOP("Initial Version"), "pfremy@chez.com");
	data->addAuthor ("Mickael Marchand", I18N_NOOP("KTextEditor implementation; improvements"), "marchand@kde.org");
	data->setTranslator(I18N_NOOP("_: NAME OF TRANSLATORS\nYour names"), I18N_NOOP("_: EMAIL OF TRANSLATORS\nYour emails"));

	return data;
}

#include "vimpart_factory.moc"
