iconName = 'about_kde'
labelText = 'KAboutKDE'

from qt import QFrame, QHBoxLayout, QVBoxLayout, SIGNAL
from kdecore import i18n
from kdeui import KAboutKDE, KPushButton, KTextEdit


helpText = ("Typically available via the applications 'Help' menu, this "
            "dialog presents the user with the standard KDE About dialog.")


class MainFrame(QFrame):
    def __init__(self, parent=None):
        QFrame.__init__(self, parent)
        self.button = KPushButton(i18n('About KDE'), self)
        self.help = KTextEdit(helpText, '', self)
        layout = QVBoxLayout(self, 4)
        layout.addWidget(self.help)
        buttonlayout = QHBoxLayout(layout, 4)
        buttonlayout.addWidget(self.button)
        buttonlayout.addStretch(1)
        layout.addStretch(1)
        self.connect(self.button, SIGNAL('clicked()'), self.showAboutDialog)

    def showAboutDialog(self):
        dlg = KAboutKDE(self)
        dlg.show()
