.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided ``as is'' without express or implied warranty.
.\" 
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.na
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft CW
.\".ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.de IN		\" send an index entry to the stderr
..
.de Pn
.ie t \\$1\fB\^\\$2\^\fR\\$3
.el \\$1\fI\^\\$2\^\fP\\$3
..
.de ZN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.de hN
.ie t <\fB\\$1\fR>\\$2
.el <\fI\\$1\fP>\\$2
..
.ny0
.TH XSetScreenSaver __libmansuffix__ __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XSetScreenSaver, XForceScreenSaver, XActivateScreenSaver, XResetScreenSaver, XGetScreenSaver \- manipulate the screen saver
.SH SYNTAX
.HP
int XSetScreenSaver\^(\^Display *\fIdisplay\fP\^, int \fItimeout\fP\^,
int \fIinterval\fP\^, int \fIprefer_blanking\fP\^, int
\fIallow_exposures\fP\^); 
.HP
int XForceScreenSaver\^(\^Display *\fIdisplay\fP\^, int \fImode\fP\^); 
.HP
int XActivateScreenSaver\^(\^Display *\fIdisplay\fP\^); 
.HP
int XResetScreenSaver\^(\^Display *\fIdisplay\fP\^); 
.HP
int XGetScreenSaver\^(\^Display *\fIdisplay\fP\^, int *\fItimeout_return\fP\^,
int *\fIinterval_return\fP\^, int *\fIprefer_blanking_return\fP\^, int
*\fIallow_exposures_return\fP\^); 
.SH ARGUMENTS
.IP \fIallow_exposures\fP 1i
Specifies the screen save control values.
You can pass
.ZN DontAllowExposures ,
.ZN AllowExposures ,
or
.ZN DefaultExposures .
.IP \fIallow_exposures_return\fP 1i
Returns the current screen save control value
.Pn ( DontAllowExposures ,
.ZN AllowExposures ,
or
.ZN DefaultExposures ).
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fIinterval\fP 1i
Specifies the interval, in seconds, between screen saver alterations.
.IP \fIinterval_return\fP 1i
Returns the interval between screen saver invocations.
.IP \fImode\fP 1i
Specifies the mode that is to be applied.
You can pass
.ZN ScreenSaverActive
or
.ZN ScreenSaverReset .
.IP \fIprefer_blanking\fP 1i
Specifies how to enable screen blanking.
You can pass
.ZN DontPreferBlanking ,
.ZN PreferBlanking ,
or
.ZN DefaultBlanking .
.IP \fIprefer_blanking_return\fP 1i
Returns the current screen blanking preference
.Pn ( DontPreferBlanking ,
.ZN PreferBlanking ,
or
.ZN DefaultBlanking ).
.IP \fItimeout\fP 1i
Specifies the timeout, in seconds, until the screen saver turns on.
.IP \fItimeout_return\fP 1i
Returns the timeout, in seconds, until the screen saver turns on.
.SH DESCRIPTION
Timeout and interval are specified in seconds. 
A timeout of 0 disables the screen saver 
(but an activated screen saver is not deactivated),
and a timeout of \-1 restores the default.
Other negative values generate a
.ZN BadValue
error.
If the timeout value is nonzero, 
.ZN XSetScreenSaver
enables the screen saver.
An interval of 0 disables the random-pattern motion.
Both values are limited to a 16-bit signed integer range by the wire protocol,
despite the C prototype.
If no input from devices (keyboard, mouse, and so on) is generated 
for the specified number of timeout seconds once the screen saver is enabled,
the screen saver is activated.
.LP
For each screen, 
if blanking is preferred and the hardware supports video blanking, 
the screen simply goes blank.  
Otherwise, if either exposures are allowed or the screen can be regenerated 
without sending 
.ZN Expose 
events to clients, 
the screen is tiled with the root window background tile randomly 
re-origined each interval seconds.
Otherwise, the screens' state do not change, 
and the screen saver is not activated.
The screen saver is deactivated,
and all screen states are restored at the next
keyboard or pointer input or at the next call to
.ZN XForceScreenSaver
with mode
.ZN ScreenSaverReset .  
.LP
If the server-dependent screen saver method supports periodic change,
the interval argument serves as a hint about how long the change period
should be, and zero hints that no periodic change should be made.
Examples of ways to change the screen include scrambling the colormap
periodically, moving an icon image around the screen periodically, or tiling
the screen with the root window background tile, randomly re-origined
periodically.
.LP
.ZN XSetScreenSaver
can generate a
.ZN BadValue 
error.
.LP
If the specified mode is 
.ZN ScreenSaverActive 
and the screen saver currently is deactivated,
.ZN XForceScreenSaver
activates the screen saver even if the screen saver had been disabled
with a timeout of zero.
If the specified mode is 
.ZN ScreenSaverReset 
and the screen saver currently is enabled,
.ZN XForceScreenSaver
deactivates the screen saver if it was activated,
and the activation timer is reset to its initial state 
(as if device input had been received).
.LP
.ZN XForceScreenSaver
can generate a
.ZN BadValue 
error.
.LP
The
.ZN XActivateScreenSaver
function activates the screen saver.
.LP
The
.ZN XResetScreenSaver
function resets the screen saver.
.LP
The
.ZN XGetScreenSaver
function gets the current screen saver values.
.SH DIAGNOSTICS
.TP 1i
.ZN BadValue
Some numeric value falls outside the range of values accepted by the request.
Unless a specific range is specified for an argument, the full range defined
by the argument's type is accepted.  Any argument defined as a set of
alternatives can generate this error.
.SH "SEE ALSO"
\fI\*(xL\fP
