#ifndef  _SIGNAL_H
#define  _SIGNAL_H

#define  SIGHUP       1
#define  SIGINT       2
#define  SIGQUIT      3
#define  SIGILL       4
#define  SIGTRAP      5
#define  SIGIOT       6
#define  SIGABRT      6
#define  SIGEMT       7
#define  SIGFPE       8
#define  SIGKILL      9
#define  SIGBUS      10
#define  SIGSEGV     11
#define  SIGSYS      12
#define  SIGPIPE     13
#define  SIGALRM     14
#define  SIGUSR1     16
#define  SIGUSR2     17
#define  SIGCLD      18
#define  SIGCHLD     18
#define  SIGPWR      19
#define  SIGWINCH    20
#define  SIGPOLL     22

#ifdef ELF_LIBRARY
#define SIGTERM 15
#define SIGWINCH 20
#define SIGURG 21
#define SIGIO 22
#define SIGSTOP 23
#define SIGTSTP 24
#define SIGCONT 25
#define SIGTTIN 26
#define SIGTTOU 27
#define SIGVTALRM 28
#define SIGPROF 29
#define SIGGXCPU 30
#define SIGGXFSZ 31
#define NSIG 32
#else
#define NSIG 23
#endif

#ifdef ELF_LIBRARY
typedef void (*sighandler_t) ();
#else
typedef void (*sighandler_t) (int);
#endif

#define  SIG_DFL     ((sighandler_t *) 0)
#define  SIG_ERR     ((signandler_t *) -1)
#define  SIG_IGN     ((sighandler_t *) 1)
#define  SIG_HOLD    ((sighandler_t *) 2)

#ifdef ELF_LIBRARY
#define  SIG_SETMASK  3
#else
#define  SIG_SETMASK  0
#endif
#define  SIG_BLOCK    1
#define  SIG_UNBLOCK  2

#ifdef ELF_LIBRARY
typedef struct {unsigned long sigbits[4];} sigset_t;

/* These are the values for the sa_flags field */
#define SA_ONSTACK   1
#define SA_RESETHAND 2
#define SA_RESTART   4
#define SA_SIGINFO   8
#define SA_NODEFER  16
#define SA_NOCLDWAIT 0x10000
#define SA_NOCLDSTOP 0x20000

struct sigaction {
       int          sa_flags;
       sighandler_t *sa_handler;
       sigset_t     sa_mask;
       int sa_resv[2];	/* Reserved, but apparently used for something */
};

#define __sigaddset(set, sig)   (((set)->sigbits[0] |= __sigmask (sig)), 0)
#define __sigdelset(set, sig)   (((set)->sigbits[0] &= ~__sigmask (sig)), 0)
#define __sigismember(set, sig) (((set)->sigbits[0] & __sigmask (sig)) ? 1 : 0)

#else

typedef long  sigset_t;

#define SA_NOCLDSTOP   1

struct sigaction {
       sighandler_t *sa_handler;
       sigset_t     sa_mask;
       int          sa_flags;
};
#define __sigemptyset(set)	((*(set) = 0L), 0)
#define __sigfillset(set)       ((*(set) = -1L), 0)
#define __sigaddset(set, sig)   ((*(set) |= __sigmask (sig)), 0)
#define __sigdelset(set, sig)   ((*(set) &= ~__sigmask (sig)), 0)
#define __sigismember(set, sig) ((*(set) & __sigmask (sig)) ? 1 : 0)
#endif


#define __sigmask(sig)	(1 << ((sig) - 1))

#define sigmask(sig)            __sigmask(sig)
#define sigemptyset(set)        __sigemptyset(set)
#define sigfillset(set)         __sigfillset(set)
#define sigaddset(set,sig)      __sigaddset(set,sig)
#define sigdelset(set,sig)      __sigdelset(set,sig)
#define sigismember(set,sig)    __sigismember(set,sig)

extern sighandler_t signal    (int sig, sighandler_t *action);
extern sighandler_t sigset    (int sig, sighandler_t *action);
extern int          sighold   (int sig);
extern int          sigrelse  (int sig);
extern int          sigpause  (int sig);
extern int          sigignore (int sig);
extern int	    kill      (int pid, int sig);

#endif
