/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractMidiDevice;
import com.sun.media.sound.HeadspaceInstrument;
import com.sun.media.sound.HeadspaceMixer;
import com.sun.media.sound.HeadspaceSoundbank;
import com.sun.media.sound.MidiOutDeviceProvider;
import com.sun.media.sound.MixerMidiChannel;
import com.sun.media.sound.Platform;
import com.sun.media.sound.Printer;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.sound.midi.Instrument;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Patch;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.Transmitter;
import javax.sound.midi.VoiceStatus;

abstract class AbstractPlayer
extends AbstractMidiDevice
implements Synthesizer {
    private static final String[] defaultSoundbankNames = new String[]{"soundbank-deluxe.gm", "soundbank-mid.gm", "soundbank.gm", "soundbank-min.gm"};
    private static final String soundJarName = "sound.jar";
    private static final String jmfJarName = "jmf.jar";
    private static final Class[] supportedMidiOutClasses = new Class[]{class$com$sun$media$sound$SimpleOutputDevice == null ? (class$com$sun$media$sound$SimpleOutputDevice = AbstractPlayer.class$("com.sun.media.sound.SimpleOutputDevice")) : class$com$sun$media$sound$SimpleOutputDevice, class$com$sun$media$sound$MidiOutDevice == null ? (class$com$sun$media$sound$MidiOutDevice = AbstractPlayer.class$("com.sun.media.sound.MidiOutDevice")) : class$com$sun$media$sound$MidiOutDevice};
    static HeadspaceMixer mixer = HeadspaceMixer.getMixerInstance();
    private static Soundbank defaultSoundbank = null;
    private Class[] orderedMidiOutClasses = new Class[]{class$com$sun$media$sound$SimpleOutputDevice == null ? (class$com$sun$media$sound$SimpleOutputDevice = AbstractPlayer.class$("com.sun.media.sound.SimpleOutputDevice")) : class$com$sun$media$sound$SimpleOutputDevice, class$com$sun$media$sound$MidiOutDevice == null ? (class$com$sun$media$sound$MidiOutDevice = AbstractPlayer.class$("com.sun.media.sound.MidiOutDevice")) : class$com$sun$media$sound$MidiOutDevice};
    AbstractMidiDevice internalSynth = null;
    protected MixerMidiChannel[] channels;
    private Vector instruments = new Vector();
    private Vector transmitters = new Vector();
    private Vector receivers = new Vector();
    static /* synthetic */ Class class$com$sun$media$sound$SimpleOutputDevice;
    static /* synthetic */ Class class$com$sun$media$sound$MidiOutDevice;

    protected AbstractPlayer(MidiDevice.Info info) {
        super(info);
        if (Printer.trace) {
            Printer.trace(">> AbstractPlayer CONSTRUCTOR: " + this);
        }
        this.channels = new MixerMidiChannel[16];
        int n2 = 0;
        while (n2 < this.channels.length) {
            this.channels[n2] = new MixerMidiChannel(this, n2);
            ++n2;
        }
        if (Printer.trace) {
            Printer.trace("<< AbstractPlayer CONSTRUCTOR completed: " + this);
        }
    }

    public synchronized void open() throws MidiUnavailableException {
        if (Printer.trace) {
            Printer.trace(">> AbstractPlayer open(): " + this);
        }
        if (this.isOpen()) {
            if (Printer.trace) {
                Printer.trace("<< AbstractPlayer open(): already open: " + this);
            }
            return;
        }
        mixer.open(this);
        this.implOpen();
        this.open = true;
        if (Printer.trace) {
            Printer.trace("<< AbstractPlayer open(): open completed: " + this);
        }
    }

    public synchronized void close() {
        if (Printer.trace) {
            Printer.trace(">> AbstractPlayer close(): " + this);
        }
        if (this.isOpen()) {
            int n2 = 0;
            while (n2 < this.transmitters.size()) {
                ((Transmitter)this.transmitters.elementAt(n2)).close();
                ++n2;
            }
            this.transmitters.removeAllElements();
            int n3 = 0;
            while (n3 < this.receivers.size()) {
                ((Receiver)this.receivers.elementAt(n3)).close();
                ++n3;
            }
            this.receivers.removeAllElements();
            this.open = false;
            this.implClose();
            mixer.close(this);
        }
        if (Printer.trace) {
            Printer.trace("<< AbstractPlayer close() completed: " + this);
        }
    }

    public int getMaxTransmitters() {
        return -1;
    }

    public synchronized Transmitter getTransmitter() throws MidiUnavailableException {
        PlayerOutTransmitter playerOutTransmitter = new PlayerOutTransmitter();
        this.transmitters.addElement(playerOutTransmitter);
        return playerOutTransmitter;
    }

    public int getMaxReceivers() {
        return -1;
    }

    public synchronized Receiver getReceiver() throws MidiUnavailableException {
        PlayerReceiver playerReceiver = new PlayerReceiver();
        this.receivers.addElement(playerReceiver);
        return playerReceiver;
    }

    public int getMaxPolyphony() {
        return HeadspaceMixer.getMixerInstance().getMidiVoices();
    }

    public long getLatency() {
        return 0L;
    }

    public MidiChannel[] getChannels() {
        MidiChannel[] midiChannelArray = new MidiChannel[this.channels.length];
        System.arraycopy(this.channels, 0, midiChannelArray, 0, this.channels.length);
        return midiChannelArray;
    }

    public VoiceStatus[] getVoiceStatus() {
        return new VoiceStatus[0];
    }

    public boolean isSoundbankSupported(Soundbank soundbank) {
        return soundbank instanceof HeadspaceSoundbank;
    }

    public boolean loadInstrument(Instrument instrument) {
        if (this.instruments.contains(instrument)) {
            return true;
        }
        try {
            if (this.nLoadInstrument(this.id, ((HeadspaceInstrument)instrument).getId())) {
                this.instruments.addElement(instrument);
                return true;
            }
            return false;
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Unsupported soundbank: " + instrument.getSoundbank());
        }
    }

    public void unloadInstrument(Instrument instrument) {
        try {
            if (this.nUnloadInstrument(this.id, ((HeadspaceInstrument)instrument).getId())) {
                this.instruments.removeElement(instrument);
            }
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Unsupported soundbank: " + instrument.getSoundbank());
        }
    }

    public boolean remapInstrument(Instrument instrument, Instrument instrument2) {
        try {
            return this.nRemapInstrument(this.id, ((HeadspaceInstrument)instrument).getId(), ((HeadspaceInstrument)instrument2).getId());
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Unsupported soundbank: " + instrument.getSoundbank() + " or " + instrument2.getSoundbank());
        }
    }

    public Soundbank getDefaultSoundbank() {
        return defaultSoundbank;
    }

    public Instrument[] getAvailableInstruments() {
        if (defaultSoundbank != null) {
            return defaultSoundbank.getInstruments();
        }
        return new Instrument[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Instrument[] getLoadedInstruments() {
        Instrument[] instrumentArray;
        Vector vector = this.instruments;
        synchronized (vector) {
            instrumentArray = new Instrument[this.instruments.size()];
            int n2 = 0;
            while (n2 < instrumentArray.length) {
                instrumentArray[n2] = (Instrument)this.instruments.elementAt(n2);
                ++n2;
            }
        }
        return instrumentArray;
    }

    public boolean loadAllInstruments(Soundbank soundbank) {
        boolean bl2 = true;
        Instrument[] instrumentArray = soundbank.getInstruments();
        int n2 = 0;
        while (n2 < instrumentArray.length) {
            if (!this.loadInstrument(instrumentArray[n2])) {
                bl2 = false;
            }
            ++n2;
        }
        return bl2;
    }

    public void unloadAllInstruments(Soundbank soundbank) {
        Instrument[] instrumentArray = soundbank.getInstruments();
        int n2 = 0;
        while (n2 < instrumentArray.length) {
            this.unloadInstrument(instrumentArray[n2]);
            ++n2;
        }
    }

    public boolean loadInstruments(Soundbank soundbank, Patch[] patchArray) {
        boolean bl2 = true;
        int n2 = 0;
        while (n2 < patchArray.length) {
            Instrument instrument = soundbank.getInstrument(patchArray[n2]);
            if (instrument != null) {
                if (!this.loadInstrument(instrument)) {
                    bl2 = false;
                }
            } else {
                bl2 = false;
            }
            ++n2;
        }
        return bl2;
    }

    public void unloadInstruments(Soundbank soundbank, Patch[] patchArray) {
        int n2 = 0;
        while (n2 < patchArray.length) {
            Instrument instrument = soundbank.getInstrument(patchArray[n2]);
            if (instrument != null) {
                this.unloadInstrument(instrument);
            }
            ++n2;
        }
    }

    public void setMidiOutClasses(Class[] classArray) {
        boolean bl2 = false;
        int n2 = 0;
        while (n2 < classArray.length) {
            bl2 = false;
            int n3 = 0;
            while (n3 < supportedMidiOutClasses.length) {
                if (supportedMidiOutClasses[n3].isAssignableFrom(classArray[n2])) {
                    bl2 = true;
                    break;
                }
                ++n3;
            }
            if (!bl2) {
                throw new IllegalArgumentException("Unsupported class for midi out services: " + classArray[n2]);
            }
            ++n2;
        }
        this.orderedMidiOutClasses = classArray;
    }

    public Class[] getMidiOutClasses() {
        return this.orderedMidiOutClasses;
    }

    abstract long getTimeStamp();

    abstract void setTimeStamp(long var1);

    boolean isUsingSoftwareSynth() {
        return this.internalSynth == this;
    }

    protected void openInternalSynth() throws MidiUnavailableException {
        if (Printer.trace) {
            Printer.trace(">> AbstractPlayer: openInternalSynth: " + this);
        }
        if (this.internalSynth != null) {
            if (Printer.trace) {
                Printer.trace("<< AbstractPlayer: openInternalSynth: internalSynth already set: " + this.internalSynth);
            }
            return;
        }
        int n2 = 0;
        while (n2 < this.orderedMidiOutClasses.length) {
            if (Printer.debug) {
                Printer.debug("AbstractPlayer: openInternalSynth: checking orderedMidiOutClasses[" + n2 + "] : " + this.orderedMidiOutClasses[n2]);
            }
            if ((class$com$sun$media$sound$MidiOutDevice == null ? AbstractPlayer.class$("com.sun.media.sound.MidiOutDevice") : class$com$sun$media$sound$MidiOutDevice).isAssignableFrom(this.orderedMidiOutClasses[n2])) {
                if (Printer.debug) {
                    Printer.debug("AbstractPlayer: openInternalSynth: trying midi out");
                }
                this.internalSynth = this.openMidiOut();
                if (this.internalSynth != null) {
                    if (Printer.debug) {
                        Printer.debug("AbstractPlayer: openInternalSynth: got it! internalSynth: " + this.internalSynth);
                    }
                    return;
                }
            } else if ((class$com$sun$media$sound$SimpleOutputDevice == null ? AbstractPlayer.class$("com.sun.media.sound.SimpleOutputDevice") : class$com$sun$media$sound$SimpleOutputDevice).isAssignableFrom(this.orderedMidiOutClasses[n2])) {
                if (Printer.debug) {
                    Printer.debug("AbstractPlayer: openInternalSynth: trying software midi");
                }
                if (defaultSoundbank == null) {
                    defaultSoundbank = this.loadDefaultSoundbank();
                }
                if (defaultSoundbank != null) {
                    this.internalSynth = this.openSoftwareSynth();
                    if (Printer.debug) {
                        Printer.debug("AbstractPlayer: openInternalSynth: got it! internalSynth: " + this.internalSynth);
                    }
                    return;
                }
            }
            ++n2;
        }
        this.internalSynth = this.openSoftwareSynth();
        if (defaultSoundbank == null && (defaultSoundbank = this.loadDefaultSoundbank()) == null && Printer.err) {
            Printer.err("\nWARNING: The default soundbank is not loaded.\nAudio synthesis may be unavailable until instruments are loaded.\n");
        }
        if (Printer.trace) {
            Printer.trace("<< AbstractPlayer: openInternalSynth: internalSynth" + this.internalSynth);
        }
    }

    protected void closeInternalSynth() {
        if (Printer.trace) {
            Printer.trace(">> AbstractPlayer: closeInternalSynth");
        }
        if (this.internalSynth != this) {
            this.nRemoveReceiver(this.id, this.internalSynth.getId());
            this.internalSynth.close(this);
        } else {
            this.nRemoveReceiver(this.id, 0L);
        }
        this.internalSynth = null;
        if (Printer.trace) {
            Printer.trace("<< AbstractPlayer: closeInternalSynth completed");
        }
    }

    protected AbstractMidiDevice openSoftwareSynth() {
        if (Printer.trace) {
            Printer.trace(">> AbstractPlayer: openSoftwareSynth");
        }
        if (Printer.trace) {
            Printer.trace("<< AbstractPlayer: openSoftwareSynth returning: " + this);
        }
        return this;
    }

    protected AbstractMidiDevice openMidiOut() {
        if (Printer.trace) {
            Printer.trace(">> AbstractPlayer: openMidiOut");
        }
        MidiDevice.Info[] infoArray = MidiSystem.getMidiDeviceInfo();
        int n2 = 0;
        while (n2 < infoArray.length) {
            block7: {
                if (infoArray[n2] instanceof MidiOutDeviceProvider.MidiOutDeviceInfo) {
                    try {
                        AbstractMidiDevice abstractMidiDevice = (AbstractMidiDevice)MidiSystem.getMidiDevice(infoArray[n2]);
                        abstractMidiDevice.open();
                        if (Printer.trace) {
                            Printer.trace("<< AbstractPlayer: openMidiOut returning: " + abstractMidiDevice);
                        }
                        return abstractMidiDevice;
                    }
                    catch (MidiUnavailableException midiUnavailableException) {
                        if (!Printer.debug) break block7;
                        Printer.debug("<< AbstractPlayer: openMidiOut: failed to open midi out device: " + midiUnavailableException);
                    }
                }
            }
            ++n2;
        }
        if (Printer.trace) {
            Printer.trace("<< AbstractPlayer: openMidiOut returning null");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connectToInternalSynth() {
        if (Printer.trace) {
            Printer.trace(">> AbstractPlayer: connectToInternalSynth");
        }
        if (this.internalSynth == null) {
            if (Printer.err) {
                Printer.err("AbstractPlayer.connectToInternalSynth: internalSynth is null!");
            }
            return;
        }
        if (this.internalSynth == this) {
            AbstractPlayer abstractPlayer = this;
            synchronized (abstractPlayer) {
                this.nAddReceiver(this.id, 0L);
            }
        }
        AbstractPlayer abstractPlayer = this;
        synchronized (abstractPlayer) {
            this.nAddReceiver(this.id, this.internalSynth.getId());
        }
        if (Printer.trace) {
            Printer.trace("<< AbstractPlayer: connectToInternalSynth completed");
        }
    }

    synchronized void implClose() {
        if (Printer.trace) {
            Printer.trace(">> AbstractPlayer: implClose");
        }
        this.closeInternalSynth();
        long l2 = this.id;
        this.id = 0L;
        int n2 = 0;
        while (n2 < this.channels.length) {
            this.channels[n2].setId(this.id);
            ++n2;
        }
        this.nClose(l2);
        if (Printer.trace) {
            Printer.trace("<< AbstractPlayer: implClose completed");
        }
    }

    protected boolean parse(int n2, int n3, int n4, int n5, long l2) {
        if (n2 == 128) {
            this.setTimeStamp(l2);
            this.channels[n3].noteOff(n4, n5);
            return true;
        }
        if (n2 == 144) {
            this.setTimeStamp(l2);
            this.channels[n3].noteOn(n4, n5);
            return true;
        }
        if (n2 == 160) {
            this.setTimeStamp(l2);
            this.channels[n3].setPolyPressure(n4, n5);
            return true;
        }
        if (n2 == 176) {
            this.setTimeStamp(l2);
            this.channels[n3].controlChange(n4, n5);
            return true;
        }
        if (n2 == 192) {
            this.setTimeStamp(l2);
            this.channels[n3].programChange(n4, n5);
            return true;
        }
        if (n2 == 208) {
            this.setTimeStamp(l2);
            this.channels[n3].setChannelPressure(n4);
            return true;
        }
        if (n2 == 224) {
            this.setTimeStamp(l2);
            this.channels[n3].setPitchBend(n4 & 0xF0 | n5 & 0xF);
            return true;
        }
        return false;
    }

    private Soundbank loadDefaultSoundbank() {
        HeadspaceSoundbank headspaceSoundbank = null;
        int n2 = 0;
        while (n2 < defaultSoundbankNames.length) {
            String string;
            String string2 = defaultSoundbankNames[n2];
            try {
                string = "file:" + string2;
                URL uRL = new URL(string);
                if (Printer.debug) {
                    Printer.debug("Looking for soundbank: " + uRL);
                }
                if ((headspaceSoundbank = new HeadspaceSoundbank(uRL)) != null) {
                    break;
                }
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (IOException iOException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            String string3 = Platform.getClasspath();
            StringTokenizer stringTokenizer = new StringTokenizer(string3, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens() && headspaceSoundbank == null) {
                String string4 = stringTokenizer.nextToken();
                String string5 = string4.substring(string4.lastIndexOf(File.separatorChar) + 1, string4.length());
                if (!string5.equals(soundJarName) && !string5.equals(jmfJarName)) continue;
                string = string4.substring(0, string4.lastIndexOf(File.separatorChar));
                string = string + File.separatorChar + string2;
                if (Printer.debug) {
                    Printer.debug("Looking for soundbank: " + string);
                }
                try {
                    headspaceSoundbank = new HeadspaceSoundbank(string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (headspaceSoundbank != null) break;
            string = Platform.getJavahome();
            string = string + File.separatorChar + "lib" + File.separatorChar + "audio" + File.separatorChar + string2;
            try {
                if (Printer.debug) {
                    Printer.debug("Looking for soundbank: " + string);
                }
                if ((headspaceSoundbank = new HeadspaceSoundbank(string)) != null) {
                    break;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            ++n2;
        }
        if (Printer.debug) {
            Printer.debug("Default soundbank: " + headspaceSoundbank);
        }
        return headspaceSoundbank;
    }

    protected native void nClose(long var1);

    protected native void nAddReceiver(long var1, long var3);

    protected native void nRemoveReceiver(long var1, long var3);

    private native boolean nLoadInstrument(long var1, int var3);

    private native boolean nUnloadInstrument(long var1, int var3);

    private native boolean nRemapInstrument(long var1, int var3, int var4);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class PlayerReceiver
    implements Receiver {
        private boolean open = true;

        PlayerReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void send(MidiMessage midiMessage, long l2) {
            if (!this.open) {
                return;
            }
            if (AbstractPlayer.this.id == 0L) {
                throw new IllegalStateException("Synthesizer is not open.");
            }
            Vector vector = AbstractPlayer.this.transmitters;
            synchronized (vector) {
                int n2 = 0;
                while (n2 < AbstractPlayer.this.transmitters.size()) {
                    Receiver receiver = ((Transmitter)AbstractPlayer.this.transmitters.elementAt(n2)).getReceiver();
                    if (receiver != null) {
                        receiver.send(midiMessage, l2);
                    }
                    ++n2;
                }
            }
            if (!(midiMessage instanceof ShortMessage)) {
                if (Printer.err) {
                    Printer.err("Unsupported message type: " + midiMessage);
                }
                return;
            }
            ShortMessage shortMessage = (ShortMessage)midiMessage;
            AbstractPlayer.this.parse(shortMessage.getCommand(), shortMessage.getChannel(), shortMessage.getData1(), shortMessage.getData2(), l2);
        }

        public void close() {
            AbstractPlayer.this.receivers.removeElement(this);
            this.open = false;
        }
    }

    class PlayerOutTransmitter
    implements Transmitter {
        private boolean open = true;
        private Receiver receiver = null;

        PlayerOutTransmitter() {
        }

        public void setReceiver(Receiver receiver) {
            this.receiver = receiver;
        }

        public Receiver getReceiver() {
            return this.receiver;
        }

        public void close() {
            AbstractPlayer.this.transmitters.removeElement(this);
            this.open = false;
        }
    }
}

