/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.Encoder;
import java.beans.Expression;
import java.beans.IdentityHashtable;
import java.beans.Introspector;
import java.beans.NameGenerator;
import java.beans.Statement;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Vector;

public class XMLEncoder
extends Encoder {
    private static String encoding = "UTF-8";
    private OutputStream out;
    private Object owner;
    private int indentation = 0;
    private boolean internal = false;
    private HashMap valueToExpression;
    private HashMap targetToStatementList;
    private boolean preambleWritten = false;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$beans$XMLDecoder;
    static /* synthetic */ Class class$java$beans$Expression;
    static /* synthetic */ Class class$java$lang$reflect$Array;
    static /* synthetic */ Class class$java$lang$Class;

    public XMLEncoder(OutputStream outputStream) {
        this.out = outputStream;
        this.valueToExpression = new IdentityHashtable();
        this.targetToStatementList = new IdentityHashtable();
        Statement.setCaching(true);
    }

    public void setOwner(Object object) {
        this.owner = object;
        this.writeExpression(new Expression(this, "getOwner", new Object[0]));
    }

    public Object getOwner() {
        return this.owner;
    }

    public void writeObject(Object object) {
        if (this.internal) {
            super.writeObject(object);
        } else {
            this.writeStatement(new Statement(this, "writeObject", new Object[]{object}));
        }
    }

    private Vector statementList(Object object) {
        Vector vector = (Vector)this.targetToStatementList.get(object);
        if (vector != null) {
            return vector;
        }
        vector = new Vector();
        this.targetToStatementList.put(object, vector);
        return vector;
    }

    private void mark(Object object, boolean bl2) {
        if (object == null || object == this) {
            return;
        }
        ValueData valueData = this.getValueData(object);
        Expression expression = valueData.exp;
        if (object.getClass() == (class$java$lang$String == null ? (class$java$lang$String = XMLEncoder.class$("java.lang.String")) : class$java$lang$String) && expression == null) {
            return;
        }
        if (bl2) {
            ++valueData.refs;
        }
        if (valueData.marked) {
            return;
        }
        valueData.marked = true;
        Object object2 = expression.getTarget();
        if (!(object2 instanceof Class)) {
            this.statementList(object2).add(expression);
            ++valueData.refs;
        }
        this.mark(expression);
    }

    private void mark(Statement statement) {
        this.mark(statement.getTarget(), false);
        Object[] objectArray = statement.getArguments();
        int n2 = 0;
        while (n2 < objectArray.length) {
            Object object = objectArray[n2];
            this.mark(object, true);
            ++n2;
        }
    }

    public void writeStatement(Statement statement) {
        boolean bl2 = this.internal;
        this.internal = true;
        try {
            super.writeStatement(statement);
            this.mark(statement);
            this.statementList(statement.getTarget()).add(statement);
        }
        catch (Exception exception) {
            this.getExceptionListener().exceptionThrown(new Exception("discarding statement " + statement));
        }
        this.internal = bl2;
    }

    public void writeExpression(Expression expression) {
        boolean bl2 = this.internal;
        this.internal = true;
        Object object = this.getValue(expression);
        if (this.get(object) == null || object instanceof String && !bl2) {
            this.getValueData((Object)object).exp = expression;
            super.writeExpression(expression);
        }
        this.internal = bl2;
    }

    public void flush() {
        if (!this.preambleWritten) {
            this.writeln("<?xml version=" + this.quote("1.0") + " encoding=" + this.quote(encoding) + "?>");
            this.writeln("<java version=" + this.quote(System.getProperty("java.version")) + " class=" + this.quote((class$java$beans$XMLDecoder == null ? (class$java$beans$XMLDecoder = XMLEncoder.class$("java.beans.XMLDecoder")) : class$java$beans$XMLDecoder).getName()) + ">");
            this.preambleWritten = true;
        }
        ++this.indentation;
        Vector vector = this.statementList(this);
        int n2 = 0;
        while (n2 < vector.size()) {
            Statement statement = (Statement)vector.get(n2);
            if (statement.getMethodName() == "writeObject") {
                this.outputValue(statement.getArguments()[0], this, true);
            } else {
                this.outputStatement(statement, this, false);
            }
            ++n2;
        }
        --this.indentation;
        try {
            this.out.flush();
        }
        catch (IOException iOException) {
            this.getExceptionListener().exceptionThrown(iOException);
        }
        NameGenerator.clear();
        super.clear();
        this.valueToExpression.clear();
        this.targetToStatementList.clear();
        Statement.setCaching(false);
    }

    public void close() {
        this.flush();
        this.writeln("</java>");
        try {
            this.out.close();
        }
        catch (IOException iOException) {
            this.getExceptionListener().exceptionThrown(iOException);
        }
    }

    private String quote(String string) {
        return "\"" + string + "\"";
    }

    private String instanceName(Object object) {
        return NameGenerator.instanceName(object);
    }

    private String propertyName(String string) {
        return Introspector.decapitalize(string.substring(3));
    }

    private ValueData getValueData(Object object) {
        ValueData valueData = (ValueData)this.valueToExpression.get(object);
        if (valueData == null) {
            valueData = new ValueData();
            this.valueToExpression.put(object, valueData);
        }
        return valueData;
    }

    private static String quoteCharacters(String string) {
        string = NameGenerator.replace(string, '&', "&amp;");
        string = NameGenerator.replace(string, '<', "&lt;");
        string = NameGenerator.replace(string, '\r', "&#13;");
        return string;
    }

    private void writeln(String string) {
        try {
            int n2 = 0;
            while (n2 < this.indentation) {
                this.out.write(32);
                ++n2;
            }
            this.out.write(string.getBytes(encoding));
            this.out.write(" \n".getBytes());
        }
        catch (IOException iOException) {
            this.getExceptionListener().exceptionThrown(iOException);
        }
    }

    private void outputValue(Object object, Object object2, boolean bl2) {
        if (object == null) {
            this.writeln("<null/>");
            return;
        }
        if (object instanceof Class) {
            this.writeln("<class>" + ((Class)object).getName() + "</class>");
            return;
        }
        ValueData valueData = this.getValueData(object);
        if (valueData.exp != null && valueData.exp.getTarget() instanceof Field && valueData.exp.getMethodName() == "get") {
            Field field = (Field)valueData.exp.getTarget();
            this.writeln("<object class=" + this.quote(field.getDeclaringClass().getName()) + " field=" + this.quote(field.getName()) + "/>");
            return;
        }
        Class clazz = Statement.primitiveTypeFor(object.getClass());
        if (clazz != null && valueData.exp.getTarget() == object.getClass() && valueData.exp.getMethodName() == "new") {
            String string = clazz.getName();
            this.writeln("<" + string + ">" + object + "</" + string + ">");
            return;
        }
        if (object instanceof String && valueData.exp == null) {
            this.writeln("<string>" + XMLEncoder.quoteCharacters((String)object) + "</string>");
            return;
        }
        if (valueData.name != null) {
            this.writeln("<object idref=" + this.quote(valueData.name) + "/>");
            return;
        }
        this.outputStatement(valueData.exp, object2, bl2);
    }

    private void outputStatement(Statement statement, Object object, boolean bl2) {
        Object object2;
        Object object3 = statement.getTarget();
        String string = statement.getMethodName();
        Object[] objectArray = statement.getArguments();
        boolean bl3 = statement.getClass() == (class$java$beans$Expression == null ? (class$java$beans$Expression = XMLEncoder.class$("java.beans.Expression")) : class$java$beans$Expression);
        Object object4 = bl3 ? this.getValue((Expression)statement) : null;
        String string2 = bl3 && bl2 ? "object" : "void";
        String string3 = "";
        ValueData valueData = this.getValueData(object4);
        if (bl3 && valueData.refs > 1) {
            object2 = this.instanceName(object4);
            valueData.name = object2;
            string3 = string3 + " id=" + this.quote((String)object2);
        }
        if (object3 != object) {
            if (object3 == (class$java$lang$reflect$Array == null ? (class$java$lang$reflect$Array = XMLEncoder.class$("java.lang.reflect.Array")) : class$java$lang$reflect$Array) && string == "newInstance") {
                string2 = "array";
                string3 = string3 + " class=" + this.quote(((Class)objectArray[0]).getName());
                string3 = string3 + " length=" + this.quote(objectArray[1].toString());
                objectArray = new Object[]{};
            } else if (object3.getClass() == (class$java$lang$Class == null ? (class$java$lang$Class = XMLEncoder.class$("java.lang.Class")) : class$java$lang$Class)) {
                string3 = string3 + " class=" + this.quote(((Class)object3).getName());
            } else {
                valueData.refs = 2;
                this.outputValue(object3, object, false);
                this.outputValue(object4, object, false);
                return;
            }
        }
        if (!bl3 && string == "set" && objectArray.length == 2 && objectArray[0] instanceof Integer || bl3 && string == "get" && objectArray.length == 1 && objectArray[0] instanceof Integer) {
            Object[] objectArray2;
            string3 = string3 + " index=" + this.quote(objectArray[0].toString());
            if (objectArray.length == 1) {
                objectArray2 = new Object[]{};
            } else {
                Object[] objectArray3 = new Object[1];
                objectArray2 = objectArray3;
                objectArray3[0] = objectArray[1];
            }
            objectArray = objectArray2;
        } else if (!bl3 && string.startsWith("set") && objectArray.length == 1 || bl3 && string.startsWith("get") && objectArray.length == 0) {
            string3 = string3 + " property=" + this.quote(this.propertyName(string));
        } else if (string != "new" && string != "newInstance") {
            string3 = string3 + " method=" + this.quote(string);
        }
        object2 = this.statementList(object4);
        if (objectArray.length == 0 && ((Vector)object2).size() == 0) {
            this.writeln("<" + string2 + string3 + "/>");
            return;
        }
        this.writeln("<" + string2 + string3 + ">");
        ++this.indentation;
        int n2 = 0;
        while (n2 < objectArray.length) {
            this.outputValue(objectArray[n2], null, true);
            ++n2;
        }
        int n3 = 0;
        while (n3 < ((Vector)object2).size()) {
            Statement statement2 = (Statement)((Vector)object2).get(n3);
            this.outputStatement(statement2, object4, false);
            ++n3;
        }
        --this.indentation;
        this.writeln("</" + string2 + ">");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ValueData {
        public int refs = 0;
        public boolean marked = false;
        public String name = null;
        public Expression exp = null;

        private ValueData() {
        }
    }
}

