/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BufferedInputStream
extends FilterInputStream {
    private static int defaultBufferSize = 2048;
    protected byte[] buf;
    protected int count;
    protected int pos;
    protected int markpos = -1;
    protected int marklimit;

    private void ensureOpen() throws IOException {
        if (this.in == null) {
            throw new IOException("Stream closed");
        }
    }

    public BufferedInputStream(InputStream inputStream) {
        this(inputStream, defaultBufferSize);
    }

    public BufferedInputStream(InputStream inputStream, int n2) {
        super(inputStream);
        if (n2 <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.buf = new byte[n2];
    }

    private void fill() throws IOException {
        int n2;
        if (this.markpos < 0) {
            this.pos = 0;
        } else if (this.pos >= this.buf.length) {
            if (this.markpos > 0) {
                n2 = this.pos - this.markpos;
                System.arraycopy(this.buf, this.markpos, this.buf, 0, n2);
                this.pos = n2;
                this.markpos = 0;
            } else if (this.buf.length >= this.marklimit) {
                this.markpos = -1;
                this.pos = 0;
            } else {
                n2 = this.pos * 2;
                if (n2 > this.marklimit) {
                    n2 = this.marklimit;
                }
                byte[] byArray = new byte[n2];
                System.arraycopy(this.buf, 0, byArray, 0, this.pos);
                this.buf = byArray;
            }
        }
        this.count = this.pos;
        n2 = this.in.read(this.buf, this.pos, this.buf.length - this.pos);
        if (n2 > 0) {
            this.count = n2 + this.pos;
        }
    }

    public synchronized int read() throws IOException {
        this.ensureOpen();
        if (this.pos >= this.count) {
            this.fill();
            if (this.pos >= this.count) {
                return -1;
            }
        }
        return this.buf[this.pos++] & 0xFF;
    }

    private int read1(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = this.count - this.pos;
        if (n4 <= 0) {
            if (n3 >= this.buf.length && this.markpos < 0) {
                return this.in.read(byArray, n2, n3);
            }
            this.fill();
            n4 = this.count - this.pos;
            if (n4 <= 0) {
                return -1;
            }
        }
        int n5 = n4 < n3 ? n4 : n3;
        System.arraycopy(this.buf, this.pos, byArray, n2, n5);
        this.pos += n5;
        return n5;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized int read(byte[] var1_1, int var2_2, int var3_3) throws IOException {
        this.ensureOpen();
        if ((var2_2 | var3_3 | var2_2 + var3_3 | var1_1.length - (var2_2 + var3_3)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (var3_3 == 0) {
            return 0;
        }
        var4_4 = this.read1(var1_1, var2_2, var3_3);
        if (var4_4 > 0) ** GOTO lbl11
        return var4_4;
        while ((var5_5 = this.read1(var1_1, var2_2 + var4_4, var3_3 - var4_4)) > 0) {
            var4_4 += var5_5;
lbl11:
            // 2 sources

            if (var4_4 < var3_3 && this.in.available() > 0) continue;
        }
        return var4_4;
    }

    public synchronized long skip(long l2) throws IOException {
        this.ensureOpen();
        if (l2 <= 0L) {
            return 0L;
        }
        long l3 = this.count - this.pos;
        if (l3 <= 0L) {
            if (this.markpos < 0) {
                return this.in.skip(l2);
            }
            this.fill();
            l3 = this.count - this.pos;
            if (l3 <= 0L) {
                return 0L;
            }
        }
        long l4 = l3 < l2 ? l3 : l2;
        this.pos = (int)((long)this.pos + l4);
        return l4;
    }

    public synchronized int available() throws IOException {
        this.ensureOpen();
        return this.count - this.pos + this.in.available();
    }

    public synchronized void mark(int n2) {
        this.marklimit = n2;
        this.markpos = this.pos;
    }

    public synchronized void reset() throws IOException {
        this.ensureOpen();
        if (this.markpos < 0) {
            throw new IOException("Resetting to invalid mark");
        }
        this.pos = this.markpos;
    }

    public boolean markSupported() {
        return true;
    }

    public void close() throws IOException {
        if (this.in == null) {
            return;
        }
        this.in.close();
        this.in = null;
        this.buf = null;
    }
}

