/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Principal;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import sun.security.provider.certpath.Builder;
import sun.security.provider.certpath.CrlRevocationChecker;
import sun.security.provider.certpath.ForwardState;
import sun.security.provider.certpath.KeyChecker;
import sun.security.provider.certpath.State;
import sun.security.util.BigInt;
import sun.security.util.Debug;
import sun.security.x509.GeneralNameInterface;
import sun.security.x509.PKIXExtensions;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;

class ForwardBuilder
extends Builder {
    private Debug debug = Debug.getInstance("certpath");
    private Date date;
    private final Collection trustedCerts;
    private final Set trustedSubjectDNs;
    private final Set trustAnchors;
    private X509CertSelector eeSelector;
    private X509CertSelector caSelector;
    private X509CertSelector caTargetSelector;
    TrustAnchor trustAnchor;

    ForwardBuilder(PKIXBuilderParameters pKIXBuilderParameters, X500Name x500Name) {
        super(pKIXBuilderParameters, x500Name);
        this.date = pKIXBuilderParameters.getDate();
        if (this.date == null) {
            this.date = new Date();
        }
        this.trustAnchors = pKIXBuilderParameters.getTrustAnchors();
        this.trustedCerts = new HashSet(this.trustAnchors.size());
        this.trustedSubjectDNs = new HashSet(this.trustAnchors.size());
        Iterator iterator = this.trustAnchors.iterator();
        while (iterator.hasNext()) {
            TrustAnchor trustAnchor = (TrustAnchor)iterator.next();
            X509Certificate x509Certificate = trustAnchor.getTrustedCert();
            try {
                if (x509Certificate != null) {
                    this.trustedCerts.add(x509Certificate);
                    Principal principal = x509Certificate.getSubjectDN();
                    if (principal instanceof X500Name) {
                        this.trustedSubjectDNs.add(principal);
                        continue;
                    }
                    byte[] byArray = x509Certificate.getSubjectX500Principal().getEncoded();
                    this.trustedSubjectDNs.add(new X500Name(byArray));
                    continue;
                }
                this.trustedSubjectDNs.add(new X500Name(trustAnchor.getCAName()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    Collection getMatchingCerts(State state) throws CertStoreException, CertificateException, IOException {
        if (this.debug != null) {
            this.debug.println("ForwardBuilder.getMatchingCerts()...");
        }
        ForwardState forwardState = (ForwardState)state;
        ArrayList arrayList = new ArrayList();
        if (forwardState.isInitial()) {
            arrayList.addAll(this.getMatchingEECerts(forwardState));
        }
        arrayList.addAll(this.getMatchingCACerts(forwardState));
        Collections.sort(arrayList, new PKIXCertComparator());
        return arrayList;
    }

    private Collection getMatchingEECerts(ForwardState forwardState) throws CertStoreException, CertificateException, IOException {
        if (this.debug != null) {
            this.debug.println("ForwardBuilder.getMatchingEECerts()...");
        }
        if (this.eeSelector == null) {
            this.eeSelector = (X509CertSelector)this.buildParams.getTargetCertConstraints();
            this.eeSelector.setCertificateValid(this.date);
            if (this.buildParams.isExplicitPolicyRequired()) {
                this.eeSelector.setPolicy(this.getMatchingPolicies());
            }
            this.eeSelector.setBasicConstraints(-2);
        }
        HashSet hashSet = new HashSet();
        Iterator iterator = this.buildParams.getCertStores().iterator();
        while (iterator.hasNext()) {
            try {
                Collection collection = ((CertStore)iterator.next()).getCertificates(this.eeSelector);
                Iterator iterator2 = collection.iterator();
                while (iterator2.hasNext()) {
                    X509Certificate x509Certificate = (X509Certificate)iterator2.next();
                    if (x509Certificate.getIssuerDN().equals(x509Certificate.getSubjectDN())) continue;
                    hashSet.add(x509Certificate);
                }
            }
            catch (CertStoreException certStoreException) {
                // empty catch block
            }
        }
        return hashSet;
    }

    private Collection getMatchingCACerts(ForwardState forwardState) throws CertificateException, CertStoreException, IOException {
        Object object;
        if (this.debug != null) {
            this.debug.println("ForwardBuilder.getMatchingCACerts()...");
        }
        X509CertSelector x509CertSelector = null;
        if (forwardState.isInitial()) {
            if (this.caTargetSelector == null) {
                this.caTargetSelector = (X509CertSelector)this.buildParams.getTargetCertConstraints();
                this.caTargetSelector.setCertificateValid(this.date);
                if (this.buildParams.isExplicitPolicyRequired()) {
                    this.caTargetSelector.setPolicy(this.getMatchingPolicies());
                }
            }
            this.caTargetSelector.setBasicConstraints(forwardState.traversedCACerts);
            x509CertSelector = this.caTargetSelector;
        } else {
            if (this.caSelector == null) {
                this.caSelector = new X509CertSelector();
                this.caSelector.setCertificateValid(this.date);
                if (this.buildParams.isExplicitPolicyRequired()) {
                    this.caSelector.setPolicy(this.getMatchingPolicies());
                }
            }
            this.caSelector.setSubject(forwardState.issuerDN);
            this.caSelector.setPathToNames(forwardState.subjectNamesTraversed);
            this.caSelector.setBasicConstraints(forwardState.traversedCACerts);
            x509CertSelector = this.caSelector;
        }
        ArrayList arrayList = new ArrayList();
        X509CertSelector x509CertSelector2 = new X509CertSelector();
        if (forwardState.isInitial()) {
            x509CertSelector2 = (X509CertSelector)this.buildParams.getTargetCertConstraints();
        } else {
            x509CertSelector2.setSubject(forwardState.issuerDN);
        }
        Iterator iterator = this.trustedCerts.iterator();
        while (iterator.hasNext()) {
            object = (X509Certificate)iterator.next();
            if (!x509CertSelector2.match((Certificate)object)) continue;
            if (this.debug != null) {
                this.debug.println("ForwardBuilder.getMatchingCACerts: found matching trust anchor");
            }
            arrayList.add(object);
        }
        if (this.buildParams.getMaxPathLength() == -1 || this.buildParams.getMaxPathLength() > forwardState.traversedCACerts) {
            object = this.buildParams.getCertStores().iterator();
            while (object.hasNext()) {
                try {
                    Collection collection = ((CertStore)object.next()).getCertificates(x509CertSelector);
                    Iterator iterator2 = collection.iterator();
                    while (iterator2.hasNext()) {
                        X509Certificate x509Certificate = (X509Certificate)iterator2.next();
                        if (x509Certificate.getIssuerDN().equals(x509Certificate.getSubjectDN())) continue;
                        arrayList.add(x509Certificate);
                    }
                }
                catch (CertStoreException certStoreException) {
                    // empty catch block
                }
            }
        }
        return arrayList;
    }

    void verifyCert(X509Certificate x509Certificate, State state, List list) throws GeneralSecurityException {
        boolean bl2;
        Object object;
        Object object2;
        Object object3;
        if (this.debug != null) {
            this.debug.println("ForwardBuilder.verifyCert(SN: " + new BigInt(x509Certificate.getSerialNumber()).toString() + "\n  Issuer: " + x509Certificate.getIssuerDN() + ")" + "\n  Subject: " + x509Certificate.getSubjectDN() + ")");
        }
        ForwardState forwardState = (ForwardState)state;
        if (list != null && !list.isEmpty()) {
            Iterator iterator = list.iterator();
            boolean bl3 = false;
            while (iterator.hasNext()) {
                object3 = (X509Certificate)iterator.next();
                object2 = new X509CertImpl(((Certificate)object3).getEncoded());
                object = ((X509CertImpl)object2).getPolicyMappingsExtension();
                if (object != null) {
                    bl3 = true;
                }
                if (this.debug != null) {
                    this.debug.println("policyMappingFound = " + bl3);
                }
                if (!x509Certificate.equals(object3) || !this.buildParams.isPolicyMappingInhibited() && bl3) continue;
                if (this.debug != null) {
                    this.debug.println("loop detected!!");
                }
                throw new CertPathValidatorException("loop detected");
            }
        }
        if (!(bl2 = this.isTrustedCert(x509Certificate))) {
            Set set = x509Certificate.getCriticalExtensionOIDs();
            if (set == null) {
                set = Collections.EMPTY_SET;
            }
            object3 = forwardState.forwardCheckers.iterator();
            while (object3.hasNext()) {
                object2 = (PKIXCertPathChecker)object3.next();
                ((PKIXCertPathChecker)object2).check(x509Certificate, set);
            }
            object2 = this.buildParams.getCertPathCheckers();
            object = object2.iterator();
            while (object.hasNext()) {
                Set set2;
                PKIXCertPathChecker pKIXCertPathChecker = (PKIXCertPathChecker)object.next();
                if (pKIXCertPathChecker.isForwardCheckingSupported() || (set2 = pKIXCertPathChecker.getSupportedExtensions()) == null) continue;
                Iterator iterator = set2.iterator();
                while (iterator.hasNext()) {
                    set.remove(iterator.next());
                }
            }
            if (!set.isEmpty()) {
                set.remove(PKIXExtensions.BasicConstraints_Id.toString());
                set.remove(PKIXExtensions.NameConstraints_Id.toString());
                set.remove(PKIXExtensions.CertificatePolicies_Id.toString());
                set.remove(PKIXExtensions.PolicyMappings_Id.toString());
                set.remove(PKIXExtensions.PolicyConstraints_Id.toString());
                set.remove(PKIXExtensions.InhibitAnyPolicy_Id.toString());
                set.remove(PKIXExtensions.SubjectAlternativeName_Id.toString());
                set.remove(PKIXExtensions.KeyUsage_Id.toString());
                set.remove(PKIXExtensions.ExtendedKeyUsage_Id.toString());
                if (!set.isEmpty()) {
                    throw new CertificateException("Unrecognized critical extension(s)");
                }
            }
        }
        if (forwardState.isInitial()) {
            return;
        }
        if (!bl2) {
            int n2 = x509Certificate.getBasicConstraints();
            if (n2 == -1) {
                throw new CertificateException("cert is NOT a CA cert");
            }
            KeyChecker.verifyCAKeyUsage(x509Certificate);
        }
        if (this.buildParams.isRevocationEnabled()) {
            if (forwardState.crlChecker.certCanSignCrl(x509Certificate)) {
                if (!forwardState.keyParamsNeeded()) {
                    forwardState.crlChecker.check(forwardState.cert, x509Certificate.getPublicKey(), true);
                }
            } else {
                throw new CertPathValidatorException("cert can't vouch for crl");
            }
        }
        if (!forwardState.keyParamsNeeded()) {
            forwardState.cert.verify(x509Certificate.getPublicKey(), this.buildParams.getSigProvider());
        }
    }

    boolean isPathCompleted(X509Certificate x509Certificate) {
        Iterator iterator = this.trustAnchors.iterator();
        while (iterator.hasNext()) {
            TrustAnchor trustAnchor = (TrustAnchor)iterator.next();
            if (trustAnchor.getTrustedCert() != null) {
                if (!x509Certificate.equals(trustAnchor.getTrustedCert())) continue;
                this.trustAnchor = trustAnchor;
                return true;
            }
            X500Principal x500Principal = null;
            try {
                x500Principal = new X500Principal(trustAnchor.getCAName());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (this.debug == null) continue;
                this.debug.println("ForwardBuilder.isPathCompleted() exception in new X500Principal(anchor.getCAName())");
                illegalArgumentException.printStackTrace();
                continue;
            }
            if (!x500Principal.equals(x509Certificate.getIssuerX500Principal())) continue;
            if (this.buildParams.isRevocationEnabled()) {
                try {
                    CrlRevocationChecker crlRevocationChecker = new CrlRevocationChecker(null, this.buildParams.getCertStores(), this.buildParams.getSigProvider(), this.buildParams.getDate());
                    crlRevocationChecker.check(x509Certificate, trustAnchor.getCAPublicKey(), true);
                }
                catch (CertPathValidatorException certPathValidatorException) {
                    if (this.debug == null) continue;
                    this.debug.println("ForwardBuilder.isPathCompleted() cpve");
                    certPathValidatorException.printStackTrace();
                    continue;
                }
                catch (Exception exception) {
                    if (this.debug == null) continue;
                    this.debug.println("ForwardBuilder.isPathCompleted() unexpected exception");
                    exception.printStackTrace();
                    continue;
                }
            }
            try {
                x509Certificate.verify(trustAnchor.getCAPublicKey(), this.buildParams.getSigProvider());
            }
            catch (InvalidKeyException invalidKeyException) {
                if (this.debug == null) continue;
                this.debug.println("ForwardBuilder.isPathCompleted() invalid DSA key found");
                continue;
            }
            catch (Exception exception) {
                if (this.debug == null) continue;
                this.debug.println("ForwardBuilder.isPathCompleted() 2 unexpected exception");
                exception.printStackTrace();
                continue;
            }
            this.trustAnchor = trustAnchor;
            return true;
        }
        return false;
    }

    boolean isTrustedCert(X509Certificate x509Certificate) {
        Iterator iterator = this.trustedCerts.iterator();
        while (iterator.hasNext()) {
            if (!x509Certificate.equals((X509Certificate)iterator.next())) continue;
            return true;
        }
        return false;
    }

    void addCertToPath(X509Certificate x509Certificate, LinkedList linkedList) {
        linkedList.addFirst(x509Certificate);
    }

    void removeFinalCertFromPath(LinkedList linkedList) {
        linkedList.removeFirst();
    }

    class PKIXCertComparator
    implements Comparator {
        private Debug debug = Debug.getInstance("certpath");
        final String METHOD_NME = "ForwardBuilder.PKIXCertComparator.compare()";

        PKIXCertComparator() {
        }

        public int compare(Object object, Object object2) {
            int n2;
            int n3;
            Principal principal;
            X509Certificate x509Certificate = (X509Certificate)object;
            X509Certificate x509Certificate2 = (X509Certificate)object2;
            Principal principal2 = x509Certificate.getIssuerDN();
            Principal principal3 = x509Certificate2.getIssuerDN();
            try {
                if (!(principal2 instanceof X500Name)) {
                    principal2 = new X500Name(principal2.getName());
                }
            }
            catch (IOException iOException) {
                return 1;
            }
            try {
                if (!(principal3 instanceof X500Name)) {
                    principal3 = new X500Name(principal3.getName());
                }
            }
            catch (IOException iOException) {
                return -1;
            }
            if (this.debug != null) {
                this.debug.println("ForwardBuilder.PKIXCertComparator.compare() o1 Issuer:  " + principal2.toString());
                this.debug.println("ForwardBuilder.PKIXCertComparator.compare() o2 Issuer:  " + principal3.toString());
            }
            if (this.debug != null) {
                this.debug.println("ForwardBuilder.PKIXCertComparator.compare() MATCH TRUSTED SUBJECT TEST...");
            }
            Iterator iterator = ForwardBuilder.this.trustedSubjectDNs.iterator();
            while (iterator.hasNext()) {
                principal = (X500Name)iterator.next();
                n3 = principal2.equals(principal);
                n2 = principal3.equals(principal);
                if (n3 != 0 && n2 != 0) {
                    if (this.debug != null) {
                        this.debug.println("ForwardBuilder.PKIXCertComparator.compare() m1 && m2; RETURN 0");
                    }
                    return 0;
                }
                if (n3 != 0) {
                    if (this.debug != null) {
                        this.debug.println("ForwardBuilder.PKIXCertComparator.compare() m1; RETURN -1");
                    }
                    return -1;
                }
                if (n2 == 0) continue;
                if (this.debug != null) {
                    this.debug.println("ForwardBuilder.PKIXCertComparator.compare() m2; RETURN 1");
                }
                return 1;
            }
            if (this.debug != null) {
                this.debug.println("ForwardBuilder.PKIXCertComparator.compare() NAMING DESCENDANT TEST...");
            }
            iterator = ForwardBuilder.this.trustedSubjectDNs.iterator();
            while (iterator.hasNext()) {
                principal = (X500Name)iterator.next();
                try {
                    n3 = Builder.distance((GeneralNameInterface)((Object)principal), (X500Name)principal2);
                }
                catch (IOException iOException) {
                    n3 = -1;
                }
                try {
                    n2 = Builder.distance((GeneralNameInterface)((Object)principal), (X500Name)principal3);
                }
                catch (IOException iOException) {
                    n2 = -1;
                }
                if (this.debug != null) {
                    this.debug.println("ForwardBuilder.PKIXCertComparator.compare() distanceTto1: " + n3);
                    this.debug.println("ForwardBuilder.PKIXCertComparator.compare() distanceTto2: " + n2);
                }
                if (n3 <= 0 && n2 <= 0) continue;
                if (this.debug != null) {
                    this.debug.println("ForwardBuilder.PKIXCertComparator.compare() distanceTto1 > 0 || distanceTto2 > 0...");
                }
                if (n3 == n2) {
                    if (this.debug != null) {
                        this.debug.println("ForwardBuilder.PKIXCertComparator.compare() distanceTto1 == distanceTto2; RETURN 0");
                    }
                    return 0;
                }
                if (n3 > 0 && n2 <= 0) {
                    if (this.debug != null) {
                        this.debug.println("ForwardBuilder.PKIXCertComparator.compare() distanceTto1 > 0 && distanceTto2 <= 0); RETURN -1");
                    }
                    return -1;
                }
                if (n3 <= 0 && n2 > 0) {
                    if (this.debug != null) {
                        this.debug.println("ForwardBuilder.PKIXCertComparator.compare() distanceTto1 <= 0 && distanceTto2 > 0; RETURN 1");
                    }
                    return 1;
                }
                if (n3 < n2) {
                    if (this.debug != null) {
                        this.debug.println("ForwardBuilder.PKIXCertComparator.compare() distanceTto1 < distance Tto2; RETURN -1");
                    }
                    return -1;
                }
                if (this.debug != null) {
                    this.debug.println("ForwardBuilder.PKIXCertComparator.compare() distanceTto1 >= distanceTto2; RETURN 1");
                }
                return 1;
            }
            if (this.debug != null) {
                this.debug.println("ForwardBuilder.PKIXCertComparator.compare() NAMING ANCESTOR TEST...");
            }
            iterator = ForwardBuilder.this.trustedSubjectDNs.iterator();
            while (iterator.hasNext()) {
                principal = (X500Name)iterator.next();
                n3 = 0;
                n2 = 0;
                try {
                    n3 = Builder.distance((GeneralNameInterface)((Object)principal), (X500Name)principal2);
                }
                catch (IOException iOException) {
                    n3 = Integer.MAX_VALUE;
                }
                try {
                    n2 = Builder.distance((GeneralNameInterface)((Object)principal), (X500Name)principal3);
                }
                catch (IOException iOException) {
                    n2 = Integer.MAX_VALUE;
                }
                if (this.debug != null) {
                    this.debug.println("ForwardBuilder.PKIXCertComparator.compare() distanceTto1: " + n3);
                    this.debug.println("ForwardBuilder.PKIXCertComparator.compare() distanceTto2: " + n2);
                }
                if (n3 >= 0 && n2 >= 0) continue;
                if (this.debug != null) {
                    this.debug.println("ForwardBuilder.PKIXCertComparator.compare() distanceTto1 < 0 || distanceTto2 < 0...");
                }
                if (n3 == n2) {
                    if (this.debug != null) {
                        this.debug.println("ForwardBuilder.PKIXCertComparator.compare() distance==; RETURN 0");
                    }
                    return 0;
                }
                if (n3 < 0 && n2 >= 0) {
                    if (this.debug != null) {
                        this.debug.println("ForwardBuilder.PKIXCertComparator.compare() distanceTto1 < 0 && distanceTto2 >= 0; RETURN -1");
                    }
                    return -1;
                }
                if (n3 >= 0 && n2 < 0) {
                    if (this.debug != null) {
                        this.debug.println("ForwardBuilder.PKIXCertComparator.compare() distanceTto1 >= 0 && distanceTto2 < 0; RETURN 1");
                    }
                    return 1;
                }
                if (n3 > n2) {
                    if (this.debug != null) {
                        this.debug.println("ForwardBuilder.PKIXCertComparator.compare() distanceTto1 > distanceTto2; RETURN -1");
                    }
                    return -1;
                }
                if (this.debug != null) {
                    this.debug.println("ForwardBuilder.PKIXCertComparator.compare() distanceTto1 <= distanceTto2; RETURN 1");
                }
                return 1;
            }
            if (this.debug != null) {
                this.debug.println("ForwardBuilder.PKIXCertComparator.compare() SAME NAMESPACE AS TRUSTED TEST...");
            }
            iterator = ForwardBuilder.this.trustedSubjectDNs.iterator();
            while (iterator.hasNext()) {
                principal = (X500Name)iterator.next();
                X500Name x500Name = ((X500Name)principal).commonAncestor((X500Name)principal2);
                X500Name x500Name2 = ((X500Name)principal).commonAncestor((X500Name)principal3);
                if (this.debug != null) {
                    this.debug.println("ForwardBuilder.PKIXCertComparator.compare() tAo1: " + String.valueOf(x500Name));
                    this.debug.println("ForwardBuilder.PKIXCertComparator.compare() tAo2: " + String.valueOf(x500Name2));
                }
                if (x500Name == null && x500Name2 == null) continue;
                if (this.debug != null) {
                    this.debug.println("ForwardBuilder.PKIXCertComparator.compare() tAo1 != null || tAo2 != null...");
                }
                if (x500Name != null && x500Name2 != null) {
                    int n4;
                    int n5;
                    block85: {
                        block84: {
                            if (this.debug != null) {
                                this.debug.println("ForwardBuilder.PKIXCertComparator.compare() tAo1 != null && tAo2 != null...");
                            }
                            n5 = Integer.MAX_VALUE;
                            n4 = Integer.MAX_VALUE;
                            try {
                                n5 = Builder.hops((GeneralNameInterface)((Object)principal), (X500Name)principal2);
                            }
                            catch (IOException iOException) {
                                if (this.debug == null) break block84;
                                this.debug.println("ForwardBuilder.PKIXCertComparator.compare() exception in Builder.hops(tSubject, cIssuer1)");
                                iOException.printStackTrace();
                            }
                        }
                        try {
                            n4 = Builder.hops((GeneralNameInterface)((Object)principal), (X500Name)principal3);
                        }
                        catch (IOException iOException) {
                            if (this.debug == null) break block85;
                            this.debug.println("ForwardBuilder.PKIXCertComparator.compare() exception in Builder.hops(tSubject, cIssuer2)");
                            iOException.printStackTrace();
                        }
                    }
                    if (this.debug != null) {
                        this.debug.println("ForwardBuilder.PKIXCertComparator.compare() hopsTto1: " + n5);
                        this.debug.println("ForwardBuilder.PKIXCertComparator.compare() hopsTto2: " + n4);
                    }
                    if (n5 == n4) {
                        if (this.debug == null) continue;
                        this.debug.println("ForwardBuilder.PKIXCertComparator.compare() hopsTto1 == hopsTto2; continue");
                        continue;
                    }
                    if (n5 > n4) {
                        if (this.debug != null) {
                            this.debug.println("ForwardBuilder.PKIXCertComparator.compare() hopsTto1 > hopsTto2; RETURN 1");
                        }
                        return 1;
                    }
                    if (this.debug != null) {
                        this.debug.println("ForwardBuilder.PKIXCertComparator.compare() hopsTto1 < hopsTto2; RETURN -1");
                    }
                    return -1;
                }
                if (x500Name == null) {
                    if (this.debug != null) {
                        this.debug.println("ForwardBuilder.PKIXCertComparator.compare() tA01 == null; RETURN 1");
                    }
                    return 1;
                }
                if (this.debug != null) {
                    this.debug.println("ForwardBuilder.PKIXCertComparator.compare() tA02 == null; RETURN -1");
                }
                return -1;
            }
            if (this.debug != null) {
                this.debug.println("ForwardBuilder.PKIXCertComparator.compare() CERT ISSUER/SUBJECT COMPARISON TEST...");
            }
            principal = x509Certificate.getSubjectDN();
            Principal principal4 = x509Certificate2.getSubjectDN();
            try {
                if (!(principal instanceof X500Name)) {
                    principal = new X500Name(principal.getName());
                }
            }
            catch (IOException iOException) {
                return 1;
            }
            try {
                if (!(principal4 instanceof X500Name)) {
                    principal4 = new X500Name(principal4.getName());
                }
            }
            catch (IOException iOException) {
                return -1;
            }
            if (this.debug != null) {
                this.debug.println("ForwardBuilder.PKIXCertComparator.compare() o1 Subject: " + principal.toString());
                this.debug.println("ForwardBuilder.PKIXCertComparator.compare() o2 Subject: " + principal4.toString());
            }
            int n6 = 0;
            int n7 = 0;
            try {
                n6 = Builder.distance((X500Name)principal, (X500Name)principal2);
            }
            catch (IOException iOException) {
                n6 = Integer.MAX_VALUE;
            }
            try {
                n7 = Builder.distance((X500Name)principal4, (X500Name)principal3);
            }
            catch (IOException iOException) {
                n7 = Integer.MAX_VALUE;
            }
            if (this.debug != null) {
                this.debug.println("ForwardBuilder.PKIXCertComparator.compare() distanceStoI1: " + n6);
                this.debug.println("ForwardBuilder.PKIXCertComparator.compare() distanceStoI2: " + n7);
            }
            if (n7 > n6) {
                if (this.debug != null) {
                    this.debug.println("ForwardBuilder.PKIXCertComparator.compare() distanceStoI2 > distanceStoI1; RETURN -1");
                }
                return -1;
            }
            if (n7 < n6) {
                if (this.debug != null) {
                    this.debug.println("ForwardBuilder.PKIXCertComparator.compare() distanceStoI2 < distanceStoI1; RETURN 1");
                }
                return 1;
            }
            if (this.debug != null) {
                this.debug.println("ForwardBuilder.PKIXCertComparator.compare() no tests matched; RETURN 0");
            }
            return 0;
        }
    }
}

