/** 
 * Copyright (C) 1997-2002 the KGhostView authors. See file AUTHORS.
 * 	
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <qdir.h>

#include <kaboutdata.h>
#include <kapplication.h>
#include <kcmdlineargs.h>
#include <klocale.h>
#include <kurl.h>

#include "kgvshell.h"
#include "kgv_view.h"

static KCmdLineOptions options[] =
{
    { "+[URL]", I18N_NOOP( "Location to open" ), 0 },
    { 0,        0,                               0 }
};

int main( int argc, char** argv )
{
    KCmdLineArgs::init( argc, argv, KGVPart::createAboutData() );
    KCmdLineArgs::addCmdLineOptions( options );
    KApplication app;
    KCmdLineArgs* args = KCmdLineArgs::parsedArgs();

    if( kapp->isRestored() )
	RESTORE( KGVShell )
    else {
	KGVShell* shell = new KGVShell;
	if( args->count() == 1 ) {
	    if( QString( args->arg(0) ) == "-" )  
		shell->openStdin();
	    else {
		KURL url( QDir::currentDirPath() + "/", args->arg(0) );
		shell->openURL( url );
	    }
	}
	shell->show();
    }
    return app.exec();
}
