/***************************************************************************
                 cgeneratenewfile.cpp - 
                             -------------------                                         

    version              :                                   
    begin                : 1 Oct 1998                                        
    copyright            : (C) 1998 by Sandy Meier                         
    email                : smeier@rz.uni-potsdam.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <qfileinfo.h>
#include "cgeneratenewfile.h"
#include "cproject.h"
#include <kprocess.h>
#include <kdebug.h>

// added by Alex Kern, Alexander.Kern@saarsoft.de
//
#include <qdir.h>
#include <klocale.h>
#include <kstddirs.h>

//#include <iostream.h>
//using namespace std;

bool handleCreateSubDirectory(CProject* prj, QString& out_onlyname,
  QString& in_absname, QString& in_filename)
{
  if(in_filename == "")
    out_onlyname = QFileInfo(in_absname).fileName(); //cat from whole path	
  else
    out_onlyname = QFileInfo(in_filename).fileName(); //cat from extra value ??

  //if in_absname includes directory path
  QString dirname = QFileInfo(in_absname).dirPath(true);
  if(dirname.contains(prj->getProjectDir()) == 0 )
  {
    kdDebug() << "don't try to create a new subdir outside projectdirectory" << endl;	
    return false;
  }
  else //just mkdir
  {
    QDir dir;
    dir = (const char*)dirname;
    kdDebug() << "handleCreateSubDirectory() needs to create a directory " <<  dirname << endl;
    if(dir.exists() == false)
    {
      QString dir_to_make;
      dir_to_make = prj->getProjectDir() + prj->getSubDir(); //always exist, i hope ,-)
      int new_element;
      while	(dir_to_make != dirname)
      {
        new_element = dirname.find(dir.separator(), dir_to_make.length(), false);

        if(new_element == -1)
          dir_to_make = dirname; //last loop
        else
          dir_to_make = dirname.left(new_element+1);

        if(dir.exists((const char*)dir_to_make, true) == false)
        {
          if(dir.mkdir((const char*)dir_to_make, true))
          {
            kdDebug() << "handleCreateSubDirectory() has created directory " << dir_to_make << endl;
          }
          else
          {
            kdDebug() << "handleCreateSubDirectory() can't create directory " << dir_to_make << endl;
            return false;
          }
        }
        else
          kdDebug() << "handleCreateSubDirectory() directory " << dir_to_make << " already exists" << endl;
      }//next subdir	
    }
  }
  return true;	
}

CGenerateNewFile::CGenerateNewFile(){
}
CGenerateNewFile::~CGenerateNewFile(){
}
QString  CGenerateNewFile::genCPPFile(QString abs_name,CProject* prj, QString file_name){
  QString name;
// added by Alex Kern, Alexander.Kern@saarsoft.de
//
/*  if ( file_name=="") { name  = QFileInfo(abs_name).fileName(); }
   else { name  = QFileInfo(file_name).fileName(); }*/
  handleCreateSubDirectory(prj, name, abs_name, file_name);
  // local cpp_template
  QString cpp_header = prj->getProjectDir() + prj->getSubDir() +"/templates/cpp_template";
  if(!QFile::exists(cpp_header)){
    cpp_header = locate("appdata", "templates/cpp_template");
  }
/*
     not needed anymore - handled by CProject::setInfosInString()
  QString email = prj->getEmail();
  QString author = prj->getAuthor();
  QString version = prj->getVersion();
  QString date = QDate::currentDate().toString();
  QString year;
  year.setNum(QDate::currentDate().year());
*/
  QStrList list;
  QString str;
  
  QFile file(cpp_header);
  QTextStream stream(&file);
  if(file.open(IO_ReadOnly)){ // read the header_template
    while(!stream.eof()){
      list.append(stream.readLine());
    }
  }
  file.close();
  file.setName(abs_name);
  if(file.open(IO_WriteOnly)){
    for(str = list.first();str !=0;str = list.next()){
/*
     not needed anymore - handled by CProject::setInfosInString()
      str.replace(QRegExp("EMAIL"),email);
      str.replace(QRegExp("AUTHOR"),author);
      str.replace(QRegExp("VERSION"),version);
      str.replace(QRegExp("DATE"),date);
      str.replace(QRegExp("YEAR"),year);
      stream << str << "\n";
*/
      str.replace(QRegExp("\\|FILENAME\\|"),name);
      stream << prj->setInfosInString(str) << '\n';
    }
  }
  file.close();  
  return file.name();

}
QString  CGenerateNewFile::genHeaderFile(QString abs_name,CProject* prj, QString file_name){
  QString name;
// added by Alex Kern, Alexander.Kern@saarsoft.de
//
/*  if ( file_name=="") { name  = QFileInfo(abs_name).fileName(); }
   else { name  = QFileInfo(file_name).fileName(); }*/
  handleCreateSubDirectory(prj, name, abs_name, file_name);
  // local header_template
  QString template_header = prj->getProjectDir() + prj->getSubDir() +"/templates/header_template";
  if(!QFile::exists(template_header)){
    template_header = locate("appdata", "templates/header_template");
  }
/*
     not needed anymore - handled by CProject::setInfosInString()
  QString email = prj->getEmail();
  QString author = prj->getAuthor();
  QString version = prj->getVersion();
  QString date = QDate::currentDate().toString();
  QString year;
  year.setNum(QDate::currentDate().year());
*/
  QStrList list;
  QString str;
  
  QFile file(template_header);
  QTextStream stream(&file);
  if(file.open(IO_ReadOnly)){ // read the header_template
    while(!stream.eof()){
      list.append(stream.readLine());
    }
  }
  file.close();
  file.setName(abs_name);
  if(file.open(IO_WriteOnly)){
    for(str = list.first();str !=0;str = list.next()){
/*
     not needed anymore - handled by CProject::setInfosInString()
      str.replace(QRegExp("EMAIL"),email);
      str.replace(QRegExp("AUTHOR"),author);
      str.replace(QRegExp("VERSION"),version);
      str.replace(QRegExp("DATE"),date);
      str.replace(QRegExp("YEAR"),year);
      stream << str << "\n";
*/
      str.replace(QRegExp("\\|FILENAME\\|"),name);
      stream << prj->setInfosInString(str) << '\n';
    }
  }
  file.close();  
  return file.name();
}

QString  CGenerateNewFile::genLEXICALFile(QString abs_name,CProject* prj){
  QString name  = QFileInfo(abs_name).fileName();
  QString lexical_header = locate("appdata", "templates/lexical_template");

  QStrList list;
  QString str;
  
  QFile file(lexical_header);
  QTextStream stream(&file);
  if(file.open(IO_ReadOnly)){ // read the header_template
    while(!stream.eof()){
      list.append(stream.readLine());
    }
  }
  file.close();
  file.setName(abs_name);
  if(file.open(IO_WriteOnly)){
    for(str = list.first();str !=0;str = list.next()){
      str.replace(QRegExp("\\|FILENAME\\|"),name);
      stream << prj->setInfosInString(str) << '\n';
    }
  }
  file.close();  
  return file.name();
}

QString  CGenerateNewFile::genEngHandbook(QString abs_name,CProject* prj){
  
  QString template_handbook = locate("appdata", "templates/handbook_en_template");
/*
     not needed anymore - handled by CProject::setInfosInString()
  QString project_name = prj->getProjectName();
  QString email = prj->getEmail();
  QString author = prj->getAuthor();
  QString version = prj->getVersion();
  QString date = QDate::currentDate().toString();
*/
  QStrList list;
  QString str;

  QFile file(template_handbook);
  QTextStream stream(&file);
  if(file.open(IO_ReadOnly)){ // read the handbook_template
    while(!stream.eof()){
      list.append(stream.readLine());
    }
  }
  file.close();
  file.setName(abs_name);
  if(file.open(IO_WriteOnly)){
    for(str = list.first();str !=0;str = list.next()){
/*
     not needed anymore - handled by CProject::setInfosInString()
      str.replace(QRegExp("PROJECT_NAME"),project_name);
      str.replace(QRegExp("EMAIL"),email);
      str.replace(QRegExp("AUTHOR"),author);
      str.replace(QRegExp("VERSION"),version);
      str.replace(QRegExp("DATE"),date);
      stream << str << "\n";
*/
      stream << prj->setInfosInString(str) << '\n';
    }
  }
  file.close();  
  return file.name();
}

QString  CGenerateNewFile::genEngDocBook(QString abs_name,CProject* prj){

  QString template_handbook = locate("appdata", "templates/docbook_en_template");
  QStrList list;
  QString str;

  QFile file(template_handbook);
  QTextStream stream(&file);
  if(file.open(IO_ReadOnly)){ // read the handbook_template
    while(!stream.eof()){
      list.append(stream.readLine());
    }
  }
  file.close();
  file.setName(abs_name);
  if(file.open(IO_WriteOnly)){
    for(str = list.first();str !=0;str = list.next()){
      stream << prj->setInfosInString(str) << '\n';
    }
  }
  file.close();
  return file.name();
}

QString  CGenerateNewFile::genKDELnkFile(QString abs_name,CProject* prj){
  QString template_kdelnk = locate("appdata", "templates/kdelnk_template");
  QString project_name = prj->getProjectName().lower();
  QString str;
  QStrList list;
  
  QFile file(template_kdelnk);
  QTextStream stream(&file);
  if(file.open(IO_ReadOnly)){ // read the kdelnk_template
    while(!stream.eof()){
      list.append(stream.readLine());
    }
  }
  file.close();

  file.setName(abs_name);
  if(file.open(IO_WriteOnly)){
    for(str = list.first();str !=0;str = list.next()){
      str.replace(QRegExp("\\|PRJNAME\\|"),project_name);
      stream << str << "\n";
    }
  }
  file.close();  
  return file.name();
  
}

QString  CGenerateNewFile::genDEsktopFile(QString abs_name,CProject* prj){
  QString template_kdelnk = locate("appdata", "templates/desktop_template");
  QString project_name = prj->getProjectName().lower();
  QString str;
  QStrList list;
  
  QFile file(template_kdelnk);
  QTextStream stream(&file);
  if(file.open(IO_ReadOnly)){ // read the kdelnk_template
    while(!stream.eof()){
      list.append(stream.readLine());
    }
  }
  file.close();

  file.setName(abs_name);
  if(file.open(IO_WriteOnly)){
    for(str = list.first();str !=0;str = list.next()){
      str.replace(QRegExp("\\|PRJNAME\\|"),project_name);
      stream << str << "\n";
    }
  }
  file.close();  
  return file.name();
}

QString  CGenerateNewFile::genLSMFile(QString abs_name,CProject* prj){
  QString template_lsm = locate("appdata", "templates/lsm_template");
/*
     not needed anymore - handled by CProject::setInfosInString()
  QString project_name = prj->getProjectName();
  QString email = prj->getEmail();
  QString author = prj->getAuthor();
  QString version = prj->getVersion();
*/

  QStrList list;
  QString str;
  
  QFile file(template_lsm);
  QTextStream stream(&file);
  if(file.open(IO_ReadOnly)){ // read the lsm_template
    while(!stream.eof()){
      list.append(stream.readLine());
    }
  }
  file.close();
  file.setName(abs_name);
  if(file.open(IO_WriteOnly)){
    for(str = list.first();str !=0;str = list.next()){
/*
     not needed anymore - handled by CProject::setInfosInString()
      str.replace(QRegExp("PROJECT_NAME"),project_name);
      str.replace(QRegExp("EMAIL"),email);
      str.replace(QRegExp("AUTHOR"),author);
      str.replace(QRegExp("VERSION"),version);
      stream << str << "\n";
*/
      stream << prj->setInfosInString(str) << '\n';
    }
  }
  file.close();  
  return file.name();
}

QString CGenerateNewFile::genIcon(QString abs_name){
  QStrList list;
  QString str;
  QString icon_template = locate("appdata", "templates/icon_template");
  QFile file(icon_template);
  QTextStream stream(&file);

  if(file.open(IO_ReadOnly)){ // read the handbook_template
    while(!stream.eof()){
      list.append(stream.readLine());
    }
  }
  file.close();
  file.setName(abs_name);
  if(file.open(IO_WriteOnly)){
    for(str = list.first();str !=0;str = list.next()){
      stream << str << "\n";
    }
  }
  file.close();  
  return file.name();
}

void CGenerateNewFile::genNifFile(QString abs_name){
  KShellProcess process;
  QString nif_template = locate("appdata", "templates/nif_template");

  process.clearArguments();
  process << "cp"; // copy is your friend :-)
  process << nif_template;
  process << abs_name;
  process.start(KProcess::Block,KProcess::AllOutput); // blocked because it is important
}
