.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided ``as is'' without express or implied warranty.
.\" 
.\" $XFree86: xc/doc/man/X11/XStColors.man,v 1.2 2001/01/27 18:20:05 dawes Exp $
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.na
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft 1
.\".ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.de FD
.LP
.KS
.TA .5i 3i
.ta .5i 3i
.nf
..
.de FN
.fi
.KE
.LP
..
.de IN		\" send an index entry to the stderr
..
.de C{
.KS
.nf
.D
.\"
.\"	choose appropriate monospace font
.\"	the imagen conditional, 480,
.\"	may be changed to L if LB is too
.\"	heavy for your eyes...
.\"
.ie "\\*(.T"480" .ft L
.el .ie "\\*(.T"300" .ft L
.el .ie "\\*(.T"202" .ft PO
.el .ie "\\*(.T"aps" .ft CW
.el .ft R
.ps \\n(PS
.ie \\n(VS>40 .vs \\n(VSu
.el .vs \\n(VSp
..
.de C}
.DE
.R
..
.de Pn
.ie t \\$1\fB\^\\$2\^\fR\\$3
.el \\$1\fI\^\\$2\^\fP\\$3
..
.de ZN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.de hN
.ie t <\fB\\$1\fR>\\$2
.el <\fI\\$1\fP>\\$2
..
.de NT
.ne 7
.ds NO Note
.if \\n(.$>$1 .if !'\\$2'C' .ds NO \\$2
.if \\n(.$ .if !'\\$1'C' .ds NO \\$1
.ie n .sp
.el .sp 10p
.TB
.ce
\\*(NO
.ie n .sp
.el .sp 5p
.if '\\$1'C' .ce 99
.if '\\$2'C' .ce 99
.in +5n
.ll -5n
.R
..
.		\" Note End -- doug kraft 3/85
.de NE
.ce 0
.in -5n
.ll +5n
.ie n .sp
.el .sp 10p
..
.ny0
.TH XStoreColors 3X11 __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XStoreColors, XStoreColor, XStoreNamedColor \- set colors
.SH SYNTAX
XStoreColors\^(\^\fIdisplay\fP, \fIcolormap\fP\^, \fIcolor\fP\^, \fIncolors\fP\^)
.br
      Display *\fIdisplay\fP\^;
.br
      Colormap \fIcolormap\fP\^;
.br
      XColor \fIcolor\fP\^[\^]\^;
.br
      int \fIncolors\fP\^;
.LP
XStoreColor\^(\^\fIdisplay\fP, \fIcolormap\fP\^, \fIcolor\fP\^)
.br
      Display *\fIdisplay\fP\^;
.br
      Colormap \fIcolormap\fP\^;
.br
      XColor *\fIcolor\fP\^;
.LP
XStoreNamedColor\^(\^\fIdisplay\fP, \fIcolormap\fP\^, \fIcolor\fP\^, \fIpixel\fP\^, \fIflags\fP\^)
.br
      Display *\fIdisplay\fP\^;
.br
      Colormap \fIcolormap\fP\^;
.br
      char *\^\fIcolor\fP\^;
.br
      unsigned long \fIpixel\fP\^;
.br
      int \fIflags\fP\^;
.SH ARGUMENTS
.ds Co pixel and RGB values or the color name string (for example, red)
.IP \fIcolor\fP 1i
Specifies the \*(Co.
.IP \fIcolor\fP 1i
Specifies an array of color definition structures to be stored.
.IP \fIcolormap\fP 1i
Specifies the colormap.
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fIflags\fP 1i
Specifies which red, green, and blue components are set.
.IP \fIncolors\fP 1i
.\"Specifies the number of color definition structures. 
Specifies the number of 
.ZN XColor
structures in the color definition array.
.IP \fIpixel\fP 1i
Specifies the entry in the colormap. 
.SH DESCRIPTION
The
.ZN XStoreColors
function changes the colormap entries of the pixel values
specified in the pixel members of the
.ZN XColor
structures.
You specify which color components are to be changed by setting 
.ZN DoRed ,
.ZN DoGreen ,
and/or
.ZN DoBlue
in the flags member of the
.ZN XColor
structures.
If the colormap is an installed map for its screen, the
changes are visible immediately.
.ZN XStoreColors 
changes the specified pixels if they are allocated writable in the colormap 
by any client, even if one or more pixels generates an error.
If a specified pixel is not a valid index into the colormap, a
.ZN BadValue
error results.
If a specified pixel either is unallocated or is allocated read-only, a
.ZN BadAccess
error results.
If more than one pixel is in error, 
the one that gets reported is arbitrary.
.LP
.ZN XStoreColors
can generate
.ZN BadAccess ,
.ZN BadColor ,
and
.ZN BadValue 
errors.
.LP
The
.ZN XStoreColor
function changes the colormap entry of the pixel value specified in the
pixel member of the
.ZN XColor
structure.
You specified this value in the
pixel member of the
.ZN XColor
structure.
This pixel value must be a read/write cell and a valid index into the colormap.
If a specified pixel is not a valid index into the colormap,
a
.ZN BadValue
error results.
.ZN XStoreColor
also changes the red, green, and/or blue color components.
You specify which color components are to be changed by setting
.ZN DoRed ,
.ZN DoGreen ,
and/or
.ZN DoBlue
in the flags member of the
.ZN XColor
structure.
If the colormap is an installed map for its screen, 
the changes are visible immediately.
.LP
.ZN XStoreColor
can generate
.ZN BadAccess ,
.ZN BadColor ,
and 
.ZN BadValue 
errors.
.LP
The
.ZN XStoreNamedColor
function looks up the named color with respect to the screen associated with
the colormap and stores the result in the specified colormap.
The pixel argument determines the entry in the colormap.
The flags argument determines which of the red, green, and blue components 
are set. 
You can set this member to the
bitwise inclusive OR of the bits 
.ZN DoRed , 
.ZN DoGreen , 
and 
.ZN DoBlue .
If the color name is not in the Host Portable Character Encoding, 
the result is implementation-dependent.
Use of uppercase or lowercase does not matter.
If the specified pixel is not a valid index into the colormap, a
.ZN BadValue
error results.
If the specified pixel either is unallocated or is allocated read-only, a
.ZN BadAccess
error results.
.LP
.ZN XStoreNamedColor
can generate
.ZN BadAccess ,
.ZN BadColor ,
.ZN BadName ,
and
.ZN BadValue 
errors.
.SH DIAGNOSTICS
.TP 1i
.ZN BadAccess
A client attempted
to free a color map entry that it did not already allocate.
.TP 1i
.ZN BadAccess
A client attempted
to store into a read-only color map entry.
.TP 1i
.ZN BadColor
A value for a Colormap argument does not name a defined Colormap.
.TP 1i
.ZN BadName
A font or color of the specified name does not exist.
.TP 1i
.ZN BadValue
Some numeric value falls outside the range of values accepted by the request.
Unless a specific range is specified for an argument, the full range defined
by the argument's type is accepted.  Any argument defined as a set of
alternatives can generate this error.
.SH "SEE ALSO"
XAllocColor(3X11),
XCreateColormap(3X11),
XQueryColor(3X11)
.br
\fI\*(xL\fP
