/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.png;

import com.sun.imageio.plugins.png.PNGImageWriter;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.SampleModel;
import java.util.Locale;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.spi.ImageWriterSpi;

public class PNGImageWriterSpi
extends ImageWriterSpi {
    private static final String vendorName = "Sun Microsystems, Inc.";
    private static final String version = "1.0";
    private static final String[] names = new String[]{"png", "PNG"};
    private static final String[] suffixes = new String[]{"png", "PNG"};
    private static final String[] MIMETypes = new String[]{"image/png", "image/x-png"};
    private static final String writerClassName = "com.sun.imageio.plugins.png.PNGImageWriter";
    private static final String[] readerSpiNames = new String[]{"com.sun.imageio.plugins.png.PNGImageReaderSpi"};

    public PNGImageWriterSpi() {
        super(vendorName, version, names, suffixes, MIMETypes, writerClassName, ImageWriterSpi.STANDARD_OUTPUT_TYPE, readerSpiNames, false, null, null, null, null, true, "javax_imageio_png_1.0", "com.sun.imageio.plugins.png.PNGMetadataFormat", null, null);
    }

    public boolean canEncodeImage(ImageTypeSpecifier imageTypeSpecifier) {
        SampleModel sampleModel = imageTypeSpecifier.getSampleModel();
        ColorModel colorModel = imageTypeSpecifier.getColorModel();
        int[] nArray = sampleModel.getSampleSize();
        int n2 = nArray[0];
        int n3 = 1;
        while (n3 < nArray.length) {
            if (nArray[n3] > n2) {
                n2 = nArray[n3];
            }
            ++n3;
        }
        if (n2 < 1 || n2 > 16) {
            return false;
        }
        int n4 = sampleModel.getNumBands();
        if (n4 < 1 || n4 > 4) {
            return false;
        }
        boolean bl2 = colorModel.hasAlpha();
        if (colorModel instanceof IndexColorModel) {
            return true;
        }
        if ((n4 == 1 || n4 == 3) && bl2) {
            return false;
        }
        return n4 != 2 && n4 != 4 || bl2;
    }

    public String getDescription(Locale locale) {
        return "Standard PNG image writer";
    }

    public ImageWriter createWriterInstance(Object object) {
        return new PNGImageWriter(this);
    }
}

