/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;

public class PipedOutputStream
extends OutputStream {
    private PipedInputStream sink;

    public PipedOutputStream(PipedInputStream pipedInputStream) throws IOException {
        this.connect(pipedInputStream);
    }

    public PipedOutputStream() {
    }

    public synchronized void connect(PipedInputStream pipedInputStream) throws IOException {
        if (pipedInputStream == null) {
            throw new NullPointerException();
        }
        if (this.sink != null || pipedInputStream.connected) {
            throw new IOException("Already connected");
        }
        this.sink = pipedInputStream;
        pipedInputStream.in = -1;
        pipedInputStream.out = 0;
        pipedInputStream.connected = true;
    }

    public void write(int n2) throws IOException {
        if (this.sink == null) {
            throw new IOException("Pipe not connected");
        }
        this.sink.receive(n2);
    }

    public void write(byte[] byArray, int n2, int n3) throws IOException {
        if (this.sink == null) {
            throw new IOException("Pipe not connected");
        }
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n2 < 0 || n2 > byArray.length || n3 < 0 || n2 + n3 > byArray.length || n2 + n3 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 == 0) {
            return;
        }
        this.sink.receive(byArray, n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void flush() throws IOException {
        if (this.sink != null) {
            PipedInputStream pipedInputStream = this.sink;
            synchronized (pipedInputStream) {
                this.sink.notifyAll();
            }
        }
    }

    public void close() throws IOException {
        if (this.sink != null) {
            this.sink.receivedLast();
        }
    }
}

