/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ContentHandler;
import java.net.ContentHandlerFactory;
import java.net.FileNameMap;
import java.net.URL;
import java.net.UnknownContentHandler;
import java.net.UnknownServiceException;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.Permission;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import sun.net.www.MimeTable;
import sun.security.action.GetPropertyAction;

public abstract class URLConnection {
    protected URL url;
    protected boolean doInput = true;
    protected boolean doOutput = false;
    private static boolean defaultAllowUserInteraction = false;
    protected boolean allowUserInteraction = defaultAllowUserInteraction;
    private static boolean defaultUseCaches = true;
    protected boolean useCaches = defaultUseCaches;
    protected long ifModifiedSince = 0L;
    protected boolean connected = false;
    private static FileNameMap fileNameMap;
    private static boolean fileNameMapLoaded;
    static ContentHandlerFactory factory;
    private static Hashtable handlers;
    private static final ContentHandler UnknownContentHandlerP;
    private static final String contentClassPrefix = "sun.net.www.content";
    private static final String contentPathProp = "java.content.handler.pkgs";

    public static synchronized FileNameMap getFileNameMap() {
        if (fileNameMap == null && !fileNameMapLoaded) {
            fileNameMap = MimeTable.loadTable();
            fileNameMapLoaded = true;
        }
        return new FileNameMap(){
            private FileNameMap map = URLConnection.access$000();

            public String getContentTypeFor(String string) {
                return this.map.getContentTypeFor(string);
            }
        };
    }

    public static void setFileNameMap(FileNameMap fileNameMap) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSetFactory();
        }
        URLConnection.fileNameMap = fileNameMap;
    }

    public abstract void connect() throws IOException;

    protected URLConnection(URL uRL) {
        this.url = uRL;
    }

    public URL getURL() {
        return this.url;
    }

    public int getContentLength() {
        return this.getHeaderFieldInt("content-length", -1);
    }

    public String getContentType() {
        return this.getHeaderField("content-type");
    }

    public String getContentEncoding() {
        return this.getHeaderField("content-encoding");
    }

    public long getExpiration() {
        return this.getHeaderFieldDate("expires", 0L);
    }

    public long getDate() {
        return this.getHeaderFieldDate("date", 0L);
    }

    public long getLastModified() {
        return this.getHeaderFieldDate("last-modified", 0L);
    }

    public String getHeaderField(String string) {
        return null;
    }

    public Map getHeaderFields() {
        return Collections.EMPTY_MAP;
    }

    public int getHeaderFieldInt(String string, int n2) {
        String string2 = this.getHeaderField(string);
        try {
            return Integer.parseInt(string2);
        }
        catch (Exception exception) {
            return n2;
        }
    }

    public long getHeaderFieldDate(String string, long l2) {
        String string2 = this.getHeaderField(string);
        try {
            return Date.parse(string2);
        }
        catch (Exception exception) {
            return l2;
        }
    }

    public String getHeaderFieldKey(int n2) {
        return null;
    }

    public String getHeaderField(int n2) {
        return null;
    }

    public Object getContent() throws IOException {
        this.getInputStream();
        return this.getContentHandler().getContent(this);
    }

    public Object getContent(Class[] classArray) throws IOException {
        this.getInputStream();
        return this.getContentHandler().getContent(this, classArray);
    }

    public Permission getPermission() throws IOException {
        return new AllPermission();
    }

    public InputStream getInputStream() throws IOException {
        throw new UnknownServiceException("protocol doesn't support input");
    }

    public OutputStream getOutputStream() throws IOException {
        throw new UnknownServiceException("protocol doesn't support output");
    }

    public String toString() {
        return this.getClass().getName() + ":" + this.url;
    }

    public void setDoInput(boolean bl2) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        this.doInput = bl2;
    }

    public boolean getDoInput() {
        return this.doInput;
    }

    public void setDoOutput(boolean bl2) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        this.doOutput = bl2;
    }

    public boolean getDoOutput() {
        return this.doOutput;
    }

    public void setAllowUserInteraction(boolean bl2) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        this.allowUserInteraction = bl2;
    }

    public boolean getAllowUserInteraction() {
        return this.allowUserInteraction;
    }

    public static void setDefaultAllowUserInteraction(boolean bl2) {
        defaultAllowUserInteraction = bl2;
    }

    public static boolean getDefaultAllowUserInteraction() {
        return defaultAllowUserInteraction;
    }

    public void setUseCaches(boolean bl2) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        this.useCaches = bl2;
    }

    public boolean getUseCaches() {
        return this.useCaches;
    }

    public void setIfModifiedSince(long l2) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        this.ifModifiedSince = l2;
    }

    public long getIfModifiedSince() {
        return this.ifModifiedSince;
    }

    public boolean getDefaultUseCaches() {
        return defaultUseCaches;
    }

    public void setDefaultUseCaches(boolean bl2) {
        defaultUseCaches = bl2;
    }

    public void setRequestProperty(String string, String string2) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        if (string == null) {
            throw new NullPointerException("key is null");
        }
    }

    public void addRequestProperty(String string, String string2) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        if (string == null) {
            throw new NullPointerException("key is null");
        }
    }

    public String getRequestProperty(String string) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        return null;
    }

    public Map getRequestProperties() {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        return Collections.EMPTY_MAP;
    }

    public static void setDefaultRequestProperty(String string, String string2) {
    }

    public static String getDefaultRequestProperty(String string) {
        return null;
    }

    public static synchronized void setContentHandlerFactory(ContentHandlerFactory contentHandlerFactory) {
        if (factory != null) {
            throw new Error("factory already defined");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSetFactory();
        }
        factory = contentHandlerFactory;
    }

    synchronized ContentHandler getContentHandler() throws UnknownServiceException {
        String string = this.stripOffParameters(this.getContentType());
        ContentHandler contentHandler = null;
        if (string == null) {
            throw new UnknownServiceException("no content-type");
        }
        try {
            contentHandler = (ContentHandler)handlers.get(string);
            if (contentHandler != null) {
                return contentHandler;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (factory != null) {
            contentHandler = factory.createContentHandler(string);
        }
        if (contentHandler == null) {
            try {
                contentHandler = this.lookupContentHandlerClassFor(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                contentHandler = UnknownContentHandlerP;
            }
            handlers.put(string, contentHandler);
        }
        return contentHandler;
    }

    private String stripOffParameters(String string) {
        if (string == null) {
            return null;
        }
        int n2 = string.indexOf(59);
        if (n2 > 0) {
            return string.substring(0, n2);
        }
        return string;
    }

    private ContentHandler lookupContentHandlerClassFor(String string) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        String string2 = this.typeToPackageName(string);
        String string3 = this.getContentHandlerPkgPrefixes();
        StringTokenizer stringTokenizer = new StringTokenizer(string3, "|");
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken().trim();
            try {
                Class clazz;
                block5: {
                    String string5 = string4 + "." + string2;
                    clazz = null;
                    try {
                        clazz = Class.forName(string5);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                        if (classLoader == null) break block5;
                        clazz = classLoader.loadClass(string5);
                    }
                }
                if (clazz == null) continue;
                ContentHandler contentHandler = (ContentHandler)clazz.newInstance();
                return contentHandler;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return UnknownContentHandlerP;
    }

    private String typeToPackageName(String string) {
        string = string.toLowerCase();
        int n2 = string.length();
        char[] cArray = new char[n2];
        string.getChars(0, n2, cArray, 0);
        int n3 = 0;
        while (n3 < n2) {
            char c2 = cArray[n3];
            if (c2 == '/') {
                cArray[n3] = 46;
            } else if (!('A' <= c2 && c2 <= 'Z' || 'a' <= c2 && c2 <= 'z' || '0' <= c2 && c2 <= '9')) {
                cArray[n3] = 95;
            }
            ++n3;
        }
        return new String(cArray);
    }

    private String getContentHandlerPkgPrefixes() {
        String string = (String)AccessController.doPrivileged(new GetPropertyAction(contentPathProp, ""));
        if (string != "") {
            string = string + "|";
        }
        return string + contentClassPrefix;
    }

    public static String guessContentTypeFromName(String string) {
        return URLConnection.getFileNameMap().getContentTypeFor(string);
    }

    public static String guessContentTypeFromStream(InputStream inputStream) throws IOException {
        if (!inputStream.markSupported()) {
            return null;
        }
        inputStream.mark(12);
        int n2 = inputStream.read();
        int n3 = inputStream.read();
        int n4 = inputStream.read();
        int n5 = inputStream.read();
        int n6 = inputStream.read();
        int n7 = inputStream.read();
        int n8 = inputStream.read();
        int n9 = inputStream.read();
        int n10 = inputStream.read();
        int n11 = inputStream.read();
        int n12 = inputStream.read();
        inputStream.reset();
        if (n2 == 202 && n3 == 254 && n4 == 186 && n5 == 190) {
            return "application/java-vm";
        }
        if (n2 == 172 && n3 == 237) {
            return "application/x-java-serialized-object";
        }
        if (n2 == 60) {
            if (n3 == 33 || n3 == 104 && (n4 == 116 && n5 == 109 && n6 == 108 || n4 == 101 && n5 == 97 && n6 == 100) || n3 == 98 && n4 == 111 && n5 == 100 && n6 == 121 || n3 == 72 && (n4 == 84 && n5 == 77 && n6 == 76 || n4 == 69 && n5 == 65 && n6 == 68) || n3 == 66 && n4 == 79 && n5 == 68 && n6 == 89) {
                return "text/html";
            }
            if (n3 == 63 && n4 == 120 && n5 == 109 && n6 == 108 && n7 == 32) {
                return "application/xml";
            }
        }
        if (n2 == 254 && n3 == 255 && n4 == 0 && n5 == 60 && n6 == 0 && n7 == 63 && n8 == 0 && n9 == 120) {
            return "application/xml";
        }
        if (n2 == 255 && n3 == 254 && n4 == 60 && n5 == 0 && n6 == 63 && n7 == 0 && n8 == 120 && n9 == 0) {
            return "application/xml";
        }
        if (n2 == 71 && n3 == 73 && n4 == 70 && n5 == 56) {
            return "image/gif";
        }
        if (n2 == 35 && n3 == 100 && n4 == 101 && n5 == 102) {
            return "image/x-bitmap";
        }
        if (n2 == 33 && n3 == 32 && n4 == 88 && n5 == 80 && n6 == 77 && n7 == 50) {
            return "image/x-pixmap";
        }
        if (n2 == 137 && n3 == 80 && n4 == 78 && n5 == 71 && n6 == 13 && n7 == 10 && n8 == 26 && n9 == 10) {
            return "image/png";
        }
        if (n2 == 255 && n3 == 216 && n4 == 255) {
            if (n5 == 224) {
                return "image/jpeg";
            }
            if (n5 == 225 && n8 == 69 && n9 == 120 && n10 == 105 && n11 == 102 && n12 == 0) {
                return "image/jpeg";
            }
            if (n5 == 238) {
                return "image/jpg";
            }
        }
        if (n2 == 208 && n3 == 207 && n4 == 17 && n5 == 224 && n6 == 161 && n7 == 177 && n8 == 26 && n9 == 225 && URLConnection.checkfpx(inputStream)) {
            return "image/vnd.fpx";
        }
        if (n2 == 46 && n3 == 115 && n4 == 110 && n5 == 100) {
            return "audio/basic";
        }
        if (n2 == 100 && n3 == 110 && n4 == 115 && n5 == 46) {
            return "audio/basic";
        }
        if (n2 == 82 && n3 == 73 && n4 == 70 && n5 == 70) {
            return "audio/x-wav";
        }
        return null;
    }

    private static boolean checkfpx(InputStream inputStream) throws IOException {
        int n2;
        int n3;
        inputStream.mark(256);
        long l2 = 28L;
        long l3 = 0L;
        while (l3 != l2) {
            l3 += inputStream.skip(l2 - l3);
        }
        long l4 = l3;
        int n4 = inputStream.read();
        inputStream.read();
        l4 += 2L;
        if (n4 == 254) {
            n3 = inputStream.read();
            n3 += inputStream.read() << 8;
        } else {
            n3 = inputStream.read() << 8;
            n3 += inputStream.read();
        }
        l2 = 48L - (l4 += 2L);
        l3 = 0L;
        while (l3 != l2) {
            l3 += inputStream.skip(l2 - l3);
        }
        l4 += l3;
        if (n4 == 254) {
            n2 = inputStream.read();
            n2 += inputStream.read() << 8;
            n2 += inputStream.read() << 16;
            n2 += inputStream.read() << 24;
        } else {
            n2 = inputStream.read() << 24;
            n2 += inputStream.read() << 16;
            n2 += inputStream.read() << 8;
            n2 += inputStream.read();
        }
        l4 += 4L;
        inputStream.reset();
        l2 = 512L + (long)(1 << n3) * (long)n2 + 80L;
        if (l2 < 0L) {
            return false;
        }
        inputStream.mark((int)l2 + 48);
        l3 = 0L;
        while (l3 != l2) {
            l3 += inputStream.skip(l2 - l3);
        }
        int[] nArray = new int[16];
        int n5 = 0;
        while (n5 < 16) {
            nArray[n5] = inputStream.read();
            ++n5;
        }
        if (n4 == 254 && nArray[0] == 0 && nArray[2] == 97 && nArray[3] == 86 && nArray[4] == 84 && nArray[5] == 193 && nArray[6] == 206 && nArray[7] == 17 && nArray[8] == 133 && nArray[9] == 83 && nArray[10] == 0 && nArray[11] == 170 && nArray[12] == 0 && nArray[13] == 161 && nArray[14] == 249 && nArray[15] == 91) {
            inputStream.reset();
            return true;
        }
        if (nArray[3] == 0 && nArray[1] == 97 && nArray[0] == 86 && nArray[5] == 84 && nArray[4] == 193 && nArray[7] == 206 && nArray[6] == 17 && nArray[8] == 133 && nArray[9] == 83 && nArray[10] == 0 && nArray[11] == 170 && nArray[12] == 0 && nArray[13] == 161 && nArray[14] == 249 && nArray[15] == 91) {
            inputStream.reset();
            return true;
        }
        inputStream.reset();
        return false;
    }

    static /* synthetic */ FileNameMap access$000() {
        return fileNameMap;
    }

    static {
        fileNameMapLoaded = false;
        handlers = new Hashtable();
        UnknownContentHandlerP = new UnknownContentHandler();
    }
}

