/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Checksum;

public class CheckedInputStream
extends FilterInputStream {
    private Checksum cksum;

    public CheckedInputStream(InputStream inputStream, Checksum checksum) {
        super(inputStream);
        this.cksum = checksum;
    }

    public int read() throws IOException {
        int n2 = this.in.read();
        if (n2 != -1) {
            this.cksum.update(n2);
        }
        return n2;
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if ((n3 = this.in.read(byArray, n2, n3)) != -1) {
            this.cksum.update(byArray, n2, n3);
        }
        return n3;
    }

    public long skip(long l2) throws IOException {
        byte[] byArray = new byte[512];
        long l3 = 0L;
        while (l3 < l2) {
            long l4 = l2 - l3;
            l4 = this.read(byArray, 0, l4 < (long)byArray.length ? (int)l4 : byArray.length);
            if (l4 == -1L) {
                return l3;
            }
            l3 += l4;
        }
        return l3;
    }

    public Checksum getChecksum() {
        return this.cksum;
    }
}

