/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.text.BreakIterator;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleExtendedComponent;
import javax.accessibility.AccessibleIcon;
import javax.accessibility.AccessibleKeyBinding;
import javax.accessibility.AccessibleRelation;
import javax.accessibility.AccessibleRelationSet;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleText;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.LabelUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;

public class JLabel
extends JComponent
implements SwingConstants,
Accessible {
    private static final String uiClassID = "LabelUI";
    private int mnemonic = 0;
    private int mnemonicIndex = -1;
    private String text = "";
    private Icon defaultIcon = null;
    private Icon disabledIcon = null;
    private boolean disabledIconSet = false;
    private int verticalAlignment = 0;
    private int horizontalAlignment = 10;
    private int verticalTextPosition = 0;
    private int horizontalTextPosition = 11;
    private int iconTextGap = 4;
    protected Component labelFor = null;
    private AccessibleIcon accessibleIcon = null;
    static final String LABELED_BY_PROPERTY = "labeledBy";

    public JLabel(String string, Icon icon, int n2) {
        this.setText(string);
        this.setIcon(icon);
        this.setHorizontalAlignment(n2);
        this.updateUI();
        this.setAlignmentX(0.0f);
    }

    public JLabel(String string, int n2) {
        this(string, null, n2);
    }

    public JLabel(String string) {
        this(string, null, 10);
    }

    public JLabel(Icon icon, int n2) {
        this(null, icon, n2);
    }

    public JLabel(Icon icon) {
        this(null, icon, 0);
    }

    public JLabel() {
        this("", null, 10);
    }

    public LabelUI getUI() {
        return (LabelUI)this.ui;
    }

    public void setUI(LabelUI labelUI) {
        super.setUI(labelUI);
    }

    public void updateUI() {
        this.setUI((LabelUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        String string2 = null;
        if (this.accessibleContext != null) {
            string2 = this.accessibleContext.getAccessibleName();
        }
        String string3 = this.text;
        this.text = string;
        this.firePropertyChange("text", string3, string);
        this.setDisplayedMnemonicIndex(SwingUtilities.findDisplayedMnemonicIndex(string, this.getDisplayedMnemonic()));
        if (this.accessibleContext != null && this.accessibleContext.getAccessibleName() != string2) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", string2, this.accessibleContext.getAccessibleName());
        }
        if (string == null || string3 == null || !string.equals(string3)) {
            this.revalidate();
            this.repaint();
        }
    }

    public Icon getIcon() {
        return this.defaultIcon;
    }

    public void setIcon(Icon icon) {
        AccessibleContext accessibleContext;
        Icon icon2 = this.defaultIcon;
        this.defaultIcon = icon;
        if (this.defaultIcon != icon2 && !this.disabledIconSet) {
            this.disabledIcon = null;
        }
        this.firePropertyChange("icon", icon2, this.defaultIcon);
        if (this.accessibleContext != null && icon2 != this.defaultIcon) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", icon2, this.defaultIcon);
        }
        if (this.defaultIcon != icon2) {
            if (this.defaultIcon == null || icon2 == null || this.defaultIcon.getIconWidth() != icon2.getIconWidth() || this.defaultIcon.getIconHeight() != icon2.getIconHeight()) {
                this.revalidate();
            }
            this.repaint();
        }
        this.accessibleIcon = null;
        if (this.defaultIcon instanceof Accessible && (accessibleContext = ((Accessible)((Object)this.defaultIcon)).getAccessibleContext()) != null && accessibleContext instanceof AccessibleIcon) {
            this.accessibleIcon = (AccessibleIcon)((Object)accessibleContext);
        }
    }

    public Icon getDisabledIcon() {
        if (!this.disabledIconSet && this.disabledIcon == null && this.defaultIcon != null && this.defaultIcon instanceof ImageIcon) {
            Image image = GrayFilter.createDisabledImage(((ImageIcon)this.defaultIcon).getImage());
            this.disabledIcon = new ImageIcon(image);
            this.firePropertyChange("disabledIcon", null, this.disabledIcon);
        }
        return this.disabledIcon;
    }

    public void setDisabledIcon(Icon icon) {
        Icon icon2 = this.disabledIcon;
        this.disabledIcon = icon;
        this.disabledIconSet = icon != null;
        this.firePropertyChange("disabledIcon", icon2, icon);
        if (icon != icon2) {
            if (icon == null || icon2 == null || icon.getIconWidth() != icon2.getIconWidth() || icon.getIconHeight() != icon2.getIconHeight()) {
                this.revalidate();
            }
            if (!this.isEnabled()) {
                this.repaint();
            }
        }
    }

    public void setDisplayedMnemonic(int n2) {
        int n3 = this.mnemonic;
        this.mnemonic = n2;
        this.firePropertyChange("displayedMnemonic", n3, this.mnemonic);
        this.setDisplayedMnemonicIndex(SwingUtilities.findDisplayedMnemonicIndex(this.getText(), this.mnemonic));
        if (n2 != n3) {
            this.revalidate();
            this.repaint();
        }
    }

    public void setDisplayedMnemonic(char n2) {
        int n3 = n2;
        if (n3 >= 97 && n3 <= 122) {
            n3 -= 32;
        }
        this.setDisplayedMnemonic(n3);
    }

    public int getDisplayedMnemonic() {
        return this.mnemonic;
    }

    public void setDisplayedMnemonicIndex(int n2) throws IllegalArgumentException {
        int n3 = this.mnemonicIndex;
        if (n2 == -1) {
            this.mnemonicIndex = -1;
        } else {
            int n4;
            String string = this.getText();
            int n5 = n4 = string == null ? 0 : string.length();
            if (n2 < -1 || n2 >= n4) {
                throw new IllegalArgumentException("index == " + n2);
            }
        }
        this.mnemonicIndex = n2;
        this.firePropertyChange("displayedMnemonicIndex", n3, n2);
        if (n2 != n3) {
            this.revalidate();
            this.repaint();
        }
    }

    public int getDisplayedMnemonicIndex() {
        return this.mnemonicIndex;
    }

    protected int checkHorizontalKey(int n2, String string) {
        if (n2 == 2 || n2 == 0 || n2 == 4 || n2 == 10 || n2 == 11) {
            return n2;
        }
        throw new IllegalArgumentException(string);
    }

    protected int checkVerticalKey(int n2, String string) {
        if (n2 == 1 || n2 == 0 || n2 == 3) {
            return n2;
        }
        throw new IllegalArgumentException(string);
    }

    public int getIconTextGap() {
        return this.iconTextGap;
    }

    public void setIconTextGap(int n2) {
        int n3 = this.iconTextGap;
        this.iconTextGap = n2;
        this.firePropertyChange("iconTextGap", n3, n2);
        if (n2 != n3) {
            this.revalidate();
            this.repaint();
        }
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(int n2) {
        if (n2 == this.verticalAlignment) {
            return;
        }
        int n3 = this.verticalAlignment;
        this.verticalAlignment = this.checkVerticalKey(n2, "verticalAlignment");
        this.firePropertyChange("verticalAlignment", n3, this.verticalAlignment);
        this.repaint();
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(int n2) {
        if (n2 == this.horizontalAlignment) {
            return;
        }
        int n3 = this.horizontalAlignment;
        this.horizontalAlignment = this.checkHorizontalKey(n2, "horizontalAlignment");
        this.firePropertyChange("horizontalAlignment", n3, this.horizontalAlignment);
        this.repaint();
    }

    public int getVerticalTextPosition() {
        return this.verticalTextPosition;
    }

    public void setVerticalTextPosition(int n2) {
        if (n2 == this.verticalTextPosition) {
            return;
        }
        int n3 = this.verticalTextPosition;
        this.verticalTextPosition = this.checkVerticalKey(n2, "verticalTextPosition");
        this.firePropertyChange("verticalTextPosition", n3, this.verticalTextPosition);
        this.repaint();
    }

    public int getHorizontalTextPosition() {
        return this.horizontalTextPosition;
    }

    public void setHorizontalTextPosition(int n2) {
        int n3 = this.horizontalTextPosition;
        this.horizontalTextPosition = this.checkHorizontalKey(n2, "horizontalTextPosition");
        this.firePropertyChange("horizontalTextPosition", n3, this.horizontalTextPosition);
        this.repaint();
    }

    public boolean imageUpdate(Image image, int n2, int n3, int n4, int n5, int n6) {
        if (!this.isShowing() || !SwingUtilities.doesIconReferenceImage(this.getIcon(), image) && !SwingUtilities.doesIconReferenceImage(this.disabledIcon, image)) {
            return false;
        }
        return super.imageUpdate(image, n2, n3, n4, n5, n6);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.getUIClassID().equals(uiClassID)) {
            byte by = JComponent.getWriteObjCounter(this);
            by = (byte)(by - 1);
            JComponent.setWriteObjCounter(this, by);
            if (by == 0 && this.ui != null) {
                this.ui.installUI(this);
            }
        }
    }

    protected String paramString() {
        String string;
        String string2 = this.text != null ? this.text : "";
        String string3 = this.defaultIcon != null && this.defaultIcon != this ? this.defaultIcon.toString() : "";
        String string4 = this.disabledIcon != null && this.disabledIcon != this ? this.disabledIcon.toString() : "";
        String string5 = string = this.labelFor != null ? this.labelFor.toString() : "";
        String string6 = this.verticalAlignment == 1 ? "TOP" : (this.verticalAlignment == 0 ? "CENTER" : (this.verticalAlignment == 3 ? "BOTTOM" : ""));
        String string7 = this.horizontalAlignment == 2 ? "LEFT" : (this.horizontalAlignment == 0 ? "CENTER" : (this.horizontalAlignment == 4 ? "RIGHT" : (this.horizontalAlignment == 10 ? "LEADING" : (this.horizontalAlignment == 11 ? "TRAILING" : ""))));
        String string8 = this.verticalTextPosition == 1 ? "TOP" : (this.verticalTextPosition == 0 ? "CENTER" : (this.verticalTextPosition == 3 ? "BOTTOM" : ""));
        String string9 = this.horizontalTextPosition == 2 ? "LEFT" : (this.horizontalTextPosition == 0 ? "CENTER" : (this.horizontalTextPosition == 4 ? "RIGHT" : (this.horizontalTextPosition == 10 ? "LEADING" : (this.horizontalTextPosition == 11 ? "TRAILING" : ""))));
        return super.paramString() + ",defaultIcon=" + string3 + ",disabledIcon=" + string4 + ",horizontalAlignment=" + string7 + ",horizontalTextPosition=" + string9 + ",iconTextGap=" + this.iconTextGap + ",labelFor=" + string + ",text=" + string2 + ",verticalAlignment=" + string6 + ",verticalTextPosition=" + string8;
    }

    public Component getLabelFor() {
        return this.labelFor;
    }

    public void setLabelFor(Component component) {
        Component component2 = this.labelFor;
        this.labelFor = component;
        this.firePropertyChange("labelFor", component2, component);
        if (component2 instanceof JComponent) {
            ((JComponent)component2).putClientProperty(LABELED_BY_PROPERTY, null);
        }
        if (component instanceof JComponent) {
            ((JComponent)component).putClientProperty(LABELED_BY_PROPERTY, this);
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJLabel();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJLabel
    extends JComponent.AccessibleJComponent
    implements AccessibleText,
    AccessibleExtendedComponent {
        protected AccessibleJLabel() {
        }

        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            if (JLabel.this.getText() == null) {
                return super.getAccessibleName();
            }
            return JLabel.this.getText();
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LABEL;
        }

        public AccessibleIcon[] getAccessibleIcon() {
            if (JLabel.this.accessibleIcon == null) {
                return null;
            }
            AccessibleIcon[] accessibleIconArray = new AccessibleIcon[]{JLabel.this.accessibleIcon};
            return accessibleIconArray;
        }

        public AccessibleRelationSet getAccessibleRelationSet() {
            Component component;
            AccessibleRelationSet accessibleRelationSet = super.getAccessibleRelationSet();
            if (!accessibleRelationSet.contains(AccessibleRelation.LABEL_FOR) && (component = JLabel.this.getLabelFor()) != null) {
                AccessibleRelation accessibleRelation = new AccessibleRelation(AccessibleRelation.LABEL_FOR);
                accessibleRelation.setTarget(component);
                accessibleRelationSet.add(accessibleRelation);
            }
            return accessibleRelationSet;
        }

        public AccessibleText getAccessibleText() {
            View view = (View)JLabel.this.getClientProperty("html");
            if (view != null) {
                return this;
            }
            return null;
        }

        public int getIndexAtPoint(Point point) {
            View view = (View)JLabel.this.getClientProperty("html");
            if (view != null) {
                Rectangle rectangle = this.getTextRectangle();
                if (rectangle == null) {
                    return -1;
                }
                Rectangle2D.Float float_ = new Rectangle2D.Float(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                Position.Bias[] biasArray = new Position.Bias[1];
                return view.viewToModel(point.x, point.y, float_, biasArray);
            }
            return -1;
        }

        public Rectangle getCharacterBounds(int n2) {
            View view = (View)JLabel.this.getClientProperty("html");
            if (view != null) {
                Rectangle rectangle = this.getTextRectangle();
                if (rectangle == null) {
                    return null;
                }
                Rectangle2D.Float float_ = new Rectangle2D.Float(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                try {
                    Shape shape = view.modelToView(n2, float_, Position.Bias.Forward);
                    return shape.getBounds();
                }
                catch (BadLocationException badLocationException) {
                    return null;
                }
            }
            return null;
        }

        public int getCharCount() {
            Document document;
            View view = (View)JLabel.this.getClientProperty("html");
            if (view != null && (document = view.getDocument()) instanceof StyledDocument) {
                StyledDocument styledDocument = (StyledDocument)document;
                return styledDocument.getLength();
            }
            return JLabel.this.accessibleContext.getAccessibleName().length();
        }

        public int getCaretPosition() {
            return -1;
        }

        public String getAtIndex(int n2, int n3) {
            if (n3 < 0 || n3 >= this.getCharCount()) {
                return null;
            }
            switch (n2) {
                case 1: {
                    try {
                        return this.getText(n3, 1);
                    }
                    catch (BadLocationException badLocationException) {
                        return null;
                    }
                }
                case 2: {
                    try {
                        String string = this.getText(0, this.getCharCount());
                        BreakIterator breakIterator = BreakIterator.getWordInstance(this.getLocale());
                        breakIterator.setText(string);
                        int n4 = breakIterator.following(n3);
                        return string.substring(breakIterator.previous(), n4);
                    }
                    catch (BadLocationException badLocationException) {
                        return null;
                    }
                }
                case 3: {
                    try {
                        String string = this.getText(0, this.getCharCount());
                        BreakIterator breakIterator = BreakIterator.getSentenceInstance(this.getLocale());
                        breakIterator.setText(string);
                        int n5 = breakIterator.following(n3);
                        return string.substring(breakIterator.previous(), n5);
                    }
                    catch (BadLocationException badLocationException) {
                        return null;
                    }
                }
            }
            return null;
        }

        public String getAfterIndex(int n2, int n3) {
            if (n3 < 0 || n3 >= this.getCharCount()) {
                return null;
            }
            switch (n2) {
                case 1: {
                    if (n3 + 1 >= this.getCharCount()) {
                        return null;
                    }
                    try {
                        return this.getText(n3 + 1, 1);
                    }
                    catch (BadLocationException badLocationException) {
                        return null;
                    }
                }
                case 2: {
                    try {
                        String string = this.getText(0, this.getCharCount());
                        BreakIterator breakIterator = BreakIterator.getWordInstance(this.getLocale());
                        breakIterator.setText(string);
                        int n4 = breakIterator.following(n3);
                        if (n4 == -1 || n4 >= string.length()) {
                            return null;
                        }
                        int n5 = breakIterator.following(n4);
                        if (n5 == -1 || n5 >= string.length()) {
                            return null;
                        }
                        return string.substring(n4, n5);
                    }
                    catch (BadLocationException badLocationException) {
                        return null;
                    }
                }
                case 3: {
                    try {
                        String string = this.getText(0, this.getCharCount());
                        BreakIterator breakIterator = BreakIterator.getSentenceInstance(this.getLocale());
                        breakIterator.setText(string);
                        int n6 = breakIterator.following(n3);
                        if (n6 == -1 || n6 >= string.length()) {
                            return null;
                        }
                        int n7 = breakIterator.following(n6);
                        if (n7 == -1 || n7 >= string.length()) {
                            return null;
                        }
                        return string.substring(n6, n7);
                    }
                    catch (BadLocationException badLocationException) {
                        return null;
                    }
                }
            }
            return null;
        }

        public String getBeforeIndex(int n2, int n3) {
            if (n3 < 0 || n3 > this.getCharCount() - 1) {
                return null;
            }
            switch (n2) {
                case 1: {
                    if (n3 == 0) {
                        return null;
                    }
                    try {
                        return this.getText(n3 - 1, 1);
                    }
                    catch (BadLocationException badLocationException) {
                        return null;
                    }
                }
                case 2: {
                    try {
                        String string = this.getText(0, this.getCharCount());
                        BreakIterator breakIterator = BreakIterator.getWordInstance(this.getLocale());
                        breakIterator.setText(string);
                        int n4 = breakIterator.following(n3);
                        n4 = breakIterator.previous();
                        int n5 = breakIterator.previous();
                        if (n5 == -1) {
                            return null;
                        }
                        return string.substring(n5, n4);
                    }
                    catch (BadLocationException badLocationException) {
                        return null;
                    }
                }
                case 3: {
                    try {
                        String string = this.getText(0, this.getCharCount());
                        BreakIterator breakIterator = BreakIterator.getSentenceInstance(this.getLocale());
                        breakIterator.setText(string);
                        int n6 = breakIterator.following(n3);
                        n6 = breakIterator.previous();
                        int n7 = breakIterator.previous();
                        if (n7 == -1) {
                            return null;
                        }
                        return string.substring(n7, n6);
                    }
                    catch (BadLocationException badLocationException) {
                        return null;
                    }
                }
            }
            return null;
        }

        public AttributeSet getCharacterAttribute(int n2) {
            StyledDocument styledDocument;
            Element element;
            Document document;
            View view = (View)JLabel.this.getClientProperty("html");
            if (view != null && (document = view.getDocument()) instanceof StyledDocument && (element = (styledDocument = (StyledDocument)document).getCharacterElement(n2)) != null) {
                return element.getAttributes();
            }
            return null;
        }

        public int getSelectionStart() {
            return -1;
        }

        public int getSelectionEnd() {
            return -1;
        }

        public String getSelectedText() {
            return null;
        }

        private String getText(int n2, int n3) throws BadLocationException {
            Document document;
            View view = (View)JLabel.this.getClientProperty("html");
            if (view != null && (document = view.getDocument()) instanceof StyledDocument) {
                StyledDocument styledDocument = (StyledDocument)document;
                return styledDocument.getText(n2, n3);
            }
            return null;
        }

        private Rectangle getTextRectangle() {
            Icon icon;
            String string = JLabel.this.getText();
            Icon icon2 = icon = JLabel.this.isEnabled() ? JLabel.this.getIcon() : JLabel.this.getDisabledIcon();
            if (icon == null && string == null) {
                return null;
            }
            Rectangle rectangle = new Rectangle();
            Rectangle rectangle2 = new Rectangle();
            Rectangle rectangle3 = new Rectangle();
            Insets insets = new Insets(0, 0, 0, 0);
            insets = JLabel.this.getInsets(insets);
            rectangle3.x = insets.left;
            rectangle3.y = insets.top;
            rectangle3.width = JLabel.this.getWidth() - (insets.left + insets.right);
            rectangle3.height = JLabel.this.getHeight() - (insets.top + insets.bottom);
            Graphics graphics = JLabel.this.getGraphics();
            if (graphics == null) {
                return null;
            }
            String string2 = SwingUtilities.layoutCompoundLabel(JLabel.this, graphics.getFontMetrics(), string, icon, JLabel.this.getVerticalAlignment(), JLabel.this.getHorizontalAlignment(), JLabel.this.getVerticalTextPosition(), JLabel.this.getHorizontalTextPosition(), rectangle3, rectangle, rectangle2, JLabel.this.getIconTextGap());
            return rectangle2;
        }

        AccessibleExtendedComponent getAccessibleExtendedComponent() {
            return this;
        }

        public String getToolTipText() {
            return JLabel.this.getToolTipText();
        }

        public String getTitledBorderText() {
            return super.getTitledBorderText();
        }

        public AccessibleKeyBinding getAccessibleKeyBinding() {
            int n2 = JLabel.this.getDisplayedMnemonic();
            if (n2 == 0) {
                return null;
            }
            return new LabelKeyBinding(n2);
        }

        class LabelKeyBinding
        implements AccessibleKeyBinding {
            int mnemonic;

            LabelKeyBinding(int n2) {
                this.mnemonic = n2;
            }

            public int getAccessibleKeyBindingCount() {
                return 1;
            }

            public Object getAccessibleKeyBinding(int n2) {
                if (n2 != 0) {
                    throw new IllegalArgumentException();
                }
                return KeyStroke.getKeyStroke(this.mnemonic, 0);
            }
        }
    }
}

