/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.text.JTextComponent;

public class BasicBorders {
    public static Border getButtonBorder() {
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        BorderUIResource.CompoundBorderUIResource compoundBorderUIResource = new BorderUIResource.CompoundBorderUIResource(new ButtonBorder(uIDefaults.getColor("Button.shadow"), uIDefaults.getColor("Button.darkShadow"), uIDefaults.getColor("Button.light"), uIDefaults.getColor("Button.highlight")), new MarginBorder());
        return compoundBorderUIResource;
    }

    public static Border getRadioButtonBorder() {
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        BorderUIResource.CompoundBorderUIResource compoundBorderUIResource = new BorderUIResource.CompoundBorderUIResource(new RadioButtonBorder(uIDefaults.getColor("RadioButton.shadow"), uIDefaults.getColor("RadioButton.darkShadow"), uIDefaults.getColor("RadioButton.light"), uIDefaults.getColor("RadioButton.highlight")), new MarginBorder());
        return compoundBorderUIResource;
    }

    public static Border getToggleButtonBorder() {
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        BorderUIResource.CompoundBorderUIResource compoundBorderUIResource = new BorderUIResource.CompoundBorderUIResource(new ToggleButtonBorder(uIDefaults.getColor("ToggleButton.shadow"), uIDefaults.getColor("ToggleButton.darkShadow"), uIDefaults.getColor("ToggleButton.light"), uIDefaults.getColor("ToggleButton.highlight")), new MarginBorder());
        return compoundBorderUIResource;
    }

    public static Border getMenuBarBorder() {
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        MenuBarBorder menuBarBorder = new MenuBarBorder(uIDefaults.getColor("MenuBar.shadow"), uIDefaults.getColor("MenuBar.highlight"));
        return menuBarBorder;
    }

    public static Border getSplitPaneBorder() {
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        SplitPaneBorder splitPaneBorder = new SplitPaneBorder(uIDefaults.getColor("SplitPane.highlight"), uIDefaults.getColor("SplitPane.darkShadow"));
        return splitPaneBorder;
    }

    public static Border getSplitPaneDividerBorder() {
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        SplitPaneDividerBorder splitPaneDividerBorder = new SplitPaneDividerBorder(uIDefaults.getColor("SplitPane.highlight"), uIDefaults.getColor("SplitPane.darkShadow"));
        return splitPaneDividerBorder;
    }

    public static Border getTextFieldBorder() {
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        FieldBorder fieldBorder = new FieldBorder(uIDefaults.getColor("TextField.shadow"), uIDefaults.getColor("TextField.darkShadow"), uIDefaults.getColor("TextField.light"), uIDefaults.getColor("TextField.highlight"));
        return fieldBorder;
    }

    public static Border getProgressBarBorder() {
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        BorderUIResource.LineBorderUIResource lineBorderUIResource = new BorderUIResource.LineBorderUIResource(Color.green, 2);
        return lineBorderUIResource;
    }

    public static Border getInternalFrameBorder() {
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        BorderUIResource.CompoundBorderUIResource compoundBorderUIResource = new BorderUIResource.CompoundBorderUIResource(new BevelBorder(0, uIDefaults.getColor("InternalFrame.borderLight"), uIDefaults.getColor("InternalFrame.borderHighlight"), uIDefaults.getColor("InternalFrame.borderDarkShadow"), uIDefaults.getColor("InternalFrame.borderShadow")), BorderFactory.createLineBorder(uIDefaults.getColor("InternalFrame.borderColor"), 1));
        return compoundBorderUIResource;
    }

    public static class SplitPaneBorder
    implements Border,
    UIResource {
        protected Color highlight;
        protected Color shadow;

        public SplitPaneBorder(Color color, Color color2) {
            this.highlight = color;
            this.shadow = color2;
        }

        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            JSplitPane jSplitPane = (JSplitPane)component;
            Component component2 = jSplitPane.getLeftComponent();
            graphics.setColor(component.getBackground());
            graphics.drawRect(n2, n3, n4 - 1, n5 - 1);
            if (jSplitPane.getOrientation() == 1) {
                Rectangle rectangle;
                if (component2 != null) {
                    rectangle = component2.getBounds();
                    graphics.setColor(this.shadow);
                    graphics.drawLine(0, 0, rectangle.width + 1, 0);
                    graphics.drawLine(0, 1, 0, rectangle.height + 2);
                    graphics.setColor(this.highlight);
                    graphics.drawLine(1, rectangle.height + 1, rectangle.width + 1, rectangle.height + 1);
                }
                if ((component2 = jSplitPane.getRightComponent()) != null) {
                    rectangle = component2.getBounds();
                    int n6 = rectangle.x + rectangle.width;
                    int n7 = rectangle.y + rectangle.height;
                    graphics.setColor(this.shadow);
                    graphics.drawLine(rectangle.x - 1, 0, n6, 0);
                    graphics.drawLine(rectangle.x - 1, n7, rectangle.x, n7);
                    graphics.setColor(this.highlight);
                    graphics.drawLine(rectangle.x, n7, n6, n7);
                    graphics.drawLine(n6, 0, n6, n7 + 1);
                }
            } else {
                Rectangle rectangle;
                if (component2 != null) {
                    rectangle = component2.getBounds();
                    graphics.setColor(this.shadow);
                    graphics.drawLine(0, 0, rectangle.width + 1, 0);
                    graphics.drawLine(0, 1, 0, rectangle.height);
                    graphics.setColor(this.highlight);
                    graphics.drawLine(1 + rectangle.width, 0, 1 + rectangle.width, rectangle.height + 1);
                    graphics.drawLine(0, rectangle.height + 1, 0, rectangle.height + 1);
                }
                if ((component2 = jSplitPane.getRightComponent()) != null) {
                    rectangle = component2.getBounds();
                    int n8 = rectangle.x + rectangle.width;
                    int n9 = rectangle.y + rectangle.height;
                    graphics.setColor(this.shadow);
                    graphics.drawLine(0, rectangle.y - 1, 0, n9);
                    graphics.drawLine(n8, rectangle.y - 1, n8, rectangle.y - 1);
                    graphics.drawLine(0, rectangle.y - 1, rectangle.width, rectangle.y - 1);
                    graphics.setColor(this.highlight);
                    graphics.drawLine(0, n9, rectangle.width + 1, n9);
                    graphics.drawLine(n8, rectangle.y, n8, n9);
                }
            }
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(1, 1, 1, 1);
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }

    static class SplitPaneDividerBorder
    implements Border,
    UIResource {
        Color highlight;
        Color shadow;

        SplitPaneDividerBorder(Color color, Color color2) {
            this.highlight = color;
            this.shadow = color2;
        }

        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            JSplitPane jSplitPane = ((BasicSplitPaneDivider)component).getBasicSplitPaneUI().getSplitPane();
            Dimension dimension = component.getSize();
            Component component2 = jSplitPane.getLeftComponent();
            graphics.setColor(component.getBackground());
            graphics.drawRect(n2, n3, n4 - 1, n5 - 1);
            if (jSplitPane.getOrientation() == 1) {
                if (component2 != null) {
                    graphics.setColor(this.highlight);
                    graphics.drawLine(0, 0, 0, dimension.height);
                }
                if ((component2 = jSplitPane.getRightComponent()) != null) {
                    graphics.setColor(this.shadow);
                    graphics.drawLine(dimension.width - 1, 0, dimension.width - 1, dimension.height);
                }
            } else {
                if (component2 != null) {
                    graphics.setColor(this.highlight);
                    graphics.drawLine(0, 0, dimension.width, 0);
                }
                if ((component2 = jSplitPane.getRightComponent()) != null) {
                    graphics.setColor(this.shadow);
                    graphics.drawLine(0, dimension.height - 1, dimension.width, dimension.height - 1);
                }
            }
        }

        public Insets getBorderInsets(Component component) {
            JSplitPane jSplitPane;
            BasicSplitPaneUI basicSplitPaneUI;
            Insets insets = new Insets(0, 0, 0, 0);
            if (component instanceof BasicSplitPaneDivider && (basicSplitPaneUI = ((BasicSplitPaneDivider)component).getBasicSplitPaneUI()) != null && (jSplitPane = basicSplitPaneUI.getSplitPane()) != null) {
                if (jSplitPane.getOrientation() == 1) {
                    insets.bottom = 0;
                    insets.top = 0;
                    insets.right = 1;
                    insets.left = 1;
                    return insets;
                }
                insets.bottom = 1;
                insets.top = 1;
                insets.right = 0;
                insets.left = 0;
                return insets;
            }
            insets.right = 1;
            insets.left = 1;
            insets.bottom = 1;
            insets.top = 1;
            return insets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }

    public static class FieldBorder
    extends AbstractBorder
    implements UIResource {
        protected Color shadow;
        protected Color darkShadow;
        protected Color highlight;
        protected Color lightHighlight;

        public FieldBorder(Color color, Color color2, Color color3, Color color4) {
            this.shadow = color;
            this.highlight = color3;
            this.darkShadow = color2;
            this.lightHighlight = color4;
        }

        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            BasicGraphicsUtils.drawEtchedRect(graphics, n2, n3, n4, n5, this.shadow, this.darkShadow, this.highlight, this.lightHighlight);
        }

        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, new Insets(0, 0, 0, 0));
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            Insets insets2 = null;
            if (component instanceof JTextComponent) {
                insets2 = ((JTextComponent)component).getMargin();
            }
            insets.top = insets2 != null ? 2 + insets2.top : 2;
            insets.left = insets2 != null ? 2 + insets2.left : 2;
            insets.bottom = insets2 != null ? 2 + insets2.bottom : 2;
            insets.right = insets2 != null ? 2 + insets2.right : 2;
            return insets;
        }
    }

    public static class MarginBorder
    extends AbstractBorder
    implements UIResource {
        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, new Insets(0, 0, 0, 0));
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            Insets insets2 = null;
            if (component instanceof AbstractButton) {
                AbstractButton abstractButton = (AbstractButton)component;
                insets2 = abstractButton.getMargin();
            } else if (component instanceof JToolBar) {
                JToolBar jToolBar = (JToolBar)component;
                insets2 = jToolBar.getMargin();
            } else if (component instanceof JTextComponent) {
                JTextComponent jTextComponent = (JTextComponent)component;
                insets2 = jTextComponent.getMargin();
            }
            insets.top = insets2 != null ? insets2.top : 0;
            insets.left = insets2 != null ? insets2.left : 0;
            insets.bottom = insets2 != null ? insets2.bottom : 0;
            insets.right = insets2 != null ? insets2.right : 0;
            return insets;
        }
    }

    public static class MenuBarBorder
    extends AbstractBorder
    implements UIResource {
        private Color shadow;
        private Color highlight;

        public MenuBarBorder(Color color, Color color2) {
            this.shadow = color;
            this.highlight = color2;
        }

        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            BasicGraphicsUtils.drawGroove(graphics, 0, n5 - 2, n4, n5, this.shadow, this.highlight);
        }

        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, new Insets(0, 0, 0, 0));
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.top = 0;
            insets.left = 0;
            insets.bottom = 2;
            insets.right = 0;
            return insets;
        }
    }

    public static class RadioButtonBorder
    extends ButtonBorder {
        public RadioButtonBorder(Color color, Color color2, Color color3, Color color4) {
            super(color, color2, color3, color4);
        }

        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            if (component instanceof AbstractButton) {
                AbstractButton abstractButton = (AbstractButton)component;
                ButtonModel buttonModel = abstractButton.getModel();
                if (buttonModel.isArmed() && buttonModel.isPressed() || buttonModel.isSelected()) {
                    BasicGraphicsUtils.drawLoweredBezel(graphics, n2, n3, n4, n5, this.shadow, this.darkShadow, this.highlight, this.lightHighlight);
                } else {
                    BasicGraphicsUtils.drawBezel(graphics, n2, n3, n4, n5, false, abstractButton.isFocusPainted() && abstractButton.hasFocus(), this.shadow, this.darkShadow, this.highlight, this.lightHighlight);
                }
            } else {
                BasicGraphicsUtils.drawBezel(graphics, n2, n3, n4, n5, false, false, this.shadow, this.darkShadow, this.highlight, this.lightHighlight);
            }
        }

        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, new Insets(0, 0, 0, 0));
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.right = 2;
            insets.bottom = 2;
            insets.left = 2;
            insets.top = 2;
            return insets;
        }
    }

    public static class ToggleButtonBorder
    extends ButtonBorder {
        public ToggleButtonBorder(Color color, Color color2, Color color3, Color color4) {
            super(color, color2, color3, color4);
        }

        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            BasicGraphicsUtils.drawBezel(graphics, n2, n3, n4, n5, false, false, this.shadow, this.darkShadow, this.highlight, this.lightHighlight);
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(2, 2, 2, 2);
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.right = 2;
            insets.bottom = 2;
            insets.left = 2;
            insets.top = 2;
            return insets;
        }
    }

    public static class ButtonBorder
    extends AbstractBorder
    implements UIResource {
        protected Color shadow;
        protected Color darkShadow;
        protected Color highlight;
        protected Color lightHighlight;

        public ButtonBorder(Color color, Color color2, Color color3, Color color4) {
            this.shadow = color;
            this.darkShadow = color2;
            this.highlight = color3;
            this.lightHighlight = color4;
        }

        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            boolean bl2 = false;
            boolean bl3 = false;
            if (component instanceof AbstractButton) {
                AbstractButton abstractButton = (AbstractButton)component;
                ButtonModel buttonModel = abstractButton.getModel();
                boolean bl4 = bl2 = buttonModel.isPressed() && buttonModel.isArmed();
                if (component instanceof JButton) {
                    bl3 = ((JButton)component).isDefaultButton();
                }
            }
            BasicGraphicsUtils.drawBezel(graphics, n2, n3, n4, n5, bl2, bl3, this.shadow, this.darkShadow, this.highlight, this.lightHighlight);
        }

        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, new Insets(0, 0, 0, 0));
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.top = 2;
            insets.right = 3;
            insets.bottom = 3;
            insets.left = 3;
            return insets;
        }
    }

    static class RolloverMarginBorder
    extends EmptyBorder {
        public RolloverMarginBorder() {
            super(3, 3, 3, 3);
        }

        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, new Insets(0, 0, 0, 0));
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            Insets insets2 = null;
            if (component instanceof AbstractButton) {
                insets2 = ((AbstractButton)component).getMargin();
            }
            if (insets2 == null || insets2 instanceof UIResource) {
                insets.left = this.left;
                insets.top = this.top;
                insets.right = this.right;
                insets.bottom = this.bottom;
            } else {
                insets.left = insets2.left;
                insets.top = insets2.top;
                insets.right = insets2.right;
                insets.bottom = insets2.bottom;
            }
            return insets;
        }
    }

    public static class RolloverButtonBorder
    extends ButtonBorder {
        public RolloverButtonBorder(Color color, Color color2, Color color3, Color color4) {
            super(color, color2, color3, color4);
        }

        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            Color color = this.shadow;
            Container container = abstractButton.getParent();
            if (container != null && container.getBackground().equals(this.shadow)) {
                color = this.darkShadow;
            }
            if (buttonModel.isRollover() && (!buttonModel.isPressed() || buttonModel.isArmed())) {
                Color color2 = graphics.getColor();
                graphics.translate(n2, n3);
                if (buttonModel.isPressed() && buttonModel.isArmed() || buttonModel.isSelected()) {
                    graphics.setColor(color);
                    graphics.drawRect(0, 0, n4 - 1, n5 - 1);
                    graphics.setColor(this.lightHighlight);
                    graphics.drawLine(n4 - 1, 0, n4 - 1, n5 - 1);
                    graphics.drawLine(0, n5 - 1, n4 - 1, n5 - 1);
                } else {
                    graphics.setColor(this.lightHighlight);
                    graphics.drawRect(0, 0, n4 - 1, n5 - 1);
                    graphics.setColor(color);
                    graphics.drawLine(n4 - 1, 0, n4 - 1, n5 - 1);
                    graphics.drawLine(0, n5 - 1, n4 - 1, n5 - 1);
                }
                graphics.translate(-n2, -n3);
                graphics.setColor(color2);
            }
        }
    }
}

