/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.GapVector;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public class GapContent
extends GapVector
implements AbstractDocument.Content,
Serializable {
    private static final char[] empty = new char[0];
    private transient MarkVector marks;
    private transient MarkData search;
    private transient int unusedMarks;

    public GapContent() {
        this(10);
    }

    public GapContent(int n2) {
        super(Math.max(n2, 2));
        char[] cArray = new char[]{'\n'};
        this.replace(0, 0, cArray, cArray.length);
        this.marks = new MarkVector();
        this.search = new MarkData(0);
    }

    protected Object allocateArray(int n2) {
        return new char[n2];
    }

    protected int getArrayLength() {
        char[] cArray = (char[])this.getArray();
        return cArray.length;
    }

    public int length() {
        int n2 = this.getArrayLength() - (this.getGapEnd() - this.getGapStart());
        return n2;
    }

    public UndoableEdit insertString(int n2, String string) throws BadLocationException {
        if (n2 >= this.length() || n2 < 0) {
            throw new BadLocationException("Invalid insert", this.length());
        }
        char[] cArray = string.toCharArray();
        this.replace(n2, 0, cArray, cArray.length);
        return new InsertUndo(n2, string.length());
    }

    public UndoableEdit remove(int n2, int n3) throws BadLocationException {
        if (n2 + n3 >= this.length()) {
            throw new BadLocationException("Invalid remove", this.length() + 1);
        }
        String string = this.getString(n2, n3);
        RemoveUndo removeUndo = new RemoveUndo(n2, string);
        this.replace(n2, n3, empty, 0);
        return removeUndo;
    }

    public String getString(int n2, int n3) throws BadLocationException {
        Segment segment = new Segment();
        this.getChars(n2, n3, segment);
        return new String(segment.array, segment.offset, segment.count);
    }

    public void getChars(int n2, int n3, Segment segment) throws BadLocationException {
        int n4 = n2 + n3;
        if (n2 < 0 || n4 < 0) {
            throw new BadLocationException("Invalid location", -1);
        }
        if (n4 > this.length() || n2 > this.length()) {
            throw new BadLocationException("Invalid location", this.length() + 1);
        }
        int n5 = this.getGapStart();
        int n6 = this.getGapEnd();
        char[] cArray = (char[])this.getArray();
        if (n2 + n3 <= n5) {
            segment.array = cArray;
            segment.offset = n2;
        } else if (n2 >= n5) {
            segment.array = cArray;
            segment.offset = n6 + n2 - n5;
        } else {
            int n7 = n5 - n2;
            if (segment.isPartialReturn()) {
                segment.array = cArray;
                segment.offset = n2;
                segment.count = n7;
                return;
            }
            segment.array = new char[n3];
            segment.offset = 0;
            System.arraycopy(cArray, n2, segment.array, 0, n7);
            System.arraycopy(cArray, n6, segment.array, n7, n3 - n7);
        }
        segment.count = n3;
    }

    public Position createPosition(int n2) throws BadLocationException {
        if (this.unusedMarks > Math.max(5, this.marks.size() / 10)) {
            this.removeUnusedMarks();
        }
        int n3 = this.getGapStart();
        int n4 = this.getGapEnd();
        int n5 = n2 < n3 ? n2 : n2 + (n4 - n3);
        MarkData markData = new MarkData(n5);
        int n6 = this.findSortIndex(markData);
        this.marks.insertElementAt(markData, n6);
        return new StickyPosition(markData);
    }

    protected void shiftEnd(int n2) {
        int n3 = this.getGapEnd();
        super.shiftEnd(n2);
        int n4 = this.getGapEnd() - n3;
        int n5 = this.findMarkAdjustIndex(n3);
        int n6 = this.marks.size();
        int n7 = n5;
        while (n7 < n6) {
            MarkData markData = this.marks.elementAt(n7);
            markData.index += n4;
            ++n7;
        }
    }

    protected void shiftGap(int n2) {
        int n3 = this.getGapStart();
        int n4 = n2 - n3;
        int n5 = this.getGapEnd();
        int n6 = n5 + n4;
        int n7 = n5 - n3;
        super.shiftGap(n2);
        if (n4 > 0) {
            int n8 = this.findMarkAdjustIndex(n3);
            int n9 = this.marks.size();
            int n10 = n8;
            while (n10 < n9) {
                MarkData markData = this.marks.elementAt(n10);
                if (markData.index < n6) {
                    markData.index -= n7;
                    ++n10;
                    continue;
                }
                break;
            }
        } else if (n4 < 0) {
            int n11 = this.findMarkAdjustIndex(n2);
            int n12 = this.marks.size();
            int n13 = n11;
            while (n13 < n12) {
                MarkData markData = this.marks.elementAt(n13);
                if (markData.index < n5) {
                    markData.index += n7;
                    ++n13;
                    continue;
                }
                break;
            }
        }
        this.resetMarksAtZero();
    }

    protected void resetMarksAtZero() {
        if (this.marks != null && this.getGapStart() == 0) {
            int n2 = this.getGapEnd();
            int n3 = 0;
            int n4 = this.marks.size();
            while (n3 < n4) {
                MarkData markData = this.marks.elementAt(n3);
                if (markData.index > n2) break;
                markData.index = 0;
                ++n3;
            }
        }
    }

    protected void shiftGapStartDown(int n2) {
        int n3 = this.findMarkAdjustIndex(n2);
        int n4 = this.marks.size();
        int n5 = this.getGapStart();
        int n6 = this.getGapEnd();
        int n7 = n3;
        while (n7 < n4) {
            MarkData markData = this.marks.elementAt(n7);
            if (markData.index > n5) break;
            markData.index = n6;
            ++n7;
        }
        super.shiftGapStartDown(n2);
        this.resetMarksAtZero();
    }

    protected void shiftGapEndUp(int n2) {
        int n3 = this.findMarkAdjustIndex(this.getGapEnd());
        int n4 = this.marks.size();
        int n5 = n3;
        while (n5 < n4) {
            MarkData markData = this.marks.elementAt(n5);
            if (markData.index >= n2) break;
            markData.index = n2;
            ++n5;
        }
        super.shiftGapEndUp(n2);
        this.resetMarksAtZero();
    }

    final int compare(MarkData markData, MarkData markData2) {
        if (markData.index < markData2.index) {
            return -1;
        }
        if (markData.index > markData2.index) {
            return 1;
        }
        return 0;
    }

    final int findMarkAdjustIndex(int n2) {
        this.search.index = Math.max(n2, 1);
        int n3 = this.findSortIndex(this.search);
        int n4 = n3 - 1;
        while (n4 >= 0) {
            MarkData markData = this.marks.elementAt(n4);
            if (markData.index != this.search.index) break;
            --n3;
            --n4;
        }
        return n3;
    }

    /*
     * Unable to fully structure code
     */
    final int findSortIndex(MarkData var1_1) {
        var2_2 = 0;
        var3_3 = this.marks.size() - 1;
        var4_4 = 0;
        if (var3_3 == -1) {
            return 0;
        }
        var5_5 = 0;
        var6_6 = this.marks.elementAt(var3_3);
        var5_5 = this.compare(var1_1, var6_6);
        if (var5_5 <= 0) ** GOTO lbl20
        return var3_3 + 1;
lbl-1000:
        // 1 sources

        {
            var4_4 = var2_2 + (var3_3 - var2_2) / 2;
            var7_7 = this.marks.elementAt(var4_4);
            var5_5 = this.compare(var1_1, var7_7);
            if (var5_5 == 0) {
                return var4_4;
            }
            if (var5_5 < 0) {
                var3_3 = var4_4 - 1;
                continue;
            }
            var2_2 = var4_4 + 1;
lbl20:
            // 3 sources

            ** while (var2_2 <= var3_3)
        }
lbl21:
        // 1 sources

        return var5_5 < 0 ? var4_4 : var4_4 + 1;
    }

    final void removeUnusedMarks() {
        int n2 = this.marks.size();
        MarkVector markVector = new MarkVector(n2);
        int n3 = 0;
        while (n3 < n2) {
            MarkData markData = this.marks.elementAt(n3);
            if (!markData.unused) {
                markVector.addElement(markData);
            }
            ++n3;
        }
        this.marks = markVector;
        this.unusedMarks = 0;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.marks = new MarkVector();
        this.search = new MarkData(0);
    }

    protected Vector getPositionsInRange(Vector vector, int n2, int n3) {
        int n4;
        int n5;
        int n6 = n2 + n3;
        int n7 = this.getGapStart();
        int n8 = this.getGapEnd();
        if (n2 < n7) {
            n5 = n2 == 0 ? 0 : this.findMarkAdjustIndex(n2);
            n4 = n6 >= n7 ? this.findMarkAdjustIndex(n6 + (n8 - n7) + 1) : this.findMarkAdjustIndex(n6 + 1);
        } else {
            n5 = this.findMarkAdjustIndex(n2 + (n8 - n7));
            n4 = this.findMarkAdjustIndex(n6 + (n8 - n7) + 1);
        }
        Vector vector2 = vector == null ? new Vector(Math.max(1, n4 - n5)) : vector;
        int n9 = n5;
        while (n9 < n4) {
            vector2.addElement(new UndoPosRef(this.marks.elementAt(n9)));
            ++n9;
        }
        return vector2;
    }

    protected void updateUndoPositions(Vector vector, int n2, int n3) {
        Object[] objectArray;
        int n4 = n2 + n3;
        int n5 = this.getGapEnd();
        int n6 = this.findMarkAdjustIndex(n5 + 1);
        int n7 = n2 != 0 ? this.findMarkAdjustIndex(n5) : 0;
        int n8 = vector.size() - 1;
        while (n8 >= 0) {
            objectArray = (Object[])vector.elementAt(n8);
            objectArray.resetLocation(n4, n5);
            --n8;
        }
        if (n7 < n6) {
            objectArray = new Object[n6 - n7];
            int n9 = 0;
            if (n2 == 0) {
                MarkData markData;
                int n10 = n7;
                while (n10 < n6) {
                    markData = this.marks.elementAt(n10);
                    if (markData.index == 0) {
                        objectArray[n9++] = markData;
                    }
                    ++n10;
                }
                n10 = n7;
                while (n10 < n6) {
                    markData = this.marks.elementAt(n10);
                    if (markData.index != 0) {
                        objectArray[n9++] = markData;
                    }
                    ++n10;
                }
            } else {
                MarkData markData;
                int n11 = n7;
                while (n11 < n6) {
                    markData = this.marks.elementAt(n11);
                    if (markData.index != n5) {
                        objectArray[n9++] = markData;
                    }
                    ++n11;
                }
                n11 = n7;
                while (n11 < n6) {
                    markData = this.marks.elementAt(n11);
                    if (markData.index == n5) {
                        objectArray[n9++] = markData;
                    }
                    ++n11;
                }
            }
            this.marks.replaceRange(n7, n6, objectArray);
        }
    }

    class RemoveUndo
    extends AbstractUndoableEdit {
        protected int offset;
        protected int length;
        protected String string;
        protected Vector posRefs;

        protected RemoveUndo(int n2, String string) {
            this.offset = n2;
            this.string = string;
            this.length = string.length();
            this.posRefs = GapContent.this.getPositionsInRange(null, n2, this.length);
        }

        public void undo() throws CannotUndoException {
            super.undo();
            try {
                GapContent.this.insertString(this.offset, this.string);
                if (this.posRefs != null) {
                    GapContent.this.updateUndoPositions(this.posRefs, this.offset, this.length);
                    this.posRefs = null;
                }
                this.string = null;
            }
            catch (BadLocationException badLocationException) {
                throw new CannotUndoException();
            }
        }

        public void redo() throws CannotRedoException {
            super.redo();
            try {
                this.string = GapContent.this.getString(this.offset, this.length);
                this.posRefs = GapContent.this.getPositionsInRange(null, this.offset, this.length);
                GapContent.this.remove(this.offset, this.length);
            }
            catch (BadLocationException badLocationException) {
                throw new CannotRedoException();
            }
        }
    }

    class InsertUndo
    extends AbstractUndoableEdit {
        protected int offset;
        protected int length;
        protected String string;
        protected Vector posRefs;

        protected InsertUndo(int n2, int n3) {
            this.offset = n2;
            this.length = n3;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            try {
                this.posRefs = GapContent.this.getPositionsInRange(null, this.offset, this.length);
                this.string = GapContent.this.getString(this.offset, this.length);
                GapContent.this.remove(this.offset, this.length);
            }
            catch (BadLocationException badLocationException) {
                throw new CannotUndoException();
            }
        }

        public void redo() throws CannotRedoException {
            super.redo();
            try {
                GapContent.this.insertString(this.offset, this.string);
                this.string = null;
                if (this.posRefs != null) {
                    GapContent.this.updateUndoPositions(this.posRefs, this.offset, this.length);
                    this.posRefs = null;
                }
            }
            catch (BadLocationException badLocationException) {
                throw new CannotRedoException();
            }
        }
    }

    final class UndoPosRef {
        protected int undoLocation;
        protected MarkData rec;

        UndoPosRef(MarkData markData) {
            this.rec = markData;
            this.undoLocation = markData.getOffset();
        }

        protected void resetLocation(int n2, int n3) {
            this.rec.index = this.undoLocation != n2 ? this.undoLocation : n3;
        }
    }

    static class MarkVector
    extends GapVector {
        MarkData[] oneMark = new MarkData[1];

        MarkVector() {
        }

        MarkVector(int n2) {
            super(n2);
        }

        protected Object allocateArray(int n2) {
            return new MarkData[n2];
        }

        protected int getArrayLength() {
            MarkData[] markDataArray = (MarkData[])this.getArray();
            return markDataArray.length;
        }

        public int size() {
            int n2 = this.getArrayLength() - (this.getGapEnd() - this.getGapStart());
            return n2;
        }

        public void insertElementAt(MarkData markData, int n2) {
            this.oneMark[0] = markData;
            this.replace(n2, 0, this.oneMark, 1);
        }

        public void addElement(MarkData markData) {
            this.insertElementAt(markData, this.size());
        }

        public MarkData elementAt(int n2) {
            int n3 = this.getGapStart();
            int n4 = this.getGapEnd();
            MarkData[] markDataArray = (MarkData[])this.getArray();
            if (n2 < n3) {
                return markDataArray[n2];
            }
            return markDataArray[n2 += n4 - n3];
        }

        /*
         * Unable to fully structure code
         */
        protected void replaceRange(int var1_1, int var2_2, Object[] var3_3) {
            block4: {
                block3: {
                    var4_4 = this.getGapStart();
                    var5_5 = this.getGapEnd();
                    var6_6 = var1_1;
                    var7_7 = 0;
                    var8_8 = (Object[])this.getArray();
                    if (var1_1 < var4_4) break block3;
                    var6_6 += var5_5 - var4_4;
                    var2_2 += var5_5 - var4_4;
                    break block4;
                }
                if (var2_2 < var4_4) ** GOTO lbl19
                var2_2 += var5_5 - var4_4;
                while (var6_6 < var4_4) {
                    var8_8[var6_6++] = var3_3[var7_7++];
                }
                var6_6 = var5_5;
                break block4;
lbl-1000:
                // 1 sources

                {
                    var8_8[var6_6++] = var3_3[var7_7++];
lbl19:
                    // 2 sources

                    ** while (var6_6 < var2_2)
                }
            }
            while (var6_6 < var2_2) {
                var8_8[var6_6++] = var3_3[var7_7++];
            }
        }
    }

    final class StickyPosition
    implements Position {
        MarkData mark;

        StickyPosition(MarkData markData) {
            this.mark = markData;
        }

        public final int getOffset() {
            return this.mark.getOffset();
        }

        protected void finalize() throws Throwable {
            this.mark.dispose();
        }

        public String toString() {
            return Integer.toString(this.getOffset());
        }
    }

    final class MarkData {
        int index;
        boolean unused;

        MarkData(int n2) {
            this.index = n2;
        }

        public final int getOffset() {
            int n2 = GapContent.this.getGapStart();
            int n3 = GapContent.this.getGapEnd();
            int n4 = this.index < n2 ? this.index : this.index - (n3 - n2);
            return Math.max(n4, 0);
        }

        public final void dispose() {
            this.unused = true;
            GapContent.this.unusedMarks += 1;
        }
    }
}

