/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.font;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.font.TextAttribute;
import java.util.Map;

public final class FontResolver {
    private Font[] allFonts;
    private static final float DEFAULT_SIZE = 12.0f;
    private static final int SHIFT = 9;
    private static final int BLOCKSIZE = 128;
    private static final int MASK = 127;
    private int[][] blocks = new int[512][];
    private static FontResolver INSTANCE;

    private FontResolver() {
        this.allFonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        this.allFonts = (Font[])this.allFonts.clone();
        int n2 = 0;
        while (n2 < this.allFonts.length) {
            this.allFonts[n2] = this.allFonts[n2].deriveFont(12.0f);
            ++n2;
        }
    }

    private int getIndexFor(char c2) {
        int n2 = 0;
        while (n2 < this.allFonts.length) {
            if (this.allFonts[n2].canDisplay(c2)) {
                return n2 + 1;
            }
            ++n2;
        }
        return 1;
    }

    public int getFontIndex(char c2) {
        int n2;
        int n3 = c2 >> 9;
        int[] nArray = this.blocks[n3];
        if (nArray == null) {
            nArray = new int[128];
            this.blocks[n3] = nArray;
        }
        if (nArray[n2 = c2 & 0x7F] == 0) {
            nArray[n2] = this.getIndexFor(c2);
        }
        return nArray[n2];
    }

    public Font getFont(int n2, Map map) {
        Font font = this.allFonts[n2 - 1];
        if (map == null) {
            return font;
        }
        Object object = map.get(TextAttribute.WEIGHT);
        Object object2 = map.get(TextAttribute.POSTURE);
        Object object3 = map.get(TextAttribute.SIZE);
        int n3 = 0;
        if (object != null && ((Float)object).floatValue() >= TextAttribute.WEIGHT_BOLD.floatValue()) {
            n3 |= 1;
        }
        if (object2 != null && ((Float)object2).floatValue() >= TextAttribute.POSTURE_OBLIQUE.floatValue()) {
            n3 |= 2;
        }
        float f2 = 12.0f;
        if (object3 != null) {
            f2 = ((Float)object3).floatValue();
        }
        if (n3 != 0 || f2 != 12.0f) {
            font = font.deriveFont(n3, f2);
        }
        return font;
    }

    public static FontResolver getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new FontResolver();
        }
        return INSTANCE;
    }
}

