/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport.tcp;

import java.security.AccessController;
import java.util.Vector;
import sun.rmi.runtime.NewThreadAction;
import sun.rmi.transport.Connection;
import sun.rmi.transport.tcp.TCPTransport;

class ConnectionAcceptor
implements Runnable {
    private TCPTransport transport;
    private Vector queue = new Vector(4);
    private static int threadNum = 0;

    public ConnectionAcceptor(TCPTransport tCPTransport) {
        this.transport = tCPTransport;
    }

    public void startNewAcceptor() {
        Thread thread = (Thread)AccessController.doPrivileged(new NewThreadAction(this, "Multiplex Accept-" + ++threadNum, true));
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(Connection connection) {
        Vector vector = this.queue;
        synchronized (vector) {
            this.queue.addElement(connection);
            this.queue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Connection connection;
        Vector vector = this.queue;
        synchronized (vector) {
            while (this.queue.size() == 0) {
                try {
                    this.queue.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.startNewAcceptor();
            connection = (Connection)this.queue.elementAt(0);
            this.queue.removeElementAt(0);
        }
        this.transport.handleMessages(connection, true);
    }
}

