/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal;

import java.io.IOException;
import java.math.BigInteger;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.EncryptedData;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.Realm;
import sun.security.krb5.RealmException;
import sun.security.krb5.internal.i;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class Ticket
implements Cloneable {
    public int tkt_vno;
    public Realm realm;
    public PrincipalName sname;
    public EncryptedData encPart;

    private Ticket() {
    }

    public Object clone() {
        Ticket ticket = new Ticket();
        ticket.realm = (Realm)this.realm.clone();
        ticket.sname = (PrincipalName)this.sname.clone();
        ticket.encPart = (EncryptedData)this.encPart.clone();
        ticket.tkt_vno = this.tkt_vno;
        return ticket;
    }

    public Ticket(Realm realm, PrincipalName principalName, EncryptedData encryptedData) {
        this.tkt_vno = 5;
        this.realm = realm;
        this.sname = principalName;
        this.encPart = encryptedData;
    }

    public Ticket(byte[] byArray) throws Asn1Exception, RealmException, i, IOException {
        this.init(new DerValue(byArray));
    }

    public Ticket(DerValue derValue) throws Asn1Exception, RealmException, i, IOException {
        this.init(derValue);
    }

    private void init(DerValue derValue) throws Asn1Exception, RealmException, i, IOException {
        if ((derValue.getTag() & 0x1F) != 1 || !derValue.isApplication() || !derValue.isConstructed()) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        if (derValue2.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        DerValue derValue3 = derValue2.getData().getDerValue();
        if ((derValue3.getTag() & 0x1F) != 0) {
            throw new Asn1Exception(906);
        }
        this.tkt_vno = derValue3.getData().getBigInteger().intValue();
        if (this.tkt_vno != 5) {
            throw new i(39);
        }
        this.realm = Realm.parse(derValue2.getData(), (byte)1, false);
        this.sname = PrincipalName.parse(derValue2.getData(), (byte)2, false);
        this.encPart = EncryptedData.parse(derValue2.getData(), (byte)3, false);
        if (derValue2.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        DerValue[] derValueArray = new DerValue[4];
        derOutputStream2.putInteger(BigInteger.valueOf(this.tkt_vno));
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream2);
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)1), this.realm.asn1Encode());
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)2), this.sname.asn1Encode());
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)3), this.encPart.asn1Encode());
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.write((byte)48, derOutputStream);
        DerOutputStream derOutputStream3 = new DerOutputStream();
        derOutputStream3.write(DerValue.createTag((byte)64, true, (byte)1), derOutputStream2);
        return derOutputStream3.toByteArray();
    }

    public static Ticket parse(DerInputStream derInputStream, byte by, boolean bl2) throws Asn1Exception, IOException, RealmException, i {
        if (bl2 && ((byte)derInputStream.peekByte() & 0x1F) != by) {
            return null;
        }
        DerValue derValue = derInputStream.getDerValue();
        if (by != (derValue.getTag() & 0x1F)) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        return new Ticket(derValue2);
    }
}

