/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Vector;
import sun.security.pkcs.ContentInfo;
import sun.security.pkcs.ParsingException;
import sun.security.pkcs.SignerInfo;
import sun.security.util.Debug;
import sun.security.util.DerEncoder;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;
import sun.security.x509.X500Name;
import sun.security.x509.X509CRLImpl;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;

public class PKCS7 {
    private ObjectIdentifier contentType;
    private BigInteger version = null;
    private AlgorithmId[] digestAlgorithmIds = null;
    private ContentInfo contentInfo = null;
    private X509Certificate[] certificates = null;
    private X509CRL[] crls = null;
    private SignerInfo[] signerInfos = null;
    private boolean oldStyle = false;
    private Principal[] certIssuerNames;

    public PKCS7(InputStream inputStream) throws ParsingException, IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        byte[] byArray = new byte[dataInputStream.available()];
        dataInputStream.readFully(byArray);
        this.parse(new DerInputStream(byArray));
    }

    public PKCS7(DerInputStream derInputStream) throws ParsingException {
        this.parse(derInputStream);
    }

    public PKCS7(byte[] byArray) throws ParsingException {
        try {
            DerInputStream derInputStream = new DerInputStream(byArray);
            this.parse(derInputStream);
        }
        catch (IOException iOException) {
            ParsingException parsingException = new ParsingException("Unable to parse the encoded bytes");
            parsingException.initCause(iOException);
            throw parsingException;
        }
    }

    private void parse(DerInputStream derInputStream) throws ParsingException {
        try {
            derInputStream.mark(derInputStream.available());
            this.parse(derInputStream, false);
        }
        catch (IOException iOException) {
            try {
                derInputStream.reset();
                this.parse(derInputStream, true);
                this.oldStyle = true;
            }
            catch (IOException iOException2) {
                ParsingException parsingException = new ParsingException(iOException2.getMessage());
                parsingException.initCause(iOException2);
                throw parsingException;
            }
        }
    }

    private void parse(DerInputStream derInputStream, boolean bl2) throws IOException {
        this.contentInfo = new ContentInfo(derInputStream, bl2);
        this.contentType = this.contentInfo.contentType;
        DerValue derValue = this.contentInfo.getContent();
        if (this.contentType.equals(ContentInfo.SIGNED_DATA_OID)) {
            this.parseSignedData(derValue);
        } else if (this.contentType.equals(ContentInfo.OLD_SIGNED_DATA_OID)) {
            this.parseOldSignedData(derValue);
        } else if (this.contentType.equals(ContentInfo.NETSCAPE_CERT_SEQUENCE_OID)) {
            this.parseNetscapeCertChain(derValue);
        } else {
            throw new ParsingException("content type " + this.contentType + " not supported.");
        }
    }

    public PKCS7(AlgorithmId[] algorithmIdArray, ContentInfo contentInfo, X509Certificate[] x509CertificateArray, SignerInfo[] signerInfoArray) {
        this.version = BigInteger.ONE;
        this.digestAlgorithmIds = algorithmIdArray;
        this.contentInfo = contentInfo;
        this.certificates = x509CertificateArray;
        this.signerInfos = signerInfoArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseNetscapeCertChain(DerValue derValue) throws ParsingException, IOException {
        DerInputStream derInputStream = new DerInputStream(derValue.toByteArray());
        DerValue[] derValueArray = derInputStream.getSequence(2);
        this.certificates = new X509Certificate[derValueArray.length];
        CertificateFactory certificateFactory = null;
        try {
            certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
        int n2 = 0;
        while (true) {
            block13: {
                Object var11_10;
                if (n2 >= derValueArray.length) {
                    return;
                }
                ByteArrayInputStream byteArrayInputStream = null;
                try {
                    try {
                        if (certificateFactory == null) {
                            this.certificates[n2] = new X509CertImpl(derValueArray[n2]);
                        } else {
                            byte[] byArray = derValueArray[n2].toByteArray();
                            byteArrayInputStream = new ByteArrayInputStream(byArray);
                            this.certificates[n2] = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
                            byteArrayInputStream.close();
                            byteArrayInputStream = null;
                        }
                    }
                    catch (CertificateException certificateException) {
                        ParsingException parsingException = new ParsingException(certificateException.getMessage());
                        parsingException.initCause(certificateException);
                        throw parsingException;
                    }
                    catch (IOException iOException) {
                        ParsingException parsingException = new ParsingException(iOException.getMessage());
                        parsingException.initCause(iOException);
                        throw parsingException;
                    }
                    var11_10 = null;
                    if (byteArrayInputStream == null) break block13;
                }
                catch (Throwable throwable) {
                    var11_10 = null;
                    if (byteArrayInputStream != null) {
                        byteArrayInputStream.close();
                    }
                    throw throwable;
                }
                byteArrayInputStream.close();
            }
            ++n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseSignedData(DerValue derValue) throws ParsingException, IOException {
        byte[] byArray;
        Object object;
        int n2;
        DerValue[] derValueArray;
        DerInputStream derInputStream = derValue.toDerInputStream();
        this.version = derInputStream.getBigInteger();
        DerValue[] derValueArray2 = derInputStream.getSet(1);
        int n3 = derValueArray2.length;
        this.digestAlgorithmIds = new AlgorithmId[n3];
        try {
            int n4 = 0;
            while (n4 < n3) {
                derValueArray = derValueArray2[n4];
                this.digestAlgorithmIds[n4] = AlgorithmId.parse((DerValue)derValueArray);
                ++n4;
            }
        }
        catch (IOException iOException) {
            ParsingException parsingException = new ParsingException("Error parsing digest AlgorithmId IDs: " + iOException.getMessage());
            parsingException.initCause(iOException);
            throw parsingException;
        }
        this.contentInfo = new ContentInfo(derInputStream);
        CertificateFactory certificateFactory = null;
        try {
            certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
        if ((byte)derInputStream.peekByte() == -96) {
            derValueArray = derInputStream.getSet(2, true);
            n3 = derValueArray.length;
            this.certificates = new X509Certificate[n3];
            n2 = 0;
            while (n2 < n3) {
                block27: {
                    Object var13_16;
                    object = null;
                    try {
                        try {
                            if (certificateFactory == null) {
                                this.certificates[n2] = new X509CertImpl(derValueArray[n2]);
                            } else {
                                byArray = derValueArray[n2].toByteArray();
                                object = new ByteArrayInputStream(byArray);
                                this.certificates[n2] = (X509Certificate)certificateFactory.generateCertificate((InputStream)object);
                                ((ByteArrayInputStream)object).close();
                                object = null;
                            }
                        }
                        catch (CertificateException certificateException) {
                            ParsingException parsingException = new ParsingException(certificateException.getMessage());
                            parsingException.initCause(certificateException);
                            throw parsingException;
                        }
                        catch (IOException iOException) {
                            ParsingException parsingException = new ParsingException(iOException.getMessage());
                            parsingException.initCause(iOException);
                            throw parsingException;
                        }
                        var13_16 = null;
                        if (object == null) break block27;
                    }
                    catch (Throwable throwable) {
                        var13_16 = null;
                        if (object != null) {
                            ((ByteArrayInputStream)object).close();
                        }
                        throw throwable;
                    }
                    ((ByteArrayInputStream)object).close();
                }
                ++n2;
            }
        }
        if ((byte)derInputStream.peekByte() == -95) {
            derValueArray = derInputStream.getSet(1, true);
            n3 = derValueArray.length;
            this.crls = new X509CRL[n3];
            n2 = 0;
            while (n2 < n3) {
                block29: {
                    Object var15_22;
                    object = null;
                    try {
                        try {
                            if (certificateFactory == null) {
                                this.crls[n2] = new X509CRLImpl(derValueArray[n2]);
                            } else {
                                byArray = derValueArray[n2].toByteArray();
                                object = new ByteArrayInputStream(byArray);
                                this.crls[n2] = (X509CRL)certificateFactory.generateCRL((InputStream)object);
                                ((ByteArrayInputStream)object).close();
                                object = null;
                            }
                        }
                        catch (CRLException cRLException) {
                            ParsingException parsingException = new ParsingException(cRLException.getMessage());
                            parsingException.initCause(cRLException);
                            throw parsingException;
                        }
                        var15_22 = null;
                        if (object == null) break block29;
                    }
                    catch (Throwable throwable) {
                        var15_22 = null;
                        if (object != null) {
                            ((ByteArrayInputStream)object).close();
                        }
                        throw throwable;
                    }
                    ((ByteArrayInputStream)object).close();
                }
                ++n2;
            }
        }
        derValueArray = derInputStream.getSet(1);
        n3 = derValueArray.length;
        this.signerInfos = new SignerInfo[n3];
        n2 = 0;
        while (n2 < n3) {
            object = derValueArray[n2].toDerInputStream();
            this.signerInfos[n2] = new SignerInfo((DerInputStream)object);
            ++n2;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseOldSignedData(DerValue derValue) throws ParsingException, IOException {
        Object object;
        DerValue[] derValueArray;
        DerInputStream derInputStream = derValue.toDerInputStream();
        this.version = derInputStream.getBigInteger();
        DerValue[] derValueArray2 = derInputStream.getSet(1);
        int n2 = derValueArray2.length;
        this.digestAlgorithmIds = new AlgorithmId[n2];
        try {
            int n3 = 0;
            while (n3 < n2) {
                derValueArray = derValueArray2[n3];
                this.digestAlgorithmIds[n3] = AlgorithmId.parse((DerValue)derValueArray);
                ++n3;
            }
        }
        catch (IOException iOException) {
            throw new ParsingException("Error parsing digest AlgorithmId IDs");
        }
        this.contentInfo = new ContentInfo(derInputStream, true);
        CertificateFactory certificateFactory = null;
        try {
            certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
        derValueArray = derInputStream.getSet(2);
        n2 = derValueArray.length;
        this.certificates = new X509Certificate[n2];
        int n4 = 0;
        while (true) {
            block17: {
                Object var13_15;
                if (n4 >= n2) break;
                object = null;
                try {
                    try {
                        if (certificateFactory == null) {
                            this.certificates[n4] = new X509CertImpl(derValueArray[n4]);
                        } else {
                            byte[] byArray = derValueArray[n4].toByteArray();
                            object = new ByteArrayInputStream(byArray);
                            this.certificates[n4] = (X509Certificate)certificateFactory.generateCertificate((InputStream)object);
                            ((ByteArrayInputStream)object).close();
                            object = null;
                        }
                    }
                    catch (CertificateException certificateException) {
                        ParsingException parsingException = new ParsingException(certificateException.getMessage());
                        parsingException.initCause(certificateException);
                        throw parsingException;
                    }
                    catch (IOException iOException) {
                        ParsingException parsingException = new ParsingException(iOException.getMessage());
                        parsingException.initCause(iOException);
                        throw parsingException;
                    }
                    var13_15 = null;
                    if (object == null) break block17;
                }
                catch (Throwable throwable) {
                    var13_15 = null;
                    if (object != null) {
                        ((ByteArrayInputStream)object).close();
                    }
                    throw throwable;
                }
                ((ByteArrayInputStream)object).close();
            }
            ++n4;
        }
        derInputStream.getSet(0);
        object = derInputStream.getSet(1);
        n2 = ((DerValue[])object).length;
        this.signerInfos = new SignerInfo[n2];
        int n5 = 0;
        while (n5 < n2) {
            DerInputStream derInputStream2 = object[n5].toDerInputStream();
            this.signerInfos[n5] = new SignerInfo(derInputStream2, true);
            ++n5;
        }
        return;
    }

    public void encodeSignedData(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        this.encodeSignedData(derOutputStream);
        outputStream.write(derOutputStream.toByteArray());
    }

    public void encodeSignedData(DerOutputStream derOutputStream) throws IOException {
        DerEncoder[] derEncoderArray;
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(this.version);
        derOutputStream2.putOrderedSetOf((byte)49, this.digestAlgorithmIds);
        this.contentInfo.encode(derOutputStream2);
        if (this.certificates != null && this.certificates.length != 0) {
            derEncoderArray = new X509CertImpl[this.certificates.length];
            int n2 = 0;
            while (n2 < this.certificates.length) {
                if (this.certificates[n2] instanceof X509CertImpl) {
                    derEncoderArray[n2] = (X509CertImpl)this.certificates[n2];
                } else {
                    try {
                        byte[] byArray = this.certificates[n2].getEncoded();
                        derEncoderArray[n2] = new X509CertImpl(byArray);
                    }
                    catch (CertificateException certificateException) {
                        IOException iOException = new IOException(certificateException.getMessage());
                        iOException.initCause(certificateException);
                        throw iOException;
                    }
                }
                ++n2;
            }
            derOutputStream2.putOrderedSetOf((byte)-96, derEncoderArray);
        }
        derOutputStream2.putOrderedSetOf((byte)49, this.signerInfos);
        derEncoderArray = new DerValue(48, derOutputStream2.toByteArray());
        ContentInfo contentInfo = new ContentInfo(ContentInfo.SIGNED_DATA_OID, (DerValue)derEncoderArray);
        contentInfo.encode(derOutputStream);
    }

    public SignerInfo verify(SignerInfo signerInfo, byte[] byArray) throws NoSuchAlgorithmException, SignatureException {
        return signerInfo.verify(this, byArray);
    }

    public SignerInfo[] verify(byte[] byArray) throws NoSuchAlgorithmException, SignatureException {
        Object object;
        Vector vector = new Vector();
        int n2 = 0;
        while (n2 < this.signerInfos.length) {
            object = this.verify(this.signerInfos[n2], byArray);
            if (object != null) {
                vector.addElement(object);
            }
            ++n2;
        }
        if (vector.size() != 0) {
            object = new SignerInfo[vector.size()];
            vector.copyInto((Object[])object);
            return object;
        }
        return null;
    }

    public SignerInfo[] verify() throws NoSuchAlgorithmException, SignatureException {
        return this.verify(null);
    }

    public BigInteger getVersion() {
        return this.version;
    }

    public AlgorithmId[] getDigestAlgorithmIds() {
        return this.digestAlgorithmIds;
    }

    public ContentInfo getContentInfo() {
        return this.contentInfo;
    }

    public X509Certificate[] getCertificates() {
        if (this.certificates != null) {
            return (X509Certificate[])this.certificates.clone();
        }
        return null;
    }

    public X509CRL[] getCRLs() {
        if (this.crls != null) {
            return (X509CRL[])this.crls.clone();
        }
        return null;
    }

    public SignerInfo[] getSignerInfos() {
        return this.signerInfos;
    }

    public X509Certificate getCertificate(BigInteger bigInteger, X500Name x500Name) {
        if (this.certificates != null) {
            if (this.certIssuerNames == null) {
                this.populateCertIssuerNames();
            }
            int n2 = 0;
            while (n2 < this.certificates.length) {
                X509Certificate x509Certificate = this.certificates[n2];
                BigInteger bigInteger2 = x509Certificate.getSerialNumber();
                if (bigInteger.equals(bigInteger2) && x500Name.equals(this.certIssuerNames[n2])) {
                    return x509Certificate;
                }
                ++n2;
            }
        }
        return null;
    }

    private void populateCertIssuerNames() {
        if (this.certificates == null) {
            return;
        }
        this.certIssuerNames = new Principal[this.certificates.length];
        int n2 = 0;
        while (n2 < this.certificates.length) {
            X509Certificate x509Certificate = this.certificates[n2];
            Principal principal = x509Certificate.getIssuerDN();
            if (!(principal instanceof X500Name)) {
                try {
                    X509CertInfo x509CertInfo = new X509CertInfo(x509Certificate.getTBSCertificate());
                    principal = (Principal)x509CertInfo.get("issuer.dname");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.certIssuerNames[n2] = principal;
            ++n2;
        }
    }

    public String toString() {
        int n2;
        String string = "";
        string = string + this.contentInfo + "\n";
        if (this.version != null) {
            string = string + "PKCS7 :: version: " + Debug.toHexString(this.version) + "\n";
        }
        if (this.digestAlgorithmIds != null) {
            string = string + "PKCS7 :: digest AlgorithmIds: \n";
            n2 = 0;
            while (n2 < this.digestAlgorithmIds.length) {
                string = string + "\t" + this.digestAlgorithmIds[n2] + "\n";
                ++n2;
            }
        }
        if (this.certificates != null) {
            string = string + "PKCS7 :: certificates: \n";
            n2 = 0;
            while (n2 < this.certificates.length) {
                string = string + "\t" + n2 + ".   " + this.certificates[n2] + "\n";
                ++n2;
            }
        }
        if (this.crls != null) {
            string = string + "PKCS7 :: crls: \n";
            n2 = 0;
            while (n2 < this.crls.length) {
                string = string + "\t" + n2 + ".   " + this.crls[n2] + "\n";
                ++n2;
            }
        }
        if (this.signerInfos != null) {
            string = string + "PKCS7 :: signer infos: \n";
            n2 = 0;
            while (n2 < this.signerInfos.length) {
                string = string + "\t" + n2 + ".  " + this.signerInfos[n2] + "\n";
                ++n2;
            }
        }
        return string;
    }

    public boolean isOldStyle() {
        return this.oldStyle;
    }
}

