/*
 * Decompiled with CFR 0.152.
 */
package sun.security.tools;

import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.text.MessageFormat;
import sun.security.tools.PolicyTool;
import sun.security.tools.ToolDialog;
import sun.security.tools.ToolWindow;

class FileMenuListener
implements ActionListener {
    private PolicyTool tool;
    private ToolWindow tw;

    FileMenuListener(PolicyTool policyTool, ToolWindow toolWindow) {
        this.tool = policyTool;
        this.tw = toolWindow;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block17: {
            if (PolicyTool.collator.compare(actionEvent.getActionCommand(), ToolWindow.QUIT) == 0) {
                ToolDialog toolDialog = new ToolDialog(PolicyTool.rb.getString("Save Changes"), this.tool, this.tw, true);
                toolDialog.displayUserSave(1);
            } else if (PolicyTool.collator.compare(actionEvent.getActionCommand(), ToolWindow.NEW_POLICY_FILE) == 0) {
                ToolDialog toolDialog = new ToolDialog(PolicyTool.rb.getString("Save Changes"), this.tool, this.tw, true);
                toolDialog.displayUserSave(2);
            } else if (PolicyTool.collator.compare(actionEvent.getActionCommand(), ToolWindow.OPEN_POLICY_FILE) == 0) {
                ToolDialog toolDialog = new ToolDialog(PolicyTool.rb.getString("Save Changes"), this.tool, this.tw, true);
                toolDialog.displayUserSave(3);
            } else if (PolicyTool.collator.compare(actionEvent.getActionCommand(), ToolWindow.SAVE_POLICY_FILE) == 0) {
                String string = ((TextField)this.tw.getComponent(1)).getText();
                if (string == null || string.length() == 0) {
                    ToolDialog toolDialog = new ToolDialog(PolicyTool.rb.getString("Save As"), this.tool, this.tw, true);
                    toolDialog.displaySaveAsDialog(0);
                } else {
                    try {
                        this.tool.savePolicy(string);
                        MessageFormat messageFormat = new MessageFormat(PolicyTool.rb.getString("Policy successfully written to filename"));
                        Object[] objectArray = new Object[]{string};
                        this.tw.displayStatusDialog(null, messageFormat.format(objectArray));
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        if (string == null || string.equals("")) {
                            this.tw.displayErrorDialog(null, new FileNotFoundException(PolicyTool.rb.getString("null filename")));
                            break block17;
                        }
                        MessageFormat messageFormat = new MessageFormat(PolicyTool.rb.getString("filename not found"));
                        Object[] objectArray = new Object[]{string};
                        this.tw.displayErrorDialog(null, new FileNotFoundException(messageFormat.format(objectArray)));
                    }
                    catch (Exception exception) {
                        this.tw.displayErrorDialog(null, exception);
                    }
                }
            } else if (PolicyTool.collator.compare(actionEvent.getActionCommand(), ToolWindow.SAVE_AS_POLICY_FILE) == 0) {
                ToolDialog toolDialog = new ToolDialog(PolicyTool.rb.getString("Save As"), this.tool, this.tw, true);
                toolDialog.displaySaveAsDialog(0);
            } else if (PolicyTool.collator.compare(actionEvent.getActionCommand(), ToolWindow.VIEW_WARNINGS) == 0) {
                this.tw.displayWarningLog(null);
            }
        }
    }
}

