/*     
 **********************************************************************
 *     common.h
 *     Copyright 1999, 2000 Creative Labs, Inc. 
 * 
 ********************************************************************** 
 * 
 *     Date                 Author          Summary of changes 
 *     ----                 ------          ------------------ 
 *     October 20, 1999     Bertrand Lee    base code release 
 * 
 ********************************************************************** 
 * 
 *     This program is free software; you can redistribute it and/or 
 *     modify it under the terms of the GNU General Public License as 
 *     published by the Free Software Foundation; either version 2 of 
 *     the License, or (at your option) any later version. 
 * 
 *     This program is distributed in the hope that it will be useful, 
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *     GNU General Public License for more details. 
 * 
 *     You should have received a copy of the GNU General Public 
 *     License along with this program; if not, write to the Free 
 *     Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, 
 *     USA. 
 * 
 ********************************************************************** 
 */ 

#ifndef _MYCOMMON_H
#define _MYCOMMON_H

/* Linux 2.0 compatibility stuff */

#define __init
#define __initdata
#define __initfunc(x) x

#define access_ok(x,y,z) (!verify_area(x,y,z))

#define signal_pending(x) ((x)->signal & ~(x)->blocked)

#undef put_user
#undef get_user

#define put_user(x,ptr) ({ __put_user((unsigned long)(x),(ptr),sizeof(*(ptr))); 0; })
#define get_user(x,ptr) ({ x = ((__typeof__(*(ptr)))__get_user((ptr),sizeof(*(ptr)))); 0; })

#define put_user_ret(x,ptr,ret) ({ if (put_user(x,ptr)) return ret; })
#define get_user_ret(x,ptr,ret) ({ if (get_user(x,ptr)) return ret; })

/* extern function prototypes */
int copy_from_user(void *to, const void *from, unsigned long n);
int copy_to_user(void *to, const void *from, unsigned long n);

/* extern global variables */
extern struct sblive_hw * sblive_devs;
extern struct file_operations emu10k1_audio_fops;
extern struct file_operations emu10k1_dac_fops;
extern struct file_operations emu10k1_mixer_fops;
extern struct file_operations emu10k1_midi_fops;
extern struct file_operations emu10k1_sndstat_fops;

#endif /* _MYCOMMON_H */
