    /*

    $Id: kfax.h,v 1.34 2002/08/11 20:49:09 nhasan Exp $

    Requires the Qt widget libraries, available at no cost at
    http://www.troll.no

    Copyright (C) 1997 Bernd Johannes Wuebben
                       wuebben@math.cornell.edu


    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */

#ifndef _KFAX_H_
#define _KFAX_H_

#include <qptrlist.h>
#include <qstring.h>

#include <qpopupmenu.h>
#include <qmenubar.h>
#include <qapplication.h>
#include <qkeycode.h>
#include <qaccel.h>
#include <qobject.h>
#include <qmultilineedit.h>
#include <qradiobutton.h>
#include <qfiledialog.h>
#include <qcheckbox.h>
#include <qgroupbox.h>
#include <qtooltip.h>
#include <qregexp.h>
#include <qprinter.h>

#include <kapplication.h>
#include <kconfig.h>
#include <ktoolbar.h>
#include <kstatusbar.h>
#include <kmainwindow.h>
#include <kurl.h>
#include <kaction.h>

#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/keysym.h>
#include <X11/keysymdef.h>
#include <X11/cursorfont.h>

#include "faxexpand.h"

#include "print.h"
#include "options.h"

#define Pimage(p)	((XImage *)(p)->extra)

// StatusBar field IDs
#define ID_LINE_COLUMN 1
#define ID_INS_OVR 2
#define ID_GENERAL 3
#define ID_FNAME 4
#define ID_TYPE 5
#define ID_PAGE_NO 6

typedef KToolBar::BarPosition BarPosition;

class MyApp:public KApplication {
public:
   virtual bool x11EventFilter( XEvent * );
};

class TopLevel : public KMainWindow
{
    Q_OBJECT


public:

    TopLevel( QWidget *parent=0, const char *name=0 );
    ~TopLevel();

    void openNetFile( const KURL& _url);
    void saveNetFile( const KURL& _url );

    static QPtrList<TopLevel> windowList;
    QPopupMenu *right_mouse_button, *colors;

    void handle_X_event(XEvent Event);
    void putImage();

protected:

    void resizeEvent(QResizeEvent *);
	void wheelEvent( QWheelEvent * );
    void dropEvent( QDropEvent * event );

    void updateActions();
    void updateGoActions();
    void updateZoomActions();

    void zoom( int );

    void readSettings();
    void writeSettings();
    void setupActions();
    void setupMenuBar();
    void setupToolBar();
    void setupEditWidget();
    void setupStatusBar();

    bool queryClose();

private:

    QFrame *faxqtwin;

    int indentID;
    KMenuBar *menubar;
    KToolBar *toolbar;
    QColor forecolor;
    QColor backcolor;

    KURL fileURL;
    KStatusBar *statusbar;

    KRecentFilesAction *actRecent;
    KToggleAction *actStatus;
    KAction *actAdd, *actSave, *actSaveAs, *actPrint;
    KAction *actSize, *actZoomIn, *actZoomOut, *actRotate, *actMirror;
    KAction *actFlip, *actNext, *actPrev, *actFirst, *actLast;

    int open_mode;
    int editor_width;
    int editor_height;

    KConfig *config;
    QString lastDir;

    QScrollBar *	hsb;
    QScrollBar *	vsb;
    QFrame* 	mainpane;

    PrintDialog * printdialog;
    struct printinfo pi;

public slots:

    void faxOpen( const KURL &  );
    void faxOpen();
    void faxAdd();
    void faxAdd( const KURL & );
    void faxClose();
    void print();
    void zoomin();
    void zoomout();
    void actualSize();
    void resizeView();
    void faxSave();
    void faxSaveAs();
    void toggleStatusBar();

    void faxoptions();
    void rotatePage();
    void mirrorPage();
    void flipPage();
    void nextPage();
    void prevPage();
    void newPage();
    void firstPage();
    void lastPage();
    void uiUpdate();

    void openadd(QString filename);
    void printIt();
    void FreeFax();
    void scrollHorz(int);
    void scrollVert(int);
};

void kfaxerror(const QString&, const QString&);

#endif
