# Makefile for the Netwide Assembler under 32-bit DOS(tm)
#
# The Netwide Assembler is copyright (C) 1996 Simon Tatham and
# Julian Hall. All rights reserved. The software is
# redistributable under the licence given in the file "Licence"
# distributed in the NASM archive.
#
# This Makefile is designed to build NASM using the 32-bit WIN32 C
# compiler Symantec(tm) C++ 7.5, provided you have a MAKE-utility
# that's compatible to SMAKE.

CC = sc
CCFLAGS = -c -a1 -mx -Nc -w2 -w7 -o+time -5
# -5            optimize for pentium (tm)
# -c            compile only
# -o-all        no optimizations (to avoid problems in disasm.c)
# -o+time       optimize for speed
# -o+space      optimize for size
# -A1           byte alignment for structures
# -mn           compile for Win32 executable
# -mx           compile for DOS386 (DOSX) executable
# -Nc           create COMDAT records
# -w2           possible unattended assignment: off
# -w7           for loops with empty instruction-body

LINK = link
LINKFLAGS = /noi /exet:DOSX
# /noignorecase all symbols are case-sensitive
# /exet:NT      Exetype: NT (Win32)
# /exet:DOSX    Exetype: DOSX (DOS32)
# /su:console   Subsystem: Console (Console-App)

LIBRARIES =
EXE = .exe
OBJ = obj

.c.$(OBJ):
        $(CC) $(CCFLAGS) $*.c


#
# modules needed for different programs
#

NASMOBJS = nasm.$(OBJ) nasmlib.$(OBJ) float.$(OBJ) insnsa.$(OBJ) \
           assemble.$(OBJ) labels.$(OBJ) parser.$(OBJ) outform.$(OBJ) \
	   output/outbin.$(OBJ) output/outaout.$(OBJ) output/outcoff.$(OBJ) output/outelf.$(OBJ) \
	   output/outobj.$(OBJ) output/outas86.$(OBJ) output/outrdf.$(OBJ) output/outrdf2.$(OBJ) \
	   output/outieee.$(OBJ) output/outdbg.$(OBJ) \
	   preproc.$(OBJ) listing.$(OBJ) eval.$(OBJ)

NDISASMOBJS = ndisasm.$(OBJ) disasm.$(OBJ) sync.$(OBJ) nasmlib.$(OBJ) \
              insnsd.$(OBJ)


#
# programs to create
#

all : nasm$(EXE) ndisasm$(EXE)


#
# We have to have a horrible kludge here to get round the 128 character
# limit, as usual... we'll simply use LNK-files :)
#
nasm$(EXE): $(NASMOBJS)
        $(LINK) $(LINKFLAGS) @<<
cx.obj $(NASMOBJS)
nasm.exe
<<

ndisasm$(EXE): $(NDISASMOBJS)
        $(LINK) $(LINKFLAGS) @<<
cx.obj $(NDISASMOBJS)
ndisasm.exe
<<

#
# modules for programs
#
clean :
	del *.obj
	del nasm$(EXE)
	del ndisasm$(EXE)

#-- Magic hints to mkdep.pl --#
# @object-ending: ".$(OBJ)"
# @path-separator: "/"
#-- Everything below is generated by mkdep.pl - do not edit --#
assemble.$(OBJ): assemble.c insns.h assemble.h regvals.c nasm.h regs.h \
 insnsi.h nasmlib.h version.h
disasm.$(OBJ): disasm.c insns.h regs.c sync.h names.c nasm.h disasm.h regs.h \
 insnsn.c insnsi.h version.h regdis.c
eval.$(OBJ): eval.c nasm.h regs.h labels.h nasmlib.h version.h eval.h
float.$(OBJ): float.c nasm.h regs.h version.h
insnsa.$(OBJ): insnsa.c insns.h nasm.h regs.h insnsi.h version.h
insnsd.$(OBJ): insnsd.c insns.h nasm.h regs.h insnsi.h version.h
insnsn.$(OBJ): insnsn.c
labels.$(OBJ): labels.c nasm.h regs.h nasmlib.h version.h
listing.$(OBJ): listing.c listing.h nasm.h regs.h nasmlib.h version.h
macros.$(OBJ): macros.c
names.$(OBJ): names.c regs.c insnsn.c
nasm.$(OBJ): nasm.c listing.h preproc.h insns.h outform.h assemble.h \
 parser.h nasm.h regs.h labels.h insnsi.h nasmlib.h version.h eval.h
nasmlib.$(OBJ): nasmlib.c insns.h regs.c names.c nasm.h regs.h insnsn.c \
 insnsi.h nasmlib.h version.h
ndisasm.$(OBJ): ndisasm.c insns.h sync.h nasm.h disasm.h regs.h insnsi.h \
 nasmlib.h version.h
outform.$(OBJ): outform.c outform.h nasm.h regs.h version.h
output/outaout.$(OBJ): output/outaout.c outform.h nasm.h regs.h nasmlib.h \
 version.h
output/outas86.$(OBJ): output/outas86.c outform.h nasm.h regs.h nasmlib.h \
 version.h
output/outbin.$(OBJ): output/outbin.c outform.h nasm.h regs.h nasmlib.h \
 version.h
output/outcoff.$(OBJ): output/outcoff.c outform.h nasm.h regs.h nasmlib.h \
 version.h
output/outdbg.$(OBJ): output/outdbg.c outform.h nasm.h regs.h nasmlib.h \
 version.h
output/outelf.$(OBJ): output/outelf.c outform.h nasm.h regs.h nasmlib.h \
 version.h
output/outieee.$(OBJ): output/outieee.c outform.h nasm.h regs.h nasmlib.h \
 version.h
output/outobj.$(OBJ): output/outobj.c outform.h nasm.h regs.h nasmlib.h \
 version.h
output/outrdf.$(OBJ): output/outrdf.c outform.h nasm.h regs.h nasmlib.h \
 version.h
output/outrdf2.$(OBJ): output/outrdf2.c outform.h nasm.h regs.h nasmlib.h \
 version.h
parser.$(OBJ): parser.c insns.h parser.h nasm.h regs.h insnsi.h regflags.c \
 float.h nasmlib.h version.h
preproc.$(OBJ): preproc.c nasm.h macros.c regs.h nasmlib.h version.h
regdis.$(OBJ): regdis.c
regflags.$(OBJ): regflags.c
regs.$(OBJ): regs.c
regvals.$(OBJ): regvals.c
sync.$(OBJ): sync.c sync.h
