/* 
   Copyright (C) 2002 John Firebaugh <jfirebaugh@kde.org>
   Copyright (C) 2001 Christoph Cullmann <cullmann@kde.org>
   Copyright (C) 2001 Joseph Wenninger <jowenn@kde.org>
   Copyright (C) 1999 Jochen Wilhelmy <digisnap@cs.tu-berlin.de>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License version 2 as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#ifndef _SpellPlugin_H_
#define _SpellPlugin_H_

#include <kate/application.h>
#include <kate/documentmanager.h>
#include <kate/document.h>  
#include <kate/pluginconfiginterface.h>
#include <kate/pluginconfiginterfaceextension.h>
#include <kate/mainwindow.h>
#include <kate/plugin.h>
#include <kate/view.h>
#include <kate/viewmanager.h>

#include <kspell.h>
#include <klocale.h>
#include <kiconloader.h>

class SpellConfigPage : public Kate::PluginConfigPage
{
	Q_OBJECT
public:
	SpellConfigPage( QWidget* parent, KSpellConfig* config );
	~SpellConfigPage() {};
	void apply() {};  
      void reset () { ; };
    void defaults () { ; };
};

class SpellPlugin : public Kate::Plugin, Kate::PluginViewInterface, Kate::PluginConfigInterfaceExtension
{
	Q_OBJECT

public:
	SpellPlugin( QObject* parent, const char* name, const QStringList &args = QStringList() );
	~SpellPlugin();
	
	void addView (Kate::MainWindow *win);
  void removeView (Kate::MainWindow *win);  
                
  
    uint configPages () const { return 1; }
    Kate::PluginConfigPage *configPage (uint , QWidget *w, const char *name=0) {return new SpellConfigPage( w, m_kspellConfig );}
    QString configPageName(uint) const {return i18n("Spelling"); };
    QString configPageFullName(uint) const { return i18n("Spell Checker Behavior"); };
    QPixmap configPagePixmap (uint number = 0, int size = KIcon::SizeSmall) const { return BarIcon("spellcheck", size); };
  
public slots:
	void spellcheck();
	void ready();
	void misspelling( const QString&, const QStringList&, unsigned int );
	void corrected  ( const QString&, const QString&, unsigned int);
	void spellResult( const QString& );
	void spellCleanDone();

private:
	void locatePosition( uint pos, uint& line, uint& col );
	Kate::Document* m_currentDoc;
	KSpell*         m_kspell;
	KSpellConfig*   m_kspellConfig;
	int             m_mispellCount;
	int             m_replaceCount;     
  QPtrList<class PluginView> m_views; 
};

#endif // _SpellPlugin_H_
