/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2002 by Andreas Zehender
    email                : zehender@kde.org
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/


#include "pmraw.h"
#include "pmoutputdevice.h"
#include "pmxmlhelper.h"

#include "pmrawedit.h"
#include "pmmemento.h"

#include <kdebug.h>
#include "pmglobals.h"

#include <klocale.h>
#include <qtextstream.h>

PMRaw::PMRaw( )
      : Base( )
{
}

PMRaw::PMRaw( const QString& t )
   : Base( )
{
   m_code = t;
}

PMRaw::~PMRaw( )
{
}

QString PMRaw::description( ) const
{
   return i18n( "raw povray" );
}

void PMRaw::setCode( const QString& code )
{
   if( code != m_code )
   {
      if( m_pMemento )
         m_pMemento->addData( PMTRaw, PMCodeID, m_code );
      m_code = code;
   }
}

bool PMRaw::isA( PMObjectType t ) const
{
   if( t == PMTRaw )
      return true;
   return Base::isA( t );
}

void PMRaw::serialize( PMOutputDevice& dev ) const
{
   dev.writeLine( "//*PMRawBegin" );

   QString tmp = m_code;
   QTextStream str( &tmp, IO_ReadOnly );
   while( !str.atEnd( ) )
      dev.writeLine( str.readLine( ) );
   
   dev.writeLine( "//*PMRawEnd" );
}

void PMRaw::serialize( QDomElement& e, QDomDocument& doc ) const
{
   QDomText t = doc.createTextNode( m_code );
   e.appendChild( t );
}

void PMRaw::readAttributes( const PMXMLHelper& h )
{
   QDomNode e = h.element( ).firstChild( );
   if( e.isText( ) )
      m_code = e.toText( ).data( );
}

PMDialogEditBase* PMRaw::editWidget( QWidget* parent ) const
{
   return new PMRawEdit( parent );
}

void PMRaw::restoreMemento( PMMemento* s )
{
   PMMementoDataIterator it( s );
   PMMementoData* data;

   for( ; it.current( ); ++it )
   {
      data = it.current( );
      if( data->objectType( ) == PMTRaw )
      {
         switch( data->valueID( ) )
         {
            case PMCodeID:
               setCode( data->stringData( ) );
               break;
            default:
               kdError( PMArea ) << "Wrong ID in PMRaw::restoreMemento\n";
               break;
         }
      }
   }
   Base::restoreMemento( s );
}

