// zoom.cpp
//
// Part of KVIEWSHELL - A framework for multipage text/gfx viewers
//
// (C) 2002 Stefan Kebekus
// Distributed under the GPL

// Add header files alphabetically

#include <math.h>
#include <qstringlist.h>

#include "zoom.h"
#include "kviewpart.h" // we include that here for maximum/minimum zoom values

float zoomVals[] = {0.20, 0.33, 0.50, 0.75, 1.00, 1.25, 1.50, 2.00, 2.50, 0};

zoom::zoom(void)
{
  _zoomValue = 1.0;
  valNo      = 3; // 1.0 is 3rd entry in the list
  for(int i=0; zoomVals[i] != 0; i++) 
    valueNames << QString("%1%").arg(zoomVals[i]);
}


void zoom::setZoomValue(const QString &cval)
{
  float fval;

  // Remove a trailing '%', if any
  QString val = cval.stripWhiteSpace();
  if (val.right(1) == "%")
    val = val.left(val.length()-1).stripWhiteSpace();

  bool ok;
  fval = val.toFloat(&ok)/100.0;

  if (ok == true)
    setZoomValue(fval);
  else {
    emit(zoomNamesChanged(valueNames));
    emit(valNoChanged(valNo));
  }
}


void zoom::setZoomValue(float f)
{
  // Make sure _zoomValue is in the permissible range!
  if (f < ZoomLimits::MinZoom/1000.0)
    f = ZoomLimits::MinZoom/1000.0;
  if (f > ZoomLimits::MaxZoom/1000.0)
    f = ZoomLimits::MaxZoom/1000.0;
  _zoomValue = f;


  valueNames.clear();

  bool flag = false;
  for(int i=0; zoomVals[i] != 0; i++) {
    if ((_zoomValue <= zoomVals[i]) && (flag == false)) {
      flag  = true;
      valNo = i;
      if (fabs(_zoomValue-zoomVals[i]) > 0.01)
	valueNames << QString("%1%").arg((int)(_zoomValue*100.0+0.5));
    }
    valueNames << QString("%1%").arg((int)(zoomVals[i]*100.0+0.5));
  }

  if (flag == false) {
    valNo = valueNames.size();
    valueNames << QString("%1%").arg((int)(_zoomValue*100.0+0.5));
  }

  emit(zoomNamesChanged(valueNames));
  emit(valNoChanged(valNo));
}

float zoom::zoomIn(void)
{
  int i;
  for(i=0; zoomVals[i] != 0; i++) 
    if (zoomVals[i] > _zoomValue)
      return zoomVals[i];

  return zoomVals[i-1];
}

float zoom::zoomOut(void)
{
  float result = zoomVals[0];

  for(int i=0; zoomVals[i] != 0; i++) 
    if (_zoomValue > zoomVals[i])
      result = zoomVals[i];

  return result;
}

#include "zoom.moc"
