/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleIcon;
import javax.accessibility.AccessibleRelationSet;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleValue;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ButtonUI;
import javax.swing.text.AttributeSet;

public abstract class AbstractButton
extends JComponent
implements ItemSelectable,
SwingConstants {
    Icon default_icon;
    Icon pressed_button;
    Icon disabled_button;
    Icon selected_button;
    Icon disabled_selected_button;
    Icon current_icon;
    String text;
    int vert_align;
    int hori_align;
    int hori_text_pos;
    int vert_text_pos;
    boolean paint_border;
    boolean paint_focus;
    Action action_taken;
    ButtonModel model;
    Insets margin;
    public static final String FOCUS_PAINTED_CHANGED_PROPERTY = "focusPainted";

    private /* synthetic */ void finit$() {
        this.vert_align = 0;
        this.hori_align = 0;
        this.hori_text_pos = 0;
        this.vert_text_pos = 0;
        this.paint_border = true;
    }

    AbstractButton() {
        this("", null);
    }

    AbstractButton(String text, Icon icon) {
        this.finit$();
        this.text = text;
        this.setIcon(icon);
        this.setAlignmentX(0.0f);
        this.setAlignmentY(0.5f);
        this.addFocusListener(new JFocusListener(this));
        this.setModel(new DefaultButtonModel(this));
        this.updateUI();
    }

    public ButtonModel getModel() {
        return this.model;
    }

    public void setModel(ButtonModel newModel) {
        this.model = newModel;
    }

    public String getActionCommand() {
        return this.getModel().getActionCommand();
    }

    public void setActionCommand(String aCommand) {
        this.getModel().setActionCommand(aCommand);
    }

    public void addActionListener(ActionListener l) {
        this.getModel().addActionListener(l);
    }

    public void removeActionListener(ActionListener l) {
        this.getModel().removeActionListener(l);
    }

    public void addChangeListener(ChangeListener l) {
        this.getModel().addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.getModel().removeChangeListener(l);
    }

    public void addItemListener(ItemListener l) {
        this.getModel().addItemListener(l);
    }

    public void removeItemListener(ItemListener l) {
        this.getModel().removeItemListener(l);
    }

    public int getHorizontalAlignment() {
        return this.hori_align;
    }

    public int getHorizontalTextPosition() {
        return this.hori_text_pos;
    }

    public int getVerticalAlignment() {
        return this.vert_align;
    }

    public int getVerticalTextPosition() {
        return this.vert_text_pos;
    }

    protected void fireItemStateChanged(ItemEvent event) {
        this.getModel().fireItemStateChanged(event);
    }

    protected void fireStateChanged(ChangeEvent event) {
        this.getModel().fireStateChanged(event);
    }

    protected void fireActionPerformed(ActionEvent event) {
        this.getModel().fireActionPerformed(event);
    }

    public void setVerticalAlignment(int alignment) {
        this.vert_align = alignment;
    }

    public void setHorizontalAlignment(int alignment) {
        this.hori_align = alignment;
    }

    public void setVerticalTextPosition(int textPosition) {
        this.vert_text_pos = textPosition;
    }

    public void setHorizontalTextPosition(int textPosition) {
        this.hori_text_pos = textPosition;
    }

    public int getMnemonic() {
        return this.getModel().getMnemonic();
    }

    public void setMnemonic(char mne) {
        this.getModel().setMnemonic(mne);
    }

    public void setMnemonic(int mne) {
        this.getModel().setMnemonic(mne);
    }

    public void setRolloverEnabled(boolean b) {
        this.getModel().setRollover(b);
    }

    public boolean isRolloverEnabled() {
        return this.getModel().isRollover();
    }

    public boolean isBorderPainted() {
        return this.paint_border;
    }

    public void setBorderPainted(boolean b) {
        if (b != this.paint_border) {
            this.paint_border = b;
            this.revalidate();
            this.repaint();
        }
    }

    public Action getAction() {
        return this.action_taken;
    }

    public void setAction(Action a) {
        this.action_taken = a;
        this.revalidate();
        this.repaint();
    }

    public void setSelected(boolean b) {
        this.getModel().setSelected(b);
    }

    public boolean isSelected() {
        return this.getModel().isSelected();
    }

    public Icon getIcon() {
        return this.default_icon;
    }

    public void setIcon(Icon defaultIcon) {
        if (this.default_icon == defaultIcon) {
            return;
        }
        this.default_icon = defaultIcon;
        if (this.default_icon != null) {
            // empty if block
        }
        this.revalidate();
        this.repaint();
    }

    public String getText() {
        return this.text;
    }

    public void setLabel(String label) {
        this.setText(label);
    }

    public String getLabel() {
        return this.getText();
    }

    public void setText(String text) {
        this.text = text;
        this.revalidate();
        this.repaint();
    }

    public Insets getMargin() {
        return this.margin;
    }

    public void setMargin(Insets m) {
        this.margin = m;
        this.revalidate();
        this.repaint();
    }

    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.getModel().setEnabled(b);
        this.repaint();
    }

    public Icon getPressedIcon() {
        return this.pressed_button;
    }

    public void setPressedIcon(Icon pressedIcon) {
        this.pressed_button = pressedIcon;
        this.revalidate();
        this.repaint();
    }

    public Icon getDisabledIcon() {
        return this.disabled_button;
    }

    public void setDisabledIcon(Icon disabledIcon) {
        this.disabled_button = disabledIcon;
        this.revalidate();
        this.repaint();
    }

    public boolean isFocusPainted() {
        return this.paint_focus;
    }

    public void setFocusPainted(boolean b) {
        boolean old = this.paint_focus;
        this.paint_focus = b;
        this.firePropertyChange(FOCUS_PAINTED_CHANGED_PROPERTY, old, b);
        if (this.hasFocus()) {
            this.revalidate();
            this.repaint();
        }
    }

    public boolean isFocusTraversable() {
        return true;
    }

    protected int checkHorizontalKey(int key, String exception) {
        return 0;
    }

    protected int checkVerticalKey(int key, String exception) {
        return 0;
    }

    protected void configurePropertiesFromAction(Action a) {
    }

    protected ActionListener createActionListener() {
        return new ActionListener(this){
            private /* synthetic */ AbstractButton this$0;
            {
                this.this$0 = this$0;
            }

            public void actionPerformed(ActionEvent e) {
            }
        };
    }

    protected PropertyChangeListener createActionPropertyChangeListener(Action a) {
        return null;
    }

    protected ChangeListener createChangeListener() {
        return new ChangeListener(this){
            private /* synthetic */ AbstractButton this$0;
            {
                this.this$0 = this$0;
            }

            public void stateChanged(ChangeEvent e) {
            }
        };
    }

    protected ItemListener createItemListener() {
        return new ItemListener(this){
            private /* synthetic */ AbstractButton this$0;
            {
                this.this$0 = this$0;
            }

            public void itemStateChanged(ItemEvent e) {
            }
        };
    }

    public void doClick() {
        this.doClick(100);
    }

    public void doClick(int pressTime) {
    }

    public Icon getDisabledSelectedIcon() {
        return this.disabled_selected_button;
    }

    public Icon getRolloverIcon() {
        return null;
    }

    Icon getRolloverSelectedIcon() {
        return null;
    }

    Icon getSelectedIcon() {
        return this.selected_button;
    }

    public Object[] getSelectedObjects() {
        return null;
    }

    public boolean imageUpdate(Image img, int infoflags, int x, int y, int w, int h) {
        return this.current_icon == img;
    }

    public boolean isContentAreaFilled() {
        return false;
    }

    protected void paintBorder(Graphics g) {
        if (this.isBorderPainted()) {
            super.paintBorder(g);
        }
    }

    protected String paramString() {
        return "AbstractButton";
    }

    public void setContentAreaFilled(boolean b) {
    }

    public void setDisabledSelectedIcon(Icon disabledSelectedIcon) {
    }

    public void setRolloverIcon(Icon rolloverIcon) {
    }

    public void setRolloverSelectedIcon(Icon rolloverSelectedIcon) {
    }

    public void setSelectedIcon(Icon selectedIcon) {
    }

    public void setUI(ButtonUI ui) {
        super.setUI(ui);
    }

    public ButtonUI getUI() {
        return (ButtonUI)this.ui;
    }

    public void updateUI() {
    }

    protected void processActionEvent(ActionEvent e) {
        System.out.println("PROCESS-ACTION-EVENT: " + e);
    }

    protected void processMouseEvent(MouseEvent e) {
        switch (e.getID()) {
            case 503: {
                break;
            }
            case 501: {
                if (!this.isEnabled()) {
                    System.out.println("button not enabled, ignoring press");
                    break;
                }
                System.out.println("telling model:press: " + this.getModel());
                this.getModel().setPressed(true);
                this.repaint();
                break;
            }
            case 502: {
                if (!this.isEnabled()) {
                    System.out.println("button not enabled, ignoring release");
                    break;
                }
                int flags = 0;
                System.out.println("        XXX--> " + this.getActionCommand());
                this.fireActionPerformed(new ActionEvent(this, 1001, this.getActionCommand(), flags));
                this.getModel().setPressed(false);
                this.repaint();
                break;
            }
        }
    }

    private static class JFocusListener
    implements FocusListener {
        AbstractButton c;

        JFocusListener(AbstractButton c) {
            this.c = c;
        }

        public void focusLost(FocusEvent event) {
            this.c.getModel().setArmed(false);
            System.out.println("LOST FOCUS");
            if (this.c.isFocusPainted()) {
                this.c.repaint();
            }
        }

        public void focusGained(FocusEvent event) {
            System.out.println("GAIN FOCUS");
        }
    }

    protected abstract class AccessibleAbstractButton
    extends JComponent.AccessibleJComponent
    implements AccessibleAction,
    AccessibleValue,
    AccessibleText {
        private /* synthetic */ AbstractButton this$0;

        protected AccessibleAbstractButton(AbstractButton this$0, AbstractButton component) {
            this.this$0 = this$0;
            super(this$0, component);
        }

        public AccessibleStateSet getAccessibleStateSet() {
            return null;
        }

        public String getAccessibleName() {
            return null;
        }

        public AccessibleIcon[] getAccessibleIcon() {
            return null;
        }

        public AccessibleRelationSet getAccessibleRelationSet() {
            return null;
        }

        public AccessibleAction getAccessibleAction() {
            return null;
        }

        public AccessibleValue getAccessibleValue() {
            return null;
        }

        public int getAccessibleActionCount() {
            return 0;
        }

        public String getAccessibleActionDescription(int value0) {
            return null;
        }

        public boolean doAccessibleAction(int value0) {
            return false;
        }

        public Number getCurrentAccessibleValue() {
            return null;
        }

        public boolean setCurrentAccessibleValue(Number value0) {
            return false;
        }

        public Number getMinimumAccessibleValue() {
            return null;
        }

        public Number getMaximumAccessibleValue() {
            return null;
        }

        public AccessibleText getAccessibleText() {
            return null;
        }

        public int getIndexAtPoint(Point value0) {
            return 0;
        }

        public Rectangle getCharacterBounds(int value0) {
            return null;
        }

        public int getCharCount() {
            return 0;
        }

        public int getCaretPosition() {
            return 0;
        }

        public String getAtIndex(int value0, int value1) {
            return null;
        }

        public String getAfterIndex(int value0, int value1) {
            return null;
        }

        public String getBeforeIndex(int value0, int value1) {
            return null;
        }

        public AttributeSet getCharacterAttribute(int value0) {
            return null;
        }

        public int getSelectionStart() {
            return 0;
        }

        public int getSelectionEnd() {
            return 0;
        }

        public String getSelectedText() {
            return null;
        }

        private Rectangle getTextRectangle() {
            return null;
        }
    }
}

