//  (C) Copyright John Maddock 2006-7.
//  Use, modification and distribution are subject to the
//  Boost Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#define SC_(x) static_cast<T>(BOOST_JOIN(x, L))
   static const boost::array<boost::array<T, 4>, 619> poisson_quantile_data = {{
      {{ SC_(2.539736270904541015625), SC_(0.097540400922298431396484375), SC_(0.1236392659323415267286721455855935332272165776019), SC_(4.1794244675777288954971650240102219690023733491107) }}, 
      {{ SC_(2.539736270904541015625), SC_(0.12698681652545928955078125), SC_(0.29692152360861802647109703200927257466043783201072), SC_(3.8759279753758017243263560996428606489658831749751) }}, 
      {{ SC_(2.539736270904541015625), SC_(0.135477006435394287109375), SC_(0.34320650665410472759846385302850183249926507900385), SC_(3.7989374337321363992500232228194835442428384328783) }}, 
      {{ SC_(2.539736270904541015625), SC_(0.188381969928741455078125), SC_(0.60664513287123148932168996645967883616307670876159), SC_(3.3882631942049236108254497545125740345098947059879) }}, 
      {{ SC_(2.539736270904541015625), SC_(0.22103404998779296875), SC_(0.75418046769318689024626280510389922651894870065918), SC_(3.1760120980068421525868462530802458163753626136545) }}, 
      {{ SC_(2.539736270904541015625), SC_(0.278498232364654541015625), SC_(0.99696859994338450962602588461832487680146529935052), SC_(2.8498938646809092776273924660633540719728165148386) }}, 
      {{ SC_(2.539736270904541015625), SC_(0.308167040348052978515625), SC_(1.1167608396721874815750956320715232750965151590926), SC_(2.6983883556775732472454879863323713890715761900718) }}, 
      {{ SC_(2.539736270904541015625), SC_(0.546881496906280517578125), SC_(2.0537693974299930086549193836285319461125762366927), SC_(1.6814731149266990335114284112670893662702121211471) }}, 
      {{ SC_(2.539736270904541015625), SC_(0.54722058773040771484375), SC_(2.0551559213142958322292400766992089704970302823545), SC_(1.6801546387421272943620405150189924628945228748043) }}, 
      {{ SC_(2.539736270904541015625), SC_(0.6323592662811279296875), SC_(2.4185680589969635905362050596047384508137625647103), SC_(1.3504767355410436804577399289250217569583832425216) }}, 
      {{ SC_(2.539736270904541015625), SC_(0.814723670482635498046875), SC_(3.40979576665416423967927240319519423210777415296), SC_(0.59212166896088946445227134508857054551303877571874) }}, 
      {{ SC_(2.539736270904541015625), SC_(0.835008561611175537109375), SC_(3.5574160837993229129674267171557135101187245049205), SC_(0.49470169893324134464824483154133205955707995130386) }}, 
      {{ SC_(2.539736270904541015625), SC_(0.905791938304901123046875), SC_(4.2182796507799899023660816530562600398630233374474), SC_(0.1024923825265003493532574009232399351614327762936) }}, 
      {{ SC_(2.539736270904541015625), SC_(0.9133758544921875), SC_(4.3110965218524397562863677756993861813110388506657), SC_(0.052913915876507499928705143631874173069654329996695) }}, 
      {{ SC_(2.539736270904541015625), SC_(0.957506835460662841796875), SC_(5.0507514608729399450273591019931952059180132941558), SC_(0) }}, 
      {{ SC_(2.539736270904541015625), SC_(0.964888513088226318359375), SC_(5.2367753540079862352449652338334329394906217447274), SC_(0) }}, 
      {{ SC_(2.539736270904541015625), SC_(0.967694938182830810546875), SC_(5.3166351261369765913994722232174376733439995923696), SC_(0) }}, 
      {{ SC_(2.539736270904541015625), SC_(0.968867778778076171875), SC_(5.3518355852884420289078324978224092379400640232473), SC_(0) }}, 
      {{ SC_(2.539736270904541015625), SC_(0.992881298065185546875), SC_(6.6543700270027625401829056826390754932290120871122), SC_(0) }}, 
      {{ SC_(2.539736270904541015625), SC_(0.996461331844329833984375), SC_(7.2179591549437624231339827362963118968410984819945), SC_(0) }}, 
      {{ SC_(2.7095401287078857421875), SC_(0.097540400922298431396484375), SC_(0.22508778216127669860840111850046509049124774877757), SC_(4.4182474958341612963906186215326419021373601918705) }}, 
      {{ SC_(2.7095401287078857421875), SC_(0.12698681652545928955078125), SC_(0.40677008040551596304058142704984892724698474450013), SC_(4.1064853787719233590964661701263902837818258099719) }}, 
      {{ SC_(2.7095401287078857421875), SC_(0.135477006435394287109375), SC_(0.45520478103550794436443361181077958307722151443163), SC_(4.0273711840535234079944645222273276521046853333475) }}, 
      {{ SC_(2.7095401287078857421875), SC_(0.188381969928741455078125), SC_(0.73026636637142655390107377497566857551034902573012), SC_(3.6051688857008976555752955024438980784366442932919) }}, 
      {{ SC_(2.7095401287078857421875), SC_(0.22103404998779296875), SC_(0.88392938865124774766856751848756090706730082877896), SC_(3.3868160972875027862660476930182731527926765710517) }}, 
      {{ SC_(2.7095401287078857421875), SC_(0.278498232364654541015625), SC_(1.1363266606638255225600870950818167357150551989263), SC_(3.0511081900439111988365299857382083529598127860583) }}, 
      {{ SC_(2.7095401287078857421875), SC_(0.308167040348052978515625), SC_(1.2606742963136106218231304529313368491205193889367), SC_(2.8950505886875929318857627817878016223780947076715) }}, 
      {{ SC_(2.7095401287078857421875), SC_(0.546881496906280517578125), SC_(2.2302498177659995331854128657702572247393894330154), SC_(1.8455667973744983745400534580442630696797091911164) }}, 
      {{ SC_(2.7095401287078857421875), SC_(0.54722058773040771484375), SC_(2.2316813572100748575831704135004677863833315667374), SC_(1.8442033129697692145260467544769069766977784230154) }}, 
      {{ SC_(2.7095401287078857421875), SC_(0.6323592662811279296875), SC_(2.6066425574726804797128859441380116059728489734554), SC_(1.5029787332697810770934731568961824651116215294506) }}, 
      {{ SC_(2.7095401287078857421875), SC_(0.814723670482635498046875), SC_(3.6273147425851163791281437708804229061207906824314), SC_(0.71512622824161600897697849329545315475907647131057) }}, 
      {{ SC_(2.7095401287078857421875), SC_(0.835008561611175537109375), SC_(3.7791124414856923080281181724476436460102273386686), SC_(0.6135013062126620064849645584217989596131282386535) }}, 
      {{ SC_(2.7095401287078857421875), SC_(0.905791938304901123046875), SC_(4.458149225470369081990154475805206149000574987061), SC_(0.20287311758458663949375602873316329115587280439004) }}, 
      {{ SC_(2.7095401287078857421875), SC_(0.9133758544921875), SC_(4.5534558318934753192152596811095152683421397095551), SC_(0.15075014180575346658654817591045191201000083591655) }}, 
      {{ SC_(2.7095401287078857421875), SC_(0.957506835460662841796875), SC_(5.3124762617564144681154664570520183781853730044827), SC_(0) }}, 
      {{ SC_(2.7095401287078857421875), SC_(0.964888513088226318359375), SC_(5.5032495514669336956769948581208817037416052591602), SC_(0) }}, 
      {{ SC_(2.7095401287078857421875), SC_(0.967694938182830810546875), SC_(5.5851345768544450002123999306065943091761910601596), SC_(0) }}, 
      {{ SC_(2.7095401287078857421875), SC_(0.968867778778076171875), SC_(5.6212251836473331425223280696624241368486034858104), SC_(0) }}, 
      {{ SC_(2.7095401287078857421875), SC_(0.992881298065185546875), SC_(6.9557169597554463521475489005690610777985653849856), SC_(0) }}, 
      {{ SC_(2.7095401287078857421875), SC_(0.996461331844329833984375), SC_(7.5326167149449785832226654644205494408676203885886), SC_(0) }}, 
      {{ SC_(4.420680999755859375), SC_(0.097540400922298431396484375), SC_(1.3396974430145122585454495048468424419264320352618), SC_(6.7283438763148574872831791875332553675646602300523) }}, 
      {{ SC_(4.420680999755859375), SC_(0.12698681652545928955078125), SC_(1.5943593540803988177742830666052464453414946104313), SC_(6.3448231261522649376887252175402416326077522703472) }}, 
      {{ SC_(4.420680999755859375), SC_(0.135477006435394287109375), SC_(1.6614817168246804493298951704417179835901855738303), SC_(6.2472654728602887897097583831549812995898408080858) }}, 
      {{ SC_(4.420680999755859375), SC_(0.188381969928741455078125), SC_(2.0376543751759201428527313894139151409067294327461), SC_(5.7248971087658352374460042773698359549632379123834) }}, 
      {{ SC_(4.420680999755859375), SC_(0.22103404998779296875), SC_(2.2446654580224159831483586795367113208776510965331), SC_(5.4534959083816989610894577161849640688969105560161) }}, 
      {{ SC_(4.420680999755859375), SC_(0.278498232364654541015625), SC_(2.5807621352225720613600353790736865733555987348493), SC_(5.0343733155738426061839689866661543927206541851375) }}, 
      {{ SC_(4.420680999755859375), SC_(0.308167040348052978515625), SC_(2.7448014090272585998043938931292051157965186772885), SC_(4.8387030783940425933647257151827080974800390869268) }}, 
      {{ SC_(4.420680999755859375), SC_(0.546881496906280517578125), SC_(3.9981671065238395569228616860453130593511301850379), SC_(3.505557886377919314863622414565557140946176046497) }}, 
      {{ SC_(4.420680999755859375), SC_(0.54722058773040771484375), SC_(3.9999907952112765051305384945750961898928212599337), SC_(3.5038021853580386246245849220792764933302027406719) }}, 
      {{ SC_(4.420680999755859375), SC_(0.6323592662811279296875), SC_(4.4755370662322077623602403442109487298546581878422), SC_(3.0619503042413349619855086785373188956985791271542) }}, 
      {{ SC_(4.420680999755859375), SC_(0.814723670482635498046875), SC_(5.7523737088686858401558160403666922549379961143882), SC_(2.0171468551181771134675292909683635311884497032409) }}, 
      {{ SC_(4.420680999755859375), SC_(0.835008561611175537109375), SC_(5.9404758600780670389419577812214780175653318248418), SC_(1.8789308781841440866768183847400702725764547783367) }}, 
      {{ SC_(4.420680999755859375), SC_(0.905791938304901123046875), SC_(6.7773282414671410921194089695719498332958307210814), SC_(1.3082106170807083740259305077843340602783571584871) }}, 
      {{ SC_(4.420680999755859375), SC_(0.9133758544921875), SC_(6.8942396868242401403890538418965641039295675778748), SC_(1.2339961120705196611183391781202394749539268956262) }}, 
      {{ SC_(4.420680999755859375), SC_(0.957506835460662841796875), SC_(7.821171397040121531326100235432854843584195583282), SC_(0.69094012860886707349500955292069725225637764995336) }}, 
      {{ SC_(4.420680999755859375), SC_(0.964888513088226318359375), SC_(8.0530885584480679142446108828803234017581269318602), SC_(0.56731808338239770597650769892754973604608332843093) }}, 
      {{ SC_(4.420680999755859375), SC_(0.967694938182830810546875), SC_(8.1525139180463156301698889503244013413378449293097), SC_(0.51578894370664249604079957647423257412791686824297) }}, 
      {{ SC_(4.420680999755859375), SC_(0.968867778778076171875), SC_(8.1963130987087259540234241916685414899812024476517), SC_(0.49336751814322145986719340359087631907186828353415) }}, 
      {{ SC_(4.420680999755859375), SC_(0.992881298065185546875), SC_(9.8072204903950038451972661576396667151044904421196), SC_(0) }}, 
      {{ SC_(4.420680999755859375), SC_(0.996461331844329833984375), SC_(10.499064126433495605510366708137413205875937581042), SC_(0) }}, 
      {{ SC_(6.16334056854248046875), SC_(0.097540400922298431396484375), SC_(2.5859664957940427509461874565129963589589688820455), SC_(8.9677396315283840656695133479880083513730127930784) }}, 
      {{ SC_(6.16334056854248046875), SC_(0.12698681652545928955078125), SC_(2.9009052707869816176646796920701448375095847243642), SC_(8.5246979852837498907844353402131712031288982600956) }}, 
      {{ SC_(6.16334056854248046875), SC_(0.135477006435394287109375), SC_(2.9834873073877956898186146652279966961454909598226), SC_(8.4118358800599451811807869174788430578782924434124) }}, 
      {{ SC_(6.16334056854248046875), SC_(0.188381969928741455078125), SC_(3.4434473940957475393031850953584457336507982842966), SC_(7.8063058825992529562573105885942390515410053671404) }}, 
      {{ SC_(6.16334056854248046875), SC_(0.22103404998779296875), SC_(3.6947440371998811706376688689734496836804910176123), SC_(7.4908336084580067399217088801958960601472349863788) }}, 
      {{ SC_(6.16334056854248046875), SC_(0.278498232364654541015625), SC_(4.1003986170918594858212154600658981004419168067157), SC_(7.0023763806308351303214371446635601414005423798617) }}, 
      {{ SC_(6.16334056854248046875), SC_(0.308167040348052978515625), SC_(4.2974477654438552880411091482794630816925561264025), SC_(6.773765866135877963783975160673357749752284302202) }}, 
      {{ SC_(6.16334056854248046875), SC_(0.546881496906280517578125), SC_(5.787010458630218045453307890019107853613374669004), SC_(5.2045621740649474362284642896242201992956763546792) }}, 
      {{ SC_(6.16334056854248046875), SC_(0.54722058773040771484375), SC_(5.7891605475359960637402200827262721850213414058386), SC_(5.2024799770953642190662187080874369352416686100864) }}, 
      {{ SC_(6.16334056854248046875), SC_(0.6323592662811279296875), SC_(6.3484127404200322386357128405939431323418020518415), SC_(4.6768700753839711497025120757799358155271336141157) }}, 
      {{ SC_(6.16334056854248046875), SC_(0.814723670482635498046875), SC_(7.8382100591531846602632204646671089815370107201852), SC_(3.4184868779947421662049228866392881111264871883922) }}, 
      {{ SC_(6.16334056854248046875), SC_(0.835008561611175537109375), SC_(8.0564604740815217756792989543682072856102195403887), SC_(3.249927919219838912312004297710792201709906833035) }}, 
      {{ SC_(6.16334056854248046875), SC_(0.905791938304901123046875), SC_(9.0242548268313231135791705274880817528987452046331), SC_(2.546833600350249575523714984244661229551120215356) }}, 
      {{ SC_(6.16334056854248046875), SC_(0.9133758544921875), SC_(9.1590772218426733681824215132720634022321809844007), SC_(2.4544140197883858708871454148128370305443415093863) }}, 
      {{ SC_(6.16334056854248046875), SC_(0.957506835460662841796875), SC_(10.225083255031436688172872083431154610023237781531), SC_(1.7687703501583610989862012375744075325036292087893) }}, 
      {{ SC_(6.16334056854248046875), SC_(0.964888513088226318359375), SC_(10.4910429250481057791237409707808406346128053259), SC_(1.6098130786280943639536169387760851064572555054941) }}, 
      {{ SC_(6.16334056854248046875), SC_(0.967694938182830810546875), SC_(10.604976902691218462157184835908874666143712716419), SC_(1.5431584901383285765046885291630022889777753672441) }}, 
      {{ SC_(6.16334056854248046875), SC_(0.968867778778076171875), SC_(10.655151475679068385512795414161210208803633817441), SC_(1.5140772460337891512212722486771665938457620462142) }}, 
      {{ SC_(6.16334056854248046875), SC_(0.992881298065185546875), SC_(12.494340063197501309164691406113117041284264416324), SC_(0.56048583005652240145806181713152405901286812442296) }}, 
      {{ SC_(6.16334056854248046875), SC_(0.996461331844329833984375), SC_(13.280923712753769694525962616630864161646653800287), SC_(0.21853569573931151163702946751408199066277444874014) }}, 
      {{ SC_(12.64718532562255859375), SC_(0.097540400922298431396484375), SC_(7.6711344139619895804514836536337678481450584324878), SC_(16.850130506171469776115421283509726284859353740057) }}, 
      {{ SC_(12.64718532562255859375), SC_(0.12698681652545928955078125), SC_(8.1547201535699795154298162845407243435126798222898), SC_(16.239558767405175964277904784404123282695495538226) }}, 
      {{ SC_(12.64718532562255859375), SC_(0.135477006435394287109375), SC_(8.2806286612811708041050143926320891533309017112699), SC_(16.083604033627550690555794926242036728995081942033) }}, 
      {{ SC_(12.64718532562255859375), SC_(0.188381969928741455078125), SC_(8.9758211019641177392680430710427599425163839792393), SC_(15.243808985147436406129215519216902152197904088285) }}, 
      {{ SC_(12.64718532562255859375), SC_(0.22103404998779296875), SC_(9.3516791282338434124664861759040923544265109549101), SC_(14.804120912602928262364597480725623835331061218201) }}, 
      {{ SC_(12.64718532562255859375), SC_(0.278498232364654541015625), SC_(9.9532137144075079682088734865811485169502051541194), SC_(14.12015821284293168735206960036708562390870351063) }}, 
      {{ SC_(12.64718532562255859375), SC_(0.308167040348052978515625), SC_(10.243298807763724010478060698880277720321796708766), SC_(13.798633656540777349502091830430059744331882886278) }}, 
      {{ SC_(12.64718532562255859375), SC_(0.546881496906280517578125), SC_(12.399275289660469011257714497830554771951746121858), SC_(11.563273411635948200345660594076842943507332490285) }}, 
      {{ SC_(12.64718532562255859375), SC_(0.54722058773040771484375), SC_(12.402346593646574078222745980931153936118481906153), SC_(11.560269810750595572221219195622818675329824015645) }}, 
      {{ SC_(12.64718532562255859375), SC_(0.6323592662811279296875), SC_(13.19782665370456596120591738385829220788127750129), SC_(10.798332099951424582914986681188597257286341937357) }}, 
      {{ SC_(12.64718532562255859375), SC_(0.814723670482635498046875), SC_(15.288189942005947077588095662863900019178028947102), SC_(8.9383434817363300471273936747034404759891162547254) }}, 
      {{ SC_(12.64718532562255859375), SC_(0.835008561611175537109375), SC_(15.591384567114640046319076067770981691962858112517), SC_(8.6845348611306367395813221127571201197146166918641) }}, 
      {{ SC_(12.64718532562255859375), SC_(0.905791938304901123046875), SC_(16.927835017840491595687492533629798547524854577836), SC_(7.6106445122443167328298276139682641625898258177196) }}, 
      {{ SC_(12.64718532562255859375), SC_(0.9133758544921875), SC_(17.113046273942503087359925791727307763838757542972), SC_(7.4674105602937188040477152280060809854748579836014) }}, 
      {{ SC_(12.64718532562255859375), SC_(0.957506835460662841796875), SC_(18.569973245653494382911382456207569635746744196882), SC_(6.3859448266286921486507096427302924566841556550563) }}, 
      {{ SC_(12.64718532562255859375), SC_(0.964888513088226318359375), SC_(18.93152783831108116874127183196847811285623625696), SC_(6.1296453214032888616203015159805383672210547060642) }}, 
      {{ SC_(12.64718532562255859375), SC_(0.967694938182830810546875), SC_(19.086191909497975149053516759983344699801043918198), SC_(6.0214345100468344269863932086605661104721698279907) }}, 
      {{ SC_(12.64718532562255859375), SC_(0.968867778778076171875), SC_(19.154261931332249800552464671562250972922345148502), SC_(5.9740783822366839368179720805820788798696498458457) }}, 
      {{ SC_(12.64718532562255859375), SC_(0.992881298065185546875), SC_(21.633315543125658905896300611103319391369453711018), SC_(4.3580642120394167757053733298567833281549145844168) }}, 
      {{ SC_(12.64718532562255859375), SC_(0.996461331844329833984375), SC_(22.68492256917358231151503114591791247245850445982), SC_(3.7341956318915674599651482908795435597345044824033) }}, 
      {{ SC_(16.2944736480712890625), SC_(0.097540400922298431396484375), SC_(10.693850670037101152771497711368715584773135538118), SC_(21.121889791601541453681111492941256715103226043036) }}, 
      {{ SC_(16.2944736480712890625), SC_(0.12698681652545928955078125), SC_(11.252465242025717147870100184437693209234712298237), SC_(20.436540859332260740727910060061745901708024868949) }}, 
      {{ SC_(16.2944736480712890625), SC_(0.135477006435394287109375), SC_(11.397665967452893835717961188341356148503300339155), SC_(20.261347293825036046882929798668385243692064590023) }}, 
      {{ SC_(16.2944736480712890625), SC_(0.188381969928741455078125), SC_(12.19770032509947480853558992949527837843154772766), SC_(19.31693484928652851147703100896941457272409982229) }}, 
      {{ SC_(16.2944736480712890625), SC_(0.22103404998779296875), SC_(12.629130730930436784262974882245754883935149204312), SC_(18.821756648937967508625437122931342224383045686541) }}, 
      {{ SC_(16.2944736480712890625), SC_(0.278498232364654541015625), SC_(13.318115142036955408997409841452247112332156832314), SC_(18.050435303052834476446622744197116416891576100601) }}, 
      {{ SC_(16.2944736480712890625), SC_(0.308167040348052978515625), SC_(13.649755729711715293236346615386101989656442500996), SC_(17.687385605745203579801289248551882571772835527034) }}, 
      {{ SC_(16.2944736480712890625), SC_(0.546881496906280517578125), SC_(16.103587520623140138404770698328267716962876193979), SC_(15.154235931792982710153039116171021793913963478755) }}, 
      {{ SC_(16.2944736480712890625), SC_(0.54722058773040771484375), SC_(16.107070658704027443991378847308001043628591516482), SC_(15.150820447157110070870972003998711791074624878056) }}, 
      {{ SC_(16.2944736480712890625), SC_(0.6323592662811279296875), SC_(17.008154017745132103552614725057620576003789945351), SC_(14.283253468555664973748342299413071138952621730455) }}, 
      {{ SC_(16.2944736480712890625), SC_(0.814723670482635498046875), SC_(19.366888819686739274125549776624219462428989868847), SC_(12.154640181569311916358968875108201381315852554446) }}, 
      {{ SC_(16.2944736480712890625), SC_(0.835008561611175537109375), SC_(19.708022155420012504510504412036051833181497206306), SC_(11.862821299641407909509350903197583777435762852207) }}, 
      {{ SC_(16.2944736480712890625), SC_(0.905791938304901123046875), SC_(21.209050162302568225326520542099219835495374869877), SC_(10.623867527454918634576446546790682697872587794339) }}, 
      {{ SC_(16.2944736480712890625), SC_(0.9133758544921875), SC_(21.416745874946280165168565760970832049836956931192), SC_(10.458054658958050388168990232003684643617840085059) }}, 
      {{ SC_(16.2944736480712890625), SC_(0.957506835460662841796875), SC_(23.048014594592231066054797831596194398240124284957), SC_(9.2011886604782521931686908767344066197277856236645) }}, 
      {{ SC_(16.2944736480712890625), SC_(0.964888513088226318359375), SC_(23.452175501874584280562667192409085747799280549345), SC_(8.9019150744407493507319421323364063076968784869333) }}, 
      {{ SC_(16.2944736480712890625), SC_(0.967694938182830810546875), SC_(23.62498949136929103398172070852459015559160920003), SC_(8.7753818417828787767639479371150461376805861578068) }}, 
      {{ SC_(16.2944736480712890625), SC_(0.968867778778076171875), SC_(23.701033346498343776960099078249896579474458326563), SC_(8.7199729277053559302911438571086669590056905096611) }}, 
      {{ SC_(16.2944736480712890625), SC_(0.992881298065185546875), SC_(26.464931905803948999532395821613248145971809244706), SC_(6.8146461008535155890042039196042685746010864745794) }}, 
      {{ SC_(16.2944736480712890625), SC_(0.996461331844329833984375), SC_(27.634361030515676698472921917162389706998509309217), SC_(6.0698163788270120646200681816079279135033855764337) }}, 
      {{ SC_(16.7001705169677734375), SC_(0.097540400922298431396484375), SC_(11.034638129824783452597218686565157888493181759292), SC_(21.592486495836760104219637788961504730499201651789) }}, 
      {{ SC_(16.7001705169677734375), SC_(0.12698681652545928955078125), SC_(11.601044643226705655060860983705162351184833560802), SC_(20.89936699183590999083396625346959347096750555563) }}, 
      {{ SC_(16.7001705169677734375), SC_(0.135477006435394287109375), SC_(11.748249244916808252496460760484611437190506691017), SC_(20.722174095140127300316933973396618862391340837863) }}, 
      {{ SC_(16.7001705169677734375), SC_(0.188381969928741455078125), SC_(12.559175460378148013318741337711849725788312287193), SC_(19.766888967437912637562714188270171964545038302194) }}, 
      {{ SC_(16.7001705169677734375), SC_(0.22103404998779296875), SC_(12.9963803212492396721056053684883452078734224349), SC_(19.265943369199835297312385729043995690990536715021) }}, 
      {{ SC_(16.7001705169677734375), SC_(0.278498232364654541015625), SC_(13.694452748953162112839552422063793383611749517637), SC_(18.485541861707272111341902580973379530227155741543) }}, 
      {{ SC_(16.7001705169677734375), SC_(0.308167040348052978515625), SC_(14.03041231133621298019513853704503907640275856256), SC_(18.11817581497518340733428655642167848033767512311) }}, 
      {{ SC_(16.7001705169677734375), SC_(0.546881496906280517578125), SC_(16.515205206102791169788252845600802269942143242809), SC_(15.554070762596479286613382669810325724417499206967) }}, 
      {{ SC_(16.7001705169677734375), SC_(0.54722058773040771484375), SC_(16.518731155145697592549800149644097197315486827454), SC_(15.550612462664315126477020374394335347899628729754) }}, 
      {{ SC_(16.7001705169677734375), SC_(0.6323592662811279296875), SC_(17.43079211193215642969883687437565016942771048078), SC_(14.672065624012867229107115532379446441909076865166) }}, 
      {{ SC_(16.7001705169677734375), SC_(0.814723670482635498046875), SC_(19.817422157167680843309060698270994027979848365703), SC_(12.515535282957473889402338060329223253320992529717) }}, 
      {{ SC_(16.7001705169677734375), SC_(0.835008561611175537109375), SC_(20.162498494735419382435778028170891194082141656125), SC_(12.219767278156873458611742557885989700840808085051) }}, 
      {{ SC_(16.7001705169677734375), SC_(0.905791938304901123046875), SC_(21.680629437827072781546905764890318735820707820674), SC_(10.963669247913543334749498624689102695423221828359) }}, 
      {{ SC_(16.7001705169677734375), SC_(0.9133758544921875), SC_(21.890661497297095284779459251611569867537016877579), SC_(10.795512033750512251630966482939978292412876733732) }}, 
      {{ SC_(16.7001705169677734375), SC_(0.957506835460662841796875), SC_(23.540043736005537976133249810576357608087185880221), SC_(9.52044335785104734836069185443264917657882232207) }}, 
      {{ SC_(16.7001705169677734375), SC_(0.964888513088226318359375), SC_(23.948630657411715351226106251362978904104511469727), SC_(9.2167129369970753002688621491010766026301145655948) }}, 
      {{ SC_(16.7001705169677734375), SC_(0.967694938182830810546875), SC_(24.123330010288903210268180038047961852955433227349), SC_(9.0882799067309322640282432698470052099055332012573) }}, 
      {{ SC_(16.7001705169677734375), SC_(0.968867778778076171875), SC_(24.200202149888339030947916427426284228939281350228), SC_(9.0320361062711072532410780804932507825360170321532) }}, 
      {{ SC_(16.7001705169677734375), SC_(0.992881298065185546875), SC_(26.993682642050434185458056637438208210688246846477), SC_(7.0967572788605379771749741989839291529937674107396) }}, 
      {{ SC_(16.7001705169677734375), SC_(0.996461331844329833984375), SC_(28.175344078106345126569168135038395326717308633766), SC_(6.3394383939027305766912478902120825568947479585851) }}, 
      {{ SC_(18.1158390045166015625), SC_(0.097540400922298431396484375), SC_(12.229803145137575990335718583500925394826480618503), SC_(23.228627367533674533821572922276109229785439322765) }}, 
      {{ SC_(18.1158390045166015625), SC_(0.12698681652545928955078125), SC_(12.822673341761532058015211573173044086031531116737), SC_(22.509111414540839864342953335953686805411522053243) }}, 
      {{ SC_(18.1158390045166015625), SC_(0.135477006435394287109375), SC_(12.976684059166514734046895999415866313428744860068), SC_(22.325126713605129915066081556032404096371551510549) }}, 
      {{ SC_(18.1158390045166015625), SC_(0.188381969928741455078125), SC_(13.824606437282753949429957785988824006698569255867), SC_(21.332905860705858496128307473617169005608841036807) }}, 
      {{ SC_(18.1158390045166015625), SC_(0.22103404998779296875), SC_(14.281426572691848161246895450110642433343094853406), SC_(20.81236726469040732971916907807977212934026001891) }}, 
      {{ SC_(18.1158390045166015625), SC_(0.278498232364654541015625), SC_(15.01037153052613079691729172739763151661405472572), SC_(20.001118054476604765258550948507385925917493155015) }}, 
      {{ SC_(18.1158390045166015625), SC_(0.308167040348052978515625), SC_(15.361003389129331876193139511724331195724912409465), SC_(19.619088019727493705142523057273934353720883081836) }}, 
      {{ SC_(18.1158390045166015625), SC_(0.546881496906280517578125), SC_(17.950981338767316651695771645702465507829660468753), SC_(16.949816059137808649308126779086158538399454219891) }}, 
      {{ SC_(18.1158390045166015625), SC_(0.54722058773040771484375), SC_(17.954652733218942402920744523224752709207037306433), SC_(16.946212300040719278539497985318257418714458430196) }}, 
      {{ SC_(18.1158390045166015625), SC_(0.6323592662811279296875), SC_(18.90400875262084625176019157381017401036294356254), SC_(16.030363223014311217316032305097475181277580268705) }}, 
      {{ SC_(18.1158390045166015625), SC_(0.814723670482635498046875), SC_(21.385406755739170391610530719179388624654968784157), SC_(13.778995984677945747533692055762656599286983552973) }}, 
      {{ SC_(18.1158390045166015625), SC_(0.835008561611175537109375), SC_(21.743878039515852848017307901035212430884592429209), SC_(13.469813729955726555908505800975759196077957341242) }}, 
      {{ SC_(18.1158390045166015625), SC_(0.905791938304901123046875), SC_(23.320108024450794895960154014300450155277608250839), SC_(12.155486587438152200205438361713390634424285299801) }}, 
      {{ SC_(18.1158390045166015625), SC_(0.9133758544921875), SC_(23.538076411450700350595673358353507263727241200012), SC_(11.979367902547473933330686030907997353481482129832) }}, 
      {{ SC_(18.1158390045166015625), SC_(0.957506835460662841796875), SC_(25.248985693754198008130087056841115436946608909113), SC_(10.64249240527183225201584070811311919594316873085) }}, 
      {{ SC_(18.1158390045166015625), SC_(0.964888513088226318359375), SC_(25.672605891807719490656368170167660577384994363804), SC_(10.323632149235174143236852255206305357443772220156) }}, 
      {{ SC_(18.1158390045166015625), SC_(0.967694938182830810546875), SC_(25.853708920308354382681824644886609939970217034117), SC_(10.188750244564714232045499011802059449483552959846) }}, 
      {{ SC_(18.1158390045166015625), SC_(0.968867778778076171875), SC_(25.933394326577259260680235077008269396707232879955), SC_(10.129672508946807738778255033241855354247796511595) }}, 
      {{ SC_(18.1158390045166015625), SC_(0.992881298065185546875), SC_(28.827341960599856817150763480721623090399103682994), SC_(8.092771426735276889343277722328757647550934616848) }}, 
      {{ SC_(18.1158390045166015625), SC_(0.996461331844329833984375), SC_(30.050542481052555238898499443708521579588587755888), SC_(7.2931147895930968783410244498702897570105273223928) }}, 
      {{ SC_(18.26751708984375), SC_(0.097540400922298431396484375), SC_(12.358378009335293471653123846939290489012834344543), SC_(23.403405544764970115716480763827192560260898281917) }}, 
      {{ SC_(18.26751708984375), SC_(0.12698681652545928955078125), SC_(12.954020408854467630407302005992337564710960830217), SC_(22.681123987437766980884860184057710579773679792445) }}, 
      {{ SC_(18.26751708984375), SC_(0.135477006435394287109375), SC_(13.108744132045379106090567522437339958662266837862), SC_(22.496427686228608299917659685541040380184607353219) }}, 
      {{ SC_(18.26751708984375), SC_(0.188381969928741455078125), SC_(13.960542399862203396981482305302410196543442917059), SC_(21.500336884057086664318614928567802107658912862523) }}, 
      {{ SC_(18.26751708984375), SC_(0.22103404998779296875), SC_(14.419417630978867214081632221088407753671474536534), SC_(20.977745384619569642813289824152669709574871136045) }}, 
      {{ SC_(18.26751708984375), SC_(0.278498232364654541015625), SC_(15.151597226827460219771938921158262471181424746215), SC_(20.163263982310714770266391105747405916722773664627) }}, 
      {{ SC_(18.26751708984375), SC_(0.308167040348052978515625), SC_(15.503766401010795352452110715546674802381197742827), SC_(19.779697451328020657979198606920611929608291640143) }}, 
      {{ SC_(18.26751708984375), SC_(0.546881496906280517578125), SC_(18.104765710618081300160015572662281056383121409967), SC_(17.099405922607606419193022941413123144383424505584) }}, 
      {{ SC_(18.26751708984375), SC_(0.54722058773040771484375), SC_(18.10845234514577551782213788442539760347033111491), SC_(17.095786922074606508725271849236860678568263622572) }}, 
      {{ SC_(18.26751708984375), SC_(0.6323592662811279296875), SC_(19.061716212401396421444362361618259867959980188279), SC_(16.17602928820526173623668686091097089368259450071) }}, 
      {{ SC_(18.26751708984375), SC_(0.814723670482635498046875), SC_(21.553043948614931900049993412103566204611342227854), SC_(13.914725524939980875158129159562005054461269758533) }}, 
      {{ SC_(18.26751708984375), SC_(0.835008561611175537109375), SC_(21.9129187017689723401126812211556391507339018288), SC_(13.604137902610091421545588145548575512832456927063) }}, 
      {{ SC_(18.26751708984375), SC_(0.905791938304901123046875), SC_(23.495235895374225818627173154751522674915316085917), SC_(12.283710780891254067977180887726854068992151499751) }}, 
      {{ SC_(18.26751708984375), SC_(0.9133758544921875), SC_(23.714035769982387637405439453109509415203186385201), SC_(12.106758142649534359488369899506190851904104134848) }}, 
      {{ SC_(18.26751708984375), SC_(0.957506835460662841796875), SC_(25.431390999518891793562793245831196862504351323722), SC_(10.763409299859546937116842638355270651761464416255) }}, 
      {{ SC_(18.26751708984375), SC_(0.964888513088226318359375), SC_(25.856586109036368229599662539600594524566810507709), SC_(10.442964689229539628752640308062765712479889441224) }}, 
      {{ SC_(18.26751708984375), SC_(0.967694938182830810546875), SC_(26.038359989113882553115159325927230344454944623567), SC_(10.307407514499689969865874687991362198078794603182) }}, 
      {{ SC_(18.26751708984375), SC_(0.968867778778076171875), SC_(26.118340112716012122094585985589139066105673771364), SC_(10.248033041430365755162111643068023089945087952672) }}, 
      {{ SC_(18.26751708984375), SC_(0.992881298065185546875), SC_(29.022811997663127528900839262373900861715632679566), SC_(8.2004950879370407225266286238027176334591369105265) }}, 
      {{ SC_(18.26751708984375), SC_(0.996461331844329833984375), SC_(30.250363466916160780779295100087151395923923353868), SC_(7.3964098804857992892696362629914986068384957057976) }}, 
      {{ SC_(19.3773555755615234375), SC_(0.097540400922298431396484375), SC_(13.302022456329356645331103380072784620537969427031), SC_(24.679416264071073690717622417575158477758899067476) }}, 
      {{ SC_(19.3773555755615234375), SC_(0.12698681652545928955078125), SC_(13.917604124550317290574473688745207627437961160936), SC_(23.937240637529651211093644570846387112815467470328) }}, 
      {{ SC_(19.3773555755615234375), SC_(0.135477006435394287109375), SC_(14.077456352838378538491688948587960175341161428929), SC_(23.747425463361927254633215322286307253701190825571) }}, 
      {{ SC_(19.3773555755615234375), SC_(0.188381969928741455078125), SC_(14.957134065569689297251729040637353422581282949593), SC_(22.72349595038472280442031066332506051766329398777) }}, 
      {{ SC_(19.3773555755615234375), SC_(0.22103404998779296875), SC_(15.430792247783457753003015542452001148339921835173), SC_(22.186136545467564437128782554426281997843080370569) }}, 
      {{ SC_(19.3773555755615234375), SC_(0.278498232364654541015625), SC_(16.186240220029310082752474589255294273528485772967), SC_(21.348403565617717373202072516464489943494553481265) }}, 
      {{ SC_(19.3773555755615234375), SC_(0.308167040348052978515625), SC_(16.549468286991968215830188896887874669431708709156), SC_(20.953783773282466642767145541416963262008439278799) }}, 
      {{ SC_(19.3773555755615234375), SC_(0.546881496906280517578125), SC_(19.229753401848391410982600118601181818659329373608), SC_(18.194218765428833455630913518826395017989370589002) }}, 
      {{ SC_(19.3773555755615234375), SC_(0.54722058773040771484375), SC_(19.233549671995648507075742940917788156251262369621), SC_(18.190490119914581443391766034431556338325765983075) }}, 
      {{ SC_(19.3773555755615234375), SC_(0.6323592662811279296875), SC_(20.214926176966698652911300446451848285478667141658), SC_(17.242614969067788864564335734896715305130034413922) }}, 
      {{ SC_(19.3773555755615234375), SC_(0.814723670482635498046875), SC_(22.777686122049501110839759447084655145995486358199), SC_(14.909832349165879848263079573450955552565831244488) }}, 
      {{ SC_(19.3773555755615234375), SC_(0.835008561611175537109375), SC_(23.147656872099904909451219581367428167123548883022), SC_(14.589135709472514983991252276439570479197292063929) }}, 
      {{ SC_(19.3773555755615234375), SC_(0.905791938304901123046875), SC_(24.773762072359485842886169274475882543414692823237), SC_(13.22483308005477703594117738756057664899462040858) }}, 
      {{ SC_(19.3773555755615234375), SC_(0.9133758544921875), SC_(24.998543077459968908195327644207286701087318921193), SC_(13.041882430237504180933480933843715531478985035775) }}, 
      {{ SC_(19.3773555755615234375), SC_(0.957506835460662841796875), SC_(26.7622646592635570121107040414275120416812576035), SC_(11.651979845855278618699933756016190315033246730554) }}, 
      {{ SC_(19.3773555755615234375), SC_(0.964888513088226318359375), SC_(27.198787919828989362933843198893710850318958367029), SC_(11.320142558996091685204284118829540651423066293584) }}, 
      {{ SC_(19.3773555755615234375), SC_(0.967694938182830810546875), SC_(27.385387111939074299514579843568124877120834376414), SC_(11.179729889277513891927084010203453414790009450959) }}, 
      {{ SC_(19.3773555755615234375), SC_(0.968867778778076171875), SC_(27.467487074764030935907873295153581300436068537063), SC_(11.11822177915428460780975883248379628878491855121) }}, 
      {{ SC_(19.3773555755615234375), SC_(0.992881298065185546875), SC_(30.447654137118708782205344863087301860796843454219), SC_(8.9942207488711667389602986174100476877674749782464) }}, 
      {{ SC_(19.3773555755615234375), SC_(0.996461331844329833984375), SC_(31.706497482188934671625956753597350747141596846306), SC_(8.1583155637897770471922745241903260802442258277653) }}, 
      {{ SC_(30.1589450836181640625), SC_(0.097540400922298431396484375), SC_(22.668644421420827574546806520849206630332837324745), SC_(36.875831250249904197678832069712959926734486928462) }}, 
      {{ SC_(30.1589450836181640625), SC_(0.12698681652545928955078125), SC_(23.453845205414823000411388938563139157459273154594), SC_(35.964304476276335557381343830942353249193082493714) }}, 
      {{ SC_(30.1589450836181640625), SC_(0.135477006435394287109375), SC_(23.657332974917157738170445045009826223808840753631), SC_(35.730911026180500741467572797019366789559843411417) }}, 
      {{ SC_(30.1589450836181640625), SC_(0.188381969928741455078125), SC_(24.77427214734173793924969689843359730995953729143), SC_(34.469963070462593318639812179738672982026023392017) }}, 
      {{ SC_(30.1589450836181640625), SC_(0.22103404998779296875), SC_(25.373766903155999366143020642334146095871585712049), SC_(33.806857313360481418987615755127875589579427414233) }}, 
      {{ SC_(30.1589450836181640625), SC_(0.278498232364654541015625), SC_(26.327314254679626967407837795452819948376100969817), SC_(32.771126137698108401187615667081710880502125452114) }}, 
      {{ SC_(30.1589450836181640625), SC_(0.308167040348052978515625), SC_(26.784705419119920255458022343018796177796468530153), SC_(32.282377312456719156997247111965903029943488716139) }}, 
      {{ SC_(30.1589450836181640625), SC_(0.546881496906280517578125), SC_(30.140200028986754353933478618812694920412167857749), SC_(28.847677752499432129836345816917281884186312206383) }}, 
      {{ SC_(30.1589450836181640625), SC_(0.54722058773040771484375), SC_(30.144930030548962955924363500339399873038633718354), SC_(28.843015318390390753909216652196459394527223359436) }}, 
      {{ SC_(30.1589450836181640625), SC_(0.6323592662811279296875), SC_(31.365730660715230956397508478163395322979273766058), SC_(27.655686301244819720229858881326539742566616621331) }}, 
      {{ SC_(30.1589450836181640625), SC_(0.814723670482635498046875), SC_(34.53678121024660798430125576148804032673509007061), SC_(24.714332081822305790422354927035893272879055852168) }}, 
      {{ SC_(30.1589450836181640625), SC_(0.835008561611175537109375), SC_(34.992712342865409288209554479047053788954122415631), SC_(24.307597233737732014671422622070528932413006597407) }}, 
      {{ SC_(30.1589450836181640625), SC_(0.905791938304901123046875), SC_(36.991588818743800447541768611792046836196657814675), SC_(22.570003712699060344458175010195328307564467030773) }}, 
      {{ SC_(30.1589450836181640625), SC_(0.9133758544921875), SC_(37.267280294905674663282768076993799825657748606749), SC_(22.336042830318260164170852548641420020626666626766) }}, 
      {{ SC_(30.1589450836181640625), SC_(0.957506835460662841796875), SC_(39.425596200000835944009921439671940176849778600999), SC_(20.550445059387119356811101323910013373259092669538) }}, 
      {{ SC_(30.1589450836181640625), SC_(0.964888513088226318359375), SC_(39.958506227725890050648619079467677515474125330912), SC_(20.1218440566614370120405117471074005536189858416) }}, 
      {{ SC_(30.1589450836181640625), SC_(0.967694938182830810546875), SC_(40.186159588609191984261089444724749792007022054682), SC_(19.940201193331396219447075191481721953866782076346) }}, 
      {{ SC_(30.1589450836181640625), SC_(0.968867778778076171875), SC_(40.28629484490922558416686504011104423610359010226), SC_(19.860577381779492959046475056545198020687220872117) }}, 
      {{ SC_(30.1589450836181640625), SC_(0.992881298065185546875), SC_(43.910262535436428289778912063406689115101469273305), SC_(17.0883457422398399303356590728006266852811527362) }}, 
      {{ SC_(30.1589450836181640625), SC_(0.996461331844329833984375), SC_(45.435126123676131580006803736026384165122567933823), SC_(15.983412368453095646505459192793685790268383676026) }}, 
      {{ SC_(30.838161468505859375), SC_(0.097540400922298431396484375), SC_(23.268046680563354565606586779001398524095052529787), SC_(37.634855665372713626073743792144511261668316930211) }}, 
      {{ SC_(30.838161468505859375), SC_(0.12698681652545928955078125), SC_(24.062809557708062395428341113473093227470401596587), SC_(36.713777471539062809949708275903919835943883016543) }}, 
      {{ SC_(30.838161468505859375), SC_(0.135477006435394287109375), SC_(24.268757565013623445712340846064418164749715650402), SC_(36.47792607017495310498033337862872137178323719441) }}, 
      {{ SC_(30.838161468505859375), SC_(0.188381969928741455078125), SC_(25.399075914670267020868313999714975605180834579226), SC_(35.203608670236208154011535399226708860251026426583) }}, 
      {{ SC_(30.838161468505859375), SC_(0.22103404998779296875), SC_(26.005667776585073612280916022596956644991200778382), SC_(34.53340943662709770560394763692024036006559935342) }}, 
      {{ SC_(30.838161468505859375), SC_(0.278498232364654541015625), SC_(26.970389109385527428965957870935522341965231753821), SC_(33.486508365995182084761234135770612831084924898688) }}, 
      {{ SC_(30.838161468505859375), SC_(0.308167040348052978515625), SC_(27.433092083447351558339686527360620119823414971664), SC_(32.992449111901469521101506070014319912121851661909) }}, 
      {{ SC_(30.838161468505859375), SC_(0.546881496906280517578125), SC_(30.826680383354937193226939943931890552076843608004), SC_(29.519658912925663787477991510321051101284998771673) }}, 
      {{ SC_(30.838161468505859375), SC_(0.54722058773040771484375), SC_(30.831463066127683484397810135170327330240649845048), SC_(29.51494379526919020226420593931175485239206156367) }}, 
      {{ SC_(30.838161468505859375), SC_(0.6323592662811279296875), SC_(32.065771932396400314656963118674163358624561337925), SC_(28.314105328620060247346159988192723606199635916195) }}, 
      {{ SC_(30.838161468505859375), SC_(0.814723670482635498046875), SC_(35.271139147194945118793296175986788307686973692746), SC_(25.338423095022514296232006773895697693531559080538) }}, 
      {{ SC_(30.838161468505859375), SC_(0.835008561611175537109375), SC_(35.7319191618839673163512855522825879101348462362), SC_(24.926836242745884279889350254195915162132292680533) }}, 
      {{ SC_(30.838161468505859375), SC_(0.905791938304901123046875), SC_(37.751820798027795168750432510397465351743303725447), SC_(23.168196834682344507000703083544618327624627668834) }}, 
      {{ SC_(30.838161468505859375), SC_(0.9133758544921875), SC_(38.030383426817768908836320994288216103904088234334), SC_(22.931360837305817503628522100454971346387511080772) }}, 
      {{ SC_(30.838161468505859375), SC_(0.957506835460662841796875), SC_(40.210949977996977136914590633162708825991855789698), SC_(21.123468923767042266150470078450432219821813922137) }}, 
      {{ SC_(30.838161468505859375), SC_(0.964888513088226318359375), SC_(40.749294277668538301734566703452274895833229274851), SC_(20.689418829062325636463126006833835725683307714982) }}, 
      {{ SC_(30.838161468505859375), SC_(0.967694938182830810546875), SC_(40.979262159218395944391596126950520963705186731289), SC_(20.505454534930254054763294729181858404303160174338) }}, 
      {{ SC_(30.838161468505859375), SC_(0.968867778778076171875), SC_(41.080414174959326923333965349008188681373891476679), SC_(20.424810809473124638288418185926706048746044789534) }}, 
      {{ SC_(30.838161468505859375), SC_(0.992881298065185546875), SC_(44.740668087350496302552933989706675539623372591229), SC_(17.616120691756711510578427427178540011361756806899) }}, 
      {{ SC_(30.838161468505859375), SC_(0.996461331844329833984375), SC_(46.280519948548857709166200289619638635418741920306), SC_(16.496083384415299195830782920443609983748794449984) }}, 
      {{ SC_(37.6827239990234375), SC_(0.097540400922298431396484375), SC_(29.352946021749666845843482962472158740256177417383), SC_(45.239030947986461254737281318699609928010001470929) }}, 
      {{ SC_(37.6827239990234375), SC_(0.12698681652545928955078125), SC_(30.23869955862943665193033752151792999945086107061), SC_(44.227048344268336232736185754498199322631271606189) }}, 
      {{ SC_(37.6827239990234375), SC_(0.135477006435394287109375), SC_(30.468059822801017995671661231547989409240669389363), SC_(43.967803178981760575804961335175951272390804437288) }}, 
      {{ SC_(37.6827239990234375), SC_(0.188381969928741455078125), SC_(31.725705243093252423947489513450454529025038929732), SC_(42.566237509216167203970262962197557418354109383711) }}, 
      {{ SC_(37.6827239990234375), SC_(0.22103404998779296875), SC_(32.399843239570666679273550338271907741953468442885), SC_(41.828521572127310534890499292304472181353368976736) }}, 
      {{ SC_(37.6827239990234375), SC_(0.278498232364654541015625), SC_(33.470916831178824336949759327572185401335972799101), SC_(40.675301420816796567889252452264317637671150035051) }}, 
      {{ SC_(37.6827239990234375), SC_(0.308167040348052978515625), SC_(33.984178480196802581888467088217298043522607746886), SC_(40.130694716772379321441170038540435291368314007864) }}, 
      {{ SC_(37.6827239990234375), SC_(0.546881496906280517578125), SC_(37.740365997371299683057669982762377665495248364282), SC_(36.295330140737936822144745915300188450290325531154) }}, 
      {{ SC_(37.6827239990234375), SC_(0.54722058773040771484375), SC_(37.745650140982057657851397455560822359429817586109), SC_(36.290113543192465005662851997086543724466786997184) }}, 
      {{ SC_(37.6827239990234375), SC_(0.6323592662811279296875), SC_(39.108540542348828783395260083611191614855117661191), SC_(34.960683655235230491700353477228238601995517107717) }}, 
      {{ SC_(37.6827239990234375), SC_(0.814723670482635498046875), SC_(42.640548035772286170948501242411862013356064280976), SC_(31.658268994787235521590444677659527875912140188893) }}, 
      {{ SC_(37.6827239990234375), SC_(0.835008561611175537109375), SC_(43.147479483746281091517151843762458661274511101554), SC_(31.2005054174787025029366797648089279614383116084) }}, 
      {{ SC_(37.6827239990234375), SC_(0.905791938304901123046875), SC_(45.367488673462529098662548977043944239948700580183), SC_(29.241590880622401164379230635383991361060420046416) }}, 
      {{ SC_(37.6827239990234375), SC_(0.9133758544921875), SC_(45.673376318983796212262413228352474087793271496405), SC_(28.977397877967594477687673014569895522824373602474) }}, 
      {{ SC_(37.6827239990234375), SC_(0.957506835460662841796875), SC_(48.065692470044996778558658693880119772948394475358), SC_(26.957405841047970798009539858031027151979291071372) }}, 
      {{ SC_(37.6827239990234375), SC_(0.964888513088226318359375), SC_(48.655748925851273162561955326695183771206068638936), SC_(26.471524362760700843451787298299341311578947241774) }}, 
      {{ SC_(37.6827239990234375), SC_(0.967694938182830810546875), SC_(48.907741192349980536728522958051807610930999105923), SC_(26.26548011994174259538533862720530864373867746059) }}, 
      {{ SC_(37.6827239990234375), SC_(0.968867778778076171875), SC_(49.018568346853246606918011590411224524608349559362), SC_(26.175135896638374055479720835565124197048906411302) }}, 
      {{ SC_(37.6827239990234375), SC_(0.992881298065185546875), SC_(53.02407418491247821809186743632936433016449753218), SC_(23.019813176696678971023411190438750354494441104321) }}, 
      {{ SC_(37.6827239990234375), SC_(0.996461331844329833984375), SC_(54.706513118394944593046682264160930606264906373061), SC_(21.756265173156173203224249376116301767163819366798) }}, 
      {{ SC_(44.653362274169921875), SC_(0.097540400922298431396484375), SC_(35.618240596300811269413152918291588612106553267115), SC_(52.914976106294007717399717270512543998187614084655) }}, 
      {{ SC_(44.653362274169921875), SC_(0.12698681652545928955078125), SC_(36.588452076327023713429953804552822888883127952446), SC_(51.818596394764872873002485024538053016282568559311) }}, 
      {{ SC_(44.653362274169921875), SC_(0.135477006435394287109375), SC_(36.83954526469596624594638033560920299497560170955), SC_(51.537631365760970201822740189946713347302704956653) }}, 
      {{ SC_(44.653362274169921875), SC_(0.188381969928741455078125), SC_(38.215394320386388785658525903502825381175642791908), SC_(50.017917801033533925183046469134290033878646286364) }}, 
      {{ SC_(44.653362274169921875), SC_(0.22103404998779296875), SC_(38.952244175784308367316752805823985177260869746127), SC_(49.217510871384175066507190898961611480478984790775) }}, 
      {{ SC_(44.653362274169921875), SC_(0.278498232364654541015625), SC_(40.122064659061842221357533501115750674753742114962), SC_(47.965567398021912248267285737600118230163443048146) }}, 
      {{ SC_(44.653362274169921875), SC_(0.308167040348052978515625), SC_(40.682271670856134762049327525114253685181553477862), SC_(47.374023320401046687747405659199479704882112312872) }}, 
      {{ SC_(44.653362274169921875), SC_(0.546881496906280517578125), SC_(44.775166844273750204693436437598938458674995370859), SC_(43.201968806950762514924060846076158545767565340834) }}, 
      {{ SC_(44.653362274169921875), SC_(0.54722058773040771484375), SC_(44.780916652872974129195758524252272687403328156345), SC_(43.196286530800993850604328631601837463617864100601) }}, 
      {{ SC_(44.653362274169921875), SC_(0.6323592662811279296875), SC_(46.263209496766289477581326251209800719449521647638), SC_(41.74744714071843554308740486544400566762146642179) }}, 
      {{ SC_(44.653362274169921875), SC_(0.814723670482635498046875), SC_(50.098523675409541121626750712816025928785805589963), SC_(38.141660330528983628196827851943275547000394308747) }}, 
      {{ SC_(44.653362274169921875), SC_(0.835008561611175537109375), SC_(50.648306685816689766554918351883448444256293068421), SC_(37.6410272852110740559690374670146559941775337824) }}, 
      {{ SC_(44.653362274169921875), SC_(0.905791938304901123046875), SC_(53.054103407043758093947406881581337862401460393742), SC_(35.496206929779901659084503734583249196914077277701) }}, 
      {{ SC_(44.653362274169921875), SC_(0.9133758544921875), SC_(53.385358933877228179382653378109110562394012464663), SC_(35.206623516005541594716774304809185980224230823056) }}, 
      {{ SC_(44.653362274169921875), SC_(0.957506835460662841796875), SC_(55.974242184476241283163248842516020657114550480509), SC_(32.989818168578314505460384681239255936684066596111) }}, 
      {{ SC_(44.653362274169921875), SC_(0.964888513088226318359375), SC_(56.612298353766537712683846765569764778064912890336), SC_(32.455853444144004284193964544433996284001689946921) }}, 
      {{ SC_(44.653362274169921875), SC_(0.967694938182830810546875), SC_(56.884733269659538473548442137925159914421147572728), SC_(32.229327653093505652976807532660352361574006017286) }}, 
      {{ SC_(44.653362274169921875), SC_(0.968867778778076171875), SC_(57.004540604968172414189087273105751158640079487408), SC_(32.129985501669815679035197934407217019631622859967) }}, 
      {{ SC_(44.653362274169921875), SC_(0.992881298065185546875), SC_(61.330450499808012132461984823248778067759558389806), SC_(28.653296774088438599698283237800093445349287250038) }}, 
      {{ SC_(44.653362274169921875), SC_(0.996461331844329833984375), SC_(63.1451847530032895517210152445898258326670771991), SC_(27.25681349509734372649562975525186400552382134225) }}, 
      {{ SC_(70.5887451171875), SC_(0.097540400922298431396484375), SC_(59.323766307764924944511985838362609462846757285539), SC_(81.080139733430217014011663293836400739084701459033) }}, 
      {{ SC_(70.5887451171875), SC_(0.12698681652545928955078125), SC_(60.560876195114799652722402332145061167474736374456), SC_(79.716982843877649560763077680056820839086439966958) }}, 
      {{ SC_(70.5887451171875), SC_(0.135477006435394287109375), SC_(60.880654539652323046569081472892565513680147278097), SC_(79.367358725762711580876280291041849614396548846976) }}, 
      {{ SC_(70.5887451171875), SC_(0.188381969928741455078125), SC_(62.630114940556122272472649291007998653671582205194), SC_(77.474145282545937129894511287965565852266350244074) }}, 
      {{ SC_(70.5887451171875), SC_(0.22103404998779296875), SC_(63.565203525378322623716056626971430469895306397143), SC_(76.475541468756053237162220106008060995831242777508) }}, 
      {{ SC_(70.5887451171875), SC_(0.278498232364654541015625), SC_(65.047198490951661294289697093312736792316947459838), SC_(74.911470893957693423562192662912099166321674401311) }}, 
      {{ SC_(70.5887451171875), SC_(0.308167040348052978515625), SC_(65.755825576480159533556650811283624895067921248432), SC_(74.171522839696776547832201698087409455114324503857) }}, 
      {{ SC_(70.5887451171875), SC_(0.546881496906280517578125), SC_(70.913329942314588537117826690565687715558168153075), SC_(68.934894930949823984053333605524648374809227329172) }}, 
      {{ SC_(70.5887451171875), SC_(0.54722058773040771484375), SC_(70.920552144456080762521519740730354908369398624764), SC_(68.927740233684966178915892745442040165100139460311) }}, 
      {{ SC_(70.5887451171875), SC_(0.6323592662811279296875), SC_(72.780383028013092435962833773699309076839518294193), SC_(67.101348522816586359597484746104920122657752978445) }}, 
      {{ SC_(70.5887451171875), SC_(0.814723670482635498046875), SC_(77.574653386409751776108575377632108278667440107224), SC_(62.536473925715093012708150848425649307156237593513) }}, 
      {{ SC_(70.5887451171875), SC_(0.835008561611175537109375), SC_(78.259905813861810255676896764118884081711144756296), SC_(61.900335619396635575617144617885535041900269483816) }}, 
      {{ SC_(70.5887451171875), SC_(0.905791938304901123046875), SC_(81.25299185090190858964179894793694530488140641349), SC_(59.167990012143531443787372615142584425879993904367) }}, 
      {{ SC_(70.5887451171875), SC_(0.9133758544921875), SC_(81.664429816893036984091842047210659476641847372055), SC_(58.798179343450093655715878624961611325642658626691) }}, 
      {{ SC_(70.5887451171875), SC_(0.957506835460662841796875), SC_(84.87454906989267154784635574995511241463435525827), SC_(55.959649852053216301475776698816147628226064804139) }}, 
      {{ SC_(70.5887451171875), SC_(0.964888513088226318359375), SC_(85.664284308608662739239695307078374271686277199771), SC_(55.273840961707984286474836578784103719708404536831) }}, 
      {{ SC_(70.5887451171875), SC_(0.967694938182830810546875), SC_(86.00131536747544194497073098620207632222159139592), SC_(54.982642219024087975392322044049822559129019576986) }}, 
      {{ SC_(70.5887451171875), SC_(0.968867778778076171875), SC_(86.149498415798992330020764253916429487454286947359), SC_(54.854889325523534153982429316046281512650760010175) }}, 
      {{ SC_(70.5887451171875), SC_(0.992881298065185546875), SC_(91.487610078397683660737175430541841512937799428622), SC_(50.364110367514638039584887682837666362656768908397) }}, 
      {{ SC_(70.5887451171875), SC_(0.996461331844329833984375), SC_(93.720151444029455143528319995335526508406531325585), SC_(48.548571957262221711956033636220622117273017974581) }}, 
      {{ SC_(85.17789459228515625), SC_(0.097540400922298431396484375), SC_(72.84004553903788231830520034488013479311140960234), SC_(96.742136134427758018486121833576858764226967340758) }}, 
      {{ SC_(85.17789459228515625), SC_(0.12698681652545928955078125), SC_(74.205534583327996472630052081845889068622132730715), SC_(95.250635933127233193631756396042753853643782897109) }}, 
      {{ SC_(85.17789459228515625), SC_(0.135477006435394287109375), SC_(74.5583528845271049150210341386169727409405514424), SC_(94.867979576235376983656631750361750287069796802806) }}, 
      {{ SC_(85.17789459228515625), SC_(0.188381969928741455078125), SC_(76.487546591565817499643888051388651300173293259813), SC_(92.79506588451712270885755022474375428700403972328) }}, 
      {{ SC_(85.17789459228515625), SC_(0.22103404998779296875), SC_(77.518009776276971399240576675634246686454930934174), SC_(91.701099910780452842777174269910102526069866085803) }}, 
      {{ SC_(85.17789459228515625), SC_(0.278498232364654541015625), SC_(79.150203736679712645502897500467177875732185657604), SC_(89.986844455763419494773914288091054743718919964303) }}, 
      {{ SC_(85.17789459228515625), SC_(0.308167040348052978515625), SC_(79.930244450137289743387278661379076187356720396016), SC_(89.175487578165917448742395084949273434187270161134) }}, 
      {{ SC_(85.17789459228515625), SC_(0.546881496906280517578125), SC_(85.600026763763718200766422350192389450061989152706), SC_(83.426592430539565198996171805635340604205167276962) }}, 
      {{ SC_(85.17789459228515625), SC_(0.54722058773040771484375), SC_(85.607957480214028276840608288846833225617369369043), SC_(83.418729210700932936050442558249286914515555242146) }}, 
      {{ SC_(85.17789459228515625), SC_(0.6323592662811279296875), SC_(87.649458344516571277262267550813247585776907004838), SC_(81.410663242087177161406662287955828572958682401628) }}, 
      {{ SC_(85.17789459228515625), SC_(0.814723670482635498046875), SC_(92.905149753978703287320964315287029527291445721338), SC_(76.384328386737955464322502085689828055034253847245) }}, 
      {{ SC_(85.17789459228515625), SC_(0.835008561611175537109375), SC_(93.655581124664278676806154731390329100707123981802), SC_(75.683000497494712632402817941960098314023009970091) }}, 
      {{ SC_(85.17789459228515625), SC_(0.905791938304901123046875), SC_(96.931212316437150395055496559295994194479907517674), SC_(72.668039917898236789601178204416295003009055849504) }}, 
      {{ SC_(85.17789459228515625), SC_(0.9133758544921875), SC_(97.381223295772200942337268016078658085252552731261), SC_(72.259643005022937869369128436888415650542634925102) }}, 
      {{ SC_(85.17789459228515625), SC_(0.957506835460662841796875), SC_(100.89017134191776531686592005090940356147015590177), SC_(69.122141014577206469765120219474792648024373108098) }}, 
      {{ SC_(85.17789459228515625), SC_(0.964888513088226318359375), SC_(101.75285996438338053679125186784903390761295624956), SC_(68.36333026687845986375645362671705799930333028949) }}, 
      {{ SC_(85.17789459228515625), SC_(0.967694938182830810546875), SC_(102.12095896927722495321629695211982965065206672783), SC_(68.041041044637030936308483398988389737107527280368) }}, 
      {{ SC_(85.17789459228515625), SC_(0.968867778778076171875), SC_(102.28278931575768870024367012296396167946998758584), SC_(67.899630580013132231120123302044800975365885349387) }}, 
      {{ SC_(85.17789459228515625), SC_(0.992881298065185546875), SC_(108.10763742269289899272965987151092325470427758751), SC_(62.921563877598128121015588773494301933955584842396) }}, 
      {{ SC_(85.17789459228515625), SC_(0.996461331844329833984375), SC_(110.54103870335337030666663631411896609047028998653), SC_(60.904803259508646421883730571739561679384210543587) }}, 
      {{ SC_(86.80068206787109375), SC_(0.097540400922298431396484375), SC_(74.349390051895413755997751108490443743192848829245), SC_(98.478364445645001483570957550579154246024071498568) }}, 
      {{ SC_(86.80068206787109375), SC_(0.12698681652545928955078125), SC_(75.728452687461834696605445471153035263329044527755), SC_(96.973293897589263882546548986928987532173736464098) }}, 
      {{ SC_(86.80068206787109375), SC_(0.135477006435394287109375), SC_(76.084764375533948797198909695899646348647411425363), SC_(96.587144852639397224800962465078820062766875027141) }}, 
      {{ SC_(86.80068206787109375), SC_(0.188381969928741455078125), SC_(78.032962026277743608851436724383962509604064496942), SC_(94.495230211644520791894707402966583490720067261757) }}, 
      {{ SC_(86.80068206787109375), SC_(0.22103404998779296875), SC_(79.073509767986584206922371237575694416496376674569), SC_(93.391180808416481938086842101322913990280465003782) }}, 
      {{ SC_(86.80068206787109375), SC_(0.278498232364654541015625), SC_(80.72158544670458022721273181766094008933303320207), SC_(91.66104491502632564091264883789247143901601593626) }}, 
      {{ SC_(86.80068206787109375), SC_(0.308167040348052978515625), SC_(81.509177365606916315276348678047670806620940025159), SC_(90.842137267883053477172142850724502096971815402632) }}, 
      {{ SC_(86.80068206787109375), SC_(0.546881496906280517578125), SC_(87.233128280252063375738345844058270328349305674397), SC_(85.039074491353540456407061255718585495961970052596) }}, 
      {{ SC_(86.80068206787109375), SC_(0.54722058773040771484375), SC_(87.241133915855622785638242938592544777075816774473), SC_(85.03113635161103078915254217943676114810739979116) }}, 
      {{ SC_(86.80068206787109375), SC_(0.6323592662811279296875), SC_(89.301844754532468844800333017560937326064832310405), SC_(83.003860020267362100413360762199651531354386597777) }}, 
      {{ SC_(86.80068206787109375), SC_(0.814723670482635498046875), SC_(94.606326601352888176663316155123771196291573221021), SC_(77.928731172129879365784977025977325042048418153296) }}, 
      {{ SC_(86.80068206787109375), SC_(0.835008561611175537109375), SC_(95.363649825121692220889368492759524230993596787353), SC_(77.220510465826137814799719618156624921270897842663) }}, 
      {{ SC_(86.80068206787109375), SC_(0.905791938304901123046875), SC_(98.669156059698539068736031635394915346101445074281), SC_(74.175668522644766478265458056185080478690225036755) }}, 
      {{ SC_(86.80068206787109375), SC_(0.9133758544921875), SC_(99.123245496043582391597118391086162621767360561617), SC_(73.763191955627475331760466538128020469477350230804) }}, 
      {{ SC_(86.80068206787109375), SC_(0.957506835460662841796875), SC_(102.66378898986011106954544424929548291179775514215), SC_(70.594081524016687156157904859895106520232458693168) }}, 
      {{ SC_(86.80068206787109375), SC_(0.964888513088226318359375), SC_(103.53419082347456836045570901546588992186067641257), SC_(69.827553185211135658181646841058756278544812780283) }}, 
      {{ SC_(86.80068206787109375), SC_(0.967694938182830810546875), SC_(103.905574550382128442991762281491249546616977939), SC_(69.501977205282904129463122846937960116854472580745) }}, 
      {{ SC_(86.80068206787109375), SC_(0.968867778778076171875), SC_(104.06884777992894405556110331383484776197272173805), SC_(69.35912292961542779775252043273421585680547102348) }}, 
      {{ SC_(86.80068206787109375), SC_(0.992881298065185546875), SC_(109.94515457120489098509918159835385686821319082393), SC_(64.329547798673001385811377084038992307096210246426) }}, 
      {{ SC_(86.80068206787109375), SC_(0.996461331844329833984375), SC_(112.39978969459072077779888328267706447833062906956), SC_(62.291520692733771342294631246522813542833094235598) }}, 
      {{ SC_(92.46335601806640625), SC_(0.097540400922298431396484375), SC_(79.624300506522068267902828720200696483065531317386), SC_(104.52879503385161531795348194372857466014766385726) }}, 
      {{ SC_(92.46335601806640625), SC_(0.12698681652545928955078125), SC_(81.049758354984283796026909747277160412737131200061), SC_(102.97733970478700805868431924186219094649976730897) }}, 
      {{ SC_(92.46335601806640625), SC_(0.135477006435394287109375), SC_(81.418010683665917934386830487972718524188500613102), SC_(102.57925226634036643439022461160482651650111434553) }}, 
      {{ SC_(92.46335601806640625), SC_(0.188381969928741455078125), SC_(83.431165577054783920656648575646371447701180031641), SC_(100.42239001297908896843219931933255685819491373978) }}, 
      {{ SC_(92.46335601806640625), SC_(0.22103404998779296875), SC_(84.506183528782241657194419123095397842516367086027), SC_(99.28387402662051797804016538484344695031434255892) }}, 
      {{ SC_(92.46335601806640625), SC_(0.278498232364654541015625), SC_(86.208545092288152905475755608269200337897367576059), SC_(97.499456366406991890566423718117604583785761167127) }}, 
      {{ SC_(92.46335601806640625), SC_(0.308167040348052978515625), SC_(87.021948166662878366428701901062321157789854365613), SC_(96.654738966445745830855836941175059536598955208227) }}, 
      {{ SC_(92.46335601806640625), SC_(0.546881496906280517578125), SC_(92.931056558061610427190827774087020724935163116998), SC_(90.666521841888910391512660188694400582438697631521) }}, 
      {{ SC_(92.46335601806640625), SC_(0.54722058773040771484375), SC_(92.939318280539593606505286333998369285792637976529), SC_(90.658327612855691211423679380639323410327095718792) }}, 
      {{ SC_(92.46335601806640625), SC_(0.6323592662811279296875), SC_(95.065692163132714221761558935562650058294649890967), SC_(88.565386987566008236603182155514295227663898474246) }}, 
      {{ SC_(92.46335601806640625), SC_(0.814723670482635498046875), SC_(100.5369473337229272155480072403604706803929353327), SC_(83.323473376708319354682692195463959283747239453997) }}, 
      {{ SC_(92.46335601806640625), SC_(0.835008561611175537109375), SC_(101.31782781209452431981520461575490476358302776333), SC_(82.591692315349241089278956062887078969911461565506) }}, 
      {{ SC_(92.46335601806640625), SC_(0.905791938304901123046875), SC_(104.72545014408943198303181011615685161762160253903), SC_(79.444713950567701557426742977240109970470926118863) }}, 
      {{ SC_(92.46335601806640625), SC_(0.9133758544921875), SC_(105.193480083473658627084807927338148801777290855), SC_(79.01829303196521315268481504849434216156252309685) }}, 
      {{ SC_(92.46335601806640625), SC_(0.957506835460662841796875), SC_(108.84201847573758616613983058378466972097537018215), SC_(75.741145940538776370843452201703739688688021328114) }}, 
      {{ SC_(92.46335601806640625), SC_(0.964888513088226318359375), SC_(109.73878419084280759373282707418276363330770035722), SC_(74.948239646205953548702815221368133817988824009019) }}, 
      {{ SC_(92.46335601806640625), SC_(0.967694938182830810546875), SC_(110.1213951153509737792954543580587696172037965924), SC_(74.611429927937825324126852607575575336259223046235) }}, 
      {{ SC_(92.46335601806640625), SC_(0.968867778778076171875), SC_(110.28960012012223245395106603471532783757932178179), SC_(74.463640895488986731544712908668438357666071823683) }}, 
      {{ SC_(92.46335601806640625), SC_(0.992881298065185546875), SC_(116.34178974502605772740865693843689317163906647352), SC_(69.258023167049898591579198761970319534604959118839) }}, 
      {{ SC_(92.46335601806640625), SC_(0.996461331844329833984375), SC_(118.86899907588089249819730952498892803536950195115), SC_(67.147317056951180202296638950750186102915727473141) }}, 
      {{ SC_(93.070068359375), SC_(0.097540400922298431396484375), SC_(80.190180767201047438584127857080846586159231887536), SC_(105.17633876887803387023097922958333954221860456054) }}, 
      {{ SC_(93.070068359375), SC_(0.12698681652545928955078125), SC_(81.620524001137966777941688921563162477526311949682), SC_(103.61999909693632003505128751654502481540886882325) }}, 
      {{ SC_(93.070068359375), SC_(0.135477006435394287109375), SC_(81.990033677429950163245752676911769334743154909802), SC_(103.22065453548512330190203605097489280884494155533) }}, 
      {{ SC_(93.070068359375), SC_(0.188381969928741455078125), SC_(84.010028595694127338200813414664579405188042572589), SC_(101.05695321994007558359909237098445072885775310274) }}, 
      {{ SC_(93.070068359375), SC_(0.22103404998779296875), SC_(85.088676297186459241051890386476168572046877377707), SC_(99.914807846441948617880261774307863988683838409148) }}, 
      {{ SC_(93.070068359375), SC_(0.278498232364654541015625), SC_(86.796754247060508491559040251430505744607709369078), SC_(98.124674211645919322391502678589453771701219568361) }}, 
      {{ SC_(93.070068359375), SC_(0.308167040348052978515625), SC_(87.612875284252935405590254377093716406929622696301), SC_(97.277238989148364919730416589810116054689313548795) }}, 
      {{ SC_(93.070068359375), SC_(0.546881496906280517578125), SC_(93.541481193900623396510897325026282182641650268945), SC_(91.269524659302002668129086116861716167215683431575) }}, 
      {{ SC_(93.070068359375), SC_(0.54722058773040771484375), SC_(93.549769882971089783645776166093766121697307214311), SC_(91.261303463434570260760576997664354789917647958022) }}, 
      {{ SC_(93.070068359375), SC_(0.6323592662811279296875), SC_(95.683058246309823869280394108236410849823254639446), SC_(89.161448232351710617311772043272811440639743932474) }}, 
      {{ SC_(93.070068359375), SC_(0.814723670482635498046875), SC_(101.17187498183158493518697697789223878045065856059), SC_(83.901971912693552085021370520395288360807440620226) }}, 
      {{ SC_(93.070068359375), SC_(0.835008561611175537109375), SC_(101.95523607124827940411353123044214411039138548459), SC_(83.167709930332428246751135883944355798185260204988) }}, 
      {{ SC_(93.070068359375), SC_(0.905791938304901123046875), SC_(105.37361130680244135217151365650622094751422354585), SC_(80.009976630607086247564985410783942660135456059602) }}, 
      {{ SC_(93.070068359375), SC_(0.9133758544921875), SC_(105.8431091832272008483055616495391091822782304633), SC_(79.5820873903703273643613204603454371363224312354) }}, 
      {{ SC_(93.070068359375), SC_(0.957506835460662841796875), SC_(109.50301937199653391756142582473457188610231972936), SC_(76.293564329985415660326938422165257467224225817975) }}, 
      {{ SC_(93.070068359375), SC_(0.964888513088226318359375), SC_(110.40256116350098996898854980424791294167303581959), SC_(75.497880553362761736599935278565325218347093467695) }}, 
      {{ SC_(93.070068359375), SC_(0.967694938182830810546875), SC_(110.78635429164723387401247672462956450449722775856), SC_(75.159887978123551342927327324939537431539687364192) }}, 
      {{ SC_(93.070068359375), SC_(0.968867778778076171875), SC_(110.95507860284919662548670455605508698020641749404), SC_(75.011579341433547269256330299847125014965035203826) }}, 
      {{ SC_(93.070068359375), SC_(0.992881298065185546875), SC_(117.02578809323804498649533732504977589520280784946), SC_(69.787425794842705183018432566516412758493141444662) }}, 
      {{ SC_(93.070068359375), SC_(0.996461331844329833984375), SC_(119.56063908164793917813240533624224856342628791395), SC_(67.669067567258052468486386717336134231145041121501) }}, 
      {{ SC_(97.50942230224609375), SC_(0.097540400922298431396484375), SC_(84.334730289130965545262389129214820368488394624841), SC_(109.91049235827021728586835632039520951173022695148) }}, 
      {{ SC_(97.50942230224609375), SC_(0.12698681652545928955078125), SC_(85.800345090817981221829041650598191039560852995101), SC_(108.31888835349878319303812323639932796492421066105) }}, 
      {{ SC_(97.50942230224609375), SC_(0.135477006435394287109375), SC_(86.178932613051346929747870357829354046238952121091), SC_(107.91046750482741592386917095270522040450369004424) }}, 
      {{ SC_(97.50942230224609375), SC_(0.188381969928741455078125), SC_(88.248311600057558539842327410591146684828908407627), SC_(105.69738880201437751826225712161647159244793734167) }}, 
      {{ SC_(97.50942230224609375), SC_(0.22103404998779296875), SC_(89.353165729412449175615237429679525994435052185594), SC_(104.52903951773822359684438142631895213182285417866) }}, 
      {{ SC_(97.50942230224609375), SC_(0.278498232364654541015625), SC_(91.10251554607446676299557156319012411580364762322), SC_(102.69763687478096199695411648691506699383853272752) }}, 
      {{ SC_(97.50942230224609375), SC_(0.308167040348052978515625), SC_(91.938260111178920345444959509202207659726714391116), SC_(101.83057909830677420437407874772893264308415597261) }}, 
      {{ SC_(97.50942230224609375), SC_(0.546881496906280517578125), SC_(98.007637409902081796954066425117173547274235025745), SC_(95.682095552433069813634147367960209430799602808304) }}, 
      {{ SC_(97.50942230224609375), SC_(0.54722058773040771484375), SC_(98.016120797032766069762836540559631718251307244158), SC_(95.673679656826783906449026043409523633568901284124) }}, 
      {{ SC_(97.50942230224609375), SC_(0.6323592662811279296875), SC_(100.19933150577687904086266141166008391726253299928), SC_(93.523901212015488195583743409481004197082147112786) }}, 
      {{ SC_(97.50942230224609375), SC_(0.814723670482635498046875), SC_(105.81494179973019180886443362707577349500115370849), SC_(88.137623393137821807489611763921510296000509101214) }}, 
      {{ SC_(97.50942230224609375), SC_(0.835008561611175537109375), SC_(106.61621268755922976200012059506908649376862421917), SC_(87.385449461036097861918536788142991030030693606217) }}, 
      {{ SC_(97.50942230224609375), SC_(0.905791938304901123046875), SC_(110.11222263638478181419530820113133306371995495468), SC_(84.150067351017829490666489645487365455516714219145) }}, 
      {{ SC_(97.50942230224609375), SC_(0.9133758544921875), SC_(110.59231880121337872819907079191639737634041074693), SC_(83.711577153771541707725956647149145469822350719205) }}, 
      {{ SC_(97.50942230224609375), SC_(0.957506835460662841796875), SC_(114.33433123807107131715636724350534943119078900783), SC_(80.340922897890996493176556041660894741781863419975) }}, 
      {{ SC_(97.50942230224609375), SC_(0.964888513088226318359375), SC_(115.25391565355845053669733172178000173877216845161), SC_(79.525186744935285095738994948680810805313605104552) }}, 
      {{ SC_(97.50942230224609375), SC_(0.967694938182830810546875), SC_(115.64624399956107214416550401369069894660905102001), SC_(79.178654420002714741933361087375656943317876953282) }}, 
      {{ SC_(97.50942230224609375), SC_(0.968867778778076171875), SC_(115.81871757154410082389426043195232216643243893591), SC_(79.026594456810150728045692694520749686991876024809) }}, 
      {{ SC_(97.50942230224609375), SC_(0.992881298065185546875), SC_(122.02313441056405167602911274904663599588577605625), SC_(73.668622934166266602815804822069174086850643660281) }}, 
      {{ SC_(97.50942230224609375), SC_(0.996461331844329833984375), SC_(124.61315479736835031696219078555534410920036288274), SC_(71.495022792245047667283036083723799279418500223586) }}, 
      {{ SC_(158.0711669921875), SC_(0.097540400922298431396484375), SC_(141.39930401458994540018781611027104932984289976636), SC_(173.96936913722630761753971169868755796723391942019) }}, 
      {{ SC_(158.0711669921875), SC_(0.12698681652545928955078125), SC_(143.28328090256702021851031819369491013717709171459), SC_(171.95946121788005258895686141055036125583168547164) }}, 
      {{ SC_(158.0711669921875), SC_(0.135477006435394287109375), SC_(143.76954549610446346479850521665451341719759610947), SC_(171.44337583758961462560542164817333949059100072216) }}, 
      {{ SC_(158.0711669921875), SC_(0.188381969928741455078125), SC_(146.42471460757327494069155935558403708035564628941), SC_(168.64456079854188335325215162678341151219436929099) }}, 
      {{ SC_(158.0711669921875), SC_(0.22103404998779296875), SC_(147.84043929529586098976171826507697658071964712425), SC_(167.16536123938907164035077133225553074595024487985) }}, 
      {{ SC_(158.0711669921875), SC_(0.278498232364654541015625), SC_(150.0793849915284335947734585334366792020127515208), SC_(164.84438577208764135822461293373459258820951001914) }}, 
      {{ SC_(158.0711669921875), SC_(0.308167040348052978515625), SC_(151.14792236571479683547137161685857116913707210936), SC_(163.74454304770130639876658366745601398817376260341) }}, 
      {{ SC_(158.0711669921875), SC_(0.546881496906280517578125), SC_(158.88731123886938386983182718082603040224594160361), SC_(155.92606548355687798492172882312461914553188703408) }}, 
      {{ SC_(158.0711669921875), SC_(0.54722058773040771484375), SC_(158.89810440710819228764582708329659131906642944275), SC_(155.9153397932697471081927999047683583426829416034) }}, 
      {{ SC_(158.0711669921875), SC_(0.6323592662811279296875), SC_(161.6735621561061358634614477565109303759788795868), SC_(153.17330728982976217945532403987222851943428283692) }}, 
      {{ SC_(158.0711669921875), SC_(0.814723670482635498046875), SC_(168.79332718949371880240531803697845005906761996155), SC_(146.28281068668283052673836788002159079963814632258) }}, 
      {{ SC_(158.0711669921875), SC_(0.835008561611175537109375), SC_(169.80705402505213255520005203771359901930396291946), SC_(145.31816348155600965239857173817231151310281278493) }}, 
      {{ SC_(158.0711669921875), SC_(0.905791938304901123046875), SC_(174.2239759889790674610923772970513357124914485025), SC_(141.16175597319258129242068902820618879278233013722) }}, 
      {{ SC_(158.0711669921875), SC_(0.9133758544921875), SC_(174.82978545099122536651222339453302137453778065061), SC_(140.5975310356458619085934775086282737306100110647) }}, 
      {{ SC_(158.0711669921875), SC_(0.957506835460662841796875), SC_(179.54562070691279013821200108769908820552347097549), SC_(136.252821628631376639252561033615709625920561977) }}, 
      {{ SC_(158.0711669921875), SC_(0.964888513088226318359375), SC_(180.70291909696247018159949000309925923228355806836), SC_(135.19929331442113890254665235728083639486227301149) }}, 
      {{ SC_(158.0711669921875), SC_(0.967694938182830810546875), SC_(181.19647698413507551954037432789902423734319506316), SC_(134.75149512749864967649770240275272942808248241845) }}, 
      {{ SC_(158.0711669921875), SC_(0.968867778778076171875), SC_(181.413417269003555098383080566493127065432574479), SC_(134.55495189786423296982375793291653440815525821183) }}, 
      {{ SC_(158.0711669921875), SC_(0.992881298065185546875), SC_(189.20347477378305235313677520776493352698354738815), SC_(127.61045483969625865918997317770910954980337404811) }}, 
      {{ SC_(158.0711669921875), SC_(0.996461331844329833984375), SC_(192.44766054931038752526528990965921838391984730004), SC_(124.78211058379508565778631343960934648155163063083) }}, 
      {{ SC_(172.6705322265625), SC_(0.097540400922298431396484375), SC_(155.26276987796449283879663196089044530269534102833), SC_(189.30462837841144440476358983820428128617902221517) }}, 
      {{ SC_(172.6705322265625), SC_(0.12698681652545928955078125), SC_(157.2347725219936234321704107895981963907837200622), SC_(187.20670263009715533789512148339573430492868437576) }}, 
      {{ SC_(172.6705322265625), SC_(0.135477006435394287109375), SC_(157.74369351969000608239169170725971270073592702706), SC_(186.667962555388048942886511589024940170462321829) }}, 
      {{ SC_(172.6705322265625), SC_(0.188381969928741455078125), SC_(160.52212247869622847416578583773234229055786843995), SC_(183.745895007681961641552447526831511502667321977) }}, 
      {{ SC_(172.6705322265625), SC_(0.22103404998779296875), SC_(162.00326143632704860448917840682988828231819598846), SC_(182.20128394886438264703187798224213628514144475606) }}, 
      {{ SC_(172.6705322265625), SC_(0.278498232364654541015625), SC_(164.34523156119672510498758273803622599946682794785), SC_(179.77728720439928537590761400654967403463999548066) }}, 
      {{ SC_(172.6705322265625), SC_(0.308167040348052978515625), SC_(165.46275574259298743432098517467010542964611900856), SC_(178.62845874822270488284372544096799778530184248102) }}, 
      {{ SC_(172.6705322265625), SC_(0.546881496906280517578125), SC_(173.55357490569441249157766276452936740920252531079), SC_(170.45855329807726412452509367246357667342769065223) }}, 
      {{ SC_(172.6705322265625), SC_(0.54722058773040771484375), SC_(173.56485413829524145127666094687867154949021994143), SC_(170.44734154156811333684708750549931423743859265428) }}, 
      {{ SC_(172.6705322265625), SC_(0.6323592662811279296875), SC_(176.46494250917749453409676709788205192837362652786), SC_(167.58067745479308659342765894818122644903507770994) }}, 
      {{ SC_(172.6705322265625), SC_(0.814723670482635498046875), SC_(183.90122951068662326846591937667772180489013272705), SC_(160.37365012890942336171886048667418988179934530542) }}, 
      {{ SC_(172.6705322265625), SC_(0.835008561611175537109375), SC_(184.95966236006423828023793529868930156146802707127), SC_(159.3642945452242456442769580571319977356473085762) }}, 
      {{ SC_(172.6705322265625), SC_(0.905791938304901123046875), SC_(189.57036114117423417570021853745270389788819200132), SC_(155.01409476375046606437632423936204738548870280739) }}, 
      {{ SC_(172.6705322265625), SC_(0.9133758544921875), SC_(190.20262214089795562719122809187546463787760233939), SC_(154.42341536829176353328275562079579673928089273559) }}, 
      {{ SC_(172.6705322265625), SC_(0.957506835460662841796875), SC_(195.12335288348622811220076567859980895086261989431), SC_(149.87377887178720381221077030738030742013275243386) }}, 
      {{ SC_(172.6705322265625), SC_(0.964888513088226318359375), SC_(196.33066467110972651017331434738226874748186240122), SC_(148.77022653645302137736160360578428723767995776931) }}, 
      {{ SC_(172.6705322265625), SC_(0.967694938182830810546875), SC_(196.845520254247767215341120051624908094959402687), SC_(148.30112572013273898846721039093001103635856842391) }}, 
      {{ SC_(172.6705322265625), SC_(0.968867778778076171875), SC_(197.07181583698222896992950460817389748958274433431), SC_(148.0952249444964699277280837320424445023674423676) }}, 
      {{ SC_(172.6705322265625), SC_(0.992881298065185546875), SC_(205.19544851840710044775818468167467387930822469968), SC_(140.81703275903276226379343701430285289551949588087) }}, 
      {{ SC_(172.6705322265625), SC_(0.996461331844329833984375), SC_(208.57723655924317711044575764822367617407357748671), SC_(137.85100796471648376227497317071806430594333287166) }}, 
      {{ SC_(343.941375732421875), SC_(0.097540400922298431396484375), SC_(319.52859348120262957645041341655347362020302577062), SC_(367.58046257085413446137527546232265010183716615753) }}, 
      {{ SC_(343.941375732421875), SC_(0.12698681652545928955078125), SC_(322.33843351781428344524376346585333592867199869227), SC_(364.64474220164073048002245959119931472091646603766) }}, 
      {{ SC_(343.941375732421875), SC_(0.135477006435394287109375), SC_(323.06300507925157545126411383765155955284962903245), SC_(363.89036079225902258175948218042862831478173586452) }}, 
      {{ SC_(343.941375732421875), SC_(0.188381969928741455078125), SC_(327.01468884410804594677050805521792123188976795099), SC_(359.79507807435066955378972943683488595637740101119) }}, 
      {{ SC_(343.941375732421875), SC_(0.22103404998779296875), SC_(329.11849465353463628500266639469983579627555320678), SC_(357.62781513659795683100486737137731610221408365146) }}, 
      {{ SC_(343.941375732421875), SC_(0.278498232364654541015625), SC_(332.44115642086080923512563467698537637439517869951), SC_(354.2231437940991571895153895393925589573628991326) }}, 
      {{ SC_(343.941375732421875), SC_(0.308167040348052978515625), SC_(334.02499423455692106820607692406318849463959626598), SC_(352.60800752546254496597342401859025335607813057694) }}, 
      {{ SC_(343.941375732421875), SC_(0.546881496906280517578125), SC_(345.46121068547064473668301441674402861018506260458), SC_(341.0927178061556260205012594464902565742727351756) }}, 
      {{ SC_(343.941375732421875), SC_(0.54722058773040771484375), SC_(345.47711697913893258921432502509539971518233670799), SC_(341.07687897849993000186931693380144472337446467921) }}, 
      {{ SC_(343.941375732421875), SC_(0.6323592662811279296875), SC_(349.56361611281868988574142196794017480435796644167), SC_(337.02379892037415974324110858584141950140615910272) }}, 
      {{ SC_(343.941375732421875), SC_(0.814723670482635498046875), SC_(360.01293394301724997491319975978028550819665991333), SC_(326.80369341662446794086774578678508138574243613798) }}, 
      {{ SC_(343.941375732421875), SC_(0.835008561611175537109375), SC_(361.4969175061521603929666991064046266869507936824), SC_(325.36877434415638638140640152843504112319238324225) }}, 
      {{ SC_(343.941375732421875), SC_(0.905791938304901123046875), SC_(367.95209534070281285564214935447460943533843793798), SC_(319.17401209340509296292533057273098155396766120142) }}, 
      {{ SC_(343.941375732421875), SC_(0.9133758544921875), SC_(368.83612909654336404984965404884302642188511372918), SC_(318.33154419315381577836628818669341086413147439836) }}, 
      {{ SC_(343.941375732421875), SC_(0.957506835460662841796875), SC_(375.7070309187892614533485302743963702559237337619), SC_(311.83156633462336416702078396241369003176997015578) }}, 
      {{ SC_(343.941375732421875), SC_(0.964888513088226318359375), SC_(377.39034115914262207957274900548682058762187983703), SC_(310.25195835293005219150343253186376409070182314542) }}, 
      {{ SC_(343.941375732421875), SC_(0.967694938182830810546875), SC_(378.10789284334281260807020620530773072693388853821), SC_(309.5801348822718050381774412914620671348840415658) }}, 
      {{ SC_(343.941375732421875), SC_(0.968867778778076171875), SC_(378.42322482269838135749591142066116673632157308079), SC_(309.28518561116417770865167910789774401383753298091) }}, 
      {{ SC_(343.941375732421875), SC_(0.992881298065185546875), SC_(389.72131289364466116410416488899635208762186768813), SC_(298.83189340467096767657305227458387853910147714465) }}, 
      {{ SC_(343.941375732421875), SC_(0.996461331844329833984375), SC_(394.41242956222249893987240602868232584925877296371), SC_(294.5561200509978835371151544952202830582774047984) }}, 
      {{ SC_(569.76220703125), SC_(0.097540400922298431396484375), SC_(538.45030039031537223511672672755988073568121136779), SC_(600.30040644706731020621005354900165878830335948085) }}, 
      {{ SC_(569.76220703125), SC_(0.12698681652545928955078125), SC_(542.08524130793528778924696517422920188232333796285), SC_(596.53960230243584125350100030341293668486372816616) }}, 
      {{ SC_(569.76220703125), SC_(0.135477006435394287109375), SC_(543.02218950968988085128891214412311414609086957687), SC_(595.57284794554982812643492687792909065252807636993) }}, 
      {{ SC_(569.76220703125), SC_(0.188381969928741455078125), SC_(548.12934331563329581440340966336826823474131360043), SC_(590.32211105573753546281829889693077399392121649682) }}, 
      {{ SC_(569.76220703125), SC_(0.22103404998779296875), SC_(550.84639357817344913115651838141420278711066644314), SC_(587.54160966502683229457807611289229074649790795304) }}, 
      {{ SC_(569.76220703125), SC_(0.278498232364654541015625), SC_(555.13492532541460607456549293372367896743828278906), SC_(583.17107517813122130837418138728694762022141485725) }}, 
      {{ SC_(569.76220703125), SC_(0.308167040348052978515625), SC_(557.1780357080541696025240381981526201942226358325), SC_(581.09666867621769999505668401704059932056267944095) }}, 
      {{ SC_(569.76220703125), SC_(0.546881496906280517578125), SC_(571.90920239096662385576391800578448563755582505978), SC_(566.2864339540194956598392755317983382970112589154) }}, 
      {{ SC_(569.76220703125), SC_(0.54722058773040771484375), SC_(571.92966599918166554253764083769625949033845351031), SC_(566.26603780776573262364334820203823771464547304344) }}, 
      {{ SC_(569.76220703125), SC_(0.6323592662811279296875), SC_(577.18468935759428610001358732671802957739052803431), SC_(561.04443143198467885282782555446681310974694651433) }}, 
      {{ SC_(569.76220703125), SC_(0.814723670482635498046875), SC_(590.60154262143829455324989824499458064073122360726), SC_(547.856771505263888626757127179895196114427983818) }}, 
      {{ SC_(569.76220703125), SC_(0.835008561611175537109375), SC_(592.50463785230571254428992611264902789091424168145), SC_(546.0027356485470540812974168258652005248568390162) }}, 
      {{ SC_(569.76220703125), SC_(0.905791938304901123046875), SC_(600.77633100840406756346970524552444028654634341474), SC_(537.99142470591477846001288790821867726479890944736) }}, 
      {{ SC_(569.76220703125), SC_(0.9133758544921875), SC_(601.90831261019936014596994111921091142589619055786), SC_(536.90100266498684833863377189798652206407925209042) }}, 
      {{ SC_(569.76220703125), SC_(0.957506835460662841796875), SC_(610.69968309331161026211184187445284658726962558934), SC_(528.48048815549479123478865563111774590011283705576) }}, 
      {{ SC_(569.76220703125), SC_(0.964888513088226318359375), SC_(612.8517196603507746509124259182678427694269571442), SC_(526.43213103357586497635943083178324232573553845347) }}, 
      {{ SC_(569.76220703125), SC_(0.967694938182830810546875), SC_(613.76886783755978873050727093775139036032788769649), SC_(525.560700481401705189450126840950642960488084) }}, 
      {{ SC_(569.76220703125), SC_(0.968867778778076171875), SC_(614.17187411940339877038207026688412506643030476477), SC_(525.17807208383210656457051479885617135528888655135) }}, 
      {{ SC_(569.76220703125), SC_(0.992881298065185546875), SC_(628.59560973994366617206998434931984561300078835384), SC_(511.59887573033155421871635167102019231685169968837) }}, 
      {{ SC_(569.76220703125), SC_(0.996461331844329833984375), SC_(634.57576976847875529807976408334321457506629757947), SC_(506.03389219719146098410453921822122389635018884613) }}, 
      {{ SC_(677.01727294921875), SC_(0.097540400922298431396484375), SC_(642.91957002956452031050346512146396420717402000347), SC_(710.34126578181259946677430179514987197840671528836) }}, 
      {{ SC_(677.01727294921875), SC_(0.12698681652545928955078125), SC_(646.88766862133561420411373212005939543252214673924), SC_(706.24730809167535247137260445192242929183589329444) }}, 
      {{ SC_(677.01727294921875), SC_(0.135477006435394287109375), SC_(647.91037045614661115591875711814070986216195729885), SC_(705.19480099319705924545444664289984970315639677861) }}, 
      {{ SC_(677.01727294921875), SC_(0.188381969928741455078125), SC_(653.48408474913253548362179782252058727086499922471), SC_(699.47750744808512192684508980001093553515488038336) }}, 
      {{ SC_(677.01727294921875), SC_(0.22103404998779296875), SC_(656.44875565144928730584655883775976069105452933018), SC_(696.44938686684322233150035914196315241199982173481) }}, 
      {{ SC_(677.01727294921875), SC_(0.278498232364654541015625), SC_(661.12729648946935993602062203317134305478766160372), SC_(691.6888449406285986346415952602607215541910391933) }}, 
      {{ SC_(677.01727294921875), SC_(0.308167040348052978515625), SC_(663.35585766604980836222914512581980943145583166855), SC_(689.42898820921343229689471545872333012289399175848) }}, 
      {{ SC_(677.01727294921875), SC_(0.546881496906280517578125), SC_(679.41750953167193757640545600848709854017104449147), SC_(673.28826956834802290275123751702295264510934935621) }}, 
      {{ SC_(677.01727294921875), SC_(0.54722058773040771484375), SC_(679.439813365399650216806007417415929600134859859), SC_(673.26603319560200788906336297738825729505499983964) }}, 
      {{ SC_(677.01727294921875), SC_(0.6323592662811279296875), SC_(685.16668170995136815512880394977788534219754378554), SC_(667.57258132768388094012069751217444313461206711471) }}, 
      {{ SC_(677.01727294921875), SC_(0.814723670482635498046875), SC_(699.78180256191297181745787886323745544801039269028), SC_(653.18664922499801268220886865957715167032802159489) }}, 
      {{ SC_(677.01727294921875), SC_(0.835008561611175537109375), SC_(701.85412984993555477138325197892885155261173875602), SC_(651.16338007555682329517923243344180942108653377736) }}, 
      {{ SC_(677.01727294921875), SC_(0.905791938304901123046875), SC_(710.85930121398056502005391393573658955515342254981), SC_(642.41858286978042713831737573303753580486169035744) }}, 
      {{ SC_(677.01727294921875), SC_(0.9133758544921875), SC_(712.09139882183290167869691721078026052130705704984), SC_(641.228043303795030348158280951903898931883071141) }}, 
      {{ SC_(677.01727294921875), SC_(0.957506835460662841796875), SC_(721.65820214300190701023408117810509437101670003484), SC_(632.03207955542592897907259782998601320790100956135) }}, 
      {{ SC_(677.01727294921875), SC_(0.964888513088226318359375), SC_(723.99949432229638655154119056682865437763848524761), SC_(629.79446132001584139957406571028863388485520069556) }}, 
      {{ SC_(677.01727294921875), SC_(0.967694938182830810546875), SC_(724.99723229018329529837489574458360436305564279498), SC_(628.84243842412759959160201537845150666923726968521) }}, 
      {{ SC_(677.01727294921875), SC_(0.968867778778076171875), SC_(725.43563817813245582466749972902951192848304939416), SC_(628.42440925737804967254026122315220910849693653552) }}, 
      {{ SC_(677.01727294921875), SC_(0.992881298065185546875), SC_(741.12135725059247779601954017373673271599111677915), SC_(613.5831676217110956950174270854090892568855564598) }}, 
      {{ SC_(677.01727294921875), SC_(0.996461331844329833984375), SC_(747.62194696456693210540372548784701775785919047868), SC_(607.49771423436714130088394928923236856550733433893) }}, 
      {{ SC_(2116.12060546875), SC_(0.097540400922298431396484375), SC_(2056.131544742772408932858643805303950981232752818), SC_(2175.3359457304797970785037100641123349568038588379) }}, 
      {{ SC_(2116.12060546875), SC_(0.12698681652545928955078125), SC_(2063.1959270721276706498819302555851852959860945849), SC_(2168.145719222154724036931566914347873067385368355) }}, 
      {{ SC_(2116.12060546875), SC_(0.135477006435394287109375), SC_(2065.0156080558051561305405020255761335367685351136), SC_(2166.2962361967432753815657498511283230778884122013) }}, 
      {{ SC_(2116.12060546875), SC_(0.188381969928741455078125), SC_(2074.9254937706348888788098039608450112124443808143), SC_(2156.2427850812096499720210455461512059777264058851) }}, 
      {{ SC_(2116.12060546875), SC_(0.22103404998779296875), SC_(2080.191553129738008965829769299669473961816057503), SC_(2150.9132812835668596541586003931248430983258162759) }}, 
      {{ SC_(2116.12060546875), SC_(0.278498232364654541015625), SC_(2088.494869744926400530419366208349116599222198336), SC_(2142.5279695532082951577616260929808659784728040516) }}, 
      {{ SC_(2116.12060546875), SC_(0.308167040348052978515625), SC_(2092.4470353455992512072041416784592399887614097273), SC_(2138.5445104396349291534141036289050624213170125972) }}, 
      {{ SC_(2116.12060546875), SC_(0.546881496906280517578125), SC_(2120.8744931713974196430378849569991514817739348621), SC_(2110.0379904126398533345883759827042160255959880304) }}, 
      {{ SC_(2116.12060546875), SC_(0.54722058773040771484375), SC_(2120.9139004816857211263381566474335413399425926598), SC_(2109.9986505597877445790957391347041866317817036102) }}, 
      {{ SC_(2116.12060546875), SC_(0.6323592662811279296875), SC_(2131.0261987234513924823236164684832872712903611799), SC_(2099.9197669634262486689664835804784923413832743398) }}, 
      {{ SC_(2116.12060546875), SC_(0.814723670482635498046875), SC_(2156.7781623132757148773264856230997475967899016508), SC_(2074.3969755293861034226502326154089716551704583128) }}, 
      {{ SC_(2116.12060546875), SC_(0.835008561611175537109375), SC_(2160.4233304818763757344447976700753289028650300668), SC_(2070.8008610324208942390039818599221856323441049959) }}, 
      {{ SC_(2116.12060546875), SC_(0.905791938304901123046875), SC_(2176.2453494464134566128218322938753807973910947795), SC_(2055.2391871148797079611505694759189250031135309311) }}, 
      {{ SC_(2116.12060546875), SC_(0.9133758544921875), SC_(2178.4078986712979241924541284206298932111503287432), SC_(2053.1181904437551686430745112630580255403060549386) }}, 
      {{ SC_(2116.12060546875), SC_(0.957506835460662841796875), SC_(2195.1812425894289226571940248275039809417912249934), SC_(2036.7156268624278931424545634412307301686029801535) }}, 
      {{ SC_(2116.12060546875), SC_(0.964888513088226318359375), SC_(2199.2813577438241106170937852846874153889528355289), SC_(2032.7191657889547895029550221244370256123542219595) }}, 
      {{ SC_(2116.12060546875), SC_(0.967694938182830810546875), SC_(2201.028041797465614878174260623219344982022186032), SC_(2031.0181875900878013681518623055003909690790974723) }}, 
      {{ SC_(2116.12060546875), SC_(0.968867778778076171875), SC_(2201.7954263315647541150281933266278476205842567018), SC_(2030.271175578312197998561016585672885006572763346) }}, 
      {{ SC_(2116.12060546875), SC_(0.992881298065185546875), SC_(2229.20870151369012570773754197936771308115802723), SC_(2003.7021547329206222561892892916327507891069653666) }}, 
      {{ SC_(2116.12060546875), SC_(0.996461331844329833984375), SC_(2240.5453564989999961029978191482616642194855574606), SC_(1992.7804912260618072358104375284439748960983752545) }}, 
      {{ SC_(4018.59375), SC_(0.097540400922298431396484375), SC_(3936.0707839936534658068037709837022154028468240748), SC_(4100.3429932228490132295562962037005580067753995907) }}, 
      {{ SC_(4018.59375), SC_(0.12698681652545928955078125), SC_(3945.8298848072531681967763115326701011222304385175), SC_(4090.4580515539203116157511318979828037430114145067) }}, 
      {{ SC_(4018.59375), SC_(0.135477006435394287109375), SC_(3948.3431860784393591046949054916115421166424892548), SC_(4087.9149489588695231903231724914509574846610121261) }}, 
      {{ SC_(4018.59375), SC_(0.188381969928741455078125), SC_(3962.026914533454778256547392766703660328918691298), SC_(4074.0876581899245589773390008815568240494771257502) }}, 
      {{ SC_(4018.59375), SC_(0.22103404998779296875), SC_(3969.295924119662357253869063628711157720432722442), SC_(4066.7552053333087195454276384083262938716698670437) }}, 
      {{ SC_(4018.59375), SC_(0.278498232364654541015625), SC_(3980.7539798627947628756315568703636848849885829801), SC_(4055.2151558067574346196529235040270145416328741923) }}, 
      {{ SC_(4018.59375), SC_(0.308167040348052978515625), SC_(3986.2062497747154496657643353483985833864589926666), SC_(4049.7315928373063815919969814866367902655466295348) }}, 
      {{ SC_(4018.59375), SC_(0.546881496906280517578125), SC_(4025.3960908602849123767621274849217695199979072139), SC_(4010.4626905708512464892384826977057329281210078885) }}, 
      {{ SC_(4018.59375), SC_(0.54722058773040771484375), SC_(4025.4503839302755820703244733259089479264879146024), SC_(4010.4084649575057182910577968043910936545212117068) }}, 
      {{ SC_(4018.59375), SC_(0.6323592662811279296875), SC_(4039.3794736838035237650906169931411509654406401368), SC_(3996.512789440848630240966788632148807590981569034) }}, 
      {{ SC_(4018.59375), SC_(0.814723670482635498046875), SC_(4074.8241513151548652841669363596596548803529459764), SC_(3961.2972802655596803731971008364528155066493702018) }}, 
      {{ SC_(4018.59375), SC_(0.835008561611175537109375), SC_(4079.8381955836874305784404198828105645281082681895), SC_(3956.3322886731084834061109902611558574385738950652) }}, 
      {{ SC_(4018.59375), SC_(0.905791938304901123046875), SC_(4101.5930074190889591181905761620964358329914747529), SC_(3934.8378153989023604313456729116156244619773576471) }}, 
      {{ SC_(4018.59375), SC_(0.9133758544921875), SC_(4104.5653336524982007455874636264703567320104886892), SC_(3931.9070404968629919119483108796691931684445299499) }}, 
      {{ SC_(4018.59375), SC_(0.957506835460662841796875), SC_(4127.6104965933207419244325669411994374078163135082), SC_(3909.2326447031534155938018309060133626563083616482) }}, 
      {{ SC_(4018.59375), SC_(0.964888513088226318359375), SC_(4133.2412859243264517014798650589658140926827665051), SC_(3903.7055050316430475007438389660944997197219760915) }}, 
      {{ SC_(4018.59375), SC_(0.967694938182830810546875), SC_(4135.6397624325915555302918946373349154120603162533), SC_(3901.3527323266136235969547226692101670194348625531) }}, 
      {{ SC_(4018.59375), SC_(0.968867778778076171875), SC_(4136.6934498135746505912159625886179747445584419212), SC_(3900.3194165334185826338280305204678046660132784103) }}, 
      {{ SC_(4018.59375), SC_(0.992881298065185546875), SC_(4174.3127205116233800136099201444135805703494110839), SC_(3863.5443505419649285195936402915256514724289152547) }}, 
      {{ SC_(4018.59375), SC_(0.996461331844329833984375), SC_(4189.8578469221414122575403980876518068299164107252), SC_(3848.4141834068660975656489719558688726469405687791) }}, 
      {{ SC_(5101.35546875), SC_(0.097540400922298431396484375), SC_(5008.426152334151347018466615583704166261306909695), SC_(5193.5110618343812434701391571589148086548206096888) }}, 
      {{ SC_(5101.35546875), SC_(0.12698681652545928955078125), SC_(5019.4296910051169477313031600605321003023754924692), SC_(5182.3816830927945755870832159846294799865531524683) }}, 
      {{ SC_(5101.35546875), SC_(0.135477006435394287109375), SC_(5022.2633108553966419228383432767835999568254565268), SC_(5179.5182620881442498342515988120540644312665750361) }}, 
      {{ SC_(5101.35546875), SC_(0.188381969928741455078125), SC_(5037.689828091456472035432279595506972532995229467), SC_(5163.9481832669946720329180400716555474916132659457) }}, 
      {{ SC_(5101.35546875), SC_(0.22103404998779296875), SC_(5045.8838165500017329382878994900282136599876709415), SC_(5155.6907518138736540429861597679212700630561335636) }}, 
      {{ SC_(5101.35546875), SC_(0.278498232364654541015625), SC_(5058.7987584428690010603073093824403971797603275662), SC_(5142.6938164520721561234287347532261579850659203431) }}, 
      {{ SC_(5101.35546875), SC_(0.308167040348052978515625), SC_(5064.9437902636676935534342928283342608293049182478), SC_(5136.5174916812811145370471667778822886942667906736) }}, 
      {{ SC_(5101.35546875), SC_(0.546881496906280517578125), SC_(5109.1038045230881577773454494131957747377023339049), SC_(5092.2784164819403957943872445330649961218154397982) }}, 
      {{ SC_(5101.35546875), SC_(0.54722058773040771484375), SC_(5109.1649719837236339817513121458663734755641629981), SC_(5092.2173164777632305341962687195555754779642827745) }}, 
      {{ SC_(5101.35546875), SC_(0.6323592662811279296875), SC_(5124.8566933461619560228289524929629217402167515404), SC_(5076.5590092557104134361305819395460484538854624886) }}, 
      {{ SC_(5101.35546875), SC_(0.814723670482635498046875), SC_(5164.7775533415905308606362709890697168329548232621), SC_(5036.8673168426772072262956646941015087308374509126) }}, 
      {{ SC_(5101.35546875), SC_(0.835008561611175537109375), SC_(5170.4237554300480399623331448709478824073733652568), SC_(5031.2701671952285396527764532690773860991255182884) }}, 
      {{ SC_(5101.35546875), SC_(0.905791938304901123046875), SC_(5194.9183720091812395838082053560344031856973650814), SC_(5007.0358876459690038998296855757812391506748660832) }}, 
      {{ SC_(5101.35546875), SC_(0.9133758544921875), SC_(5198.2646580002515422865007279639392903132409565951), SC_(5003.7311526976749347229010926113363678356230783871) }}, 
      {{ SC_(5101.35546875), SC_(0.957506835460662841796875), SC_(5224.2061752496951649870549762278363969288211233393), SC_(4978.1603994816179460771275993941014250706068994958) }}, 
      {{ SC_(5101.35546875), SC_(0.964888513088226318359375), SC_(5230.543834317593317587404962788996730567373445405), SC_(4971.9263890295074031522728901691049084391709573273) }}, 
      {{ SC_(5101.35546875), SC_(0.967694938182830810546875), SC_(5233.243310129673082808758006057140301979386234662), SC_(4969.272616536393415260260780938970294644846262622) }}, 
      {{ SC_(5101.35546875), SC_(0.968867778778076171875), SC_(5234.4292127822792456365135909466993084322468436454), SC_(4968.1070852509782363815136876780603569829587459012) }}, 
      {{ SC_(5101.35546875), SC_(0.992881298065185546875), SC_(5276.7616062520965173051655898249454045331956387497), SC_(4926.6188847738786707759762074160001917724282411443) }}, 
      {{ SC_(5101.35546875), SC_(0.996461331844329833984375), SC_(5294.2501844314325125048772034713449994484653720861), SC_(4909.5452582703210591979659987383164828981390456314) }}, 
      {{ SC_(13472.287109375), SC_(0.097540400922298431396484375), SC_(13321.509336342814016939407594305469126665173908278), SC_(13622.291157811434064811076782402415527051787793896) }}, 
      {{ SC_(13472.287109375), SC_(0.12698681652545928955078125), SC_(13339.430623859773449473867223285813164096904412236), SC_(13604.244032033515017531483956804339033056504319254) }}, 
      {{ SC_(13472.287109375), SC_(0.135477006435394287109375), SC_(13344.044875551923055003102393128241906739559136479), SC_(13599.599979577883302140153734053880016126040615276) }}, 
      {{ SC_(13472.287109375), SC_(0.188381969928741455078125), SC_(13369.159462638029437108114105616614173433348840568), SC_(13574.341832587589025708574775831268207659268611373) }}, 
      {{ SC_(13472.287109375), SC_(0.22103404998779296875), SC_(13382.49536602799266543338108343575696944508483471), SC_(13560.942486839219001529172723527296716955373812772) }}, 
      {{ SC_(13472.287109375), SC_(0.278498232364654541015625), SC_(13403.509078586706036133172628024638283744953682557), SC_(13539.846781536909927223317973533611947925723844512) }}, 
      {{ SC_(13472.287109375), SC_(0.308167040348052978515625), SC_(13413.505148328594948814497371707047100651297815376), SC_(13529.81941909306577703969923735786866013306082014) }}, 
      {{ SC_(13472.287109375), SC_(0.546881496906280517578125), SC_(13485.294199289283559134394974022412397991553440821), SC_(13457.951307748265022050341604414239085051568694591) }}, 
      {{ SC_(13472.287109375), SC_(0.54722058773040771484375), SC_(13485.393581281356354101831548685205551565426728831), SC_(13457.851993212219583489480999314033048302363894409) }}, 
      {{ SC_(13472.287109375), SC_(0.6323592662811279296875), SC_(13510.88371724971574712006111180448448986038903186), SC_(13432.395271161689852106478483997463362663184272793) }}, 
      {{ SC_(13472.287109375), SC_(0.814723670482635498046875), SC_(13575.687501208338503015327471034179160306983991627), SC_(13367.820652770404302796525145864768036922960857783) }}, 
      {{ SC_(13472.287109375), SC_(0.835008561611175537109375), SC_(13584.84783738172991634549579798610296097967425791), SC_(13358.709368495873114850112384880806538400658276777) }}, 
      {{ SC_(13472.287109375), SC_(0.905791938304901123046875), SC_(13624.572865617532065585542679501501354564267191607), SC_(13319.24467375842712259059005432054226850476838892) }}, 
      {{ SC_(13472.287109375), SC_(0.9133758544921875), SC_(13629.997967694922530299857221893979430454373232789), SC_(13313.861122058286460766002537973251312862384527324) }}, 
      {{ SC_(13472.287109375), SC_(0.957506835460662841796875), SC_(13672.040076812056139173655258967916835983691304596), SC_(13272.189769794293141289802429921883590322240623341) }}, 
      {{ SC_(13472.287109375), SC_(0.964888513088226318359375), SC_(13682.307154187056918977757761381544778907402334372), SC_(13262.026338628394852723091843869472676980570491091) }}, 
      {{ SC_(13472.287109375), SC_(0.967694938182830810546875), SC_(13686.679853573044805715245773961497453039600405299), SC_(13257.699341444709197060065421653399200238946200322) }}, 
      {{ SC_(13472.287109375), SC_(0.968867778778076171875), SC_(13688.600726767116170546457425717608064097667372415), SC_(13255.798839109163404233963534674631378011190564693) }}, 
      {{ SC_(13472.287109375), SC_(0.992881298065185546875), SC_(13757.132735620495312173288987252384908485800121366), SC_(13188.11099623988365459730671377960849979963440631) }}, 
      {{ SC_(13472.287109375), SC_(0.996461331844329833984375), SC_(13785.42461768262875823645818711186354219560847756), SC_(13160.234048332580281387288998623329226376221006978) }}, 
      {{ SC_(21533.0078125), SC_(0.097540400922298431396484375), SC_(21342.489530774528422442751297452797856912271534306), SC_(21722.752369341177445966709513523872359998152638084) }}, 
      {{ SC_(21533.0078125), SC_(0.12698681652545928955078125), SC_(21365.163134860999454698235267807132982623870326046), SC_(21699.952927406596208517823030105742141485690107312) }}, 
      // This next one is disabled, because rounding the expected result to float 
      // results in a change of value when rounding the result.
      // {{ SC_(21533.0078125), SC_(0.135477006435394287109375), SC_(21371.000635839925468224783394436264380332621650997), SC_(21694.085625753365583876792313211090140641237364813) }}, 
      {{ SC_(21533.0078125), SC_(0.188381969928741455078125), SC_(21402.770687925746754018108265475209057176344684766), SC_(21662.172014146846950443900950560166812044088262695) }}, 
      {{ SC_(21533.0078125), SC_(0.22103404998779296875), SC_(21419.638962869415971010599238922528933576697585819), SC_(21645.240296989914953912074020329465712841475123166) }}, 
      {{ SC_(21533.0078125), SC_(0.278498232364654541015625), SC_(21446.216338805119994100950385012299870473665630669), SC_(21618.580928476108223370743123436382577519047601928) }}, 
      {{ SC_(21533.0078125), SC_(0.308167040348052978515625), SC_(21458.857981420800853369438097216364035795967755877), SC_(21605.907993215065680862411562940327751235639835825) }}, 
      {{ SC_(21533.0078125), SC_(0.546881496906280517578125), SC_(21549.627545070877730360754111396995498261412405609), SC_(21515.059369307696871271661919837674378168993970665) }}, 
      {{ SC_(21533.0078125), SC_(0.54722058773040771484375), SC_(21549.753179571013263889918578328687169704467238534), SC_(21514.933802263490359509166807428906690586363289475) }}, 
      {{ SC_(21533.0078125), SC_(0.6323592662811279296875), SC_(21581.974601302864615857244782514336741884395734384), SC_(21482.745794398686763439050080601847328209204644086) }}, 
      {{ SC_(21533.0078125), SC_(0.814723670482635498046875), SC_(21663.872367350387475035008256452069501897450083904), SC_(21401.077193458745796458879598059735976167554307072) }}, 
      {{ SC_(21533.0078125), SC_(0.835008561611175537109375), SC_(21675.446827929503803640203376831878825072934453297), SC_(21389.551784654799299671107702856803076075076776328) }}, 
      {{ SC_(21533.0078125), SC_(0.905791938304901123046875), SC_(21725.634765736413776389143291809050357300699306627), SC_(21339.6241795405693269559823355712767928082592718) }}, 
      {{ SC_(21533.0078125), SC_(0.9133758544921875), SC_(21732.48796045968784137781373249147199899474733742), SC_(21332.8125350427175652901170857351517464592136753) }}, 
      {{ SC_(21533.0078125), SC_(0.957506835460662841796875), SC_(21785.590741330979888005344804033132087524399988861), SC_(21280.080509386589379665484620938712973319935895665) }}, 
      {{ SC_(21533.0078125), SC_(0.964888513088226318359375), SC_(21798.557218003432867406166855932357022109497728002), SC_(21267.217678374239705649203964780441964266860151737) }}, 
      {{ SC_(21533.0078125), SC_(0.967694938182830810546875), SC_(21804.079374038028385048187041100264350787618846948), SC_(21261.741224287222313604821025048565879887594278124) }}, 
      {{ SC_(21533.0078125), SC_(0.968867778778076171875), SC_(21806.505150808045188175269798380893915291446599662), SC_(21259.335818259699059193512358302672174062051718198) }}, 
      {{ SC_(21533.0078125), SC_(0.992881298065185546875), SC_(21893.035484643765250702345204307305220150252817399), SC_(21173.649644247497441133933107438101115419091883006) }}, 
      {{ SC_(21533.0078125), SC_(0.996461331844329833984375), SC_(21928.748866501301794010747676997623434830926924354), SC_(21138.35119254861052629794920186014308896076971475) }}, 
      {{ SC_(36064.203125), SC_(0.097540400922298431396484375), SC_(35817.756768465760157590621734165018504764822234946), SC_(36309.87575645560720888470897187326305111307971067) }}, 
      {{ SC_(36064.203125), SC_(0.12698681652545928955078125), SC_(35847.118451935014429046646043595383698848956280643), SC_(36280.388235416270565451383221510177119530752580683) }}, 
      {{ SC_(36064.203125), SC_(0.135477006435394287109375), SC_(35854.677469154058812990446398308816060488884214194), SC_(36272.799417582977292393610184889120531754662042693) }}, 
      {{ SC_(36064.203125), SC_(0.188381969928741455078125), SC_(35895.813963688688899347185287707174915963110925951), SC_(36231.519363785909686114717073499040831813259848196) }}, 
      {{ SC_(36064.203125), SC_(0.22103404998779296875), SC_(35917.653456211419739834853063677815640317758960528), SC_(36209.61642914766359611814946788126355540985450165) }}, 
      {{ SC_(36064.203125), SC_(0.278498232364654541015625), SC_(35952.060752264711660225756482245675795827380357506), SC_(36175.127140627721533908135757767552638737317829985) }}, 
      {{ SC_(36064.203125), SC_(0.308167040348052978515625), SC_(35968.425594177917174114988015625463665216529807154), SC_(36158.731006107268024793529385791325197439496378759) }}, 
      {{ SC_(36064.203125), SC_(0.546881496906280517578125), SC_(36085.90704613659583139939209269495550265372509376), SC_(36041.170493976707019744110284599564890573120559004) }}, 
      {{ SC_(36064.203125), SC_(0.54722058773040771484375), SC_(36086.069626640932451371680215150290901608708630273), SC_(36041.007980928233195582697368438443122786769469145) }}, 
      {{ SC_(36064.203125), SC_(0.6323592662811279296875), SC_(36127.764204300101112509183105856533197297089468966), SC_(35999.346817101912053061808800875199004294182125904) }}, 
      {{ SC_(36064.203125), SC_(0.814723670482635498046875), SC_(36233.718875717808828467602793313871953177027240436), SC_(35893.621310482160314578578260464699451147711607827) }}, 
      {{ SC_(36064.203125), SC_(0.835008561611175537109375), SC_(36248.690808962376388084529607619710721880422487915), SC_(35878.698428929463581276848946039910866441775986925) }}, 
      {{ SC_(36064.203125), SC_(0.905791938304901123046875), SC_(36313.603520004301043829040859165025143758574372428), SC_(35814.04605003764537924388506916510248513184115016) }}, 
      {{ SC_(36064.203125), SC_(0.9133758544921875), SC_(36322.466512379710977125706991116296873669955779604), SC_(35805.224607785412252967347192248072950856592829061) }}, 
      {{ SC_(36064.203125), SC_(0.957506835460662841796875), SC_(36391.135299980195669560575736147367436281777633283), SC_(35736.926574297038969011121854824598284630491333953) }}, 
      {{ SC_(36064.203125), SC_(0.964888513088226318359375), SC_(36407.900717612615585771720933010639586549398001689), SC_(35720.264801955017393133538609471435523920615869955) }}, 
      {{ SC_(36064.203125), SC_(0.967694938182830810546875), SC_(36415.040536152281865027842381342733053433785349414), SC_(35713.170685191394470780844154374449975091285878881) }}, 
      {{ SC_(36064.203125), SC_(0.968867778778076171875), SC_(36418.176877787056615649047742815339774220928179991), SC_(35710.054714220975799133006437370089582352859367611) }}, 
      {{ SC_(36064.203125), SC_(0.992881298065185546875), SC_(36530.036726520261049674022412341545736190010493948), SC_(35599.039021162752923959319339473143116039188421182) }}, 
      {{ SC_(36064.203125), SC_(0.996461331844329833984375), SC_(36576.19456101664404260142699288335175602354959484), SC_(35553.29611413405182964733910119676514324895954306) }}
   }};
#undef SC_

